/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.relational.history;

import io.debezium.annotation.ThreadSafe;
import io.debezium.relational.Tables;
import io.debezium.relational.ddl.DdlParser;
import io.debezium.relational.history.AbstractDatabaseHistory;
import io.debezium.relational.history.HistoryRecord;
import io.debezium.util.FunctionalReadWriteLock;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

@ThreadSafe
public final class MemoryDatabaseHistory
extends AbstractDatabaseHistory {
    private final List<HistoryRecord> records = new ArrayList<HistoryRecord>();
    private final FunctionalReadWriteLock lock = FunctionalReadWriteLock.reentrant();

    @Override
    protected void storeRecord(HistoryRecord record) {
        this.lock.write(() -> this.records.add(record));
    }

    @Override
    protected void recoverRecords(Tables schema, DdlParser ddlParser, Consumer<HistoryRecord> records) {
        this.lock.write(() -> this.records.forEach(records));
    }

    public String toString() {
        return "memory";
    }
}

