/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.connector.mysql.AbstractReader;
import io.debezium.connector.mysql.Filters;
import io.debezium.connector.mysql.MySqlSchema;
import io.debezium.connector.mysql.MySqlTaskContext;
import io.debezium.connector.mysql.RecordMakers;
import io.debezium.connector.mysql.SnapshotReaderMetrics;
import io.debezium.connector.mysql.SourceInfo;
import io.debezium.function.BlockingConsumer;
import io.debezium.function.BufferedBlockingConsumer;
import io.debezium.function.Predicates;
import io.debezium.jdbc.JdbcConnection;
import io.debezium.relational.Table;
import io.debezium.relational.TableId;
import io.debezium.relational.ddl.DdlChanges;
import io.debezium.util.Clock;
import io.debezium.util.Strings;
import java.lang.invoke.LambdaMetafactory;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.kafka.connect.source.SourceRecord;

public class SnapshotReader
extends AbstractReader {
    private boolean minimalBlocking = true;
    private final boolean includeData;
    private RecordRecorder recorder;
    private volatile Thread thread;
    private final SnapshotReaderMetrics metrics;

    public SnapshotReader(String name, MySqlTaskContext context) {
        super(name, context);
        this.includeData = !context.isSchemaOnlySnapshot();
        this.recorder = this::recordRowAsRead;
        this.metrics = new SnapshotReaderMetrics(context.clock());
        this.metrics.register(context, this.logger);
    }

    public SnapshotReader useMinimalBlocking(boolean minimalBlocking) {
        this.minimalBlocking = minimalBlocking;
        return this;
    }

    public SnapshotReader generateReadEvents() {
        this.recorder = this::recordRowAsRead;
        return this;
    }

    public SnapshotReader generateInsertEvents() {
        this.recorder = this::recordRowAsInsert;
        return this;
    }

    @Override
    protected void doStart() {
        this.thread = new Thread(this::execute, "mysql-snapshot-" + this.context.serverName());
        this.thread.start();
    }

    @Override
    protected void doStop() {
        this.logger.debug("Stopping snapshot reader");
    }

    @Override
    protected void doCleanup() {
        try {
            this.thread = null;
            this.logger.debug("Completed writing all snapshot records");
        }
        finally {
            this.metrics.unregister(this.logger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    protected void execute() {
        block71: {
            this.context.configureLoggingContext("snapshot");
            sql = new AtomicReference<String>();
            mysql = this.context.jdbc();
            schema = this.context.dbSchema();
            filters = schema.filters();
            source = this.context.source();
            clock = this.context.clock();
            ts = clock.currentTimeInMillis();
            this.logger.info("Starting snapshot for {} with user '{}'", (Object)this.context.connectionString(), (Object)mysql.username());
            this.logRolesForCurrentUser(mysql);
            this.logServerInformation(mysql);
            isLocked = false;
            isTxnStarted = false;
            try {
                block70: {
                    block72: {
                        block68: {
                            block69: {
                                block65: {
                                    block66: {
                                        block63: {
                                            block64: {
                                                block61: {
                                                    block62: {
                                                        block59: {
                                                            block60: {
                                                                block57: {
                                                                    block58: {
                                                                        block55: {
                                                                            block56: {
                                                                                this.metrics.startSnapshot();
                                                                                if (!this.isRunning()) {
                                                                                    return;
                                                                                }
                                                                                this.logger.info("Step 0: disabling autocommit and enabling repeatable read transactions");
                                                                                mysql.setAutoCommit(false);
                                                                                sql.set("SET TRANSACTION ISOLATION LEVEL REPEATABLE READ");
                                                                                mysql.execute(new String[]{(String)sql.get()});
                                                                                this.metrics.globalLockAcquired();
                                                                                systemVariables = this.context.readMySqlCharsetSystemVariables(sql);
                                                                                setSystemVariablesStatement = this.context.setStatementFor(systemVariables);
                                                                                interrupted = new AtomicBoolean(false);
                                                                                lockAcquired = 0L;
                                                                                if (this.isRunning()) break block55;
                                                                                step = 9;
                                                                                if (!isLocked) break block56;
                                                                                this.logger.info("Step {}: releasing global read lock to enable MySQL writes", (Object)step++);
                                                                                sql.set("UNLOCK TABLES");
                                                                                mysql.execute(new String[]{sql.get()});
                                                                                isLocked = false;
                                                                                lockReleased = clock.currentTimeInMillis();
                                                                                this.metrics.globalLockReleased();
                                                                                this.logger.info("Writes to MySQL prevented for a total of {}", (Object)Strings.duration((long)(lockReleased - lockAcquired)));
                                                                            }
                                                                            if (isTxnStarted) {
                                                                                if (interrupted.get() || !this.isRunning()) {
                                                                                    this.logger.info("Step {}: rolling back transaction after abort", (Object)step++);
                                                                                    sql.set("ROLLBACK");
                                                                                    mysql.execute(new String[]{sql.get()});
                                                                                    this.metrics.abortSnapshot();
                                                                                    return;
                                                                                }
                                                                                this.logger.info("Step {}: committing transaction", (Object)step++);
                                                                                sql.set("COMMIT");
                                                                                mysql.execute(new String[]{sql.get()});
                                                                                this.metrics.completeSnapshot();
                                                                            }
                                                                            return;
                                                                        }
                                                                        this.logger.info("Step 1: start transaction with consistent snapshot");
                                                                        sql.set("START TRANSACTION WITH CONSISTENT SNAPSHOT");
                                                                        mysql.execute(new String[]{sql.get()});
                                                                        isTxnStarted = true;
                                                                        if (this.isRunning()) break block57;
                                                                        step = 9;
                                                                        if (!isLocked) break block58;
                                                                        this.logger.info("Step {}: releasing global read lock to enable MySQL writes", (Object)step++);
                                                                        sql.set("UNLOCK TABLES");
                                                                        mysql.execute(new String[]{sql.get()});
                                                                        isLocked = false;
                                                                        lockReleased = clock.currentTimeInMillis();
                                                                        this.metrics.globalLockReleased();
                                                                        this.logger.info("Writes to MySQL prevented for a total of {}", (Object)Strings.duration((long)(lockReleased - lockAcquired)));
                                                                    }
                                                                    if (isTxnStarted) {
                                                                        if (interrupted.get() || !this.isRunning()) {
                                                                            this.logger.info("Step {}: rolling back transaction after abort", (Object)step++);
                                                                            sql.set("ROLLBACK");
                                                                            mysql.execute(new String[]{sql.get()});
                                                                            this.metrics.abortSnapshot();
                                                                            return;
                                                                        }
                                                                        this.logger.info("Step {}: committing transaction", (Object)step++);
                                                                        sql.set("COMMIT");
                                                                        mysql.execute(new String[]{sql.get()});
                                                                        this.metrics.completeSnapshot();
                                                                    }
                                                                    return;
                                                                }
                                                                lockAcquired = clock.currentTimeInMillis();
                                                                this.logger.info("Step 2: flush and obtain global read lock (preventing writes to database)");
                                                                sql.set("FLUSH TABLES WITH READ LOCK");
                                                                mysql.execute(new String[]{sql.get()});
                                                                isLocked = true;
                                                                if (this.isRunning()) break block59;
                                                                step = 9;
                                                                if (!isLocked) break block60;
                                                                this.logger.info("Step {}: releasing global read lock to enable MySQL writes", (Object)step++);
                                                                sql.set("UNLOCK TABLES");
                                                                mysql.execute(new String[]{sql.get()});
                                                                isLocked = false;
                                                                lockReleased = clock.currentTimeInMillis();
                                                                this.metrics.globalLockReleased();
                                                                this.logger.info("Writes to MySQL prevented for a total of {}", (Object)Strings.duration((long)(lockReleased - lockAcquired)));
                                                            }
                                                            if (isTxnStarted) {
                                                                if (interrupted.get() || !this.isRunning()) {
                                                                    this.logger.info("Step {}: rolling back transaction after abort", (Object)step++);
                                                                    sql.set("ROLLBACK");
                                                                    mysql.execute(new String[]{sql.get()});
                                                                    this.metrics.abortSnapshot();
                                                                    return;
                                                                }
                                                                this.logger.info("Step {}: committing transaction", (Object)step++);
                                                                sql.set("COMMIT");
                                                                mysql.execute(new String[]{sql.get()});
                                                                this.metrics.completeSnapshot();
                                                            }
                                                            return;
                                                        }
                                                        this.logger.info("Step 3: read binlog position of MySQL master");
                                                        showMasterStmt = "SHOW MASTER STATUS";
                                                        sql.set(showMasterStmt);
                                                        mysql.query(sql.get(), (JdbcConnection.ResultSetConsumer)LambdaMetafactory.metafactory(null, null, null, (Ljava/sql/ResultSet;)V, lambda$execute$0(io.debezium.connector.mysql.SourceInfo java.lang.String java.sql.ResultSet ), (Ljava/sql/ResultSet;)V)((SnapshotReader)this, (SourceInfo)source, (String)showMasterStmt));
                                                        if (this.isRunning()) break block61;
                                                        step = 9;
                                                        if (!isLocked) break block62;
                                                        this.logger.info("Step {}: releasing global read lock to enable MySQL writes", (Object)step++);
                                                        sql.set("UNLOCK TABLES");
                                                        mysql.execute(new String[]{sql.get()});
                                                        isLocked = false;
                                                        lockReleased = clock.currentTimeInMillis();
                                                        this.metrics.globalLockReleased();
                                                        this.logger.info("Writes to MySQL prevented for a total of {}", (Object)Strings.duration((long)(lockReleased - lockAcquired)));
                                                    }
                                                    if (isTxnStarted) {
                                                        if (interrupted.get() || !this.isRunning()) {
                                                            this.logger.info("Step {}: rolling back transaction after abort", (Object)step++);
                                                            sql.set("ROLLBACK");
                                                            mysql.execute(new String[]{sql.get()});
                                                            this.metrics.abortSnapshot();
                                                            return;
                                                        }
                                                        this.logger.info("Step {}: committing transaction", (Object)step++);
                                                        sql.set("COMMIT");
                                                        mysql.execute(new String[]{sql.get()});
                                                        this.metrics.completeSnapshot();
                                                    }
                                                    return;
                                                }
                                                this.logger.info("Step 4: read list of available databases");
                                                databaseNames = new ArrayList<E>();
                                                sql.set("SHOW DATABASES");
                                                mysql.query(sql.get(), (JdbcConnection.ResultSetConsumer)LambdaMetafactory.metafactory(null, null, null, (Ljava/sql/ResultSet;)V, lambda$execute$1(java.util.List java.sql.ResultSet ), (Ljava/sql/ResultSet;)V)(databaseNames));
                                                this.logger.info("\t list of available databases is: {}", databaseNames);
                                                if (this.isRunning()) break block63;
                                                step = 9;
                                                if (!isLocked) break block64;
                                                this.logger.info("Step {}: releasing global read lock to enable MySQL writes", (Object)step++);
                                                sql.set("UNLOCK TABLES");
                                                mysql.execute(new String[]{sql.get()});
                                                isLocked = false;
                                                lockReleased = clock.currentTimeInMillis();
                                                this.metrics.globalLockReleased();
                                                this.logger.info("Writes to MySQL prevented for a total of {}", (Object)Strings.duration((long)(lockReleased - lockAcquired)));
                                            }
                                            if (isTxnStarted) {
                                                if (interrupted.get() || !this.isRunning()) {
                                                    this.logger.info("Step {}: rolling back transaction after abort", (Object)step++);
                                                    sql.set("ROLLBACK");
                                                    mysql.execute(new String[]{sql.get()});
                                                    this.metrics.abortSnapshot();
                                                    return;
                                                }
                                                this.logger.info("Step {}: committing transaction", (Object)step++);
                                                sql.set("COMMIT");
                                                mysql.execute(new String[]{sql.get()});
                                                this.metrics.completeSnapshot();
                                            }
                                            return;
                                        }
                                        this.logger.info("Step 5: read list of available tables in each database");
                                        tableIds = new ArrayList<E>();
                                        tableIdsByDbName = new HashMap<K, V>();
                                        readableDatabaseNames = new HashSet<String>();
                                        for (Object dbName : databaseNames) {
                                            try {
                                                sql.set("SHOW TABLES IN " + this.quote((String)dbName));
                                                mysql.query(sql.get(), (JdbcConnection.ResultSetConsumer)LambdaMetafactory.metafactory(null, null, null, (Ljava/sql/ResultSet;)V, lambda$execute$3(java.lang.String io.debezium.connector.mysql.Filters java.util.List java.util.Map java.sql.ResultSet ), (Ljava/sql/ResultSet;)V)((SnapshotReader)this, (String)dbName, (Filters)filters, tableIds, tableIdsByDbName));
                                                readableDatabaseNames.add((String)dbName);
                                            }
                                            catch (SQLException e) {
                                                this.logger.warn("\t skipping database '{}' due to error reading tables: {}", dbName, (Object)e.getMessage());
                                            }
                                        }
                                        this.logger.info("\t snapshot continuing with databases: {}", readableDatabaseNames);
                                        this.logger.info("Step 6: generating DROP and CREATE statements to reflect current database schemas:");
                                        schema.applyDdl(source, null, setSystemVariablesStatement, (DdlChanges.DatabaseStatementStringConsumer)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/String;Ljava/lang/String;)V, enqueueSchemaChanges(java.lang.String java.lang.String ), (Ljava/lang/String;Ljava/lang/String;)V)((SnapshotReader)this));
                                        allTableIds = new HashSet<E>(schema.tables().tableIds());
                                        allTableIds.addAll(tableIds);
                                        allTableIds.stream().filter((Predicate<TableId>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$execute$4(io.debezium.relational.TableId ), (Lio/debezium/relational/TableId;)Z)((SnapshotReader)this)).forEach((Consumer<TableId>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$execute$5(io.debezium.connector.mysql.MySqlSchema io.debezium.connector.mysql.SourceInfo io.debezium.relational.TableId ), (Lio/debezium/relational/TableId;)V)((SnapshotReader)this, (MySqlSchema)schema, (SourceInfo)source));
                                        schema.tables().tableIds().stream().map((Function<TableId, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, catalog(), (Lio/debezium/relational/TableId;)Ljava/lang/String;)()).filter(Predicates.not((Predicate<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, contains(java.lang.Object ), (Ljava/lang/String;)Z)(readableDatabaseNames))).filter((Predicate<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$execute$6(java.lang.String ), (Ljava/lang/String;)Z)((SnapshotReader)this)).forEach((Consumer<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$execute$7(io.debezium.connector.mysql.MySqlSchema io.debezium.connector.mysql.SourceInfo java.lang.String ), (Ljava/lang/String;)V)((SnapshotReader)this, (MySqlSchema)schema, (SourceInfo)source));
                                        block27: for (Map.Entry entry : tableIdsByDbName.entrySet()) {
                                            if (!this.isRunning()) break;
                                            dbName = (String)entry.getKey();
                                            schema.applyDdl(source, dbName, "DROP DATABASE IF EXISTS " + this.quote(dbName), (DdlChanges.DatabaseStatementStringConsumer)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/String;Ljava/lang/String;)V, enqueueSchemaChanges(java.lang.String java.lang.String ), (Ljava/lang/String;Ljava/lang/String;)V)((SnapshotReader)this));
                                            schema.applyDdl(source, dbName, "CREATE DATABASE " + this.quote(dbName), (DdlChanges.DatabaseStatementStringConsumer)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/String;Ljava/lang/String;)V, enqueueSchemaChanges(java.lang.String java.lang.String ), (Ljava/lang/String;Ljava/lang/String;)V)((SnapshotReader)this));
                                            schema.applyDdl(source, dbName, "USE " + this.quote(dbName), (DdlChanges.DatabaseStatementStringConsumer)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/String;Ljava/lang/String;)V, enqueueSchemaChanges(java.lang.String java.lang.String ), (Ljava/lang/String;Ljava/lang/String;)V)((SnapshotReader)this));
                                            for (TableId tableId : (List)entry.getValue()) {
                                                if (!this.isRunning()) continue block27;
                                                sql.set("SHOW CREATE TABLE " + this.quote(tableId));
                                                mysql.query(sql.get(), (JdbcConnection.ResultSetConsumer)LambdaMetafactory.metafactory(null, null, null, (Ljava/sql/ResultSet;)V, lambda$execute$8(io.debezium.connector.mysql.MySqlSchema io.debezium.connector.mysql.SourceInfo java.lang.String java.sql.ResultSet ), (Ljava/sql/ResultSet;)V)((SnapshotReader)this, (MySqlSchema)schema, (SourceInfo)source, (String)dbName));
                                            }
                                        }
                                        this.context.makeRecord().regenerate();
                                        if (this.minimalBlocking && isLocked) {
                                            this.logger.info("Step 7: releasing global read lock to enable MySQL writes");
                                            sql.set("UNLOCK TABLES");
                                            mysql.execute(new String[]{sql.get()});
                                            isLocked = false;
                                            lockReleased = clock.currentTimeInMillis();
                                            this.metrics.globalLockReleased();
                                            this.logger.info("Step 7: blocked writes to MySQL for a total of {}", (Object)Strings.duration((long)(lockReleased - lockAcquired)));
                                        }
                                        if (this.isRunning()) break block65;
                                        step = 9;
                                        if (!isLocked) break block66;
                                        this.logger.info("Step {}: releasing global read lock to enable MySQL writes", (Object)step++);
                                        sql.set("UNLOCK TABLES");
                                        mysql.execute(new String[]{sql.get()});
                                        isLocked = false;
                                        lockReleased = clock.currentTimeInMillis();
                                        this.metrics.globalLockReleased();
                                        this.logger.info("Writes to MySQL prevented for a total of {}", (Object)Strings.duration((long)(lockReleased - lockAcquired)));
                                    }
                                    if (isTxnStarted) {
                                        if (interrupted.get() || !this.isRunning()) {
                                            this.logger.info("Step {}: rolling back transaction after abort", (Object)step++);
                                            sql.set("ROLLBACK");
                                            mysql.execute(new String[]{sql.get()});
                                            this.metrics.abortSnapshot();
                                            return;
                                        }
                                        this.logger.info("Step {}: committing transaction", (Object)step++);
                                        sql.set("COMMIT");
                                        mysql.execute(new String[]{sql.get()});
                                        this.metrics.completeSnapshot();
                                    }
                                    return;
                                }
                                try {
                                    if (!this.includeData) ** GOTO lbl383
                                    bufferedRecordQueue = BufferedBlockingConsumer.bufferLast((BlockingConsumer)(BlockingConsumer)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$execute$9(org.apache.kafka.connect.source.SourceRecord ), (Lorg/apache/kafka/connect/source/SourceRecord;)V)((SnapshotReader)this));
                                    this.logger.info("Step 8: scanning contents of {} tables", (Object)tableIds.size());
                                    this.metrics.setTableCount(tableIds.size());
                                    startScan = clock.currentTimeInMillis();
                                    totalRowCount = new AtomicLong();
                                    counter = 0;
                                    completedCounter = 0;
                                    largeTableCount = this.context.rowCountForLargeTable();
                                    for (TableId tableId : tableIds) {
                                        if (!this.isRunning()) break;
                                        recordMaker = this.context.makeRecord().forTable(tableId, null, (BlockingConsumer<SourceRecord>)bufferedRecordQueue);
                                        if (recordMaker != null) {
                                            sql.set("USE " + this.quote(tableId.catalog()) + ";");
                                            mysql.execute(new String[]{sql.get()});
                                            numRows = new AtomicLong(-1L);
                                            rowCountStr = new AtomicReference<String>("<unknown>");
                                            statementFactory = (JdbcConnection.StatementFactory)LambdaMetafactory.metafactory(null, null, null, (Ljava/sql/Connection;)Ljava/sql/Statement;, createStatementWithLargeResultSet(java.sql.Connection ), (Ljava/sql/Connection;)Ljava/sql/Statement;)((SnapshotReader)this);
                                            if (largeTableCount > 0L) {
                                                try {
                                                    sql.set("SHOW TABLE STATUS LIKE '" + tableId.table() + "';");
                                                    mysql.query(sql.get(), (JdbcConnection.ResultSetConsumer)LambdaMetafactory.metafactory(null, null, null, (Ljava/sql/ResultSet;)V, lambda$execute$10(java.util.concurrent.atomic.AtomicLong java.sql.ResultSet ), (Ljava/sql/ResultSet;)V)((AtomicLong)numRows));
                                                    if (numRows.get() <= largeTableCount) {
                                                        statementFactory = (JdbcConnection.StatementFactory)LambdaMetafactory.metafactory(null, null, null, (Ljava/sql/Connection;)Ljava/sql/Statement;, createStatement(java.sql.Connection ), (Ljava/sql/Connection;)Ljava/sql/Statement;)((SnapshotReader)this);
                                                    }
                                                    rowCountStr.set(numRows.toString());
                                                }
                                                catch (SQLException e) {
                                                    this.logger.debug("Error while getting number of rows in table {}: {}", new Object[]{tableId, e.getMessage(), e});
                                                }
                                            }
                                            start = clock.currentTimeInMillis();
                                            this.logger.info("Step 8: - scanning table '{}' ({} of {} tables)", new Object[]{tableId, ++counter, tableIds.size()});
                                            sql.set("SELECT * FROM " + this.quote(tableId));
                                            try {
                                                mysql.query(sql.get(), statementFactory, (JdbcConnection.ResultSetConsumer)LambdaMetafactory.metafactory(null, null, null, (Ljava/sql/ResultSet;)V, lambda$execute$11(io.debezium.connector.mysql.MySqlSchema io.debezium.relational.TableId io.debezium.connector.mysql.RecordMakers$RecordsForTable long io.debezium.util.Clock java.util.concurrent.atomic.AtomicReference long java.util.concurrent.atomic.AtomicLong java.util.concurrent.atomic.AtomicBoolean java.sql.ResultSet ), (Ljava/sql/ResultSet;)V)((SnapshotReader)this, (MySqlSchema)schema, (TableId)tableId, (RecordMakers.RecordsForTable)recordMaker, (long)ts, (Clock)clock, rowCountStr, (long)start, (AtomicLong)totalRowCount, (AtomicBoolean)interrupted));
                                            }
                                            finally {
                                                this.metrics.completeTable();
                                                if (interrupted.get()) break;
                                            }
                                        }
                                        ++completedCounter;
                                    }
                                    if (this.isRunning() && !interrupted.get()) break block68;
                                    step = 9;
                                    if (!isLocked) break block69;
                                    this.logger.info("Step {}: releasing global read lock to enable MySQL writes", (Object)step++);
                                }
                                catch (Throwable var39_62) {
                                    step = 9;
                                    if (isLocked) {
                                        this.logger.info("Step {}: releasing global read lock to enable MySQL writes", (Object)step++);
                                        sql.set("UNLOCK TABLES");
                                        mysql.execute(new String[]{sql.get()});
                                        isLocked = false;
                                        lockReleased = clock.currentTimeInMillis();
                                        this.metrics.globalLockReleased();
                                        this.logger.info("Writes to MySQL prevented for a total of {}", (Object)Strings.duration((long)(lockReleased - lockAcquired)));
                                    }
                                    if (isTxnStarted) {
                                        if (interrupted.get() || !this.isRunning()) {
                                            this.logger.info("Step {}: rolling back transaction after abort", (Object)step++);
                                            sql.set("ROLLBACK");
                                            mysql.execute(new String[]{sql.get()});
                                            this.metrics.abortSnapshot();
                                            return;
                                        }
                                        this.logger.info("Step {}: committing transaction", (Object)step++);
                                        sql.set("COMMIT");
                                        mysql.execute(new String[]{sql.get()});
                                        this.metrics.completeSnapshot();
                                    }
                                    throw var39_62;
                                }
                                sql.set("UNLOCK TABLES");
                                mysql.execute(new String[]{sql.get()});
                                isLocked = false;
                                lockReleased = clock.currentTimeInMillis();
                                this.metrics.globalLockReleased();
                                this.logger.info("Writes to MySQL prevented for a total of {}", (Object)Strings.duration((long)(lockReleased - lockAcquired)));
                            }
                            if (isTxnStarted) {
                                if (interrupted.get() || !this.isRunning()) {
                                    this.logger.info("Step {}: rolling back transaction after abort", (Object)step++);
                                    sql.set("ROLLBACK");
                                    mysql.execute(new String[]{sql.get()});
                                    this.metrics.abortSnapshot();
                                    return;
                                }
                                this.logger.info("Step {}: committing transaction", (Object)step++);
                                sql.set("COMMIT");
                                mysql.execute(new String[]{sql.get()});
                                this.metrics.completeSnapshot();
                            }
                            return;
                        }
                        source.markLastSnapshot();
                        stop = clock.currentTimeInMillis();
                        try {
                            bufferedRecordQueue.flush((Function<SourceRecord, SourceRecord>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, replaceOffset(org.apache.kafka.connect.source.SourceRecord ), (Lorg/apache/kafka/connect/source/SourceRecord;)Lorg/apache/kafka/connect/source/SourceRecord;)((SnapshotReader)this));
                            this.logger.info("Step 8: scanned {} rows in {} tables in {}", new Object[]{totalRowCount, tableIds.size(), Strings.duration((long)(stop - startScan))});
                        }
                        catch (InterruptedException e) {
                            Thread.interrupted();
                            this.logger.info("Step 8: aborting the snapshot after {} rows in {} of {} tables {}", new Object[]{totalRowCount, completedCounter, tableIds.size(), Strings.duration((long)(stop - startScan))});
                            interrupted.set(true);
                        }
                        break block72;
lbl383:
                        // 1 sources

                        this.logger.info("Step 8: encountered only schema based snapshot, skipping data snapshot");
                    }
                    step = 9;
                    if (!isLocked) break block70;
                    this.logger.info("Step {}: releasing global read lock to enable MySQL writes", (Object)step++);
                    sql.set("UNLOCK TABLES");
                    mysql.execute(new String[]{sql.get()});
                    isLocked = false;
                    lockReleased = clock.currentTimeInMillis();
                    this.metrics.globalLockReleased();
                    this.logger.info("Writes to MySQL prevented for a total of {}", (Object)Strings.duration((long)(lockReleased - lockAcquired)));
                }
                if (isTxnStarted) {
                    if (interrupted.get() || !this.isRunning()) {
                        this.logger.info("Step {}: rolling back transaction after abort", (Object)step++);
                        sql.set("ROLLBACK");
                        mysql.execute(new String[]{sql.get()});
                        this.metrics.abortSnapshot();
                        return;
                    }
                    this.logger.info("Step {}: committing transaction", (Object)step++);
                    sql.set("COMMIT");
                    mysql.execute(new String[]{sql.get()});
                    this.metrics.completeSnapshot();
                }
                if (!this.isRunning()) {
                    try {
                        this.completeSuccessfully();
                        stop = clock.currentTimeInMillis();
                        this.logger.info("Stopped snapshot after {} but before completing", (Object)Strings.duration((long)(stop - ts)));
                        break block71;
                    }
                    finally {
                        this.cleanupResources();
                    }
                }
                try {
                    source.completeSnapshot();
                }
                finally {
                    this.completeSuccessfully();
                    stop = clock.currentTimeInMillis();
                    this.logger.info("Completed snapshot in {}", (Object)Strings.duration((long)(stop - ts)));
                }
            }
            catch (Throwable e) {
                this.failed(e, "Aborting snapshot due to error when last running '" + (String)sql.get() + "': " + e.getMessage());
            }
        }
    }

    protected String quote(String dbOrTableName) {
        return "`" + dbOrTableName + "`";
    }

    protected String quote(TableId id) {
        return this.quote(id.catalog()) + "." + this.quote(id.table());
    }

    private Statement createStatementWithLargeResultSet(Connection connection) throws SQLException {
        Statement stmt = connection.createStatement(1003, 1007);
        stmt.setFetchSize(Integer.MIN_VALUE);
        return stmt;
    }

    private Statement createStatement(Connection connection) throws SQLException {
        return connection.createStatement();
    }

    private void logServerInformation(JdbcConnection mysql) {
        try {
            this.logger.info("MySQL server variables related to change data capture:");
            mysql.query("SHOW VARIABLES WHERE Variable_name REGEXP 'version|binlog|tx_|gtid|character_set|collation|time_zone'", rs -> {
                while (rs.next()) {
                    this.logger.info("\t{} = {}", (Object)Strings.pad((String)rs.getString(1), (int)45, (char)' '), (Object)Strings.pad((String)rs.getString(2), (int)45, (char)' '));
                }
            });
        }
        catch (SQLException e) {
            this.logger.info("Cannot determine MySql server version", (Throwable)e);
        }
    }

    private void logRolesForCurrentUser(JdbcConnection mysql) {
        try {
            ArrayList grants = new ArrayList();
            mysql.query("SHOW GRANTS FOR CURRENT_USER", rs -> {
                while (rs.next()) {
                    grants.add(rs.getString(1));
                }
            });
            if (grants.isEmpty()) {
                this.logger.warn("Snapshot is using user '{}' but it likely doesn't have proper privileges. If tables are missing or are empty, ensure connector is configured with the correct MySQL user and/or ensure that the MySQL user has the required privileges.", (Object)mysql.username());
            } else {
                this.logger.info("Snapshot is using user '{}' with these MySQL grants:", (Object)mysql.username());
                grants.forEach(grant -> this.logger.info("\t{}", grant));
            }
        }
        catch (SQLException e) {
            this.logger.info("Cannot determine the privileges for '{}' ", (Object)mysql.username(), (Object)e);
        }
    }

    protected SourceRecord replaceOffset(SourceRecord record) {
        if (record == null) {
            return null;
        }
        Map<String, ?> newOffset = this.context.source().offset();
        return new SourceRecord(record.sourcePartition(), newOffset, record.topic(), record.kafkaPartition(), record.keySchema(), record.key(), record.valueSchema(), record.value());
    }

    protected void enqueueSchemaChanges(String dbName, String ddlStatement) {
        if (!this.context.includeSchemaChangeRecords() || ddlStatement.length() == 0) {
            return;
        }
        if (this.context.makeRecord().schemaChanges(dbName, ddlStatement, (BlockingConsumer<SourceRecord>)((BlockingConsumer)x$0 -> super.enqueueRecord((SourceRecord)x$0))) > 0) {
            this.logger.info("\t{}", (Object)ddlStatement);
        }
    }

    protected void recordRowAsRead(RecordMakers.RecordsForTable recordMaker, Object[] row, long ts) throws InterruptedException {
        recordMaker.read(row, ts);
    }

    protected void recordRowAsInsert(RecordMakers.RecordsForTable recordMaker, Object[] row, long ts) throws InterruptedException {
        recordMaker.create(row, ts);
    }

    private /* synthetic */ void lambda$execute$11(MySqlSchema schema, TableId tableId, RecordMakers.RecordsForTable recordMaker, long ts, Clock clock, AtomicReference rowCountStr, long start, AtomicLong totalRowCount, AtomicBoolean interrupted, ResultSet rs) throws SQLException {
        long rowNum = 0L;
        try {
            Table table = schema.tableFor(tableId);
            int numColumns = table.columns().size();
            Object[] row = new Object[numColumns];
            while (rs.next()) {
                int i = 0;
                int j = 1;
                while (i != numColumns) {
                    row[i] = rs.getObject(j);
                    ++i;
                    ++j;
                }
                this.recorder.recordRow(recordMaker, row, ts);
                if (++rowNum % 100L == 0L && !this.isRunning()) break;
                if (rowNum % 10000L != 0L) continue;
                long stop = clock.currentTimeInMillis();
                this.logger.info("Step 8: - {} of {} rows scanned from table '{}' after {}", new Object[]{rowNum, rowCountStr, tableId, Strings.duration((long)(stop - start))});
            }
            totalRowCount.addAndGet(rowNum);
            if (this.isRunning()) {
                long stop = clock.currentTimeInMillis();
                this.logger.info("Step 8: - Completed scanning a total of {} rows from table '{}' after {}", new Object[]{rowNum, tableId, Strings.duration((long)(stop - start))});
            }
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            this.logger.info("Step 8: Stopping the snapshot due to thread interruption");
            interrupted.set(true);
        }
    }

    private static /* synthetic */ void lambda$execute$10(AtomicLong numRows, ResultSet rs) throws SQLException {
        if (rs.next()) {
            numRows.set(rs.getLong(5));
        }
    }

    private /* synthetic */ void lambda$execute$9(SourceRecord x$0) throws InterruptedException {
        super.enqueueRecord(x$0);
    }

    private /* synthetic */ void lambda$execute$8(MySqlSchema schema, SourceInfo source, String dbName, ResultSet rs) throws SQLException {
        if (rs.next()) {
            schema.applyDdl(source, dbName, rs.getString(2), this::enqueueSchemaChanges);
        }
    }

    private /* synthetic */ void lambda$execute$7(MySqlSchema schema, SourceInfo source, String missingDbName) {
        schema.applyDdl(source, missingDbName, "DROP DATABASE IF EXISTS " + this.quote(missingDbName), this::enqueueSchemaChanges);
    }

    private /* synthetic */ boolean lambda$execute$6(String id) {
        return this.isRunning();
    }

    private /* synthetic */ void lambda$execute$5(MySqlSchema schema, SourceInfo source, TableId tableId) {
        schema.applyDdl(source, tableId.schema(), "DROP TABLE IF EXISTS " + this.quote(tableId), this::enqueueSchemaChanges);
    }

    private /* synthetic */ boolean lambda$execute$4(TableId id) {
        return this.isRunning();
    }

    private /* synthetic */ void lambda$execute$3(String dbName, Filters filters, List tableIds, Map tableIdsByDbName, ResultSet rs) throws SQLException {
        while (rs.next() && this.isRunning()) {
            TableId id = new TableId(dbName, null, rs.getString(1));
            if (filters.tableFilter().test(id)) {
                tableIds.add(id);
                tableIdsByDbName.computeIfAbsent(dbName, k -> new ArrayList()).add(id);
                this.logger.info("\t including '{}'", (Object)id);
                continue;
            }
            this.logger.info("\t '{}' is filtered out, discarding", (Object)id);
        }
    }

    private static /* synthetic */ void lambda$execute$1(List databaseNames, ResultSet rs) throws SQLException {
        while (rs.next()) {
            databaseNames.add(rs.getString(1));
        }
    }

    private /* synthetic */ void lambda$execute$0(SourceInfo source, String showMasterStmt, ResultSet rs) throws SQLException {
        if (rs.next()) {
            String binlogFilename = rs.getString(1);
            long binlogPosition = rs.getLong(2);
            source.setBinlogStartPoint(binlogFilename, binlogPosition);
            if (rs.getMetaData().getColumnCount() > 4) {
                String gtidSet = rs.getString(5);
                source.setCompletedGtidSet(gtidSet);
                this.logger.info("\t using binlog '{}' at position '{}' and gtid '{}'", new Object[]{binlogFilename, binlogPosition, gtidSet});
            } else {
                this.logger.info("\t using binlog '{}' at position '{}'", (Object)binlogFilename, (Object)binlogPosition);
            }
        } else {
            throw new IllegalStateException("Cannot read the binlog filename and position via '" + showMasterStmt + "'. Make sure your server is correctly configured");
        }
        source.startSnapshot();
    }

    protected static interface RecordRecorder {
        public void recordRow(RecordMakers.RecordsForTable var1, Object[] var2, long var3) throws InterruptedException;
    }
}

