/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.config.Configuration;
import io.debezium.connector.mysql.GtidSet;
import io.debezium.connector.mysql.MySqlConnectorConfig;
import io.debezium.connector.mysql.MySqlTaskContext;
import io.debezium.relational.history.FileDatabaseHistory;
import io.debezium.util.Testing;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import org.fest.assertions.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class MySqlTaskContextTest {
    protected static final Path DB_HISTORY_PATH = Testing.Files.createTestingPath((String)"file-db-history-context.txt").toAbsolutePath();
    protected String hostname;
    protected int port;
    protected String username;
    protected String password;
    protected int serverId;
    protected String serverName;
    protected String databaseName;
    protected Configuration config;
    protected MySqlTaskContext context;

    @Before
    public void beforeEach() {
        String portStr;
        this.hostname = System.getProperty("database.hostname");
        if (this.hostname == null) {
            this.hostname = "localhost";
        }
        this.port = (portStr = System.getProperty("database.port")) != null ? Integer.parseInt(portStr) : (Integer)MySqlConnectorConfig.PORT.defaultValue();
        this.username = "snapper";
        this.password = "snapperpass";
        this.serverId = 18965;
        this.serverName = "logical_server_name";
        this.databaseName = "connector_test_ro";
        Testing.Files.delete((Path)DB_HISTORY_PATH);
    }

    @After
    public void afterEach() {
        if (this.context != null) {
            try {
                this.context.shutdown();
            }
            finally {
                this.context = null;
                Testing.Files.delete((Path)DB_HISTORY_PATH);
            }
        }
    }

    protected Configuration.Builder simpleConfig() {
        return (Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)Configuration.create().with(MySqlConnectorConfig.HOSTNAME, this.hostname)).with(MySqlConnectorConfig.PORT, this.port)).with(MySqlConnectorConfig.USER, this.username)).with(MySqlConnectorConfig.PASSWORD, this.password)).with(MySqlConnectorConfig.SSL_MODE, MySqlConnectorConfig.SecureConnectionMode.DISABLED.name().toLowerCase())).with(MySqlConnectorConfig.SERVER_ID, this.serverId)).with(MySqlConnectorConfig.SERVER_NAME, this.serverName)).with(MySqlConnectorConfig.DATABASE_WHITELIST, this.databaseName)).with(MySqlConnectorConfig.DATABASE_HISTORY, FileDatabaseHistory.class)).with(FileDatabaseHistory.FILE_PATH, (Object)DB_HISTORY_PATH);
    }

    @Test
    public void shouldCreateTaskFromConfigurationWithNeverSnapshotMode() throws Exception {
        this.config = ((Configuration.Builder)this.simpleConfig().with(MySqlConnectorConfig.SNAPSHOT_MODE, MySqlConnectorConfig.SnapshotMode.NEVER.getValue())).build();
        this.context = new MySqlTaskContext(this.config);
        this.context.start();
        Assertions.assertThat((String)("" + this.context.snapshotMode().getValue())).isEqualTo((Object)MySqlConnectorConfig.SnapshotMode.NEVER.getValue());
        Assertions.assertThat((boolean)this.context.isSnapshotAllowedWhenNeeded()).isEqualTo(false);
        Assertions.assertThat((boolean)this.context.isSnapshotNeverAllowed()).isEqualTo(true);
    }

    @Test
    public void shouldCreateTaskFromConfigurationWithWhenNeededSnapshotMode() throws Exception {
        this.config = ((Configuration.Builder)this.simpleConfig().with(MySqlConnectorConfig.SNAPSHOT_MODE, MySqlConnectorConfig.SnapshotMode.WHEN_NEEDED.getValue())).build();
        this.context = new MySqlTaskContext(this.config);
        this.context.start();
        Assertions.assertThat((String)("" + this.context.snapshotMode().getValue())).isEqualTo((Object)MySqlConnectorConfig.SnapshotMode.WHEN_NEEDED.getValue());
        Assertions.assertThat((boolean)this.context.isSnapshotAllowedWhenNeeded()).isEqualTo(true);
        Assertions.assertThat((boolean)this.context.isSnapshotNeverAllowed()).isEqualTo(false);
    }

    @Test
    public void shouldUseGtidSetIncludes() throws Exception {
        this.config = ((Configuration.Builder)this.simpleConfig().with(MySqlConnectorConfig.GTID_SOURCE_INCLUDES, "a,b,c,d.*")).build();
        this.context = new MySqlTaskContext(this.config);
        this.context.start();
        Predicate filter = this.context.gtidSourceFilter();
        Assertions.assertThat((Object)filter).isNotNull();
        Assertions.assertThat((boolean)filter.test("a")).isTrue();
        Assertions.assertThat((boolean)filter.test("b")).isTrue();
        Assertions.assertThat((boolean)filter.test("c")).isTrue();
        Assertions.assertThat((boolean)filter.test("d")).isTrue();
        Assertions.assertThat((boolean)filter.test("d1")).isTrue();
        Assertions.assertThat((boolean)filter.test("d2")).isTrue();
        Assertions.assertThat((boolean)filter.test("d1234xdgfe")).isTrue();
        Assertions.assertThat((boolean)filter.test("a1")).isFalse();
        Assertions.assertThat((boolean)filter.test("a2")).isFalse();
        Assertions.assertThat((boolean)filter.test("b1")).isFalse();
        Assertions.assertThat((boolean)filter.test("c1")).isFalse();
        Assertions.assertThat((boolean)filter.test("e")).isFalse();
    }

    @Test
    public void shouldUseGtidSetIncludesLiteralUuids() throws Exception {
        String gtidStr = "036d85a9-64e5-11e6-9b48-42010af0000c:1-2,7145bf69-d1ca-11e5-a588-0242ac110004:1-3200,7c1de3f2-3fd2-11e6-9cdc-42010af000bc:1-41";
        this.config = ((Configuration.Builder)this.simpleConfig().with(MySqlConnectorConfig.GTID_SOURCE_INCLUDES, "036d85a9-64e5-11e6-9b48-42010af0000c,7145bf69-d1ca-11e5-a588-0242ac110004")).build();
        this.context = new MySqlTaskContext(this.config);
        this.context.start();
        Predicate filter = this.context.gtidSourceFilter();
        Assertions.assertThat((Object)filter).isNotNull();
        Assertions.assertThat((boolean)filter.test("036d85a9-64e5-11e6-9b48-42010af0000c")).isTrue();
        Assertions.assertThat((boolean)filter.test("7145bf69-d1ca-11e5-a588-0242ac110004")).isTrue();
        Assertions.assertThat((boolean)filter.test("036d85a9-64e5-11e6-9b48-42010af0000c-extra")).isFalse();
        Assertions.assertThat((boolean)filter.test("7145bf69-d1ca-11e5-a588-0242ac110004-extra")).isFalse();
        Assertions.assertThat((boolean)filter.test("7c1de3f2-3fd2-11e6-9cdc-42010af000bc")).isFalse();
        GtidSet original = new GtidSet(gtidStr);
        Assertions.assertThat((Object)original.forServerWithId("036d85a9-64e5-11e6-9b48-42010af0000c")).isNotNull();
        Assertions.assertThat((Object)original.forServerWithId("7c1de3f2-3fd2-11e6-9cdc-42010af000bc")).isNotNull();
        Assertions.assertThat((Object)original.forServerWithId("7145bf69-d1ca-11e5-a588-0242ac110004")).isNotNull();
        GtidSet filtered = original.retainAll(filter);
        Assertions.assertThat((Object)filtered.forServerWithId("036d85a9-64e5-11e6-9b48-42010af0000c")).isNotNull();
        Assertions.assertThat((Object)filtered.forServerWithId("7c1de3f2-3fd2-11e6-9cdc-42010af000bc")).isNull();
        Assertions.assertThat((Object)filtered.forServerWithId("7145bf69-d1ca-11e5-a588-0242ac110004")).isNotNull();
    }

    @Test
    public void shouldUseGtidSetxcludesLiteralUuids() throws Exception {
        String gtidStr = "036d85a9-64e5-11e6-9b48-42010af0000c:1-2,7145bf69-d1ca-11e5-a588-0242ac110004:1-3200,7c1de3f2-3fd2-11e6-9cdc-42010af000bc:1-41";
        this.config = ((Configuration.Builder)this.simpleConfig().with(MySqlConnectorConfig.GTID_SOURCE_EXCLUDES, "7c1de3f2-3fd2-11e6-9cdc-42010af000bc")).build();
        this.context = new MySqlTaskContext(this.config);
        this.context.start();
        Predicate filter = this.context.gtidSourceFilter();
        Assertions.assertThat((Object)filter).isNotNull();
        Assertions.assertThat((boolean)filter.test("036d85a9-64e5-11e6-9b48-42010af0000c")).isTrue();
        Assertions.assertThat((boolean)filter.test("7145bf69-d1ca-11e5-a588-0242ac110004")).isTrue();
        Assertions.assertThat((boolean)filter.test("036d85a9-64e5-11e6-9b48-42010af0000c-extra")).isTrue();
        Assertions.assertThat((boolean)filter.test("7145bf69-d1ca-11e5-a588-0242ac110004-extra")).isTrue();
        Assertions.assertThat((boolean)filter.test("7c1de3f2-3fd2-11e6-9cdc-42010af000bc")).isFalse();
        GtidSet original = new GtidSet(gtidStr);
        Assertions.assertThat((Object)original.forServerWithId("036d85a9-64e5-11e6-9b48-42010af0000c")).isNotNull();
        Assertions.assertThat((Object)original.forServerWithId("7c1de3f2-3fd2-11e6-9cdc-42010af000bc")).isNotNull();
        Assertions.assertThat((Object)original.forServerWithId("7145bf69-d1ca-11e5-a588-0242ac110004")).isNotNull();
        GtidSet filtered = original.retainAll(filter);
        Assertions.assertThat((Object)filtered.forServerWithId("036d85a9-64e5-11e6-9b48-42010af0000c")).isNotNull();
        Assertions.assertThat((Object)filtered.forServerWithId("7c1de3f2-3fd2-11e6-9cdc-42010af000bc")).isNull();
        Assertions.assertThat((Object)filtered.forServerWithId("7145bf69-d1ca-11e5-a588-0242ac110004")).isNotNull();
    }

    @Test
    public void shouldNotAllowBothGtidSetIncludesAndExcludes() throws Exception {
        this.config = ((Configuration.Builder)((Configuration.Builder)this.simpleConfig().with(MySqlConnectorConfig.GTID_SOURCE_INCLUDES, "036d85a9-64e5-11e6-9b48-42010af0000c,7145bf69-d1ca-11e5-a588-0242ac110004")).with(MySqlConnectorConfig.GTID_SOURCE_EXCLUDES, "7c1de3f2-3fd2-11e6-9cdc-42010af000bc:1-41")).build();
        this.context = new MySqlTaskContext(this.config);
        boolean valid = this.config.validateAndRecord((Iterable)MySqlConnectorConfig.ALL_FIELDS, msg -> {});
        Assertions.assertThat((boolean)valid).isFalse();
    }

    @Test
    public void shouldFilterAndMergeGtidSet() throws Exception {
        String gtidStr = "036d85a9-64e5-11e6-9b48-42010af0000c:1-2,7c1de3f2-3fd2-11e6-9cdc-42010af000bc:5-41";
        String availableServerGtidStr = "036d85a9-64e5-11e6-9b48-42010af0000c:1-20,7145bf69-d1ca-11e5-a588-0242ac110004:1-3200,123e4567-e89b-12d3-a456-426655440000:1-41";
        this.config = ((Configuration.Builder)this.simpleConfig().with(MySqlConnectorConfig.GTID_SOURCE_INCLUDES, "036d85a9-64e5-11e6-9b48-42010af0000c")).build();
        this.context = new MySqlTaskContext(this.config);
        this.context.start();
        this.context.source().setCompletedGtidSet(gtidStr);
        GtidSet mergedGtidSet = this.context.filterGtidSet(new GtidSet(availableServerGtidStr));
        Assertions.assertThat((Object)mergedGtidSet).isNotNull();
        GtidSet.UUIDSet uuidSet1 = mergedGtidSet.forServerWithId("036d85a9-64e5-11e6-9b48-42010af0000c");
        GtidSet.UUIDSet uuidSet2 = mergedGtidSet.forServerWithId("7145bf69-d1ca-11e5-a588-0242ac110004");
        GtidSet.UUIDSet uuidSet3 = mergedGtidSet.forServerWithId("123e4567-e89b-12d3-a456-426655440000");
        GtidSet.UUIDSet uuidSet4 = mergedGtidSet.forServerWithId("7c1de3f2-3fd2-11e6-9cdc-42010af000bc");
        Assertions.assertThat((List)uuidSet1.getIntervals()).isEqualTo(Arrays.asList(new GtidSet.Interval(1L, 2L)));
        Assertions.assertThat((List)uuidSet2.getIntervals()).isEqualTo(Arrays.asList(new GtidSet.Interval(1L, 3200L)));
        Assertions.assertThat((List)uuidSet3.getIntervals()).isEqualTo(Arrays.asList(new GtidSet.Interval(1L, 41L)));
        Assertions.assertThat((Object)uuidSet4).isNull();
    }
}

