/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.config.Configuration;
import io.debezium.connector.mysql.GtidSet;
import io.debezium.connector.mysql.MySqlConnectorConfig;
import io.debezium.connector.mysql.MySqlJdbcContext;
import io.debezium.connector.mysql.MySqlSchema;
import io.debezium.connector.mysql.RecordMakers;
import io.debezium.connector.mysql.SourceInfo;
import io.debezium.connector.mysql.TopicSelector;
import io.debezium.function.Predicates;
import io.debezium.util.Clock;
import io.debezium.util.LoggingContext;
import io.debezium.util.Strings;
import java.util.Map;
import java.util.function.Predicate;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public final class MySqlTaskContext
extends MySqlJdbcContext {
    private final SourceInfo source;
    private final MySqlSchema dbSchema;
    private final TopicSelector topicSelector;
    private final RecordMakers recordProcessor;
    private final Predicate<String> gtidSourceFilter;
    private final Clock clock = Clock.system();

    public MySqlTaskContext(Configuration config) {
        super(config);
        this.topicSelector = TopicSelector.defaultSelector(this.serverName());
        this.source = new SourceInfo();
        this.source.setServerName(this.serverName());
        this.dbSchema = new MySqlSchema(config, this.serverName());
        this.recordProcessor = new RecordMakers(this.dbSchema, this.source, this.topicSelector);
        String gtidSetIncludes = config.getString(MySqlConnectorConfig.GTID_SOURCE_INCLUDES);
        String gtidSetExcludes = config.getString(MySqlConnectorConfig.GTID_SOURCE_EXCLUDES);
        this.gtidSourceFilter = gtidSetIncludes != null ? Predicates.includes((String)gtidSetIncludes) : (gtidSetExcludes != null ? Predicates.excludes((String)gtidSetExcludes) : null);
    }

    public String connectorName() {
        return this.config.getString("name");
    }

    public TopicSelector topicSelector() {
        return this.topicSelector;
    }

    public SourceInfo source() {
        return this.source;
    }

    public MySqlSchema dbSchema() {
        return this.dbSchema;
    }

    public RecordMakers makeRecord() {
        return this.recordProcessor;
    }

    public Predicate<String> gtidSourceFilter() {
        return this.gtidSourceFilter;
    }

    public void initializeHistory() {
        Map<String, String> variables = this.readMySqlCharsetSystemVariables(null);
        String ddlStatement = this.setStatementFor(variables);
        this.dbSchema.applyDdl(this.source, "", ddlStatement, null);
    }

    public void loadHistory(SourceInfo startingPoint) {
        Map<String, String> variables = this.readMySqlCharsetSystemVariables(null);
        this.dbSchema.setSystemVariables(variables);
        this.dbSchema.loadHistory(startingPoint);
        String systemCharsetName = variables.get("character_set_server");
        String systemCharsetNameFromHistory = this.dbSchema.systemVariables().getVariable("character_set_server");
        if (!Strings.equalsIgnoreCase((String)systemCharsetName, (String)systemCharsetNameFromHistory)) {
            String ddlStatement = this.setStatementFor(variables);
            this.dbSchema.applyDdl(this.source, "", ddlStatement, null);
        }
        this.recordProcessor.regenerate();
    }

    public Clock clock() {
        return this.clock;
    }

    public long serverId() {
        return this.config.getLong(MySqlConnectorConfig.SERVER_ID);
    }

    public String serverName() {
        String serverName = this.config.getString(MySqlConnectorConfig.SERVER_NAME);
        if (serverName == null) {
            serverName = this.hostname() + ":" + this.port();
        }
        return serverName;
    }

    public int maxQueueSize() {
        return this.config.getInteger(MySqlConnectorConfig.MAX_QUEUE_SIZE);
    }

    public int maxBatchSize() {
        return this.config.getInteger(MySqlConnectorConfig.MAX_BATCH_SIZE);
    }

    public long timeoutInMilliseconds() {
        return this.config.getLong(MySqlConnectorConfig.CONNECTION_TIMEOUT_MS);
    }

    public long pollIntervalInMillseconds() {
        return this.config.getLong(MySqlConnectorConfig.POLL_INTERVAL_MS);
    }

    public long rowCountForLargeTable() {
        return this.config.getLong(MySqlConnectorConfig.ROW_COUNT_FOR_STREAMING_RESULT_SETS);
    }

    public boolean includeSchemaChangeRecords() {
        return this.config.getBoolean(MySqlConnectorConfig.INCLUDE_SCHEMA_CHANGES);
    }

    public boolean isSnapshotAllowedWhenNeeded() {
        return this.snapshotMode() == MySqlConnectorConfig.SnapshotMode.WHEN_NEEDED;
    }

    public boolean isSnapshotNeverAllowed() {
        return this.snapshotMode() == MySqlConnectorConfig.SnapshotMode.NEVER;
    }

    public boolean isInitialSnapshotOnly() {
        return this.snapshotMode() == MySqlConnectorConfig.SnapshotMode.INITIAL_ONLY;
    }

    public boolean isSchemaOnlySnapshot() {
        return this.snapshotMode() == MySqlConnectorConfig.SnapshotMode.SCHEMA_ONLY;
    }

    protected MySqlConnectorConfig.SnapshotMode snapshotMode() {
        String value = this.config.getString(MySqlConnectorConfig.SNAPSHOT_MODE);
        return MySqlConnectorConfig.SnapshotMode.parse(value, MySqlConnectorConfig.SNAPSHOT_MODE.defaultValueAsString());
    }

    public boolean useMinimalSnapshotLocking() {
        return this.config.getBoolean(MySqlConnectorConfig.SNAPSHOT_MINIMAL_LOCKING);
    }

    @Override
    public void start() {
        super.start();
        this.dbSchema().start();
    }

    @Override
    public void shutdown() {
        try {
            this.logger.debug("Stopping database history");
            this.dbSchema.shutdown();
        }
        catch (Throwable e) {
            this.logger.error("Unexpected error shutting down the database history", e);
        }
        finally {
            super.shutdown();
        }
    }

    public LoggingContext.PreviousContext configureLoggingContext(String contextName) {
        return LoggingContext.forConnector((String)"MySQL", (String)this.serverName(), (String)contextName);
    }

    public void temporaryLoggingContext(String contextName, Runnable operation) {
        LoggingContext.temporarilyForConnector((String)"MySQL", (String)this.serverName(), (String)contextName, (Runnable)operation);
    }

    public ObjectName metricName(String contextName) throws MalformedObjectNameException {
        return new ObjectName("debezium.mysql:type=connector-metrics,context=" + contextName + ",server=" + this.serverName());
    }

    public GtidSet filterGtidSet(GtidSet availableServerGtidSet) {
        String gtidStr = this.source.gtidSet();
        if (gtidStr == null) {
            return null;
        }
        this.logger.info("Attempting to generate a filtered GTID set");
        this.logger.info("GTID set from previous recorded offset: {}", (Object)gtidStr);
        GtidSet filteredGtidSet = new GtidSet(gtidStr);
        Predicate<String> gtidSourceFilter = this.gtidSourceFilter();
        if (gtidSourceFilter != null) {
            filteredGtidSet = filteredGtidSet.retainAll(gtidSourceFilter);
            this.logger.info("GTID set after applying GTID source includes/excludes to previous recorded offset: {}", (Object)filteredGtidSet);
        }
        this.logger.info("GTID set available on server: {}", (Object)availableServerGtidSet);
        GtidSet mergedGtidSet = availableServerGtidSet.with(filteredGtidSet);
        this.logger.info("Final merged GTID set to use when connecting to MySQL: {}", (Object)mergedGtidSet);
        return mergedGtidSet;
    }
}

