/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import com.github.shyiko.mysql.binlog.network.ServerException;
import io.debezium.connector.mysql.MySqlTaskContext;
import io.debezium.util.Clock;
import io.debezium.util.Metronome;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.source.SourceRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractReader {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final MySqlTaskContext context;
    private final BlockingQueue<SourceRecord> records;
    private final AtomicBoolean running = new AtomicBoolean(false);
    private final AtomicBoolean success = new AtomicBoolean(false);
    private final AtomicReference<ConnectException> failure = new AtomicReference();
    private ConnectException failureException;
    private final int maxBatchSize;
    private final Metronome metronome;

    public AbstractReader(MySqlTaskContext context) {
        this.context = context;
        this.records = new LinkedBlockingDeque<SourceRecord>(context.maxQueueSize());
        this.maxBatchSize = context.maxBatchSize();
        this.metronome = Metronome.parker((long)context.pollIntervalInMillseconds(), (TimeUnit)TimeUnit.MILLISECONDS, (Clock)Clock.SYSTEM);
    }

    public void start() {
        if (this.running.compareAndSet(false, true)) {
            this.failure.set(null);
            this.success.set(false);
            this.doStart();
        }
    }

    public void stop() {
        try {
            if (this.running.compareAndSet(true, false)) {
                this.doStop();
            }
        }
        finally {
            this.doShutdown();
        }
    }

    protected abstract void doStart();

    protected abstract void doStop();

    protected abstract void doCleanup();

    protected abstract void doShutdown();

    protected void completeSuccessfully() {
        this.success.set(true);
    }

    protected void failed(Throwable error) {
        this.failure.set(this.wrap(error));
    }

    protected void failed(Throwable error, String msg) {
        ConnectException wrapped = this.wrap(error);
        this.logger.error("Failed due to error: {}", (Object)msg, (Object)wrapped);
        this.failure.set(wrapped);
    }

    protected ConnectException wrap(Throwable error) {
        assert (error != null);
        String msg = error.getMessage();
        if (error instanceof ServerException) {
            ServerException e = (ServerException)error;
            msg = msg + " Error code: " + e.getErrorCode() + "; SQLSTATE: " + e.getSqlState() + ".";
        } else if (error instanceof SQLException) {
            SQLException e = (SQLException)error;
            msg = e.getMessage() + " Error code: " + e.getErrorCode() + "; SQLSTATE: " + e.getSQLState() + ".";
        }
        return new ConnectException(msg, error);
    }

    public boolean isRunning() {
        return this.running.get();
    }

    public List<SourceRecord> poll() throws InterruptedException {
        this.failureException = this.failure.get();
        if (this.failureException != null) {
            throw this.failureException;
        }
        this.logger.trace("Polling for next batch of records");
        ArrayList<SourceRecord> batch = new ArrayList<SourceRecord>(this.maxBatchSize);
        while (this.running.get() && this.records.drainTo(batch, this.maxBatchSize) == 0 && !this.success.get()) {
            this.metronome.pause();
            this.failureException = this.failure.get();
            if (this.failureException == null) continue;
            throw this.failureException;
        }
        if (batch.isEmpty() && this.success.get() && this.records.isEmpty()) {
            this.running.set(false);
            this.doCleanup();
            return null;
        }
        this.pollComplete(batch);
        this.logger.trace("Completed batch of {} records", (Object)batch.size());
        return batch;
    }

    protected void pollComplete(List<SourceRecord> batch) {
    }

    protected void enqueueRecord(SourceRecord record) throws InterruptedException {
        if (record != null) {
            this.records.put(record);
        }
    }
}

