/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.config.Configuration;
import io.debezium.config.Field;
import io.debezium.connector.mysql.MySqlConnectorConfig;
import io.debezium.jdbc.JdbcConnection;
import io.debezium.util.Strings;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.kafka.connect.errors.ConnectException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MySqlJdbcContext
implements AutoCloseable {
    protected static final String MYSQL_CONNECTION_URL = "jdbc:mysql://${hostname}:${port}/?useInformationSchema=true&nullCatalogMeansCurrent=false&useSSL=${useSSL}&useUnicode=true&characterEncoding=UTF-8&characterSetResults=UTF-8&zeroDateTimeBehavior=convertToNull";
    protected static JdbcConnection.ConnectionFactory FACTORY = JdbcConnection.patternBasedFactory((String)"jdbc:mysql://${hostname}:${port}/?useInformationSchema=true&nullCatalogMeansCurrent=false&useSSL=${useSSL}&useUnicode=true&characterEncoding=UTF-8&characterSetResults=UTF-8&zeroDateTimeBehavior=convertToNull", (Field[])new Field[0]);
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final Configuration config;
    protected final JdbcConnection jdbc;
    private final Map<String, String> originalSystemProperties = new HashMap<String, String>();

    public MySqlJdbcContext(Configuration config) {
        this.config = config;
        boolean useSSL = this.sslModeEnabled();
        Configuration jdbcConfig = config.subset("database.", true).edit().with("useSSL", Boolean.toString(useSSL)).build();
        this.jdbc = new JdbcConnection(jdbcConfig, FACTORY);
    }

    public Configuration config() {
        return this.config;
    }

    public JdbcConnection jdbc() {
        return this.jdbc;
    }

    public Logger logger() {
        return this.logger;
    }

    public String username() {
        return this.config.getString(MySqlConnectorConfig.USER);
    }

    public String password() {
        return this.config.getString(MySqlConnectorConfig.PASSWORD);
    }

    public String hostname() {
        return this.config.getString(MySqlConnectorConfig.HOSTNAME);
    }

    public int port() {
        return this.config.getInteger(MySqlConnectorConfig.PORT);
    }

    public MySqlConnectorConfig.SecureConnectionMode sslMode() {
        String mode = this.config.getString(MySqlConnectorConfig.SSL_MODE);
        return MySqlConnectorConfig.SecureConnectionMode.parse(mode);
    }

    public boolean sslModeEnabled() {
        return this.sslMode() != MySqlConnectorConfig.SecureConnectionMode.DISABLED;
    }

    public void start() {
        if (this.sslModeEnabled()) {
            this.originalSystemProperties.clear();
            this.setSystemProperty("javax.net.ssl.keyStore", MySqlConnectorConfig.SSL_KEYSTORE, true);
            this.setSystemProperty("javax.net.ssl.keyStorePassword", MySqlConnectorConfig.SSL_KEYSTORE_PASSWORD, false);
            this.setSystemProperty("javax.net.ssl.trustStore", MySqlConnectorConfig.SSL_TRUSTSTORE, true);
            this.setSystemProperty("javax.net.ssl.trustStorePassword", MySqlConnectorConfig.SSL_KEYSTORE_PASSWORD, false);
        }
    }

    public void shutdown() {
        try {
            this.jdbc.close();
        }
        catch (SQLException e) {
            this.logger.error("Unexpected error shutting down the database connection", (Throwable)e);
        }
        finally {
            this.originalSystemProperties.forEach((name, value) -> {
                if (value != null) {
                    System.setProperty(name, value);
                } else {
                    System.clearProperty(name);
                }
            });
        }
    }

    @Override
    public void close() {
        this.shutdown();
    }

    protected String connectionString() {
        return this.jdbc.connectionString(MYSQL_CONNECTION_URL);
    }

    protected Map<String, String> readMySqlCharsetSystemVariables(AtomicReference<String> sql) {
        HashMap<String, String> variables = new HashMap<String, String>();
        try (JdbcConnection mysql = this.jdbc.connect();){
            this.logger.debug("Reading MySQL charset-related system variables before parsing DDL history.");
            String statement = "SHOW VARIABLES WHERE Variable_name IN ('character_set_server','collation_server')";
            if (sql != null) {
                sql.set(statement);
            }
            mysql.query(statement, rs -> {
                while (rs.next()) {
                    String varName = rs.getString(1);
                    String value = rs.getString(2);
                    if (varName == null || value == null) continue;
                    variables.put(varName, value);
                    this.logger.debug("\t{} = {}", (Object)Strings.pad((String)varName, (int)45, (char)' '), (Object)Strings.pad((String)value, (int)45, (char)' '));
                }
            });
        }
        catch (SQLException e) {
            throw new ConnectException("Error reading MySQL variables: " + e.getMessage(), (Throwable)e);
        }
        return variables;
    }

    protected String setStatementFor(Map<String, String> variables) {
        StringBuilder sb = new StringBuilder("SET ");
        boolean first = true;
        ArrayList<String> varNames = new ArrayList<String>(variables.keySet());
        Collections.sort(varNames);
        for (String varName : varNames) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(varName).append("=");
            String value = variables.get(varName);
            if (value == null) {
                value = "";
            }
            if (value.contains(",") || value.contains(";")) {
                value = "'" + value + "'";
            }
            sb.append(value);
        }
        return sb.append(";").toString();
    }

    protected void setSystemProperty(String property, Field field, boolean showValueInError) {
        String value = this.config.getString(field);
        if (value != null) {
            value = value.trim();
            String existingValue = System.getProperty(property);
            if (existingValue == null) {
                String existing = System.setProperty(property, value);
                this.originalSystemProperties.put(property, existing);
            } else if (!(existingValue = existingValue.trim()).equalsIgnoreCase(value)) {
                String msg = "System or JVM property '" + property + "' is already defined, but the configuration property '" + field.name() + "' defines a different value";
                if (showValueInError) {
                    msg = "System or JVM property '" + property + "' is already defined as " + existingValue + ", but the configuration property '" + field.name() + "' defines a different value '" + value + "'";
                }
                throw new ConnectException(msg);
            }
        }
    }
}

