/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import com.github.shyiko.mysql.binlog.BinaryLogClient;
import com.github.shyiko.mysql.binlog.event.DeleteRowsEventData;
import com.github.shyiko.mysql.binlog.event.Event;
import com.github.shyiko.mysql.binlog.event.EventData;
import com.github.shyiko.mysql.binlog.event.EventHeader;
import com.github.shyiko.mysql.binlog.event.EventHeaderV4;
import com.github.shyiko.mysql.binlog.event.EventType;
import com.github.shyiko.mysql.binlog.event.GtidEventData;
import com.github.shyiko.mysql.binlog.event.QueryEventData;
import com.github.shyiko.mysql.binlog.event.RotateEventData;
import com.github.shyiko.mysql.binlog.event.TableMapEventData;
import com.github.shyiko.mysql.binlog.event.UpdateRowsEventData;
import com.github.shyiko.mysql.binlog.event.WriteRowsEventData;
import com.github.shyiko.mysql.binlog.event.deserialization.EventDataDeserializer;
import com.github.shyiko.mysql.binlog.event.deserialization.EventDeserializer;
import com.github.shyiko.mysql.binlog.event.deserialization.GtidEventDataDeserializer;
import com.github.shyiko.mysql.binlog.io.ByteArrayInputStream;
import com.github.shyiko.mysql.binlog.network.AuthenticationException;
import com.github.shyiko.mysql.binlog.network.SSLMode;
import io.debezium.connector.mysql.AbstractReader;
import io.debezium.connector.mysql.GtidSet;
import io.debezium.connector.mysql.MySqlConnectorConfig;
import io.debezium.connector.mysql.MySqlTaskContext;
import io.debezium.connector.mysql.RecordMakers;
import io.debezium.connector.mysql.RowDeserializers;
import io.debezium.connector.mysql.SourceInfo;
import io.debezium.connector.mysql.StopEventDataDeserializer;
import io.debezium.function.BlockingConsumer;
import io.debezium.relational.TableId;
import io.debezium.util.Clock;
import io.debezium.util.ElapsedTimeStrategy;
import io.debezium.util.Strings;
import java.io.IOException;
import java.io.Serializable;
import java.util.BitSet;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Predicate;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.source.SourceRecord;

public class BinlogReader
extends AbstractReader {
    private static final long INITIAL_POLL_PERIOD_IN_MILLIS = TimeUnit.SECONDS.toMillis(5L);
    private static final long MAX_POLL_PERIOD_IN_MILLIS = TimeUnit.HOURS.toMillis(1L);
    private final boolean recordSchemaChangesInSourceRecords;
    private final RecordMakers recordMakers;
    private final SourceInfo source;
    private final EnumMap<EventType, BlockingConsumer<Event>> eventHandlers = new EnumMap(EventType.class);
    private BinaryLogClient client;
    private int startingRowNumber = 0;
    private final Clock clock;
    private final ElapsedTimeStrategy pollOutputDelay;
    private long recordCounter = 0L;
    private long previousOutputMillis = 0L;
    private final AtomicLong totalRecordCounter = new AtomicLong();
    private volatile Map<String, ?> lastOffset = null;
    private com.github.shyiko.mysql.binlog.GtidSet gtidSet;

    public BinlogReader(MySqlTaskContext context) {
        super(context);
        this.source = context.source();
        this.recordMakers = context.makeRecord();
        this.recordSchemaChangesInSourceRecords = context.includeSchemaChangeRecords();
        this.clock = context.clock();
        this.pollOutputDelay = ElapsedTimeStrategy.exponential((Clock)this.clock, (long)INITIAL_POLL_PERIOD_IN_MILLIS, (long)MAX_POLL_PERIOD_IN_MILLIS);
        this.client = new BinaryLogClient(context.hostname(), context.port(), context.username(), context.password());
        this.client.setServerId(context.serverId());
        this.client.setSSLMode(this.sslModeFor(context.sslMode()));
        this.client.setKeepAlive(context.config().getBoolean(MySqlConnectorConfig.KEEP_ALIVE));
        this.client.registerEventListener(this::handleEvent);
        this.client.registerLifecycleListener((BinaryLogClient.LifecycleListener)new ReaderThreadLifecycleListener());
        if (this.logger.isDebugEnabled()) {
            this.client.registerEventListener(this::logEvent);
        }
        final HashMap<Long, TableMapEventData> tableMapEventByTableId = new HashMap<Long, TableMapEventData>();
        EventDeserializer eventDeserializer = new EventDeserializer(){

            public Event nextEvent(ByteArrayInputStream inputStream) throws IOException {
                Event event = super.nextEvent(inputStream);
                if (event.getHeader().getEventType() == EventType.TABLE_MAP) {
                    TableMapEventData tableMapEvent = (TableMapEventData)event.getData();
                    tableMapEventByTableId.put(tableMapEvent.getTableId(), tableMapEvent);
                }
                return event;
            }
        };
        eventDeserializer.setEventDataDeserializer(EventType.STOP, (EventDataDeserializer)new StopEventDataDeserializer());
        eventDeserializer.setEventDataDeserializer(EventType.GTID, (EventDataDeserializer)new GtidEventDataDeserializer());
        eventDeserializer.setEventDataDeserializer(EventType.WRITE_ROWS, (EventDataDeserializer)new RowDeserializers.WriteRowsDeserializer(tableMapEventByTableId));
        eventDeserializer.setEventDataDeserializer(EventType.UPDATE_ROWS, (EventDataDeserializer)new RowDeserializers.UpdateRowsDeserializer(tableMapEventByTableId));
        eventDeserializer.setEventDataDeserializer(EventType.DELETE_ROWS, (EventDataDeserializer)new RowDeserializers.DeleteRowsDeserializer(tableMapEventByTableId));
        eventDeserializer.setEventDataDeserializer(EventType.EXT_WRITE_ROWS, (EventDataDeserializer)new RowDeserializers.WriteRowsDeserializer(tableMapEventByTableId).setMayContainExtraInformation(true));
        eventDeserializer.setEventDataDeserializer(EventType.EXT_UPDATE_ROWS, (EventDataDeserializer)new RowDeserializers.UpdateRowsDeserializer(tableMapEventByTableId).setMayContainExtraInformation(true));
        eventDeserializer.setEventDataDeserializer(EventType.EXT_DELETE_ROWS, (EventDataDeserializer)new RowDeserializers.DeleteRowsDeserializer(tableMapEventByTableId).setMayContainExtraInformation(true));
        this.client.setEventDeserializer(eventDeserializer);
    }

    @Override
    protected void doStart() {
        this.eventHandlers.put(EventType.STOP, (BlockingConsumer<Event>)((BlockingConsumer)this::handleServerStop));
        this.eventHandlers.put(EventType.HEARTBEAT, (BlockingConsumer<Event>)((BlockingConsumer)this::handleServerHeartbeat));
        this.eventHandlers.put(EventType.INCIDENT, (BlockingConsumer<Event>)((BlockingConsumer)this::handleServerIncident));
        this.eventHandlers.put(EventType.ROTATE, (BlockingConsumer<Event>)((BlockingConsumer)this::handleRotateLogsEvent));
        this.eventHandlers.put(EventType.TABLE_MAP, (BlockingConsumer<Event>)((BlockingConsumer)this::handleUpdateTableMetadata));
        this.eventHandlers.put(EventType.QUERY, (BlockingConsumer<Event>)((BlockingConsumer)this::handleQueryEvent));
        this.eventHandlers.put(EventType.WRITE_ROWS, (BlockingConsumer<Event>)((BlockingConsumer)this::handleInsert));
        this.eventHandlers.put(EventType.UPDATE_ROWS, (BlockingConsumer<Event>)((BlockingConsumer)this::handleUpdate));
        this.eventHandlers.put(EventType.DELETE_ROWS, (BlockingConsumer<Event>)((BlockingConsumer)this::handleDelete));
        this.eventHandlers.put(EventType.EXT_WRITE_ROWS, (BlockingConsumer<Event>)((BlockingConsumer)this::handleInsert));
        this.eventHandlers.put(EventType.EXT_UPDATE_ROWS, (BlockingConsumer<Event>)((BlockingConsumer)this::handleUpdate));
        this.eventHandlers.put(EventType.EXT_DELETE_ROWS, (BlockingConsumer<Event>)((BlockingConsumer)this::handleDelete));
        String gtidSetStr = this.source.gtidSet();
        if (gtidSetStr != null) {
            this.eventHandlers.put(EventType.GTID, (BlockingConsumer<Event>)((BlockingConsumer)this::handleGtidEvent));
            this.logger.info("GTID set from previous recorded offset: {}", (Object)gtidSetStr);
            Predicate<String> gtidSourceFilter = this.context.gtidSourceFilter();
            if (gtidSourceFilter != null) {
                GtidSet gtidSet = new GtidSet(gtidSetStr).retainAll(gtidSourceFilter);
                gtidSetStr = gtidSet.toString();
                this.logger.info("GTID set after applying GTID source includes/excludes: {}", (Object)gtidSetStr);
                this.source.setGtidSet(gtidSetStr);
            }
            this.client.setGtidSet(gtidSetStr);
            this.gtidSet = new com.github.shyiko.mysql.binlog.GtidSet(gtidSetStr);
        } else {
            this.client.setBinlogFilename(this.source.binlogFilename());
            this.client.setBinlogPosition(this.source.nextBinlogPosition());
            this.gtidSet = null;
        }
        this.startingRowNumber = this.source.nextEventRowNumber();
        this.pollOutputDelay.hasElapsed();
        this.previousOutputMillis = this.clock.currentTimeInMillis();
        if (this.isRunning()) {
            long timeoutInMilliseconds = this.context.timeoutInMilliseconds();
            long started = this.context.clock().currentTimeInMillis();
            try {
                this.logger.debug("Attempting to establish binlog reader connection with timeout of {} ms", (Object)timeoutInMilliseconds);
                this.client.connect(this.context.timeoutInMilliseconds());
            }
            catch (TimeoutException e) {
                long duration = this.context.clock().currentTimeInMillis() - started;
                if ((double)duration > 0.9 * (double)this.context.timeoutInMilliseconds()) {
                    double actualSeconds = TimeUnit.MILLISECONDS.toSeconds(duration);
                    throw new ConnectException("Timed out after " + actualSeconds + " seconds while waiting to connect to MySQL at " + this.context.hostname() + ":" + this.context.port() + " with user '" + this.context.username() + "'", (Throwable)e);
                }
            }
            catch (AuthenticationException e) {
                throw new ConnectException("Failed to authenticate to the MySQL database at " + this.context.hostname() + ":" + this.context.port() + " with user '" + this.context.username() + "'", (Throwable)e);
            }
            catch (Throwable e) {
                throw new ConnectException("Unable to connect to the MySQL database at " + this.context.hostname() + ":" + this.context.port() + " with user '" + this.context.username() + "': " + e.getMessage(), e);
            }
        }
    }

    @Override
    protected void doStop() {
        try {
            this.logger.debug("Stopping binlog reader, last recorded offset: {}", this.lastOffset);
            this.client.disconnect();
        }
        catch (IOException e) {
            this.logger.error("Unexpected error when disconnecting from the MySQL binary log reader", (Throwable)e);
        }
    }

    @Override
    protected void doCleanup() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void pollComplete(List<SourceRecord> batch) {
        int batchSize = batch.size();
        this.recordCounter += (long)batchSize;
        this.totalRecordCounter.addAndGet(batchSize);
        if (batchSize > 0) {
            SourceRecord lastRecord = batch.get(batchSize - 1);
            this.lastOffset = lastRecord.sourceOffset();
            if (this.pollOutputDelay.hasElapsed()) {
                long millisSinceLastOutput = this.clock.currentTimeInMillis() - this.previousOutputMillis;
                try {
                    this.context.temporaryLoggingContext("binlog", () -> this.logger.info("{} records sent during previous {}, last recorded offset: {}", new Object[]{this.recordCounter, Strings.duration((long)millisSinceLastOutput), this.lastOffset}));
                }
                finally {
                    this.recordCounter = 0L;
                    this.previousOutputMillis += millisSinceLastOutput;
                }
            }
        }
    }

    protected void logEvent(Event event) {
        this.logger.trace("Received event: {}", (Object)event);
    }

    protected void ignoreEvent(Event event) {
        this.logger.trace("Ignoring event due to missing handler: {}", (Object)event);
    }

    protected void handleEvent(Event event) {
        if (event == null) {
            return;
        }
        EventHeader eventHeader = event.getHeader();
        this.source.setBinlogTimestampSeconds(eventHeader.getTimestamp() / 1000L);
        this.source.setBinlogServerId(eventHeader.getServerId());
        EventType eventType = eventHeader.getEventType();
        if (eventType == EventType.ROTATE) {
            EventData eventData = event.getData();
            RotateEventData rotateEventData = eventData instanceof EventDeserializer.EventDataWrapper ? (RotateEventData)((EventDeserializer.EventDataWrapper)eventData).getInternal() : (RotateEventData)eventData;
            this.source.setBinlogStartPoint(rotateEventData.getBinlogFilename(), rotateEventData.getBinlogPosition());
        } else if (eventHeader instanceof EventHeaderV4) {
            EventHeaderV4 trackableEventHeader = (EventHeaderV4)eventHeader;
            this.source.setEventPosition(trackableEventHeader.getPosition(), trackableEventHeader.getEventLength());
        }
        try {
            this.eventHandlers.getOrDefault(eventType, (BlockingConsumer<Event>)((BlockingConsumer)this::ignoreEvent)).accept((Object)event);
            this.startingRowNumber = 0;
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            this.eventHandlers.clear();
            this.logger.info("Stopped processing binlog events due to thread interruption");
        }
    }

    protected <T extends EventData> T unwrapData(Event event) {
        EventData eventData = event.getData();
        if (eventData instanceof EventDeserializer.EventDataWrapper) {
            eventData = ((EventDeserializer.EventDataWrapper)eventData).getInternal();
        }
        return (T)eventData;
    }

    protected void handleServerStop(Event event) {
        this.logger.debug("Server stopped: {}", (Object)event);
    }

    protected void handleServerHeartbeat(Event event) {
        this.logger.trace("Server heartbeat: {}", (Object)event);
    }

    protected void handleServerIncident(Event event) {
        this.logger.trace("Server incident: {}", (Object)event);
    }

    protected void handleRotateLogsEvent(Event event) {
        this.logger.debug("Rotating logs: {}", (Object)event);
        RotateEventData command = (RotateEventData)this.unwrapData(event);
        assert (command != null);
        this.recordMakers.clear();
    }

    protected void handleGtidEvent(Event event) {
        this.logger.debug("GTID transaction: {}", (Object)event);
        GtidEventData gtidEvent = (GtidEventData)this.unwrapData(event);
        String gtid = gtidEvent.getGtid();
        this.gtidSet.add(gtid);
        this.source.setGtid(gtid);
        this.source.setGtidSet(this.gtidSet.toString());
    }

    protected void handleQueryEvent(Event event) {
        QueryEventData command = (QueryEventData)this.unwrapData(event);
        this.logger.debug("Received update table command: {}", (Object)event);
        this.context.dbSchema().applyDdl(this.context.source(), command.getDatabase(), command.getSql(), (dbName, statements) -> {
            if (this.recordSchemaChangesInSourceRecords && this.recordMakers.schemaChanges(dbName, statements, (BlockingConsumer<SourceRecord>)((BlockingConsumer)x$0 -> super.enqueueRecord((SourceRecord)x$0))) > 0) {
                this.logger.debug("Recorded DDL statements for database '{}': {}", (Object)dbName, (Object)statements);
            }
        });
    }

    protected void handleUpdateTableMetadata(Event event) {
        String tableName;
        String databaseName;
        TableId tableId;
        TableMapEventData metadata = (TableMapEventData)this.unwrapData(event);
        long tableNumber = metadata.getTableId();
        if (this.recordMakers.assign(tableNumber, tableId = new TableId(databaseName = metadata.getDatabase(), null, tableName = metadata.getTable()))) {
            this.logger.debug("Received update table metadata event: {}", (Object)event);
        } else {
            this.logger.debug("Skipping update table metadata event: {}", (Object)event);
        }
    }

    protected void handleInsert(Event event) throws InterruptedException {
        BitSet includedColumns;
        WriteRowsEventData write = (WriteRowsEventData)this.unwrapData(event);
        long tableNumber = write.getTableId();
        RecordMakers.RecordsForTable recordMaker = this.recordMakers.forTable(tableNumber, includedColumns = write.getIncludedColumns(), (BlockingConsumer<SourceRecord>)((BlockingConsumer)x$0 -> super.enqueueRecord((SourceRecord)x$0)));
        if (recordMaker != null) {
            List rows = write.getRows();
            Long ts = this.context.clock().currentTimeInMillis();
            int count = 0;
            int numRows = rows.size();
            for (int row = this.startingRowNumber; row != numRows; ++row) {
                count += recordMaker.create((Object[])rows.get(row), ts, row, numRows);
            }
            this.logger.debug("Recorded {} insert records for event: {}", (Object)count, (Object)event);
        } else {
            this.logger.debug("Skipping insert row event: {}", (Object)event);
        }
    }

    protected void handleUpdate(Event event) throws InterruptedException {
        BitSet includedColumns;
        UpdateRowsEventData update = (UpdateRowsEventData)this.unwrapData(event);
        long tableNumber = update.getTableId();
        RecordMakers.RecordsForTable recordMaker = this.recordMakers.forTable(tableNumber, includedColumns = update.getIncludedColumns(), (BlockingConsumer<SourceRecord>)((BlockingConsumer)x$0 -> super.enqueueRecord((SourceRecord)x$0)));
        if (recordMaker != null) {
            List rows = update.getRows();
            Long ts = this.context.clock().currentTimeInMillis();
            int count = 0;
            int numRows = rows.size();
            for (int row = this.startingRowNumber; row != numRows; ++row) {
                Map.Entry changes = (Map.Entry)rows.get(row);
                Object[] before = (Serializable[])changes.getKey();
                Object[] after = (Serializable[])changes.getValue();
                count += recordMaker.update(before, after, ts, row, numRows);
            }
            this.logger.debug("Recorded {} update records for event: {}", (Object)count, (Object)event);
        } else {
            this.logger.debug("Skipping update row event: {}", (Object)event);
        }
    }

    protected void handleDelete(Event event) throws InterruptedException {
        BitSet includedColumns;
        DeleteRowsEventData deleted = (DeleteRowsEventData)this.unwrapData(event);
        long tableNumber = deleted.getTableId();
        RecordMakers.RecordsForTable recordMaker = this.recordMakers.forTable(tableNumber, includedColumns = deleted.getIncludedColumns(), (BlockingConsumer<SourceRecord>)((BlockingConsumer)x$0 -> super.enqueueRecord((SourceRecord)x$0)));
        if (recordMaker != null) {
            List rows = deleted.getRows();
            Long ts = this.context.clock().currentTimeInMillis();
            int count = 0;
            int numRows = rows.size();
            for (int row = this.startingRowNumber; row != numRows; ++row) {
                count += recordMaker.delete((Object[])rows.get(row), ts, row, numRows);
            }
            this.logger.debug("Recorded {} delete records for event: {}", (Object)count, (Object)event);
        } else {
            this.logger.debug("Skipping delete row event: {}", (Object)event);
        }
    }

    protected SSLMode sslModeFor(MySqlConnectorConfig.SecureConnectionMode mode) {
        switch (mode) {
            case DISABLED: {
                return SSLMode.DISABLED;
            }
            case PREFERRED: {
                return SSLMode.PREFERRED;
            }
            case REQUIRED: {
                return SSLMode.REQUIRED;
            }
            case VERIFY_CA: {
                return SSLMode.VERIFY_CA;
            }
            case VERIFY_IDENTITY: {
                return SSLMode.VERIFY_IDENTITY;
            }
        }
        return null;
    }

    protected final class ReaderThreadLifecycleListener
    implements BinaryLogClient.LifecycleListener {
        protected ReaderThreadLifecycleListener() {
        }

        public void onDisconnect(BinaryLogClient client) {
            BinlogReader.this.context.temporaryLoggingContext("binlog", () -> {
                Map offset = BinlogReader.this.lastOffset;
                if (offset != null) {
                    BinlogReader.this.logger.info("Stopped reading binlog after {} events, last recorded offset: {}", (Object)BinlogReader.this.totalRecordCounter, (Object)offset);
                } else {
                    BinlogReader.this.logger.info("Stopped reading binlog after {} events, no new offset was recorded", (Object)BinlogReader.this.totalRecordCounter);
                }
            });
        }

        public void onConnect(BinaryLogClient client) {
            BinlogReader.this.context.configureLoggingContext("binlog");
            BinlogReader.this.logger.info("Connected to MySQL binlog at {}:{}, starting at {}", new Object[]{BinlogReader.this.context.hostname(), BinlogReader.this.context.port(), BinlogReader.this.source});
        }

        public void onCommunicationFailure(BinaryLogClient client, Exception ex) {
            BinlogReader.this.failed(ex);
        }

        public void onEventDeserializationFailure(BinaryLogClient client, Exception ex) {
            BinlogReader.this.failed(ex);
        }
    }
}

