/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.config.Configuration;
import io.debezium.connector.mysql.MySqlConnectorConfig;
import io.debezium.connector.mysql.MySqlJdbcContext;
import io.debezium.connector.mysql.MySqlSchema;
import io.debezium.connector.mysql.RecordMakers;
import io.debezium.connector.mysql.SourceInfo;
import io.debezium.connector.mysql.TopicSelector;
import io.debezium.util.Clock;
import io.debezium.util.LoggingContext;
import io.debezium.util.Strings;
import java.util.Map;

public final class MySqlTaskContext
extends MySqlJdbcContext {
    private final SourceInfo source;
    private final MySqlSchema dbSchema;
    private final TopicSelector topicSelector;
    private final RecordMakers recordProcessor;
    private final Clock clock = Clock.system();

    public MySqlTaskContext(Configuration config) {
        super(config);
        this.topicSelector = TopicSelector.defaultSelector(this.serverName());
        this.source = new SourceInfo();
        this.source.setServerName(this.serverName());
        this.dbSchema = new MySqlSchema(config, this.serverName());
        this.dbSchema.start();
        this.recordProcessor = new RecordMakers(this.dbSchema, this.source, this.topicSelector);
    }

    public TopicSelector topicSelector() {
        return this.topicSelector;
    }

    public SourceInfo source() {
        return this.source;
    }

    public MySqlSchema dbSchema() {
        return this.dbSchema;
    }

    public RecordMakers makeRecord() {
        return this.recordProcessor;
    }

    public void initializeHistory() {
        Map<String, String> variables = this.readMySqlCharsetSystemVariables(null);
        String ddlStatement = this.setStatementFor(variables);
        this.dbSchema.applyDdl(this.source, "", ddlStatement, null);
    }

    public void loadHistory(SourceInfo startingPoint) {
        Map<String, String> variables = this.readMySqlCharsetSystemVariables(null);
        this.dbSchema.setSystemVariables(variables);
        this.dbSchema.loadHistory(startingPoint);
        String systemCharsetName = variables.get("character_set_server");
        String systemCharsetNameFromHistory = this.dbSchema.systemVariables().getVariable("character_set_server");
        if (!Strings.equalsIgnoreCase((String)systemCharsetName, (String)systemCharsetNameFromHistory)) {
            String ddlStatement = this.setStatementFor(variables);
            this.dbSchema.applyDdl(this.source, "", ddlStatement, null);
        }
        this.recordProcessor.regenerate();
    }

    public Clock clock() {
        return this.clock;
    }

    public long serverId() {
        return this.config.getLong(MySqlConnectorConfig.SERVER_ID);
    }

    public String serverName() {
        String serverName = this.config.getString(MySqlConnectorConfig.SERVER_NAME);
        if (serverName == null) {
            serverName = this.hostname() + ":" + this.port();
        }
        return serverName;
    }

    public int maxQueueSize() {
        return this.config.getInteger(MySqlConnectorConfig.MAX_QUEUE_SIZE);
    }

    public int maxBatchSize() {
        return this.config.getInteger(MySqlConnectorConfig.MAX_BATCH_SIZE);
    }

    public long timeoutInMilliseconds() {
        return this.config.getLong(MySqlConnectorConfig.CONNECTION_TIMEOUT_MS);
    }

    public long pollIntervalInMillseconds() {
        return this.config.getLong(MySqlConnectorConfig.POLL_INTERVAL_MS);
    }

    public long rowCountForLargeTable() {
        return this.config.getLong(MySqlConnectorConfig.ROW_COUNT_FOR_STREAMING_RESULT_SETS);
    }

    public boolean includeSchemaChangeRecords() {
        return this.config.getBoolean(MySqlConnectorConfig.INCLUDE_SCHEMA_CHANGES);
    }

    public boolean isSnapshotAllowedWhenNeeded() {
        return this.snapshotMode() == MySqlConnectorConfig.SnapshotMode.WHEN_NEEDED;
    }

    public boolean isSnapshotNeverAllowed() {
        return this.snapshotMode() == MySqlConnectorConfig.SnapshotMode.NEVER;
    }

    protected MySqlConnectorConfig.SnapshotMode snapshotMode() {
        String value = this.config.getString(MySqlConnectorConfig.SNAPSHOT_MODE);
        return MySqlConnectorConfig.SnapshotMode.parse(value, MySqlConnectorConfig.SNAPSHOT_MODE.defaultValueAsString());
    }

    public boolean useMinimalSnapshotLocking() {
        return this.config.getBoolean(MySqlConnectorConfig.SNAPSHOT_MINIMAL_LOCKING);
    }

    @Override
    public void start() {
        super.start();
        this.dbSchema().start();
    }

    @Override
    public void shutdown() {
        try {
            this.logger.debug("Stopping database history");
            this.dbSchema.shutdown();
        }
        catch (Throwable e) {
            this.logger.error("Unexpected error shutting down the database history", e);
        }
        finally {
            super.shutdown();
        }
    }

    public LoggingContext.PreviousContext configureLoggingContext(String contextName) {
        return LoggingContext.forConnector((String)"MySQL", (String)this.serverName(), (String)contextName);
    }

    public void temporaryLoggingContext(String contextName, Runnable operation) {
        LoggingContext.temporarilyForConnector((String)"MySQL", (String)this.serverName(), (String)contextName, (Runnable)operation);
    }
}

