/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class MySqlSystemVariables {
    public static final String CHARSET_NAME_SERVER = "character_set_server";
    private final ConcurrentMap<String, String> global = new ConcurrentHashMap<String, String>();
    private final ConcurrentMap<String, String> session = new ConcurrentHashMap<String, String>();

    public MySqlSystemVariables setVariable(Scope scope, String name, String value) {
        name = this.variableName(name);
        if (value != null) {
            this.forScope(scope).put(name, value);
        } else {
            this.forScope(scope).remove(name);
        }
        return this;
    }

    public String getVariable(String name, Scope scope) {
        name = this.variableName(name);
        return (String)this.forScope(scope).get(name);
    }

    public String getVariable(String name) {
        String value = (String)this.session.get(name = this.variableName(name));
        if (value == null) {
            value = (String)this.global.get(name);
        }
        return value;
    }

    private String variableName(String name) {
        return name.toLowerCase();
    }

    private ConcurrentMap<String, String> forScope(Scope scope) {
        if (scope != null) {
            switch (scope) {
                case GLOBAL: {
                    return this.global;
                }
                case SESSION: 
                case LOCAL: {
                    return this.session;
                }
            }
        }
        return this.session;
    }

    public static enum Scope {
        GLOBAL,
        SESSION,
        LOCAL;

    }
}

