/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.annotation.NotThreadSafe;
import io.debezium.config.Configuration;
import io.debezium.connector.mysql.AbstractReader;
import io.debezium.connector.mysql.BinlogReader;
import io.debezium.connector.mysql.GtidSet;
import io.debezium.connector.mysql.Module;
import io.debezium.connector.mysql.MySqlConnectorConfig;
import io.debezium.connector.mysql.MySqlTaskContext;
import io.debezium.connector.mysql.SnapshotReader;
import io.debezium.connector.mysql.SourceInfo;
import io.debezium.util.LoggingContext;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.source.SourceRecord;
import org.apache.kafka.connect.source.SourceTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public final class MySqlConnectorTask
extends SourceTask {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private MySqlTaskContext taskContext;
    private SnapshotReader snapshotReader;
    private BinlogReader binlogReader;
    private volatile AbstractReader currentReader;

    public String version() {
        return Module.version();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(Map<String, String> props) {
        if (this.context == null) {
            throw new ConnectException("Unexpected null context");
        }
        Configuration config = Configuration.from(props);
        if (!config.validateAndRecord((Iterable)MySqlConnectorConfig.ALL_FIELDS, arg_0 -> ((Logger)this.logger).error(arg_0))) {
            throw new ConnectException("Error configuring an instance of " + ((Object)((Object)this)).getClass().getSimpleName() + "; check the logs for details");
        }
        this.taskContext = new MySqlTaskContext(config);
        LoggingContext.PreviousContext prevLoggingContext = this.taskContext.configureLoggingContext("task");
        try {
            this.taskContext.start();
            boolean startWithSnapshot = false;
            boolean snapshotEventsAreInserts = true;
            SourceInfo source = this.taskContext.source();
            Map offsets = this.context.offsetStorageReader().offset(this.taskContext.source().partition());
            if (offsets != null) {
                source.setOffset(offsets);
                this.logger.info("Found existing offset: {}", (Object)offsets);
                this.taskContext.loadHistory(source);
                if (source.isSnapshotInEffect()) {
                    if (this.taskContext.isSnapshotNeverAllowed()) {
                        String msg = "The connector previously stopped while taking a snapshot, but now the connector is configured to never allow snapshots. Reconfigure the connector to use snapshots initially or when needed.";
                        throw new ConnectException(msg);
                    }
                    startWithSnapshot = true;
                    this.logger.info("Prior execution was an incomplete snapshot, so starting new snapshot");
                } else {
                    startWithSnapshot = false;
                    if (!this.isBinlogAvailable()) {
                        if (!this.taskContext.isSnapshotAllowedWhenNeeded()) {
                            String msg = "The connector is trying to read binlog starting at " + source + ", but this is no longer " + "available on the server. Reconfigure the connector to use a snapshot when needed.";
                            throw new ConnectException(msg);
                        }
                        startWithSnapshot = true;
                    }
                }
            } else if (this.taskContext.isSnapshotNeverAllowed()) {
                this.logger.info("Found no existing offset and snapshots disallowed, so starting at beginning of binlog");
                source.setBinlogStartPoint("", 0L);
                this.taskContext.initializeHistory();
            } else {
                startWithSnapshot = true;
                this.logger.info("Found no existing offset, so preparing to perform a snapshot");
            }
            if (!startWithSnapshot && source.gtidSet() == null && this.isGtidModeEnabled()) {
                source.setGtidSet("");
            }
            this.binlogReader = new BinlogReader(this.taskContext);
            if (startWithSnapshot) {
                this.snapshotReader = new SnapshotReader(this.taskContext);
                this.snapshotReader.onSuccessfulCompletion(this::transitionToReadBinlog);
                this.snapshotReader.useMinimalBlocking(this.taskContext.useMinimalSnapshotLocking());
                if (snapshotEventsAreInserts) {
                    this.snapshotReader.generateInsertEvents();
                }
                this.currentReader = this.snapshotReader;
            } else {
                this.currentReader = this.binlogReader;
            }
            this.currentReader.start();
        }
        finally {
            prevLoggingContext.restore();
        }
    }

    public List<SourceRecord> poll() throws InterruptedException {
        LoggingContext.PreviousContext prevLoggingContext = this.taskContext.configureLoggingContext("task");
        try {
            this.logger.trace("Polling for events");
            List<SourceRecord> list = this.currentReader.poll();
            return list;
        }
        finally {
            prevLoggingContext.restore();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void stop() {
        if (this.context == null) return;
        LoggingContext.PreviousContext prevLoggingContext = this.taskContext.configureLoggingContext("task");
        try {
            this.logger.info("Stopping MySQL connector task");
            if (this.snapshotReader == null) return;
            this.snapshotReader.stop();
            return;
        }
        finally {
            try {
                if (this.binlogReader != null) {
                    this.binlogReader.stop();
                }
            }
            finally {
                try {
                    if (this.taskContext != null) {
                        this.taskContext.shutdown();
                    }
                }
                catch (Throwable e) {
                    this.logger.error("Unexpected error shutting down the database history and/or closing JDBC connections", e);
                }
                finally {
                    this.context = null;
                    this.logger.info("Connector task successfully stopped");
                    prevLoggingContext.restore();
                }
            }
        }
    }

    protected void transitionToReadBinlog() {
        this.logger.debug("Transitioning from snapshot reader to binlog reader");
        this.binlogReader.start();
        this.currentReader = this.binlogReader;
    }

    protected boolean isBinlogAvailable() {
        String gtidStr = this.taskContext.source().gtidSet();
        if (gtidStr != null) {
            if (gtidStr.trim().isEmpty()) {
                return true;
            }
            String availableGtidStr = this.knownGtidSet();
            if (availableGtidStr == null || availableGtidStr.trim().isEmpty()) {
                this.logger.info("Connector used GTIDs previously, but MySQL does not know of any GTIDs or they are not enabled");
                return false;
            }
            GtidSet gtidSet = new GtidSet(gtidStr);
            GtidSet availableGtidSet = new GtidSet(this.knownGtidSet());
            if (gtidSet.isContainedWithin(availableGtidSet)) {
                this.logger.info("MySQL current GTID set {} does contain the GTID set required by the connector {}", (Object)availableGtidSet, (Object)gtidSet);
                return true;
            }
            this.logger.info("Connector last known GTIDs are {}, but MySQL has {}", (Object)gtidSet, (Object)availableGtidSet);
            return false;
        }
        String binlogFilename = this.taskContext.source().binlogFilename();
        if (binlogFilename == null) {
            return true;
        }
        if (binlogFilename.equals("")) {
            return true;
        }
        ArrayList logNames = new ArrayList();
        try {
            this.logger.info("Step 0: Get all known binlogs from MySQL");
            this.taskContext.jdbc().query("SHOW BINARY LOGS", rs -> {
                while (rs.next()) {
                    logNames.add(rs.getString(1));
                }
            });
        }
        catch (SQLException e) {
            throw new ConnectException("Unexpected error while connecting to MySQL and looking for binary logs: ", (Throwable)e);
        }
        boolean found = logNames.stream().anyMatch(binlogFilename::equals);
        if (!found) {
            this.logger.info("Connector requires binlog file '{}', but MySQL only has {}", (Object)binlogFilename, (Object)String.join((CharSequence)", ", logNames));
        }
        this.logger.info("MySQL has the binlog file '{}' required by the connector", (Object)binlogFilename);
        return found;
    }

    protected boolean isGtidModeEnabled() {
        AtomicReference<String> mode = new AtomicReference<String>("off");
        try {
            this.taskContext.jdbc().query("SHOW GLOBAL VARIABLES LIKE 'GTID_MODE'", rs -> {
                if (rs.next()) {
                    mode.set(rs.getString(1));
                }
            });
        }
        catch (SQLException e) {
            throw new ConnectException("Unexpected error while connecting to MySQL and looking at GTID mode: ", (Throwable)e);
        }
        return !"OFF".equalsIgnoreCase(mode.get());
    }

    protected String knownGtidSet() {
        AtomicReference gtidSetStr = new AtomicReference();
        try {
            this.taskContext.jdbc().query("SHOW MASTER STATUS", rs -> {
                if (rs.next()) {
                    gtidSetStr.set(rs.getString(5));
                }
            });
        }
        catch (SQLException e) {
            throw new ConnectException("Unexpected error while connecting to MySQL and looking at GTID mode: ", (Throwable)e);
        }
        return (String)gtidSetStr.get();
    }
}

