/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.confluent.connect.avro.AvroData;
import io.debezium.connector.mysql.SourceInfo;
import io.debezium.doc.FixFor;
import io.debezium.document.Document;
import java.util.HashMap;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.kafka.connect.data.Struct;
import org.fest.assertions.Assertions;
import org.fest.assertions.GenericAssert;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SourceInfoTest {
    private static int avroSchemaCacheSize = 1000;
    private static final AvroData avroData = new AvroData(avroSchemaCacheSize);
    private static final String FILENAME = "mysql-bin.00001";
    private static final String GTID_SET = "gtid-set";
    private static final String SERVER_NAME = "my-server";
    private SourceInfo source;

    @Before
    public void beforeEach() {
        this.source = new SourceInfo();
    }

    @Test
    public void shouldStartSourceInfoFromZeroBinlogCoordinates() {
        this.source.setBinlogStartPoint(FILENAME, 0L);
        Assertions.assertThat((String)this.source.binlogFilename()).isEqualTo((Object)FILENAME);
        Assertions.assertThat((long)this.source.nextBinlogPosition()).isEqualTo(0L);
        Assertions.assertThat((long)this.source.lastBinlogPosition()).isEqualTo(0L);
        Assertions.assertThat((int)this.source.nextEventRowNumber()).isEqualTo(0);
        Assertions.assertThat((int)this.source.lastEventRowNumber()).isEqualTo(0);
        Assertions.assertThat((boolean)this.source.isSnapshotInEffect()).isFalse();
    }

    @Test
    public void shouldStartSourceInfoFromNonZeroBinlogCoordinates() {
        this.source.setBinlogStartPoint(FILENAME, 100L);
        Assertions.assertThat((String)this.source.binlogFilename()).isEqualTo((Object)FILENAME);
        Assertions.assertThat((long)this.source.nextBinlogPosition()).isEqualTo(100L);
        Assertions.assertThat((long)this.source.lastBinlogPosition()).isEqualTo(100L);
        Assertions.assertThat((int)this.source.nextEventRowNumber()).isEqualTo(0);
        Assertions.assertThat((int)this.source.lastEventRowNumber()).isEqualTo(0);
        Assertions.assertThat((boolean)this.source.isSnapshotInEffect()).isFalse();
    }

    @Test
    public void shouldRecoverSourceInfoFromOffsetWithZeroBinlogCoordinates() {
        this.sourceWith(this.offset(0L, 0));
        Assertions.assertThat((String)this.source.gtidSet()).isNull();
        Assertions.assertThat((String)this.source.binlogFilename()).isEqualTo((Object)FILENAME);
        Assertions.assertThat((long)this.source.nextBinlogPosition()).isEqualTo(0L);
        Assertions.assertThat((long)this.source.lastBinlogPosition()).isEqualTo(0L);
        Assertions.assertThat((int)this.source.nextEventRowNumber()).isEqualTo(0);
        Assertions.assertThat((int)this.source.lastEventRowNumber()).isEqualTo(0);
        Assertions.assertThat((boolean)this.source.isSnapshotInEffect()).isFalse();
    }

    @Test
    public void shouldRecoverSourceInfoFromOffsetWithNonZeroBinlogCoordinates() {
        this.sourceWith(this.offset(100L, 0));
        Assertions.assertThat((String)this.source.gtidSet()).isNull();
        Assertions.assertThat((String)this.source.binlogFilename()).isEqualTo((Object)FILENAME);
        Assertions.assertThat((long)this.source.nextBinlogPosition()).isEqualTo(100L);
        Assertions.assertThat((long)this.source.lastBinlogPosition()).isEqualTo(100L);
        Assertions.assertThat((int)this.source.nextEventRowNumber()).isEqualTo(0);
        Assertions.assertThat((int)this.source.lastEventRowNumber()).isEqualTo(0);
        Assertions.assertThat((boolean)this.source.isSnapshotInEffect()).isFalse();
    }

    @Test
    public void shouldRecoverSourceInfoFromOffsetWithZeroBinlogCoordinatesAndNonZeroRow() {
        this.sourceWith(this.offset(0L, 5));
        Assertions.assertThat((String)this.source.gtidSet()).isNull();
        Assertions.assertThat((String)this.source.binlogFilename()).isEqualTo((Object)FILENAME);
        Assertions.assertThat((long)this.source.nextBinlogPosition()).isEqualTo(0L);
        Assertions.assertThat((long)this.source.lastBinlogPosition()).isEqualTo(0L);
        Assertions.assertThat((int)this.source.nextEventRowNumber()).isEqualTo(5);
        Assertions.assertThat((int)this.source.lastEventRowNumber()).isEqualTo(5);
        Assertions.assertThat((boolean)this.source.isSnapshotInEffect()).isFalse();
    }

    @Test
    public void shouldRecoverSourceInfoFromOffsetWithNonZeroBinlogCoordinatesAndNonZeroRow() {
        this.sourceWith(this.offset(100L, 5));
        Assertions.assertThat((String)this.source.gtidSet()).isNull();
        Assertions.assertThat((String)this.source.binlogFilename()).isEqualTo((Object)FILENAME);
        Assertions.assertThat((long)this.source.nextBinlogPosition()).isEqualTo(100L);
        Assertions.assertThat((long)this.source.lastBinlogPosition()).isEqualTo(100L);
        Assertions.assertThat((int)this.source.nextEventRowNumber()).isEqualTo(5);
        Assertions.assertThat((int)this.source.lastEventRowNumber()).isEqualTo(5);
        Assertions.assertThat((boolean)this.source.isSnapshotInEffect()).isFalse();
    }

    @Test
    public void shouldRecoverSourceInfoFromOffsetWithZeroBinlogCoordinatesAndSnapshot() {
        this.sourceWith(this.offset(0L, 0, true));
        Assertions.assertThat((String)this.source.gtidSet()).isNull();
        Assertions.assertThat((String)this.source.binlogFilename()).isEqualTo((Object)FILENAME);
        Assertions.assertThat((long)this.source.nextBinlogPosition()).isEqualTo(0L);
        Assertions.assertThat((long)this.source.lastBinlogPosition()).isEqualTo(0L);
        Assertions.assertThat((int)this.source.nextEventRowNumber()).isEqualTo(0);
        Assertions.assertThat((int)this.source.lastEventRowNumber()).isEqualTo(0);
        Assertions.assertThat((boolean)this.source.isSnapshotInEffect()).isTrue();
    }

    @Test
    public void shouldRecoverSourceInfoFromOffsetWithNonZeroBinlogCoordinatesAndSnapshot() {
        this.sourceWith(this.offset(100L, 0, true));
        Assertions.assertThat((String)this.source.gtidSet()).isNull();
        Assertions.assertThat((String)this.source.binlogFilename()).isEqualTo((Object)FILENAME);
        Assertions.assertThat((long)this.source.nextBinlogPosition()).isEqualTo(100L);
        Assertions.assertThat((long)this.source.lastBinlogPosition()).isEqualTo(100L);
        Assertions.assertThat((int)this.source.nextEventRowNumber()).isEqualTo(0);
        Assertions.assertThat((int)this.source.lastEventRowNumber()).isEqualTo(0);
        Assertions.assertThat((boolean)this.source.isSnapshotInEffect()).isTrue();
    }

    @Test
    public void shouldRecoverSourceInfoFromOffsetWithZeroBinlogCoordinatesAndNonZeroRowAndSnapshot() {
        this.sourceWith(this.offset(0L, 5, true));
        Assertions.assertThat((String)this.source.gtidSet()).isNull();
        Assertions.assertThat((String)this.source.binlogFilename()).isEqualTo((Object)FILENAME);
        Assertions.assertThat((long)this.source.nextBinlogPosition()).isEqualTo(0L);
        Assertions.assertThat((long)this.source.lastBinlogPosition()).isEqualTo(0L);
        Assertions.assertThat((int)this.source.nextEventRowNumber()).isEqualTo(5);
        Assertions.assertThat((int)this.source.lastEventRowNumber()).isEqualTo(5);
        Assertions.assertThat((boolean)this.source.isSnapshotInEffect()).isTrue();
    }

    @Test
    public void shouldRecoverSourceInfoFromOffsetWithNonZeroBinlogCoordinatesAndNonZeroRowAndSnapshot() {
        this.sourceWith(this.offset(100L, 5, true));
        Assertions.assertThat((String)this.source.gtidSet()).isNull();
        Assertions.assertThat((String)this.source.binlogFilename()).isEqualTo((Object)FILENAME);
        Assertions.assertThat((long)this.source.nextBinlogPosition()).isEqualTo(100L);
        Assertions.assertThat((long)this.source.lastBinlogPosition()).isEqualTo(100L);
        Assertions.assertThat((int)this.source.nextEventRowNumber()).isEqualTo(5);
        Assertions.assertThat((int)this.source.lastEventRowNumber()).isEqualTo(5);
        Assertions.assertThat((boolean)this.source.isSnapshotInEffect()).isTrue();
    }

    @Test
    public void shouldStartSourceInfoFromBinlogCoordinatesWithGtidsAndZeroBinlogCoordinates() {
        this.sourceWith(this.offset(GTID_SET, 0L, 0, false));
        Assertions.assertThat((String)this.source.gtidSet()).isEqualTo((Object)GTID_SET);
        Assertions.assertThat((String)this.source.binlogFilename()).isEqualTo((Object)FILENAME);
        Assertions.assertThat((long)this.source.nextBinlogPosition()).isEqualTo(0L);
        Assertions.assertThat((long)this.source.lastBinlogPosition()).isEqualTo(0L);
        Assertions.assertThat((int)this.source.nextEventRowNumber()).isEqualTo(0);
        Assertions.assertThat((int)this.source.lastEventRowNumber()).isEqualTo(0);
        Assertions.assertThat((boolean)this.source.isSnapshotInEffect()).isFalse();
    }

    @Test
    public void shouldStartSourceInfoFromBinlogCoordinatesWithGtidsAndZeroBinlogCoordinatesAndNonZeroRow() {
        this.sourceWith(this.offset(GTID_SET, 0L, 5, false));
        Assertions.assertThat((String)this.source.gtidSet()).isEqualTo((Object)GTID_SET);
        Assertions.assertThat((String)this.source.binlogFilename()).isEqualTo((Object)FILENAME);
        Assertions.assertThat((long)this.source.nextBinlogPosition()).isEqualTo(0L);
        Assertions.assertThat((long)this.source.lastBinlogPosition()).isEqualTo(0L);
        Assertions.assertThat((int)this.source.nextEventRowNumber()).isEqualTo(5);
        Assertions.assertThat((int)this.source.lastEventRowNumber()).isEqualTo(5);
        Assertions.assertThat((boolean)this.source.isSnapshotInEffect()).isFalse();
    }

    @Test
    public void shouldStartSourceInfoFromBinlogCoordinatesWithGtidsAndNonZeroBinlogCoordinates() {
        this.sourceWith(this.offset(GTID_SET, 100L, 0, false));
        Assertions.assertThat((String)this.source.gtidSet()).isEqualTo((Object)GTID_SET);
        Assertions.assertThat((String)this.source.binlogFilename()).isEqualTo((Object)FILENAME);
        Assertions.assertThat((long)this.source.nextBinlogPosition()).isEqualTo(100L);
        Assertions.assertThat((long)this.source.lastBinlogPosition()).isEqualTo(100L);
        Assertions.assertThat((int)this.source.nextEventRowNumber()).isEqualTo(0);
        Assertions.assertThat((int)this.source.lastEventRowNumber()).isEqualTo(0);
        Assertions.assertThat((boolean)this.source.isSnapshotInEffect()).isFalse();
    }

    @Test
    public void shouldStartSourceInfoFromBinlogCoordinatesWithGtidsAndNonZeroBinlogCoordinatesAndNonZeroRow() {
        this.sourceWith(this.offset(GTID_SET, 100L, 5, false));
        Assertions.assertThat((String)this.source.gtidSet()).isEqualTo((Object)GTID_SET);
        Assertions.assertThat((String)this.source.binlogFilename()).isEqualTo((Object)FILENAME);
        Assertions.assertThat((long)this.source.nextBinlogPosition()).isEqualTo(100L);
        Assertions.assertThat((long)this.source.lastBinlogPosition()).isEqualTo(100L);
        Assertions.assertThat((int)this.source.nextEventRowNumber()).isEqualTo(5);
        Assertions.assertThat((int)this.source.lastEventRowNumber()).isEqualTo(5);
        Assertions.assertThat((boolean)this.source.isSnapshotInEffect()).isFalse();
    }

    @Test
    public void shouldStartSourceInfoFromBinlogCoordinatesWithGtidsAndZeroBinlogCoordinatesAndSnapshot() {
        this.sourceWith(this.offset(GTID_SET, 0L, 0, true));
        Assertions.assertThat((String)this.source.gtidSet()).isEqualTo((Object)GTID_SET);
        Assertions.assertThat((String)this.source.binlogFilename()).isEqualTo((Object)FILENAME);
        Assertions.assertThat((long)this.source.nextBinlogPosition()).isEqualTo(0L);
        Assertions.assertThat((long)this.source.lastBinlogPosition()).isEqualTo(0L);
        Assertions.assertThat((int)this.source.nextEventRowNumber()).isEqualTo(0);
        Assertions.assertThat((int)this.source.lastEventRowNumber()).isEqualTo(0);
        Assertions.assertThat((boolean)this.source.isSnapshotInEffect()).isTrue();
    }

    @Test
    public void shouldStartSourceInfoFromBinlogCoordinatesWithGtidsAndZeroBinlogCoordinatesAndNonZeroRowAndSnapshot() {
        this.sourceWith(this.offset(GTID_SET, 0L, 5, true));
        Assertions.assertThat((String)this.source.gtidSet()).isEqualTo((Object)GTID_SET);
        Assertions.assertThat((String)this.source.binlogFilename()).isEqualTo((Object)FILENAME);
        Assertions.assertThat((long)this.source.nextBinlogPosition()).isEqualTo(0L);
        Assertions.assertThat((long)this.source.lastBinlogPosition()).isEqualTo(0L);
        Assertions.assertThat((int)this.source.nextEventRowNumber()).isEqualTo(5);
        Assertions.assertThat((int)this.source.lastEventRowNumber()).isEqualTo(5);
        Assertions.assertThat((boolean)this.source.isSnapshotInEffect()).isTrue();
    }

    @Test
    public void shouldStartSourceInfoFromBinlogCoordinatesWithGtidsAndNonZeroBinlogCoordinatesAndSnapshot() {
        this.sourceWith(this.offset(GTID_SET, 100L, 0, true));
        Assertions.assertThat((String)this.source.gtidSet()).isEqualTo((Object)GTID_SET);
        Assertions.assertThat((String)this.source.binlogFilename()).isEqualTo((Object)FILENAME);
        Assertions.assertThat((long)this.source.nextBinlogPosition()).isEqualTo(100L);
        Assertions.assertThat((long)this.source.lastBinlogPosition()).isEqualTo(100L);
        Assertions.assertThat((int)this.source.nextEventRowNumber()).isEqualTo(0);
        Assertions.assertThat((int)this.source.lastEventRowNumber()).isEqualTo(0);
        Assertions.assertThat((boolean)this.source.isSnapshotInEffect()).isTrue();
    }

    @Test
    public void shouldStartSourceInfoFromBinlogCoordinatesWithGtidsAndNonZeroBinlogCoordinatesAndNonZeroRowAndSnapshot() {
        this.sourceWith(this.offset(GTID_SET, 100L, 5, true));
        Assertions.assertThat((String)this.source.gtidSet()).isEqualTo((Object)GTID_SET);
        Assertions.assertThat((String)this.source.binlogFilename()).isEqualTo((Object)FILENAME);
        Assertions.assertThat((long)this.source.nextBinlogPosition()).isEqualTo(100L);
        Assertions.assertThat((long)this.source.lastBinlogPosition()).isEqualTo(100L);
        Assertions.assertThat((int)this.source.nextEventRowNumber()).isEqualTo(5);
        Assertions.assertThat((int)this.source.lastEventRowNumber()).isEqualTo(5);
        Assertions.assertThat((boolean)this.source.isSnapshotInEffect()).isTrue();
    }

    @Test
    public void shouldAdvanceSourceInfoFromNonZeroPositionAndRowZeroForEventsWithOneRow() {
        this.sourceWith(this.offset(100L, 0));
        this.handleNextEvent(200L, 10L, this.withRowCount(1));
        this.handleNextEvent(220L, 10L, this.withRowCount(1));
        this.handleNextEvent(250L, 50L, this.withRowCount(1));
    }

    @Test
    public void shouldAdvanceSourceInfoFromNonZeroPositionAndRowZeroForEventsWithMultipleRow() {
        this.sourceWith(this.offset(100L, 0));
        this.handleNextEvent(200L, 10L, this.withRowCount(3));
        this.handleNextEvent(220L, 10L, this.withRowCount(4));
        this.handleNextEvent(250L, 50L, this.withRowCount(6));
        this.handleNextEvent(300L, 20L, this.withRowCount(1));
        this.handleNextEvent(350L, 20L, this.withRowCount(3));
    }

    protected int withRowCount(int rowCount) {
        return rowCount;
    }

    protected void handleNextEvent(long positionOfEvent, long eventSize, int rowCount) {
        this.source.setEventPosition(positionOfEvent, eventSize);
        for (int i = 0; i != rowCount; ++i) {
            Map offset = this.source.offsetForRow(i, rowCount);
            if (i + 1 < rowCount) {
                Assertions.assertThat(offset.get("pos")).isEqualTo((Object)positionOfEvent);
                Assertions.assertThat(offset.get("row")).isEqualTo((Object)(i + 1));
            } else {
                Assertions.assertThat(offset.get("pos")).isEqualTo((Object)(positionOfEvent + eventSize));
                Assertions.assertThat(offset.get("row")).isEqualTo((Object)0);
            }
            Assertions.assertThat(offset.get("file")).isEqualTo((Object)FILENAME);
            if (this.source.gtidSet() != null) {
                Assertions.assertThat(offset.get("gtids")).isEqualTo((Object)this.source.gtidSet());
            }
            Struct recordSource = this.source.struct();
            Assertions.assertThat((Long)recordSource.getInt64("pos")).isEqualTo(positionOfEvent);
            Assertions.assertThat((Integer)recordSource.getInt32("row")).isEqualTo(i);
            Assertions.assertThat((String)recordSource.getString("file")).isEqualTo((Object)FILENAME);
            if (this.source.gtidSet() == null) continue;
            Assertions.assertThat((String)recordSource.getString("gtids")).isEqualTo((Object)this.source.gtidSet());
        }
    }

    protected Map<String, String> offset(long position, int row) {
        return this.offset(null, position, row, false);
    }

    protected Map<String, String> offset(long position, int row, boolean snapshot) {
        return this.offset(null, position, row, snapshot);
    }

    protected Map<String, String> offset(String gtidSet, long position, int row, boolean snapshot) {
        HashMap<String, String> offset = new HashMap<String, String>();
        offset.put("file", FILENAME);
        offset.put("pos", Long.toString(position));
        offset.put("row", Integer.toString(row));
        if (gtidSet != null) {
            offset.put("gtids", gtidSet);
        }
        if (snapshot) {
            offset.put("snapshot", Boolean.TRUE.toString());
        }
        return offset;
    }

    protected SourceInfo sourceWith(Map<String, String> offset) {
        this.source = new SourceInfo();
        this.source.setOffset(offset);
        this.source.setServerName(SERVER_NAME);
        return this.source;
    }

    @Test
    public void shouldValidateSourceInfoSchema() {
        org.apache.kafka.connect.data.Schema kafkaSchema = SourceInfo.SCHEMA;
        Schema avroSchema = avroData.fromConnectSchema(kafkaSchema);
        Assert.assertTrue((avroSchema != null ? 1 : 0) != 0);
    }

    @Test
    public void shouldConsiderPositionsWithSameGtidSetsAsSame() {
        this.assertPositionWithGtids("IdA:1-5").isAtOrBefore(this.positionWithGtids("IdA:1-5"));
        this.assertPositionWithGtids("IdA:1-5,IdB:1-20").isAtOrBefore(this.positionWithGtids("IdA:1-5,IdB:1-20"));
        this.assertPositionWithGtids("IdA:1-5,IdB:1-20").isAtOrBefore(this.positionWithGtids("IdB:1-20,IdA:1-5"));
    }

    @Test
    public void shouldConsiderPositionsWithSameGtidSetsAndSnapshotAsSame() {
        this.assertPositionWithGtids("IdA:1-5", true).isAtOrBefore(this.positionWithGtids("IdA:1-5", true));
        this.assertPositionWithGtids("IdA:1-5,IdB:1-20", true).isAtOrBefore(this.positionWithGtids("IdA:1-5,IdB:1-20", true));
        this.assertPositionWithGtids("IdA:1-5,IdB:1-20", true).isAtOrBefore(this.positionWithGtids("IdB:1-20,IdA:1-5", true));
    }

    @Test
    public void shouldOrderPositionWithGtidAndSnapshotBeforePositionWithSameGtidButNoSnapshot() {
        this.assertPositionWithGtids("IdA:1-5", true).isAtOrBefore(this.positionWithGtids("IdA:1-5"));
        this.assertPositionWithGtids("IdA:1-5,IdB:1-20", true).isAtOrBefore(this.positionWithGtids("IdA:1-5,IdB:1-20"));
        this.assertPositionWithGtids("IdA:1-5,IdB:1-20", true).isAtOrBefore(this.positionWithGtids("IdB:1-20,IdA:1-5"));
    }

    @Test
    public void shouldOrderPositionWithoutGtidAndSnapshotAfterPositionWithSameGtidAndSnapshot() {
        this.assertPositionWithGtids("IdA:1-5", false).isAfter(this.positionWithGtids("IdA:1-5", true));
        this.assertPositionWithGtids("IdA:1-5,IdB:1-20", false).isAfter(this.positionWithGtids("IdA:1-5,IdB:1-20", true));
        this.assertPositionWithGtids("IdA:1-5,IdB:1-20", false).isAfter(this.positionWithGtids("IdB:1-20,IdA:1-5", true));
    }

    @Test
    public void shouldOrderPositionWithGtidsAsBeforePositionWithExtraServerUuidInGtids() {
        this.assertPositionWithGtids("IdA:1-5").isBefore(this.positionWithGtids("IdA:1-5,IdB:1-20"));
    }

    @Test
    public void shouldOrderPositionsWithSameServerButLowerUpperLimitAsBeforePositionWithSameServerUuidInGtids() {
        this.assertPositionWithGtids("IdA:1-5").isBefore(this.positionWithGtids("IdA:1-6"));
        this.assertPositionWithGtids("IdA:1-5:7-9").isBefore(this.positionWithGtids("IdA:1-10"));
        this.assertPositionWithGtids("IdA:2-5:8-9").isBefore(this.positionWithGtids("IdA:1-10"));
    }

    @Test
    public void shouldOrderPositionWithoutGtidAsBeforePositionWithGtid() {
        this.assertPositionWithoutGtids("filename.01", Integer.MAX_VALUE, 0).isBefore(this.positionWithGtids("IdA:1-5"));
    }

    @Test
    public void shouldOrderPositionWithGtidAsAfterPositionWithoutGtid() {
        this.assertPositionWithGtids("IdA:1-5").isAfter(this.positionWithoutGtids("filename.01", 0, 0));
    }

    @Test
    @FixFor(value={"DBZ-107"})
    public void shouldRemoveNewlinesFromGtidSet() {
        String gtidExecuted = "036d85a9-64e5-11e6-9b48-42010af0000c:1-2,\n7145bf69-d1ca-11e5-a588-0242ac110004:1-3149,\n7c1de3f2-3fd2-11e6-9cdc-42010af000bc:1-39";
        String gtidCleaned = "036d85a9-64e5-11e6-9b48-42010af0000c:1-2,7145bf69-d1ca-11e5-a588-0242ac110004:1-3149,7c1de3f2-3fd2-11e6-9cdc-42010af000bc:1-39";
        this.source.setGtidSet(gtidExecuted);
        Assertions.assertThat((String)this.source.gtidSet()).isEqualTo((Object)gtidCleaned);
    }

    @Test
    @FixFor(value={"DBZ-107"})
    public void shouldNotSetBlankGtidSet() {
        this.source.setGtidSet("");
        Assertions.assertThat((String)this.source.gtidSet()).isNull();
    }

    @Test
    @FixFor(value={"DBZ-107"})
    public void shouldNotSetNullGtidSet() {
        this.source.setGtidSet(null);
        Assertions.assertThat((String)this.source.gtidSet()).isNull();
    }

    protected Document positionWithGtids(String gtids) {
        return this.positionWithGtids(gtids, false);
    }

    protected Document positionWithGtids(String gtids, boolean snapshot) {
        if (snapshot) {
            return Document.create((CharSequence)"gtids", (Object)gtids, (CharSequence)"snapshot", (Object)true);
        }
        return Document.create((CharSequence)"gtids", (Object)gtids);
    }

    protected Document positionWithoutGtids(String filename, int position, int row) {
        return this.positionWithoutGtids(filename, position, row, false);
    }

    protected Document positionWithoutGtids(String filename, int position, int row, boolean snapshot) {
        if (snapshot) {
            return Document.create((CharSequence)"file", (Object)filename, (CharSequence)"pos", (Object)position, (CharSequence)"row", (Object)row, (CharSequence)"snapshot", (Object)true);
        }
        return Document.create((CharSequence)"file", (Object)filename, (CharSequence)"pos", (Object)position, (CharSequence)"row", (Object)row);
    }

    protected PositionAssert assertThatDocument(Document position) {
        return new PositionAssert(position);
    }

    protected PositionAssert assertPositionWithGtids(String gtids) {
        return this.assertThatDocument(this.positionWithGtids(gtids));
    }

    protected PositionAssert assertPositionWithGtids(String gtids, boolean snapshot) {
        return this.assertThatDocument(this.positionWithGtids(gtids, snapshot));
    }

    protected PositionAssert assertPositionWithoutGtids(String filename, int position, int row) {
        return this.assertPositionWithoutGtids(filename, position, row, false);
    }

    protected PositionAssert assertPositionWithoutGtids(String filename, int position, int row, boolean snapshot) {
        return this.assertThatDocument(this.positionWithoutGtids(filename, position, row, snapshot));
    }

    protected static class PositionAssert
    extends GenericAssert<PositionAssert, Document> {
        public PositionAssert(Document position) {
            super(PositionAssert.class, (Object)position);
        }

        public PositionAssert isAt(Document otherPosition) {
            if (SourceInfo.isPositionAtOrBefore((Document)((Document)this.actual), (Document)otherPosition)) {
                return this;
            }
            this.failIfCustomMessageIsSet();
            throw this.failure(this.actual + " should be consider same position as " + otherPosition);
        }

        public PositionAssert isBefore(Document otherPosition) {
            return this.isAtOrBefore(otherPosition);
        }

        public PositionAssert isAtOrBefore(Document otherPosition) {
            if (SourceInfo.isPositionAtOrBefore((Document)((Document)this.actual), (Document)otherPosition)) {
                return this;
            }
            this.failIfCustomMessageIsSet();
            throw this.failure(this.actual + " should be consider same position as or before " + otherPosition);
        }

        public PositionAssert isAfter(Document otherPosition) {
            if (!SourceInfo.isPositionAtOrBefore((Document)((Document)this.actual), (Document)otherPosition)) {
                return this;
            }
            this.failIfCustomMessageIsSet();
            throw this.failure(this.actual + " should be consider after " + otherPosition);
        }
    }
}

