/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.config.Configuration;
import io.debezium.connector.mysql.MySqlConnectorConfig;
import io.debezium.connector.mysql.MySqlTaskContext;
import io.debezium.connector.mysql.SnapshotReader;
import io.debezium.data.KeyValueStore;
import io.debezium.data.SchemaChangeHistory;
import io.debezium.data.VerifyRecord;
import io.debezium.relational.history.FileDatabaseHistory;
import io.debezium.util.Testing;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.connect.source.SourceRecord;
import org.fest.assertions.Assertions;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SnapshotReaderIT {
    private static final Path DB_HISTORY_PATH = Testing.Files.createTestingPath((String)"file-db-history-snapshot.txt").toAbsolutePath();
    private static final String DB_NAME = "connector_test_ro";
    private static final String LOGICAL_NAME = "logical_server_name";
    private Configuration config;
    private MySqlTaskContext context;
    private SnapshotReader reader;
    private CountDownLatch completed;

    @Before
    public void beforeEach() {
        Testing.Files.delete((Path)DB_HISTORY_PATH);
        this.completed = new CountDownLatch(1);
    }

    @After
    public void afterEach() {
        if (this.context != null) {
            try {
                this.context.shutdown();
            }
            finally {
                this.context = null;
                Testing.Files.delete((Path)DB_HISTORY_PATH);
            }
        }
    }

    protected Configuration.Builder simpleConfig() {
        String hostname = System.getProperty("database.hostname");
        String port = System.getProperty("database.port");
        Assertions.assertThat((String)hostname).isNotNull();
        Assertions.assertThat((String)port).isNotNull();
        return (Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)Configuration.create().with(MySqlConnectorConfig.HOSTNAME, hostname)).with(MySqlConnectorConfig.PORT, port)).with(MySqlConnectorConfig.USER, "snapper")).with(MySqlConnectorConfig.PASSWORD, "snapperpass")).with(MySqlConnectorConfig.SSL_MODE, MySqlConnectorConfig.SecureConnectionMode.DISABLED.toString().toLowerCase())).with(MySqlConnectorConfig.SERVER_ID, 18911)).with(MySqlConnectorConfig.SERVER_NAME, LOGICAL_NAME)).with(MySqlConnectorConfig.POLL_INTERVAL_MS, 10)).with(MySqlConnectorConfig.INCLUDE_SCHEMA_CHANGES, false)).with(MySqlConnectorConfig.DATABASE_WHITELIST, DB_NAME)).with(MySqlConnectorConfig.DATABASE_HISTORY, FileDatabaseHistory.class)).with(FileDatabaseHistory.FILE_PATH, (Object)DB_HISTORY_PATH);
    }

    @Test
    public void shouldCreateSnapshotOfSingleDatabase() throws Exception {
        this.config = this.simpleConfig().build();
        this.context = new MySqlTaskContext(this.config);
        this.context.start();
        this.reader = new SnapshotReader(this.context);
        this.reader.onSuccessfulCompletion(this.completed::countDown);
        this.reader.generateInsertEvents();
        this.reader.useMinimalBlocking(true);
        this.reader.start();
        List records = null;
        KeyValueStore store = KeyValueStore.createForTopicsBeginningWith((String)"logical_server_name.");
        SchemaChangeHistory schemaChanges = new SchemaChangeHistory(LOGICAL_NAME);
        while ((records = this.reader.poll()) != null) {
            records.forEach(record -> {
                VerifyRecord.isValid((SourceRecord)record);
                store.add(record);
                schemaChanges.add(record);
            });
        }
        Assertions.assertThat((List)records).isNull();
        Assertions.assertThat((int)schemaChanges.recordCount()).isEqualTo(0);
        Assertions.assertThat((int)store.collectionCount()).isEqualTo(4);
        KeyValueStore.Collection products = store.collection(DB_NAME, "products");
        Assertions.assertThat((long)products.numberOfCreates()).isEqualTo(9L);
        Assertions.assertThat((long)products.numberOfUpdates()).isEqualTo(0L);
        Assertions.assertThat((long)products.numberOfDeletes()).isEqualTo(0L);
        Assertions.assertThat((long)products.numberOfReads()).isEqualTo(0L);
        Assertions.assertThat((long)products.numberOfTombstones()).isEqualTo(0L);
        Assertions.assertThat((long)products.numberOfKeySchemaChanges()).isEqualTo(1L);
        Assertions.assertThat((long)products.numberOfValueSchemaChanges()).isEqualTo(1L);
        KeyValueStore.Collection products_on_hand = store.collection(DB_NAME, "products_on_hand");
        Assertions.assertThat((long)products_on_hand.numberOfCreates()).isEqualTo(9L);
        Assertions.assertThat((long)products_on_hand.numberOfUpdates()).isEqualTo(0L);
        Assertions.assertThat((long)products_on_hand.numberOfDeletes()).isEqualTo(0L);
        Assertions.assertThat((long)products_on_hand.numberOfReads()).isEqualTo(0L);
        Assertions.assertThat((long)products_on_hand.numberOfTombstones()).isEqualTo(0L);
        Assertions.assertThat((long)products_on_hand.numberOfKeySchemaChanges()).isEqualTo(1L);
        Assertions.assertThat((long)products_on_hand.numberOfValueSchemaChanges()).isEqualTo(1L);
        KeyValueStore.Collection customers = store.collection(DB_NAME, "customers");
        Assertions.assertThat((long)customers.numberOfCreates()).isEqualTo(4L);
        Assertions.assertThat((long)customers.numberOfUpdates()).isEqualTo(0L);
        Assertions.assertThat((long)customers.numberOfDeletes()).isEqualTo(0L);
        Assertions.assertThat((long)customers.numberOfReads()).isEqualTo(0L);
        Assertions.assertThat((long)customers.numberOfTombstones()).isEqualTo(0L);
        Assertions.assertThat((long)customers.numberOfKeySchemaChanges()).isEqualTo(1L);
        Assertions.assertThat((long)customers.numberOfValueSchemaChanges()).isEqualTo(1L);
        KeyValueStore.Collection orders = store.collection(DB_NAME, "orders");
        Assertions.assertThat((long)orders.numberOfCreates()).isEqualTo(5L);
        Assertions.assertThat((long)orders.numberOfUpdates()).isEqualTo(0L);
        Assertions.assertThat((long)orders.numberOfDeletes()).isEqualTo(0L);
        Assertions.assertThat((long)orders.numberOfReads()).isEqualTo(0L);
        Assertions.assertThat((long)orders.numberOfTombstones()).isEqualTo(0L);
        Assertions.assertThat((long)orders.numberOfKeySchemaChanges()).isEqualTo(1L);
        Assertions.assertThat((long)orders.numberOfValueSchemaChanges()).isEqualTo(1L);
        if (this.completed.await(10L, TimeUnit.SECONDS)) {
            Testing.print((Object)"completed the snapshot");
        } else {
            Assert.fail((String)"failed to complete the snapshot within 10 seconds");
        }
    }

    @Test
    public void shouldCreateSnapshotOfSingleDatabaseUsingReadEvents() throws Exception {
        this.config = ((Configuration.Builder)this.simpleConfig().with(MySqlConnectorConfig.DATABASE_WHITELIST, "connector_(.*)")).build();
        this.context = new MySqlTaskContext(this.config);
        this.context.start();
        this.reader = new SnapshotReader(this.context);
        this.reader.onSuccessfulCompletion(this.completed::countDown);
        this.reader.generateReadEvents();
        this.reader.useMinimalBlocking(true);
        this.reader.start();
        List records = null;
        KeyValueStore store = KeyValueStore.createForTopicsBeginningWith((String)"logical_server_name.");
        SchemaChangeHistory schemaChanges = new SchemaChangeHistory(LOGICAL_NAME);
        while ((records = this.reader.poll()) != null) {
            records.forEach(record -> {
                VerifyRecord.isValid((SourceRecord)record);
                store.add(record);
                schemaChanges.add(record);
            });
        }
        Assertions.assertThat((List)records).isNull();
        Assertions.assertThat((int)schemaChanges.recordCount()).isEqualTo(0);
        Assertions.assertThat((Collection)store.databases()).containsOnly(new Object[]{DB_NAME, "connector_test"});
        Assertions.assertThat((int)store.collectionCount()).isEqualTo(8);
        KeyValueStore.Collection products = store.collection(DB_NAME, "products");
        Assertions.assertThat((long)products.numberOfCreates()).isEqualTo(0L);
        Assertions.assertThat((long)products.numberOfUpdates()).isEqualTo(0L);
        Assertions.assertThat((long)products.numberOfDeletes()).isEqualTo(0L);
        Assertions.assertThat((long)products.numberOfReads()).isEqualTo(9L);
        Assertions.assertThat((long)products.numberOfTombstones()).isEqualTo(0L);
        Assertions.assertThat((long)products.numberOfKeySchemaChanges()).isEqualTo(1L);
        Assertions.assertThat((long)products.numberOfValueSchemaChanges()).isEqualTo(1L);
        KeyValueStore.Collection products_on_hand = store.collection(DB_NAME, "products_on_hand");
        Assertions.assertThat((long)products_on_hand.numberOfCreates()).isEqualTo(0L);
        Assertions.assertThat((long)products_on_hand.numberOfUpdates()).isEqualTo(0L);
        Assertions.assertThat((long)products_on_hand.numberOfDeletes()).isEqualTo(0L);
        Assertions.assertThat((long)products_on_hand.numberOfReads()).isEqualTo(9L);
        Assertions.assertThat((long)products_on_hand.numberOfTombstones()).isEqualTo(0L);
        Assertions.assertThat((long)products_on_hand.numberOfKeySchemaChanges()).isEqualTo(1L);
        Assertions.assertThat((long)products_on_hand.numberOfValueSchemaChanges()).isEqualTo(1L);
        KeyValueStore.Collection customers = store.collection(DB_NAME, "customers");
        Assertions.assertThat((long)customers.numberOfCreates()).isEqualTo(0L);
        Assertions.assertThat((long)customers.numberOfUpdates()).isEqualTo(0L);
        Assertions.assertThat((long)customers.numberOfDeletes()).isEqualTo(0L);
        Assertions.assertThat((long)customers.numberOfReads()).isEqualTo(4L);
        Assertions.assertThat((long)customers.numberOfTombstones()).isEqualTo(0L);
        Assertions.assertThat((long)customers.numberOfKeySchemaChanges()).isEqualTo(1L);
        Assertions.assertThat((long)customers.numberOfValueSchemaChanges()).isEqualTo(1L);
        KeyValueStore.Collection orders = store.collection(DB_NAME, "orders");
        Assertions.assertThat((long)orders.numberOfCreates()).isEqualTo(0L);
        Assertions.assertThat((long)orders.numberOfUpdates()).isEqualTo(0L);
        Assertions.assertThat((long)orders.numberOfDeletes()).isEqualTo(0L);
        Assertions.assertThat((long)orders.numberOfReads()).isEqualTo(5L);
        Assertions.assertThat((long)orders.numberOfTombstones()).isEqualTo(0L);
        Assertions.assertThat((long)orders.numberOfKeySchemaChanges()).isEqualTo(1L);
        Assertions.assertThat((long)orders.numberOfValueSchemaChanges()).isEqualTo(1L);
        if (this.completed.await(10L, TimeUnit.SECONDS)) {
            Testing.print((Object)"completed the snapshot");
        } else {
            Assert.fail((String)"failed to complete the snapshot within 10 seconds");
        }
    }

    @Test
    public void shouldCreateSnapshotOfSingleDatabaseWithSchemaChanges() throws Exception {
        this.config = ((Configuration.Builder)this.simpleConfig().with(MySqlConnectorConfig.INCLUDE_SCHEMA_CHANGES, true)).build();
        this.context = new MySqlTaskContext(this.config);
        this.context.start();
        this.reader = new SnapshotReader(this.context);
        this.reader.onSuccessfulCompletion(this.completed::countDown);
        this.reader.generateInsertEvents();
        this.reader.useMinimalBlocking(true);
        this.reader.start();
        List records = null;
        KeyValueStore store = KeyValueStore.createForTopicsBeginningWith((String)"logical_server_name.");
        SchemaChangeHistory schemaChanges = new SchemaChangeHistory(LOGICAL_NAME);
        while ((records = this.reader.poll()) != null) {
            records.forEach(record -> {
                VerifyRecord.isValid((SourceRecord)record);
                store.add(record);
                schemaChanges.add(record);
            });
        }
        Assertions.assertThat((List)records).isNull();
        Assertions.assertThat((int)schemaChanges.recordCount()).isEqualTo(12);
        Assertions.assertThat((int)schemaChanges.databaseCount()).isEqualTo(2);
        Assertions.assertThat((Collection)schemaChanges.databases()).containsOnly(new Object[]{DB_NAME, ""});
        Assertions.assertThat((int)store.collectionCount()).isEqualTo(4);
        KeyValueStore.Collection products = store.collection(DB_NAME, "products");
        Assertions.assertThat((long)products.numberOfCreates()).isEqualTo(9L);
        Assertions.assertThat((long)products.numberOfUpdates()).isEqualTo(0L);
        Assertions.assertThat((long)products.numberOfDeletes()).isEqualTo(0L);
        Assertions.assertThat((long)products.numberOfReads()).isEqualTo(0L);
        Assertions.assertThat((long)products.numberOfTombstones()).isEqualTo(0L);
        Assertions.assertThat((long)products.numberOfKeySchemaChanges()).isEqualTo(1L);
        Assertions.assertThat((long)products.numberOfValueSchemaChanges()).isEqualTo(1L);
        KeyValueStore.Collection products_on_hand = store.collection(DB_NAME, "products_on_hand");
        Assertions.assertThat((long)products_on_hand.numberOfCreates()).isEqualTo(9L);
        Assertions.assertThat((long)products_on_hand.numberOfUpdates()).isEqualTo(0L);
        Assertions.assertThat((long)products_on_hand.numberOfDeletes()).isEqualTo(0L);
        Assertions.assertThat((long)products_on_hand.numberOfReads()).isEqualTo(0L);
        Assertions.assertThat((long)products_on_hand.numberOfTombstones()).isEqualTo(0L);
        Assertions.assertThat((long)products_on_hand.numberOfKeySchemaChanges()).isEqualTo(1L);
        Assertions.assertThat((long)products_on_hand.numberOfValueSchemaChanges()).isEqualTo(1L);
        KeyValueStore.Collection customers = store.collection(DB_NAME, "customers");
        Assertions.assertThat((long)customers.numberOfCreates()).isEqualTo(4L);
        Assertions.assertThat((long)customers.numberOfUpdates()).isEqualTo(0L);
        Assertions.assertThat((long)customers.numberOfDeletes()).isEqualTo(0L);
        Assertions.assertThat((long)customers.numberOfReads()).isEqualTo(0L);
        Assertions.assertThat((long)customers.numberOfTombstones()).isEqualTo(0L);
        Assertions.assertThat((long)customers.numberOfKeySchemaChanges()).isEqualTo(1L);
        Assertions.assertThat((long)customers.numberOfValueSchemaChanges()).isEqualTo(1L);
        KeyValueStore.Collection orders = store.collection(DB_NAME, "orders");
        Assertions.assertThat((long)orders.numberOfCreates()).isEqualTo(5L);
        Assertions.assertThat((long)orders.numberOfUpdates()).isEqualTo(0L);
        Assertions.assertThat((long)orders.numberOfDeletes()).isEqualTo(0L);
        Assertions.assertThat((long)orders.numberOfReads()).isEqualTo(0L);
        Assertions.assertThat((long)orders.numberOfTombstones()).isEqualTo(0L);
        Assertions.assertThat((long)orders.numberOfKeySchemaChanges()).isEqualTo(1L);
        Assertions.assertThat((long)orders.numberOfValueSchemaChanges()).isEqualTo(1L);
        if (this.completed.await(10L, TimeUnit.SECONDS)) {
            Testing.print((Object)"completed the snapshot");
        } else {
            Assert.fail((String)"failed to complete the snapshot within 10 seconds");
        }
    }
}

