/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.config.Configuration;
import io.debezium.connector.mysql.MySqlConnectorConfig;
import io.debezium.connector.mysql.MySqlTaskContext;
import io.debezium.relational.history.FileDatabaseHistory;
import io.debezium.util.Testing;
import java.nio.file.Path;
import java.sql.SQLException;
import java.util.concurrent.atomic.AtomicInteger;
import org.fest.assertions.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class MySqlTaskContextIT {
    private static final Path DB_HISTORY_PATH = Testing.Files.createTestingPath((String)"file-db-history-context.txt").toAbsolutePath();
    private String hostname;
    private int port;
    private String username;
    private String password;
    private int serverId;
    private String serverName;
    private String databaseName;
    private Configuration config;
    private MySqlTaskContext context;

    @Before
    public void beforeEach() {
        this.hostname = System.getProperty("database.hostname");
        this.port = Integer.parseInt(System.getProperty("database.port"));
        this.username = "snapper";
        this.password = "snapperpass";
        this.serverId = 18965;
        this.serverName = "logical_server_name";
        this.databaseName = "connector_test_ro";
        Testing.Files.delete((Path)DB_HISTORY_PATH);
    }

    @After
    public void afterEach() {
        if (this.context != null) {
            try {
                this.context.shutdown();
            }
            finally {
                this.context = null;
                Testing.Files.delete((Path)DB_HISTORY_PATH);
            }
        }
    }

    protected Configuration.Builder simpleConfig() {
        return (Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)Configuration.create().with(MySqlConnectorConfig.HOSTNAME, this.hostname)).with(MySqlConnectorConfig.PORT, this.port)).with(MySqlConnectorConfig.USER, this.username)).with(MySqlConnectorConfig.PASSWORD, this.password)).with(MySqlConnectorConfig.SSL_MODE, MySqlConnectorConfig.SecureConnectionMode.DISABLED.name().toLowerCase())).with(MySqlConnectorConfig.SERVER_ID, this.serverId)).with(MySqlConnectorConfig.SERVER_NAME, this.serverName)).with(MySqlConnectorConfig.DATABASE_WHITELIST, this.databaseName)).with(MySqlConnectorConfig.DATABASE_HISTORY, FileDatabaseHistory.class)).with(FileDatabaseHistory.FILE_PATH, (Object)DB_HISTORY_PATH);
    }

    @Test
    public void shouldCreateTaskFromConfiguration() throws Exception {
        this.config = this.simpleConfig().build();
        this.context = new MySqlTaskContext(this.config);
        this.context.start();
        Assertions.assertThat((Object)this.context.config()).isSameAs((Object)this.config);
        Assertions.assertThat((Object)this.context.clock()).isNotNull();
        Assertions.assertThat((Object)this.context.dbSchema()).isNotNull();
        Assertions.assertThat((Object)this.context.jdbc()).isNotNull();
        Assertions.assertThat((Object)this.context.logger()).isNotNull();
        Assertions.assertThat((Object)this.context.makeRecord()).isNotNull();
        Assertions.assertThat((Object)this.context.source()).isNotNull();
        Assertions.assertThat((Object)this.context.topicSelector()).isNotNull();
        Assertions.assertThat((String)this.context.hostname()).isEqualTo((Object)this.hostname);
        Assertions.assertThat((int)this.context.port()).isEqualTo(this.port);
        Assertions.assertThat((String)this.context.username()).isEqualTo((Object)this.username);
        Assertions.assertThat((String)this.context.password()).isEqualTo((Object)this.password);
        Assertions.assertThat((long)this.context.serverId()).isEqualTo((long)this.serverId);
        Assertions.assertThat((String)this.context.serverName()).isEqualTo((Object)this.serverName);
        Assertions.assertThat((String)("" + this.context.includeSchemaChangeRecords())).isEqualTo((Object)MySqlConnectorConfig.INCLUDE_SCHEMA_CHANGES.defaultValueAsString());
        Assertions.assertThat((String)("" + this.context.maxBatchSize())).isEqualTo((Object)MySqlConnectorConfig.MAX_BATCH_SIZE.defaultValueAsString());
        Assertions.assertThat((String)("" + this.context.maxQueueSize())).isEqualTo((Object)MySqlConnectorConfig.MAX_QUEUE_SIZE.defaultValueAsString());
        Assertions.assertThat((String)("" + this.context.pollIntervalInMillseconds())).isEqualTo((Object)MySqlConnectorConfig.POLL_INTERVAL_MS.defaultValueAsString());
        Assertions.assertThat((String)("" + this.context.snapshotMode().getValue())).isEqualTo((Object)MySqlConnectorConfig.SNAPSHOT_MODE.defaultValueAsString());
        Assertions.assertThat((boolean)this.context.isSnapshotAllowedWhenNeeded()).isEqualTo(false);
        Assertions.assertThat((boolean)this.context.isSnapshotNeverAllowed()).isEqualTo(false);
        this.assertNotConnectedToJdbc();
    }

    @Test
    public void shouldCreateTaskFromConfigurationWithNeverSnapshotMode() throws Exception {
        this.config = ((Configuration.Builder)this.simpleConfig().with(MySqlConnectorConfig.SNAPSHOT_MODE, MySqlConnectorConfig.SnapshotMode.NEVER.getValue())).build();
        this.context = new MySqlTaskContext(this.config);
        this.context.start();
        Assertions.assertThat((String)("" + this.context.snapshotMode().getValue())).isEqualTo((Object)MySqlConnectorConfig.SnapshotMode.NEVER.getValue());
        Assertions.assertThat((boolean)this.context.isSnapshotAllowedWhenNeeded()).isEqualTo(false);
        Assertions.assertThat((boolean)this.context.isSnapshotNeverAllowed()).isEqualTo(true);
    }

    @Test
    public void shouldCreateTaskFromConfigurationWithWhenNeededSnapshotMode() throws Exception {
        this.config = ((Configuration.Builder)this.simpleConfig().with(MySqlConnectorConfig.SNAPSHOT_MODE, MySqlConnectorConfig.SnapshotMode.WHEN_NEEDED.getValue())).build();
        this.context = new MySqlTaskContext(this.config);
        this.context.start();
        Assertions.assertThat((String)("" + this.context.snapshotMode().getValue())).isEqualTo((Object)MySqlConnectorConfig.SnapshotMode.WHEN_NEEDED.getValue());
        Assertions.assertThat((boolean)this.context.isSnapshotAllowedWhenNeeded()).isEqualTo(true);
        Assertions.assertThat((boolean)this.context.isSnapshotNeverAllowed()).isEqualTo(false);
    }

    @Test
    public void shouldCloseJdbcConnectionOnShutdown() throws Exception {
        this.config = this.simpleConfig().build();
        this.context = new MySqlTaskContext(this.config);
        this.context.start();
        this.assertNotConnectedToJdbc();
        this.context.jdbc().connection();
        this.assertConnectedToJdbc();
        this.context.shutdown();
        this.assertNotConnectedToJdbc();
    }

    protected void assertCanConnectToJdbc() throws SQLException {
        AtomicInteger count = new AtomicInteger();
        this.context.jdbc().query("SHOW DATABASES", rs -> {
            while (rs.next()) {
                count.incrementAndGet();
            }
        });
        Assertions.assertThat((int)count.get()).isGreaterThan(0);
    }

    protected void assertConnectedToJdbc() throws SQLException {
        Assertions.assertThat((boolean)this.context.jdbc().isConnected()).isTrue();
    }

    protected void assertNotConnectedToJdbc() throws SQLException {
        Assertions.assertThat((boolean)this.context.jdbc().isConnected()).isFalse();
    }
}

