/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import com.mysql.jdbc.CharsetMapping;
import io.debezium.annotation.Immutable;
import io.debezium.connector.mysql.MySqlDdlParser;
import io.debezium.data.Enum;
import io.debezium.data.EnumSet;
import io.debezium.jdbc.JdbcValueConverters;
import io.debezium.relational.Column;
import io.debezium.relational.ValueConverter;
import io.debezium.time.Year;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.time.ZoneOffset;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.SchemaBuilder;

@Immutable
public class MySqlValueConverters
extends JdbcValueConverters {
    public MySqlValueConverters(boolean adaptiveTimePrecision) {
        this(adaptiveTimePrecision, ZoneOffset.UTC);
    }

    public MySqlValueConverters(boolean adaptiveTimePrecision, ZoneOffset defaultOffset) {
        super(adaptiveTimePrecision, defaultOffset);
    }

    public SchemaBuilder schemaBuilder(Column column) {
        String typeName = column.typeName().toUpperCase();
        if (this.matches(typeName, "YEAR")) {
            return Year.builder();
        }
        if (this.matches(typeName, "ENUM")) {
            String commaSeparatedOptions = this.extractEnumAndSetOptions(column, true);
            return Enum.builder((String)commaSeparatedOptions);
        }
        if (this.matches(typeName, "SET")) {
            String commaSeparatedOptions = this.extractEnumAndSetOptions(column, true);
            return EnumSet.builder((String)commaSeparatedOptions);
        }
        return super.schemaBuilder(column);
    }

    public ValueConverter converter(Column column, Field fieldDefn) {
        String typeName = column.typeName().toUpperCase();
        if (this.matches(typeName, "YEAR")) {
            return data -> this.convertYearToInt(column, fieldDefn, data);
        }
        if (this.matches(typeName, "ENUM")) {
            String options = this.extractEnumAndSetOptions(column, false);
            return data -> this.convertEnumToString(options, column, fieldDefn, data);
        }
        if (this.matches(typeName, "SET")) {
            String options = this.extractEnumAndSetOptions(column, false);
            return data -> this.convertSetToString(options, column, fieldDefn, data);
        }
        switch (column.jdbcType()) {
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: 
            case 70: 
            case 2005: 
            case 2009: 
            case 2011: {
                Charset charset = this.charsetFor(column);
                if (charset != null) {
                    this.logger.debug("Using {} charset by default for column: {}", (Object)charset, (Object)column);
                    return data -> this.convertString(column, fieldDefn, charset, data);
                }
                this.logger.warn("Using UTF-8 charset by default for column without charset: {}", (Object)column);
                return data -> this.convertString(column, fieldDefn, StandardCharsets.UTF_8, data);
            }
        }
        return super.converter(column, fieldDefn);
    }

    protected Charset charsetFor(Column column) {
        String mySqlCharsetName = column.charsetName();
        if (mySqlCharsetName == null) {
            this.logger.warn("Column is missing a character set: {}", (Object)column);
            return null;
        }
        String encoding = CharsetMapping.getJavaEncodingForMysqlCharset((String)mySqlCharsetName);
        if (encoding == null) {
            this.logger.warn("Column uses MySQL character set '{}', which has no mapping to a Java character set", (Object)mySqlCharsetName);
        } else {
            try {
                return Charset.forName(encoding);
            }
            catch (IllegalCharsetNameException e) {
                this.logger.error("Unable to load Java charset '{}' for column with MySQL character set '{}'", (Object)encoding, (Object)mySqlCharsetName);
            }
        }
        return null;
    }

    protected Object convertString(Column column, Field fieldDefn, Charset columnCharset, Object data) {
        if (data == null) {
            return null;
        }
        if (data instanceof byte[]) {
            return new String((byte[])data, columnCharset);
        }
        if (data instanceof String) {
            return data;
        }
        return this.handleUnknownData(column, fieldDefn, data);
    }

    protected Object convertYearToInt(Column column, Field fieldDefn, Object data) {
        if (data == null) {
            return null;
        }
        if (data instanceof java.time.Year) {
            return ((java.time.Year)data).getValue();
        }
        if (data instanceof Date) {
            return ((Date)data).getYear();
        }
        if (data instanceof Number) {
            return ((Number)data).intValue();
        }
        return this.handleUnknownData(column, fieldDefn, data);
    }

    protected Object convertEnumToString(String options, Column column, Field fieldDefn, Object data) {
        if (data == null) {
            return null;
        }
        if (data instanceof String) {
            return data;
        }
        if (data instanceof Integer) {
            int index = (Integer)data - 1;
            if (index < options.length()) {
                return options.substring(index, index + 1);
            }
            return null;
        }
        return this.handleUnknownData(column, fieldDefn, data);
    }

    protected Object convertSetToString(String options, Column column, Field fieldDefn, Object data) {
        if (data == null) {
            return null;
        }
        if (data instanceof String) {
            return data;
        }
        if (data instanceof Long) {
            long indexes = (Long)data;
            return this.convertSetValue(indexes, options);
        }
        return this.handleUnknownData(column, fieldDefn, data);
    }

    protected boolean matches(String upperCaseTypeName, String upperCaseMatch) {
        if (upperCaseTypeName == null) {
            return false;
        }
        return upperCaseMatch.equals(upperCaseTypeName) || upperCaseTypeName.startsWith(upperCaseMatch + "(");
    }

    protected String extractEnumAndSetOptions(Column column, boolean commaSeparated) {
        String options = MySqlDdlParser.parseSetAndEnumOptions(column.typeExpression());
        if (!commaSeparated) {
            return options;
        }
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (int i = 0; i != options.length(); ++i) {
            if (first) {
                first = false;
            } else {
                sb.append(',');
            }
            sb.append(options.charAt(i));
        }
        return sb.toString();
    }

    protected String convertSetValue(long indexes, String options) {
        StringBuilder sb = new StringBuilder();
        int index = 0;
        boolean first = true;
        while (indexes != 0L) {
            if (indexes % 2L != 0L) {
                if (first) {
                    first = false;
                } else {
                    sb.append(',');
                }
                sb.append(options.substring(index, index + 1));
            }
            ++index;
            indexes >>>= 1;
        }
        return sb.toString();
    }
}

