/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.jdbc;

import io.debezium.annotation.Immutable;
import io.debezium.data.Bits;
import io.debezium.relational.Column;
import io.debezium.relational.ValueConverter;
import io.debezium.relational.ValueConverterProvider;
import io.debezium.time.Date;
import io.debezium.time.MicroTime;
import io.debezium.time.MicroTimestamp;
import io.debezium.time.NanoTime;
import io.debezium.time.NanoTimestamp;
import io.debezium.time.Timestamp;
import io.debezium.time.ZonedTime;
import io.debezium.time.ZonedTimestamp;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.sql.RowId;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.connect.data.Decimal;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public class JdbcValueConverters
implements ValueConverterProvider {
    private static final Short SHORT_TRUE = new Short(1);
    private static final Short SHORT_FALSE = new Short(0);
    private static final Integer INTEGER_TRUE = new Integer(1);
    private static final Integer INTEGER_FALSE = new Integer(0);
    private static final Long LONG_TRUE = new Long(1L);
    private static final Long LONG_FALSE = new Long(0L);
    private static final Float FLOAT_TRUE = new Float(1.0);
    private static final Float FLOAT_FALSE = new Float(0.0);
    private static final Double DOUBLE_TRUE = new Double(1.0);
    private static final Double DOUBLE_FALSE = new Double(0.0);
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ZoneOffset defaultOffset;
    private final boolean adaptiveTimePrecision;

    public JdbcValueConverters() {
        this(true, ZoneOffset.UTC);
    }

    public JdbcValueConverters(boolean adaptiveTimePrecision, ZoneOffset defaultOffset) {
        this.defaultOffset = defaultOffset != null ? defaultOffset : ZoneOffset.UTC;
        this.adaptiveTimePrecision = adaptiveTimePrecision;
    }

    @Override
    public SchemaBuilder schemaBuilder(Column column) {
        switch (column.jdbcType()) {
            case 0: {
                this.logger.warn("Unexpected JDBC type: NULL");
                return null;
            }
            case -7: {
                if (column.length() > 1) {
                    return Bits.builder(column.length());
                }
            }
            case 16: {
                return SchemaBuilder.bool();
            }
            case -2: 
            case 2004: {
                return SchemaBuilder.bytes();
            }
            case -4: 
            case -3: {
                return SchemaBuilder.bytes();
            }
            case -6: {
                return SchemaBuilder.int8();
            }
            case 5: {
                return SchemaBuilder.int16();
            }
            case 4: {
                return SchemaBuilder.int32();
            }
            case -5: {
                return SchemaBuilder.int64();
            }
            case 7: {
                return SchemaBuilder.float32();
            }
            case 6: 
            case 8: {
                return SchemaBuilder.float64();
            }
            case 2: 
            case 3: {
                return Decimal.builder((int)column.scale());
            }
            case -16: 
            case -15: 
            case -9: 
            case 1: 
            case 2011: {
                return SchemaBuilder.string();
            }
            case -1: 
            case 12: 
            case 70: 
            case 2005: 
            case 2009: {
                return SchemaBuilder.string();
            }
            case 91: {
                if (this.adaptiveTimePrecision) {
                    return Date.builder();
                }
                return org.apache.kafka.connect.data.Date.builder();
            }
            case 92: {
                if (this.adaptiveTimePrecision) {
                    if (column.length() <= 3) {
                        return io.debezium.time.Time.builder();
                    }
                    if (column.length() <= 6) {
                        return MicroTime.builder();
                    }
                    return NanoTime.builder();
                }
                return Time.builder();
            }
            case 93: {
                if (this.adaptiveTimePrecision) {
                    if (column.length() <= 3 || !this.adaptiveTimePrecision) {
                        return Timestamp.builder();
                    }
                    if (column.length() <= 6) {
                        return MicroTimestamp.builder();
                    }
                    return NanoTimestamp.builder();
                }
                return org.apache.kafka.connect.data.Timestamp.builder();
            }
            case 2013: {
                return ZonedTime.builder();
            }
            case 2014: {
                return ZonedTimestamp.builder();
            }
            case -8: {
                return SchemaBuilder.bytes();
            }
        }
        return null;
    }

    @Override
    public ValueConverter converter(Column column, Field fieldDefn) {
        switch (column.jdbcType()) {
            case 0: {
                return data -> null;
            }
            case -7: {
                return data -> this.convertBit(column, fieldDefn, data);
            }
            case 16: {
                return data -> this.convertBoolean(column, fieldDefn, data);
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                return data -> this.convertBinary(column, fieldDefn, data);
            }
            case -6: {
                return data -> this.convertTinyInt(column, fieldDefn, data);
            }
            case 5: {
                return data -> this.convertSmallInt(column, fieldDefn, data);
            }
            case 4: {
                return data -> this.convertInteger(column, fieldDefn, data);
            }
            case -5: {
                return data -> this.convertBigInt(column, fieldDefn, data);
            }
            case 6: {
                return data -> this.convertFloat(column, fieldDefn, data);
            }
            case 8: {
                return data -> this.convertDouble(column, fieldDefn, data);
            }
            case 7: {
                return data -> this.convertReal(column, fieldDefn, data);
            }
            case 2: {
                return data -> this.convertNumeric(column, fieldDefn, data);
            }
            case 3: {
                return data -> this.convertDecimal(column, fieldDefn, data);
            }
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: 
            case 70: 
            case 2005: 
            case 2009: 
            case 2011: {
                return data -> this.convertString(column, fieldDefn, data);
            }
            case 91: {
                if (this.adaptiveTimePrecision) {
                    return data -> this.convertDateToEpochDays(column, fieldDefn, data);
                }
                return data -> this.convertDateToEpochDaysAsDate(column, fieldDefn, data);
            }
            case 92: {
                if (this.adaptiveTimePrecision) {
                    if (column.length() <= 3) {
                        return data -> this.convertTimeToMillisPastMidnight(column, fieldDefn, data);
                    }
                    if (column.length() <= 6) {
                        return data -> this.convertTimeToMicrosPastMidnight(column, fieldDefn, data);
                    }
                    return data -> this.convertTimeToNanosPastMidnight(column, fieldDefn, data);
                }
                return data -> this.convertTimeToMillisPastMidnightAsDate(column, fieldDefn, data);
            }
            case 93: {
                if (this.adaptiveTimePrecision) {
                    if (column.length() <= 3) {
                        return data -> this.convertTimestampToEpochMillis(column, fieldDefn, data);
                    }
                    if (column.length() <= 6) {
                        return data -> this.convertTimestampToEpochMicros(column, fieldDefn, data);
                    }
                    return data -> this.convertTimestampToEpochNanos(column, fieldDefn, data);
                }
                return data -> this.convertTimestampToEpochMillisAsDate(column, fieldDefn, data);
            }
            case 2013: {
                return data -> this.convertTimeWithZone(column, fieldDefn, data);
            }
            case 2014: {
                return data -> this.convertTimestampWithZone(column, fieldDefn, data);
            }
            case -8: {
                return data -> this.convertRowId(column, fieldDefn, data);
            }
        }
        return null;
    }

    protected Object convertTimestampWithZone(Column column, Field fieldDefn, Object data) {
        if (data == null) {
            return null;
        }
        try {
            return ZonedTimestamp.toIsoString(data, (ZoneId)this.defaultOffset);
        }
        catch (IllegalArgumentException e) {
            return this.handleUnknownData(column, fieldDefn, data);
        }
    }

    protected Object convertTimeWithZone(Column column, Field fieldDefn, Object data) {
        if (data == null) {
            return null;
        }
        try {
            return ZonedTime.toIsoString(data, (ZoneId)this.defaultOffset);
        }
        catch (IllegalArgumentException e) {
            return this.handleUnknownData(column, fieldDefn, data);
        }
    }

    protected Object convertTimestampToEpochMillis(Column column, Field fieldDefn, Object data) {
        if (data == null) {
            return null;
        }
        try {
            return Timestamp.toEpochMillis(data);
        }
        catch (IllegalArgumentException e) {
            return this.handleUnknownData(column, fieldDefn, data);
        }
    }

    protected Object convertTimestampToEpochMicros(Column column, Field fieldDefn, Object data) {
        if (data == null) {
            return null;
        }
        try {
            return MicroTimestamp.toEpochMicros(data);
        }
        catch (IllegalArgumentException e) {
            return this.handleUnknownData(column, fieldDefn, data);
        }
    }

    protected Object convertTimestampToEpochNanos(Column column, Field fieldDefn, Object data) {
        if (data == null) {
            return null;
        }
        try {
            return NanoTimestamp.toEpochNanos(data);
        }
        catch (IllegalArgumentException e) {
            return this.handleUnknownData(column, fieldDefn, data);
        }
    }

    protected Object convertTimestampToEpochMillisAsDate(Column column, Field fieldDefn, Object data) {
        if (data == null) {
            return null;
        }
        try {
            return new java.util.Date(Timestamp.toEpochMillis(data));
        }
        catch (IllegalArgumentException e) {
            return this.handleUnknownData(column, fieldDefn, data);
        }
    }

    protected Object convertTimeToMillisPastMidnight(Column column, Field fieldDefn, Object data) {
        if (data == null) {
            return null;
        }
        try {
            return io.debezium.time.Time.toMilliOfDay(data);
        }
        catch (IllegalArgumentException e) {
            return this.handleUnknownData(column, fieldDefn, data);
        }
    }

    protected Object convertTimeToMicrosPastMidnight(Column column, Field fieldDefn, Object data) {
        if (data == null) {
            return null;
        }
        try {
            return MicroTime.toMicroOfDay(data);
        }
        catch (IllegalArgumentException e) {
            return this.handleUnknownData(column, fieldDefn, data);
        }
    }

    protected Object convertTimeToNanosPastMidnight(Column column, Field fieldDefn, Object data) {
        if (data == null) {
            return null;
        }
        try {
            return NanoTime.toNanoOfDay(data);
        }
        catch (IllegalArgumentException e) {
            return this.handleUnknownData(column, fieldDefn, data);
        }
    }

    protected Object convertTimeToMillisPastMidnightAsDate(Column column, Field fieldDefn, Object data) {
        if (data == null) {
            return null;
        }
        try {
            return new java.util.Date(io.debezium.time.Time.toMilliOfDay(data));
        }
        catch (IllegalArgumentException e) {
            return this.handleUnknownData(column, fieldDefn, data);
        }
    }

    protected Object convertDateToEpochDays(Column column, Field fieldDefn, Object data) {
        if (data == null) {
            return null;
        }
        try {
            return Date.toEpochDay(data);
        }
        catch (IllegalArgumentException e) {
            this.logger.warn("Unexpected JDBC DATE value for field {} with schema {}: class={}, value={}", new Object[]{fieldDefn.name(), fieldDefn.schema(), data.getClass(), data});
            return null;
        }
    }

    protected Object convertDateToEpochDaysAsDate(Column column, Field fieldDefn, Object data) {
        if (data == null) {
            return null;
        }
        try {
            int epochDay = Date.toEpochDay(data);
            long epochMillis = TimeUnit.DAYS.toMillis(epochDay);
            return new java.util.Date(epochMillis);
        }
        catch (IllegalArgumentException e) {
            this.logger.warn("Unexpected JDBC DATE value for field {} with schema {}: class={}, value={}", new Object[]{fieldDefn.name(), fieldDefn.schema(), data.getClass(), data});
            return null;
        }
    }

    protected Object convertBinary(Column column, Field fieldDefn, Object data) {
        if (data == null) {
            return null;
        }
        if (data instanceof char[]) {
            data = new String((char[])data);
        }
        if (data instanceof String) {
            data = ((String)data).getBytes();
        }
        if (data instanceof byte[]) {
            return ByteBuffer.wrap((byte[])data);
        }
        return this.unexpectedBinary(data, fieldDefn);
    }

    protected byte[] unexpectedBinary(Object value, Field fieldDefn) {
        this.logger.warn("Unexpected JDBC BINARY value for field {} with schema {}: class={}, value={}", new Object[]{fieldDefn.name(), fieldDefn.schema(), value.getClass(), value});
        return null;
    }

    protected Object convertTinyInt(Column column, Field fieldDefn, Object data) {
        return this.convertSmallInt(column, fieldDefn, data);
    }

    protected Object convertSmallInt(Column column, Field fieldDefn, Object data) {
        if (data == null) {
            return null;
        }
        if (data instanceof Short) {
            return data;
        }
        if (data instanceof Number) {
            Number value = (Number)data;
            return new Short(value.shortValue());
        }
        if (data instanceof Boolean) {
            return (Boolean)data != false ? SHORT_TRUE : SHORT_FALSE;
        }
        return this.handleUnknownData(column, fieldDefn, data);
    }

    protected Object convertInteger(Column column, Field fieldDefn, Object data) {
        if (data == null) {
            return null;
        }
        if (data instanceof Integer) {
            return data;
        }
        if (data instanceof Number) {
            Number value = (Number)data;
            return new Integer(value.intValue());
        }
        if (data instanceof Boolean) {
            return (Boolean)data != false ? INTEGER_TRUE : INTEGER_FALSE;
        }
        return this.handleUnknownData(column, fieldDefn, data);
    }

    protected Object convertBigInt(Column column, Field fieldDefn, Object data) {
        if (data == null) {
            return null;
        }
        if (data instanceof Long) {
            return data;
        }
        if (data instanceof Number) {
            Number value = (Number)data;
            return new Long(value.longValue());
        }
        if (data instanceof Boolean) {
            return (Boolean)data != false ? LONG_TRUE : LONG_FALSE;
        }
        return this.handleUnknownData(column, fieldDefn, data);
    }

    protected Object convertFloat(Column column, Field fieldDefn, Object data) {
        return this.convertDouble(column, fieldDefn, data);
    }

    protected Object convertDouble(Column column, Field fieldDefn, Object data) {
        if (data == null) {
            return null;
        }
        if (data instanceof Double) {
            return data;
        }
        if (data instanceof Number) {
            Number value = (Number)data;
            return new Double(value.doubleValue());
        }
        if (data instanceof Boolean) {
            return (Boolean)data != false ? DOUBLE_TRUE : DOUBLE_FALSE;
        }
        return this.handleUnknownData(column, fieldDefn, data);
    }

    protected Object convertReal(Column column, Field fieldDefn, Object data) {
        if (data == null) {
            return null;
        }
        if (data instanceof Float) {
            return data;
        }
        if (data instanceof Number) {
            Number value = (Number)data;
            return new Float(value.floatValue());
        }
        if (data instanceof Boolean) {
            return (Boolean)data != false ? FLOAT_TRUE : FLOAT_FALSE;
        }
        return this.handleUnknownData(column, fieldDefn, data);
    }

    protected Object convertNumeric(Column column, Field fieldDefn, Object data) {
        if (data == null) {
            return null;
        }
        BigDecimal decimal = null;
        if (data instanceof BigDecimal) {
            decimal = (BigDecimal)data;
        } else if (data instanceof Boolean) {
            decimal = new BigDecimal((Boolean)data != false ? 1 : 0);
        } else if (data instanceof Short) {
            decimal = new BigDecimal(((Short)data).intValue());
        } else if (data instanceof Integer) {
            decimal = new BigDecimal((Integer)data);
        } else if (data instanceof Long) {
            decimal = BigDecimal.valueOf((Long)data);
        } else if (data instanceof Float) {
            decimal = BigDecimal.valueOf(((Float)data).doubleValue());
        } else if (data instanceof Double) {
            decimal = BigDecimal.valueOf((Double)data);
        } else {
            return this.handleUnknownData(column, fieldDefn, data);
        }
        return decimal;
    }

    protected Object convertDecimal(Column column, Field fieldDefn, Object data) {
        if (data == null) {
            return null;
        }
        BigDecimal decimal = null;
        if (data instanceof BigDecimal) {
            decimal = (BigDecimal)data;
        } else if (data instanceof Boolean) {
            decimal = new BigDecimal((Boolean)data != false ? 1 : 0);
        } else if (data instanceof Short) {
            decimal = new BigDecimal(((Short)data).intValue());
        } else if (data instanceof Integer) {
            decimal = new BigDecimal((Integer)data);
        } else if (data instanceof Long) {
            decimal = BigDecimal.valueOf((Long)data);
        } else if (data instanceof Float) {
            decimal = BigDecimal.valueOf(((Float)data).doubleValue());
        } else if (data instanceof Double) {
            decimal = BigDecimal.valueOf((Double)data);
        } else {
            return this.handleUnknownData(column, fieldDefn, data);
        }
        return decimal;
    }

    protected Object convertString(Column column, Field fieldDefn, Object data) {
        return data == null ? null : data.toString();
    }

    protected Object convertRowId(Column column, Field fieldDefn, Object data) {
        if (data == null) {
            return null;
        }
        if (data instanceof RowId) {
            RowId row = (RowId)data;
            return ByteBuffer.wrap(row.getBytes());
        }
        return this.handleUnknownData(column, fieldDefn, data);
    }

    protected Object convertBit(Column column, Field fieldDefn, Object data) {
        if (data == null) {
            return null;
        }
        if (data instanceof Boolean) {
            return data;
        }
        if (data instanceof Short) {
            return ((Short)data).intValue() == 0 ? Boolean.FALSE : Boolean.TRUE;
        }
        if (data instanceof Integer) {
            return (Integer)data == 0 ? Boolean.FALSE : Boolean.TRUE;
        }
        if (data instanceof Long) {
            return ((Long)data).intValue() == 0 ? Boolean.FALSE : Boolean.TRUE;
        }
        return this.handleUnknownData(column, fieldDefn, data);
    }

    protected Object convertBoolean(Column column, Field fieldDefn, Object data) {
        if (data == null) {
            return null;
        }
        if (data instanceof Boolean) {
            return data;
        }
        if (data instanceof Short) {
            return ((Short)data).intValue() == 0 ? Boolean.FALSE : Boolean.TRUE;
        }
        if (data instanceof Integer) {
            return (Integer)data == 0 ? Boolean.FALSE : Boolean.TRUE;
        }
        if (data instanceof Long) {
            return ((Long)data).intValue() == 0 ? Boolean.FALSE : Boolean.TRUE;
        }
        return this.handleUnknownData(column, fieldDefn, data);
    }

    protected Object handleUnknownData(Column column, Field fieldDefn, Object data) {
        this.logger.warn("Unexpected value for JDBC type {} and column {}: class={}, value={}", new Object[]{column.jdbcType(), column, data.getClass(), data});
        return null;
    }
}

