/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.config.Configuration;
import io.debezium.config.Field;
import io.debezium.connector.mysql.MySqlConnectorConfig;
import io.debezium.jdbc.JdbcConnection;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MySqlJdbcContext
implements AutoCloseable {
    protected static final String MYSQL_CONNECTION_URL = "jdbc:mysql://${hostname}:${port}/?useInformationSchema=true&nullCatalogMeansCurrent=false";
    protected static JdbcConnection.ConnectionFactory FACTORY = JdbcConnection.patternBasedFactory((String)"jdbc:mysql://${hostname}:${port}/?useInformationSchema=true&nullCatalogMeansCurrent=false", (Field[])new Field[0]);
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final Configuration config;
    protected final JdbcConnection jdbc;

    public MySqlJdbcContext(Configuration config) {
        this.config = config;
        Configuration jdbcConfig = config.subset("database.", true).edit().with("useInformationSchema", "true").with("nullCatalogMeansCurrent", "false").build();
        this.jdbc = new JdbcConnection(jdbcConfig, FACTORY);
    }

    public Configuration config() {
        return this.config;
    }

    public JdbcConnection jdbc() {
        return this.jdbc;
    }

    public Logger logger() {
        return this.logger;
    }

    public String username() {
        return this.config.getString(MySqlConnectorConfig.USER);
    }

    public String password() {
        return this.config.getString(MySqlConnectorConfig.PASSWORD);
    }

    public String hostname() {
        return this.config.getString(MySqlConnectorConfig.HOSTNAME);
    }

    public int port() {
        return this.config.getInteger(MySqlConnectorConfig.PORT);
    }

    public void start() {
    }

    public void shutdown() {
        try {
            this.jdbc.close();
        }
        catch (SQLException e) {
            this.logger.error("Unexpected error shutting down the database connection", (Throwable)e);
        }
    }

    @Override
    public void close() {
        this.shutdown();
    }

    protected String connectionString() {
        return this.jdbc.connectionString(MYSQL_CONNECTION_URL);
    }
}

