/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.config.Configuration;
import io.debezium.connector.mysql.Module;
import io.debezium.connector.mysql.MySqlConnectorConfig;
import io.debezium.connector.mysql.MySqlConnectorTask;
import io.debezium.connector.mysql.MySqlJdbcContext;
import io.debezium.jdbc.JdbcConnection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.config.Config;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigValue;
import org.apache.kafka.connect.connector.Task;
import org.apache.kafka.connect.source.SourceConnector;

public class MySqlConnector
extends SourceConnector {
    private Map<String, String> props;

    public String version() {
        return Module.version();
    }

    public Class<? extends Task> taskClass() {
        return MySqlConnectorTask.class;
    }

    public void start(Map<String, String> props) {
        this.props = props;
    }

    public List<Map<String, String>> taskConfigs(int maxTasks) {
        return this.props == null ? Collections.emptyList() : Collections.singletonList(new HashMap<String, String>(this.props));
    }

    public void stop() {
        this.props = null;
    }

    public ConfigDef config() {
        return MySqlConnectorConfig.configDef();
    }

    public Config validate(Map<String, String> connectorConfigs) {
        Configuration config = Configuration.from(connectorConfigs);
        Map results = config.validate(MySqlConnectorConfig.EXPOSED_FIELDS);
        ConfigValue hostnameValue = (ConfigValue)results.get(MySqlConnectorConfig.HOSTNAME.name());
        ConfigValue portValue = (ConfigValue)results.get(MySqlConnectorConfig.PORT.name());
        ConfigValue userValue = (ConfigValue)results.get(MySqlConnectorConfig.USER.name());
        ConfigValue passwordValue = (ConfigValue)results.get(MySqlConnectorConfig.PASSWORD.name());
        if (hostnameValue.errorMessages().isEmpty() && portValue.errorMessages().isEmpty() && userValue.errorMessages().isEmpty() && passwordValue.errorMessages().isEmpty()) {
            try (MySqlJdbcContext jdbcContext = new MySqlJdbcContext(config);){
                JdbcConnection mysql = jdbcContext.jdbc();
                mysql.execute(new String[]{"SELECT version()"});
            }
            catch (SQLException e) {
                hostnameValue.addErrorMessage("Unable to connect: " + e.getMessage());
            }
        }
        return new Config(new ArrayList(results.values()));
    }
}

