/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.config.Configuration;
import io.debezium.connector.mysql.MySqlConnector;
import io.debezium.connector.mysql.MySqlConnectorConfig;
import io.debezium.doc.FixFor;
import io.debezium.embedded.AbstractConnectorTest;
import io.debezium.relational.history.FileDatabaseHistory;
import io.debezium.time.Date;
import io.debezium.time.Time;
import io.debezium.time.Timestamp;
import io.debezium.time.ZonedTimestamp;
import io.debezium.util.Testing;
import java.nio.file.Path;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.connect.data.Struct;
import org.fest.assertions.Assertions;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MySqlConnectorRegressionIT
extends AbstractConnectorTest {
    private static final Path DB_HISTORY_PATH = Testing.Files.createTestingPath((String)"file-db-history-regression.txt").toAbsolutePath();
    private Configuration config;

    @Before
    public void beforeEach() {
        this.stopConnector();
        this.initializeConnectorTestFramework();
        Testing.Files.delete((Path)DB_HISTORY_PATH);
    }

    @After
    public void afterEach() {
        try {
            this.stopConnector();
        }
        finally {
            Testing.Files.delete((Path)DB_HISTORY_PATH);
        }
    }

    @Test
    @FixFor(value={"DBZ-61"})
    public void shouldConsumeAllEventsFromDatabaseUsingBinlogAndNoSnapshot() throws SQLException, InterruptedException {
        this.config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)Configuration.create().with(MySqlConnectorConfig.HOSTNAME, System.getProperty("database.hostname"))).with(MySqlConnectorConfig.PORT, System.getProperty("database.port"))).with(MySqlConnectorConfig.USER, "snapper")).with(MySqlConnectorConfig.PASSWORD, "snapperpass")).with(MySqlConnectorConfig.SERVER_ID, 18765)).with(MySqlConnectorConfig.SERVER_NAME, "regression")).with(MySqlConnectorConfig.POLL_INTERVAL_MS, 10)).with(MySqlConnectorConfig.DATABASE_WHITELIST, "regression_test")).with(MySqlConnectorConfig.DATABASE_HISTORY, FileDatabaseHistory.class)).with(MySqlConnectorConfig.INCLUDE_SCHEMA_CHANGES, true)).with(MySqlConnectorConfig.SNAPSHOT_MODE, MySqlConnectorConfig.SnapshotMode.NEVER.toString())).with(FileDatabaseHistory.FILE_PATH, (Object)DB_HISTORY_PATH)).with("database.useSSL", false)).build();
        this.start(MySqlConnector.class, this.config);
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(11);
        this.stopConnector();
        Assertions.assertThat((Object)records).isNotNull();
        Assertions.assertThat((int)records.recordsForTopic("regression").size()).isEqualTo(5);
        Assertions.assertThat((int)records.recordsForTopic("regression.regression_test.t1464075356413_testtable6").size()).isEqualTo(1);
        Assertions.assertThat((int)records.recordsForTopic("regression.regression_test.dbz84_integer_types_table").size()).isEqualTo(1);
        Assertions.assertThat((int)records.recordsForTopic("regression.regression_test.dbz_85_fractest").size()).isEqualTo(1);
        Assertions.assertThat((int)records.recordsForTopic("regression.regression_test.dbz_100_enumsettest").size()).isEqualTo(3);
        Assertions.assertThat((int)records.topics().size()).isEqualTo(5);
        Assertions.assertThat((int)records.databaseNames().size()).isEqualTo(1);
        Assertions.assertThat((int)records.ddlRecordsForDatabase("regression_test").size()).isEqualTo(5);
        Assertions.assertThat((List)records.ddlRecordsForDatabase("connector_test")).isNull();
        Assertions.assertThat((List)records.ddlRecordsForDatabase("readbinlog_test")).isNull();
        records.ddlRecordsForDatabase("regression_test").forEach(arg_0 -> ((MySqlConnectorRegressionIT)this).print(arg_0));
        records.forEach(arg_0 -> ((MySqlConnectorRegressionIT)this).validate(arg_0));
        records.forEach(record -> {
            Struct value = (Struct)record.value();
            if (record.topic().endsWith("dbz_100_enumsettest")) {
                Struct after = value.getStruct("after");
                String c1 = after.getString("c1");
                String c2 = after.getString("c2");
                if (c1.equals("a")) {
                    Assertions.assertThat((String)c2).isEqualTo((Object)"a,b,c");
                } else if (c1.equals("b")) {
                    Assertions.assertThat((String)c2).isEqualTo((Object)"a,b");
                } else if (c1.equals("c")) {
                    Assertions.assertThat((String)c2).isEqualTo((Object)"a");
                } else {
                    Assert.fail((String)"c1 didn't match expected value");
                }
            } else if (record.topic().endsWith("dbz_85_fractest")) {
                Struct after = value.getStruct("after");
                Integer c1 = after.getInt32("c1");
                LocalDate c1Date = LocalDate.ofEpochDay(c1.intValue());
                Assertions.assertThat((int)c1Date.getYear()).isEqualTo(2014);
                Assertions.assertThat((Object)c1Date.getMonth()).isEqualTo((Object)Month.SEPTEMBER);
                Assertions.assertThat((int)c1Date.getDayOfMonth()).isEqualTo(8);
                Assertions.assertThat((int)Date.toEpochDay((Object)c1Date)).isEqualTo((Object)c1);
                Integer c2 = after.getInt32("c2");
                LocalTime c2Time = LocalTime.ofNanoOfDay(TimeUnit.MILLISECONDS.toNanos(c2.intValue()));
                Assertions.assertThat((int)c2Time.getHour()).isEqualTo(17);
                Assertions.assertThat((int)c2Time.getMinute()).isEqualTo(51);
                Assertions.assertThat((int)c2Time.getSecond()).isEqualTo(4);
                Assertions.assertThat((int)c2Time.getNano()).isEqualTo((int)TimeUnit.MILLISECONDS.toNanos(780L));
                Assertions.assertThat((int)Time.toMilliOfDay((Object)c2Time)).isEqualTo((Object)c2);
                Long c3 = after.getInt64("c3");
                long c3Seconds = c3 / 1000L;
                long c3Millis = c3 % 1000L;
                LocalDateTime c3DateTime = LocalDateTime.ofEpochSecond(c3Seconds, (int)TimeUnit.MILLISECONDS.toNanos(c3Millis), ZoneOffset.UTC);
                Assertions.assertThat((int)c3DateTime.getYear()).isEqualTo(2014);
                Assertions.assertThat((Object)c3DateTime.getMonth()).isEqualTo((Object)Month.SEPTEMBER);
                Assertions.assertThat((int)c3DateTime.getDayOfMonth()).isEqualTo(8);
                Assertions.assertThat((int)c3DateTime.getHour()).isEqualTo(17);
                Assertions.assertThat((int)c3DateTime.getMinute()).isEqualTo(51);
                Assertions.assertThat((int)c3DateTime.getSecond()).isEqualTo(4);
                Assertions.assertThat((int)c3DateTime.getNano()).isEqualTo((int)TimeUnit.MILLISECONDS.toNanos(780L));
                Assertions.assertThat((long)Timestamp.toEpochMillis((Object)c3DateTime)).isEqualTo((Object)c3);
                String c4 = after.getString("c4");
                OffsetDateTime c4DateTime = OffsetDateTime.parse(c4, ZonedTimestamp.FORMATTER);
                c4DateTime = c4DateTime.withOffsetSameInstant(OffsetDateTime.now().getOffset());
                Assertions.assertThat((int)c4DateTime.getYear()).isEqualTo(2014);
                Assertions.assertThat((Object)c4DateTime.getMonth()).isEqualTo((Object)Month.SEPTEMBER);
                Assertions.assertThat((int)c4DateTime.getDayOfMonth()).isEqualTo(8);
                Assertions.assertThat((int)c4DateTime.getHour()).isEqualTo(17);
                Assertions.assertThat((int)c4DateTime.getMinute()).isEqualTo(51);
                Assertions.assertThat((int)c4DateTime.getSecond()).isEqualTo(4);
                Assertions.assertThat((int)c4DateTime.getNano()).isEqualTo((int)TimeUnit.MILLISECONDS.toNanos(780L));
                Assertions.assertThat((Object)c4DateTime.getOffset()).isEqualTo((Object)OffsetDateTime.now().getOffset());
            }
        });
    }

    @Test
    @FixFor(value={"DBZ-61"})
    public void shouldConsumeAllEventsFromDatabaseUsingBinlogAndNoSnapshotAndConnectTimesTypes() throws SQLException, InterruptedException {
        this.config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)Configuration.create().with(MySqlConnectorConfig.HOSTNAME, System.getProperty("database.hostname"))).with(MySqlConnectorConfig.PORT, System.getProperty("database.port"))).with(MySqlConnectorConfig.USER, "snapper")).with(MySqlConnectorConfig.PASSWORD, "snapperpass")).with(MySqlConnectorConfig.SERVER_ID, 18765)).with(MySqlConnectorConfig.SERVER_NAME, "regression")).with(MySqlConnectorConfig.POLL_INTERVAL_MS, 10)).with(MySqlConnectorConfig.DATABASE_WHITELIST, "regression_test")).with(MySqlConnectorConfig.DATABASE_HISTORY, FileDatabaseHistory.class)).with(MySqlConnectorConfig.INCLUDE_SCHEMA_CHANGES, true)).with(MySqlConnectorConfig.SNAPSHOT_MODE, MySqlConnectorConfig.SnapshotMode.NEVER.toString())).with(MySqlConnectorConfig.TIME_PRECISION_MODE, MySqlConnectorConfig.TemporalPrecisionMode.CONNECT.toString())).with(FileDatabaseHistory.FILE_PATH, (Object)DB_HISTORY_PATH)).with("database.useSSL", false)).build();
        this.start(MySqlConnector.class, this.config);
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(11);
        this.stopConnector();
        Assertions.assertThat((Object)records).isNotNull();
        Assertions.assertThat((int)records.recordsForTopic("regression").size()).isEqualTo(5);
        Assertions.assertThat((int)records.recordsForTopic("regression.regression_test.t1464075356413_testtable6").size()).isEqualTo(1);
        Assertions.assertThat((int)records.recordsForTopic("regression.regression_test.dbz84_integer_types_table").size()).isEqualTo(1);
        Assertions.assertThat((int)records.recordsForTopic("regression.regression_test.dbz_85_fractest").size()).isEqualTo(1);
        Assertions.assertThat((int)records.recordsForTopic("regression.regression_test.dbz_100_enumsettest").size()).isEqualTo(3);
        Assertions.assertThat((int)records.topics().size()).isEqualTo(5);
        Assertions.assertThat((int)records.databaseNames().size()).isEqualTo(1);
        Assertions.assertThat((int)records.ddlRecordsForDatabase("regression_test").size()).isEqualTo(5);
        Assertions.assertThat((List)records.ddlRecordsForDatabase("connector_test")).isNull();
        Assertions.assertThat((List)records.ddlRecordsForDatabase("readbinlog_test")).isNull();
        records.ddlRecordsForDatabase("regression_test").forEach(arg_0 -> ((MySqlConnectorRegressionIT)this).print(arg_0));
        records.forEach(arg_0 -> ((MySqlConnectorRegressionIT)this).validate(arg_0));
        records.forEach(record -> {
            Struct value = (Struct)record.value();
            if (record.topic().endsWith("dbz_100_enumsettest")) {
                Struct after = value.getStruct("after");
                String c1 = after.getString("c1");
                String c2 = after.getString("c2");
                if (c1.equals("a")) {
                    Assertions.assertThat((String)c2).isEqualTo((Object)"a,b,c");
                } else if (c1.equals("b")) {
                    Assertions.assertThat((String)c2).isEqualTo((Object)"a,b");
                } else if (c1.equals("c")) {
                    Assertions.assertThat((String)c2).isEqualTo((Object)"a");
                } else {
                    Assert.fail((String)"c1 didn't match expected value");
                }
            } else if (record.topic().endsWith("dbz_85_fractest")) {
                Struct after = value.getStruct("after");
                java.util.Date c1 = (java.util.Date)after.get("c1");
                LocalDate c1Date = LocalDate.ofEpochDay(c1.getTime() / TimeUnit.DAYS.toMillis(1L));
                Assertions.assertThat((int)c1Date.getYear()).isEqualTo(2014);
                Assertions.assertThat((Object)c1Date.getMonth()).isEqualTo((Object)Month.SEPTEMBER);
                Assertions.assertThat((int)c1Date.getDayOfMonth()).isEqualTo(8);
                java.util.Date c2 = (java.util.Date)after.get("c2");
                LocalTime c2Time = LocalTime.ofNanoOfDay(TimeUnit.MILLISECONDS.toNanos(c2.getTime()));
                Assertions.assertThat((int)c2Time.getHour()).isEqualTo(17);
                Assertions.assertThat((int)c2Time.getMinute()).isEqualTo(51);
                Assertions.assertThat((int)c2Time.getSecond()).isEqualTo(4);
                Assertions.assertThat((int)c2Time.getNano()).isEqualTo((int)TimeUnit.MILLISECONDS.toNanos(780L));
                Assertions.assertThat((int)Time.toMilliOfDay((Object)c2Time)).isEqualTo((int)c2.getTime());
                java.util.Date c3 = (java.util.Date)after.get("c3");
                long c3Seconds = c3.getTime() / 1000L;
                long c3Millis = c3.getTime() % 1000L;
                LocalDateTime c3DateTime = LocalDateTime.ofEpochSecond(c3Seconds, (int)TimeUnit.MILLISECONDS.toNanos(c3Millis), ZoneOffset.UTC);
                Assertions.assertThat((int)c3DateTime.getYear()).isEqualTo(2014);
                Assertions.assertThat((Object)c3DateTime.getMonth()).isEqualTo((Object)Month.SEPTEMBER);
                Assertions.assertThat((int)c3DateTime.getDayOfMonth()).isEqualTo(8);
                Assertions.assertThat((int)c3DateTime.getHour()).isEqualTo(17);
                Assertions.assertThat((int)c3DateTime.getMinute()).isEqualTo(51);
                Assertions.assertThat((int)c3DateTime.getSecond()).isEqualTo(4);
                Assertions.assertThat((int)c3DateTime.getNano()).isEqualTo((int)TimeUnit.MILLISECONDS.toNanos(780L));
                Assertions.assertThat((long)Timestamp.toEpochMillis((Object)c3DateTime)).isEqualTo(c3.getTime());
                String c4 = after.getString("c4");
                OffsetDateTime c4DateTime = OffsetDateTime.parse(c4, ZonedTimestamp.FORMATTER);
                c4DateTime = c4DateTime.withOffsetSameInstant(OffsetDateTime.now().getOffset());
                Assertions.assertThat((int)c4DateTime.getYear()).isEqualTo(2014);
                Assertions.assertThat((Object)c4DateTime.getMonth()).isEqualTo((Object)Month.SEPTEMBER);
                Assertions.assertThat((int)c4DateTime.getDayOfMonth()).isEqualTo(8);
                Assertions.assertThat((int)c4DateTime.getHour()).isEqualTo(17);
                Assertions.assertThat((int)c4DateTime.getMinute()).isEqualTo(51);
                Assertions.assertThat((int)c4DateTime.getSecond()).isEqualTo(4);
                Assertions.assertThat((int)c4DateTime.getNano()).isEqualTo((int)TimeUnit.MILLISECONDS.toNanos(780L));
                Assertions.assertThat((Object)c4DateTime.getOffset()).isEqualTo((Object)OffsetDateTime.now().getOffset());
            }
        });
    }

    @Test
    public void shouldConsumeAllEventsFromDatabaseUsingSnapshot() throws SQLException, InterruptedException {
        this.config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)Configuration.create().with(MySqlConnectorConfig.HOSTNAME, System.getProperty("database.hostname"))).with(MySqlConnectorConfig.PORT, System.getProperty("database.port"))).with(MySqlConnectorConfig.USER, "snapper")).with(MySqlConnectorConfig.PASSWORD, "snapperpass")).with(MySqlConnectorConfig.SERVER_ID, 18765)).with(MySqlConnectorConfig.SERVER_NAME, "regression")).with(MySqlConnectorConfig.POLL_INTERVAL_MS, 10)).with(MySqlConnectorConfig.DATABASE_WHITELIST, "regression_test")).with(MySqlConnectorConfig.DATABASE_HISTORY, FileDatabaseHistory.class)).with(MySqlConnectorConfig.INCLUDE_SCHEMA_CHANGES, true)).with(MySqlConnectorConfig.SNAPSHOT_MODE, MySqlConnectorConfig.SnapshotMode.INITIAL.toString())).with(FileDatabaseHistory.FILE_PATH, (Object)DB_HISTORY_PATH)).with("database.useSSL", false)).build();
        this.start(MySqlConnector.class, this.config);
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(17);
        this.stopConnector();
        Assertions.assertThat((Object)records).isNotNull();
        Assertions.assertThat((int)records.recordsForTopic("regression").size()).isEqualTo(11);
        Assertions.assertThat((int)records.recordsForTopic("regression.regression_test.t1464075356413_testtable6").size()).isEqualTo(1);
        Assertions.assertThat((int)records.recordsForTopic("regression.regression_test.dbz84_integer_types_table").size()).isEqualTo(1);
        Assertions.assertThat((int)records.recordsForTopic("regression.regression_test.dbz_85_fractest").size()).isEqualTo(1);
        Assertions.assertThat((int)records.recordsForTopic("regression.regression_test.dbz_100_enumsettest").size()).isEqualTo(3);
        Assertions.assertThat((int)records.topics().size()).isEqualTo(5);
        Assertions.assertThat((int)records.databaseNames().size()).isEqualTo(1);
        Assertions.assertThat((int)records.ddlRecordsForDatabase("regression_test").size()).isEqualTo(11);
        Assertions.assertThat((List)records.ddlRecordsForDatabase("connector_test")).isNull();
        Assertions.assertThat((List)records.ddlRecordsForDatabase("readbinlog_test")).isNull();
        records.ddlRecordsForDatabase("regression_test").forEach(arg_0 -> ((MySqlConnectorRegressionIT)this).print(arg_0));
        records.forEach(arg_0 -> ((MySqlConnectorRegressionIT)this).validate(arg_0));
        records.forEach(record -> {
            Struct value = (Struct)record.value();
            if (record.topic().endsWith("dbz_100_enumsettest")) {
                Struct after = value.getStruct("after");
                String c1 = after.getString("c1");
                String c2 = after.getString("c2");
                if (c1.equals("a")) {
                    Assertions.assertThat((String)c2).isEqualTo((Object)"a,b,c");
                } else if (c1.equals("b")) {
                    Assertions.assertThat((String)c2).isEqualTo((Object)"a,b");
                } else if (c1.equals("c")) {
                    Assertions.assertThat((String)c2).isEqualTo((Object)"a");
                } else {
                    Assert.fail((String)"c1 didn't match expected value");
                }
            } else if (record.topic().endsWith("dbz_85_fractest")) {
                Struct after = value.getStruct("after");
                Integer c1 = after.getInt32("c1");
                LocalDate c1Date = LocalDate.ofEpochDay(c1.intValue());
                Assertions.assertThat((int)c1Date.getYear()).isEqualTo(2014);
                Assertions.assertThat((Object)c1Date.getMonth()).isEqualTo((Object)Month.SEPTEMBER);
                Assertions.assertThat((int)c1Date.getDayOfMonth()).isEqualTo(8);
                Assertions.assertThat((int)Date.toEpochDay((Object)c1Date)).isEqualTo((Object)c1);
                Integer c2 = after.getInt32("c2");
                LocalTime c2Time = LocalTime.ofNanoOfDay(TimeUnit.MILLISECONDS.toNanos(c2.intValue()));
                Assertions.assertThat((int)c2Time.getHour()).isEqualTo(17);
                Assertions.assertThat((int)c2Time.getMinute()).isEqualTo(51);
                Assertions.assertThat((int)c2Time.getSecond()).isEqualTo(4);
                Assertions.assertThat((int)c2Time.getNano()).isEqualTo(0);
                Assertions.assertThat((int)Time.toMilliOfDay((Object)c2Time)).isEqualTo((Object)c2);
                Long c3 = after.getInt64("c3");
                long c3Seconds = c3 / 1000L;
                long c3Millis = c3 % 1000L;
                LocalDateTime c3DateTime = LocalDateTime.ofEpochSecond(c3Seconds, (int)TimeUnit.MILLISECONDS.toNanos(c3Millis), ZoneOffset.UTC);
                Assertions.assertThat((int)c3DateTime.getYear()).isEqualTo(2014);
                Assertions.assertThat((Object)c3DateTime.getMonth()).isEqualTo((Object)Month.SEPTEMBER);
                Assertions.assertThat((int)c3DateTime.getDayOfMonth()).isEqualTo(8);
                Assertions.assertThat((int)c3DateTime.getHour()).isEqualTo(17);
                Assertions.assertThat((int)c3DateTime.getMinute()).isEqualTo(51);
                Assertions.assertThat((int)c3DateTime.getSecond()).isEqualTo(4);
                Assertions.assertThat((int)c3DateTime.getNano()).isEqualTo((int)TimeUnit.MILLISECONDS.toNanos(780L));
                Assertions.assertThat((long)Timestamp.toEpochMillis((Object)c3DateTime)).isEqualTo((Object)c3);
                String c4 = after.getString("c4");
                OffsetDateTime c4DateTime = OffsetDateTime.parse(c4, ZonedTimestamp.FORMATTER);
                c4DateTime = c4DateTime.withOffsetSameInstant(OffsetDateTime.now().getOffset());
                Assertions.assertThat((int)c4DateTime.getYear()).isEqualTo(2014);
                Assertions.assertThat((Object)c4DateTime.getMonth()).isEqualTo((Object)Month.SEPTEMBER);
                Assertions.assertThat((int)c4DateTime.getDayOfMonth()).isEqualTo(8);
                Assertions.assertThat((int)c4DateTime.getHour()).isEqualTo(17);
                Assertions.assertThat((int)c4DateTime.getMinute()).isEqualTo(51);
                Assertions.assertThat((int)c4DateTime.getSecond()).isEqualTo(4);
                Assertions.assertThat((int)c4DateTime.getNano()).isEqualTo((int)TimeUnit.MILLISECONDS.toNanos(780L));
                Assertions.assertThat((Object)c4DateTime.getOffset()).isEqualTo((Object)OffsetDateTime.now().getOffset());
            }
        });
    }
}

