/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.annotation.Immutable;
import io.debezium.connector.mysql.MySqlDdlParser;
import io.debezium.data.Enum;
import io.debezium.data.EnumSet;
import io.debezium.jdbc.JdbcValueConverters;
import io.debezium.relational.Column;
import io.debezium.relational.ValueConverter;
import io.debezium.time.Year;
import java.sql.Date;
import java.time.ZoneOffset;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.SchemaBuilder;

@Immutable
public class MySqlValueConverters
extends JdbcValueConverters {
    public MySqlValueConverters(boolean adaptiveTimePrecision) {
        this(adaptiveTimePrecision, ZoneOffset.UTC);
    }

    public MySqlValueConverters(boolean adaptiveTimePrecision, ZoneOffset defaultOffset) {
        super(adaptiveTimePrecision, defaultOffset);
    }

    public SchemaBuilder schemaBuilder(Column column) {
        String typeName = column.typeName().toUpperCase();
        if (this.matches(typeName, "YEAR")) {
            return Year.builder();
        }
        if (this.matches(typeName, "ENUM")) {
            String commaSeparatedOptions = this.extractEnumAndSetOptions(column, true);
            return Enum.builder((String)commaSeparatedOptions);
        }
        if (this.matches(typeName, "SET")) {
            String commaSeparatedOptions = this.extractEnumAndSetOptions(column, true);
            return EnumSet.builder((String)commaSeparatedOptions);
        }
        return super.schemaBuilder(column);
    }

    public ValueConverter converter(Column column, Field fieldDefn) {
        String typeName = column.typeName().toUpperCase();
        if (this.matches(typeName, "YEAR")) {
            return data -> this.convertYearToInt(column, fieldDefn, data);
        }
        if (this.matches(typeName, "ENUM")) {
            String options = this.extractEnumAndSetOptions(column, false);
            return data -> this.convertEnumToString(options, column, fieldDefn, data);
        }
        if (this.matches(typeName, "SET")) {
            String options = this.extractEnumAndSetOptions(column, false);
            return data -> this.convertSetToString(options, column, fieldDefn, data);
        }
        return super.converter(column, fieldDefn);
    }

    protected Object convertYearToInt(Column column, Field fieldDefn, Object data) {
        if (data == null) {
            return null;
        }
        if (data instanceof java.time.Year) {
            return ((java.time.Year)data).getValue();
        }
        if (data instanceof Date) {
            return ((Date)data).getYear();
        }
        if (data instanceof Number) {
            return ((Number)data).intValue();
        }
        return this.handleUnknownData(column, fieldDefn, data);
    }

    protected Object convertEnumToString(String options, Column column, Field fieldDefn, Object data) {
        if (data == null) {
            return null;
        }
        if (data instanceof String) {
            return data;
        }
        if (data instanceof Integer) {
            int index = (Integer)data - 1;
            if (index < options.length()) {
                return options.substring(index, index + 1);
            }
            return null;
        }
        return this.handleUnknownData(column, fieldDefn, data);
    }

    protected Object convertSetToString(String options, Column column, Field fieldDefn, Object data) {
        if (data == null) {
            return null;
        }
        if (data instanceof String) {
            return data;
        }
        if (data instanceof Long) {
            long indexes = (Long)data;
            return this.convertSetValue(indexes, options);
        }
        return this.handleUnknownData(column, fieldDefn, data);
    }

    protected boolean matches(String upperCaseTypeName, String upperCaseMatch) {
        if (upperCaseTypeName == null) {
            return false;
        }
        return upperCaseMatch.equals(upperCaseTypeName) || upperCaseTypeName.startsWith(upperCaseMatch + "(");
    }

    protected String extractEnumAndSetOptions(Column column, boolean commaSeparated) {
        String options = MySqlDdlParser.parseSetAndEnumOptions(column.typeExpression());
        if (!commaSeparated) {
            return options;
        }
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (int i = 0; i != options.length(); ++i) {
            if (first) {
                first = false;
            } else {
                sb.append(',');
            }
            sb.append(options.charAt(i));
        }
        return sb.toString();
    }

    protected String convertSetValue(long indexes, String options) {
        StringBuilder sb = new StringBuilder();
        int index = 0;
        boolean first = true;
        while (indexes != 0L) {
            if (indexes % 2L != 0L) {
                if (first) {
                    first = false;
                } else {
                    sb.append(',');
                }
                sb.append(options.substring(index, index + 1));
            }
            ++index;
            indexes >>>= 1;
        }
        return sb.toString();
    }
}

