/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.annotation.NotThreadSafe;
import io.debezium.config.Configuration;
import io.debezium.connector.mysql.Filters;
import io.debezium.connector.mysql.MySqlConnectorConfig;
import io.debezium.connector.mysql.MySqlDdlParser;
import io.debezium.connector.mysql.MySqlValueConverters;
import io.debezium.connector.mysql.SourceInfo;
import io.debezium.jdbc.JdbcConnection;
import io.debezium.relational.Table;
import io.debezium.relational.TableId;
import io.debezium.relational.TableSchema;
import io.debezium.relational.TableSchemaBuilder;
import io.debezium.relational.Tables;
import io.debezium.relational.ValueConverterProvider;
import io.debezium.relational.ddl.DdlChanges;
import io.debezium.relational.ddl.DdlParser;
import io.debezium.relational.ddl.DdlParserListener;
import io.debezium.relational.history.DatabaseHistory;
import io.debezium.relational.history.HistoryRecordComparator;
import io.debezium.text.ParsingException;
import io.debezium.util.AvroValidator;
import io.debezium.util.Collect;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.kafka.connect.errors.ConnectException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class MySqlSchema {
    private static final HistoryRecordComparator HISTORY_COMPARATOR = HistoryRecordComparator.usingPositions(SourceInfo::isPositionAtOrBefore);
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final AvroValidator schemaNameValidator = AvroValidator.create((Logger)this.logger);
    private final Set<String> ignoredQueryStatements = Collect.unmodifiableSet((Object[])new String[]{"BEGIN", "END", "FLUSH PRIVILEGES"});
    private final MySqlDdlParser ddlParser;
    private final Map<TableId, TableSchema> tableSchemaByTableId = new HashMap<TableId, TableSchema>();
    private final Filters filters;
    private final DatabaseHistory dbHistory;
    private final TableSchemaBuilder schemaBuilder;
    private final DdlChanges ddlChanges;
    private final String serverName;
    private final String schemaPrefix;
    private Tables tables;

    public MySqlSchema(Configuration config, String serverName) {
        this.filters = new Filters(config);
        this.ddlParser = new MySqlDdlParser(false);
        this.tables = new Tables();
        this.ddlChanges = new DdlChanges(this.ddlParser.terminator());
        this.ddlParser.addListener((DdlParserListener)this.ddlChanges);
        String timePrecisionModeStr = config.getString(MySqlConnectorConfig.TIME_PRECISION_MODE);
        MySqlConnectorConfig.TemporalPrecisionMode timePrecisionMode = MySqlConnectorConfig.TemporalPrecisionMode.parse(timePrecisionModeStr);
        boolean adaptiveTimePrecision = MySqlConnectorConfig.TemporalPrecisionMode.ADAPTIVE.equals((Object)timePrecisionMode);
        MySqlValueConverters valueConverters = new MySqlValueConverters(adaptiveTimePrecision);
        this.schemaBuilder = new TableSchemaBuilder((ValueConverterProvider)valueConverters, arg_0 -> ((AvroValidator)this.schemaNameValidator).validate(arg_0));
        if (serverName != null) {
            serverName = serverName.trim();
        }
        this.serverName = serverName;
        this.schemaPrefix = this.serverName == null || serverName.isEmpty() ? "" : (serverName.endsWith(".") ? serverName : serverName + ".");
        this.dbHistory = (DatabaseHistory)config.getInstance(MySqlConnectorConfig.DATABASE_HISTORY, DatabaseHistory.class);
        if (this.dbHistory == null) {
            throw new ConnectException("Unable to instantiate the database history class " + config.getString(MySqlConnectorConfig.DATABASE_HISTORY));
        }
        Configuration dbHistoryConfig = config.subset("database.history.", false);
        this.dbHistory.configure(dbHistoryConfig, HISTORY_COMPARATOR);
    }

    public void start() {
        this.dbHistory.start();
    }

    public void shutdown() {
        this.dbHistory.stop();
    }

    public Filters filters() {
        return this.filters;
    }

    public Tables tables() {
        return this.tables.subset(this.filters.tableFilter());
    }

    public Table tableFor(TableId id) {
        return this.filters.tableFilter().test(id) ? this.tables.forTable(id) : null;
    }

    public TableSchema schemaFor(TableId id) {
        return this.filters.tableFilter().test(id) ? this.tableSchemaByTableId.get(id) : null;
    }

    public String historyLocation() {
        return this.dbHistory.toString();
    }

    public void loadFromDatabase(JdbcConnection jdbc, SourceInfo source) throws SQLException {
        this.changeTablesAndRecordInHistory(source, () -> {
            jdbc.readSchema(this.tables(), null, null, this.filters.tableNameFilter(), null, true);
            return null;
        });
    }

    protected void changeTablesAndRecordInHistory(SourceInfo source, Callable<Void> changeFunction) throws SQLException {
        StringBuilder ddl = new StringBuilder();
        this.tables().drainChanges();
        Tables copy = this.tables().clone();
        try {
            changeFunction.call();
        }
        catch (Exception e) {
            this.tables = copy;
            if (e instanceof SQLException) {
                throw (SQLException)e;
            }
            this.logger.error("Unexpected error whle changing model of MySQL schemas: {}", (Object)e.getMessage(), (Object)e);
        }
        this.refreshSchemas();
        this.tables().drainChanges().forEach(changedTableId -> {
            Table table = this.tables().forTable(changedTableId);
            this.appendDropTableStatement(ddl, table.id());
            if (table != null) {
                this.appendCreateTableStatement(ddl, table);
            }
        });
        this.dbHistory.record(source.partition(), source.offset(), "", this.tables(), ddl.toString());
    }

    protected void appendDropTableStatement(StringBuilder sb, TableId tableId) {
        sb.append("DROP TABLE ").append(tableId).append(" IF EXISTS;").append(System.lineSeparator());
    }

    protected void appendCreateTableStatement(StringBuilder sb, Table table) {
        sb.append("CREATE TABLE ").append(table.id()).append(';').append(System.lineSeparator());
    }

    public void loadHistory(SourceInfo startingPoint) {
        this.tables = new Tables();
        this.dbHistory.recover(startingPoint.partition(), startingPoint.offset(), this.tables, (DdlParser)this.ddlParser);
        this.refreshSchemas();
    }

    protected void refreshSchemas() {
        this.tableSchemaByTableId.clear();
        this.tables.tableIds().forEach(id -> {
            Table table = this.tables.forTable(id);
            TableSchema schema = this.schemaBuilder.create(this.schemaPrefix, table, this.filters.columnFilter(), this.filters.columnMappers());
            this.tableSchemaByTableId.put((TableId)id, schema);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean applyDdl(SourceInfo source, String databaseName, String ddlStatements, DdlChanges.DatabaseStatementStringConsumer statementConsumer) {
        if (this.ignoredQueryStatements.contains(ddlStatements)) {
            return false;
        }
        try {
            this.ddlChanges.reset();
            this.ddlParser.setCurrentSchema(databaseName);
            this.ddlParser.parse(ddlStatements, this.tables);
        }
        catch (ParsingException e) {
            this.logger.error("Error parsing DDL statement and updating tables: {}", (Object)ddlStatements, (Object)e);
        }
        finally {
            if (statementConsumer != null) {
                if (!this.ddlChanges.isEmpty() && this.ddlChanges.applyToMoreDatabasesThan(databaseName)) {
                    this.ddlChanges.groupStatementStringsByDatabase((dbName, ddl) -> {
                        if (this.filters.databaseFilter().test(dbName)) {
                            if (dbName == null) {
                                dbName = "";
                            }
                            statementConsumer.consume(dbName, ddlStatements);
                        }
                    });
                } else if (this.filters.databaseFilter().test(databaseName)) {
                    if (databaseName == null) {
                        databaseName = "";
                    }
                    statementConsumer.consume(databaseName, ddlStatements);
                }
            }
            this.dbHistory.record(source.partition(), source.offset(), databaseName, this.tables, ddlStatements);
        }
        Set changes = this.tables.drainChanges();
        changes.forEach(tableId -> {
            Table table = this.tables.forTable(tableId);
            if (table == null) {
                this.tableSchemaByTableId.remove(tableId);
            } else {
                TableSchema schema = this.schemaBuilder.create(this.schemaPrefix, table, this.filters.columnFilter(), this.filters.columnMappers());
                this.tableSchemaByTableId.put((TableId)tableId, schema);
            }
        });
        return true;
    }
}

