/*
 * Decompiled with CFR 0.152.
 */
package com.github.shyiko.mysql.binlog.event.deserialization;

import com.github.shyiko.mysql.binlog.event.TableMapEventData;
import com.github.shyiko.mysql.binlog.event.deserialization.ColumnType;
import com.github.shyiko.mysql.binlog.event.deserialization.EventDataDeserializer;
import com.github.shyiko.mysql.binlog.io.ByteArrayInputStream;
import java.io.IOException;

public class TableMapEventDataDeserializer
implements EventDataDeserializer<TableMapEventData> {
    @Override
    public TableMapEventData deserialize(ByteArrayInputStream inputStream) throws IOException {
        TableMapEventData eventData = new TableMapEventData();
        eventData.setTableId(inputStream.readLong(6));
        inputStream.skip(3L);
        eventData.setDatabase(inputStream.readZeroTerminatedString());
        inputStream.skip(1L);
        eventData.setTable(inputStream.readZeroTerminatedString());
        int numberOfColumns = inputStream.readPackedInteger();
        eventData.setColumnTypes(inputStream.read(numberOfColumns));
        inputStream.readPackedInteger();
        eventData.setColumnMetadata(this.readMetadata(inputStream, eventData.getColumnTypes()));
        eventData.setColumnNullability(inputStream.readBitSet(numberOfColumns, true));
        return eventData;
    }

    private int[] readMetadata(ByteArrayInputStream inputStream, byte[] columnTypes) throws IOException {
        int[] metadata = new int[columnTypes.length];
        block6: for (int i = 0; i < columnTypes.length; ++i) {
            switch (ColumnType.byCode(columnTypes[i] & 0xFF)) {
                case FLOAT: 
                case DOUBLE: 
                case BLOB: 
                case GEOMETRY: {
                    metadata[i] = inputStream.readInteger(1);
                    continue block6;
                }
                case BIT: 
                case VARCHAR: 
                case NEWDECIMAL: {
                    metadata[i] = inputStream.readInteger(2);
                    continue block6;
                }
                case SET: 
                case ENUM: 
                case STRING: {
                    metadata[i] = TableMapEventDataDeserializer.bigEndianInteger(inputStream.read(2), 0, 2);
                    continue block6;
                }
                case TIME_V2: 
                case DATETIME_V2: 
                case TIMESTAMP_V2: {
                    metadata[i] = inputStream.readInteger(1);
                    continue block6;
                }
                default: {
                    metadata[i] = 0;
                }
            }
        }
        return metadata;
    }

    private static int bigEndianInteger(byte[] bytes, int offset, int length) {
        int result = 0;
        for (int i = offset; i < offset + length; ++i) {
            int b = bytes[i];
            result = result << 8 | (b >= 0 ? b : b + 256);
        }
        return result;
    }
}

