/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.relational.history;

import io.debezium.annotation.ThreadSafe;
import io.debezium.config.Configuration;
import io.debezium.config.Field;
import io.debezium.document.DocumentReader;
import io.debezium.document.DocumentWriter;
import io.debezium.relational.Tables;
import io.debezium.relational.ddl.DdlParser;
import io.debezium.relational.history.AbstractDatabaseHistory;
import io.debezium.relational.history.HistoryRecord;
import io.debezium.relational.history.HistoryRecordComparator;
import io.debezium.util.Collect;
import io.debezium.util.FunctionalReadWriteLock;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.function.Consumer;
import org.apache.kafka.connect.errors.ConnectException;
import org.slf4j.Logger;

@ThreadSafe
public final class FileDatabaseHistory
extends AbstractDatabaseHistory {
    public static final Field FILE_PATH = Field.create("database.history.file.filename").withDescription("The path to the file that will be used to record the database history").withValidation(Field::isRequired);
    public static Collection<Field> ALL_FIELDS = Collect.arrayListOf(FILE_PATH, new Field[0]);
    private static final Charset UTF8 = StandardCharsets.UTF_8;
    private final FunctionalReadWriteLock lock = FunctionalReadWriteLock.reentrant();
    private final DocumentWriter writer = DocumentWriter.defaultWriter();
    private final DocumentReader reader = DocumentReader.defaultReader();
    private Path path;

    @Override
    public void configure(Configuration config, HistoryRecordComparator comparator) {
        this.lock.write(() -> {
            if (!config.validateAndRecord(ALL_FIELDS, arg_0 -> ((Logger)this.logger).error(arg_0))) {
                throw new ConnectException("Error configuring an instance of " + this.getClass().getSimpleName() + "; check the logs for details");
            }
            config.validateAndRecord(ALL_FIELDS, arg_0 -> ((Logger)this.logger).error(arg_0));
            super.configure(config, comparator);
            this.path = Paths.get(config.getString(FILE_PATH), new String[0]);
        });
    }

    @Override
    protected void storeRecord(HistoryRecord record) {
        this.lock.write(() -> {
            try {
                String line = this.writer.write(record.document());
                if (!Files.exists(this.path, new LinkOption[0])) {
                    Files.createDirectories(this.path.getParent(), new FileAttribute[0]);
                    try {
                        Files.createFile(this.path, new FileAttribute[0]);
                    }
                    catch (FileAlreadyExistsException fileAlreadyExistsException) {
                        // empty catch block
                    }
                }
                Files.write(this.path, Collect.arrayListOf(line, new String[0]), UTF8, StandardOpenOption.APPEND);
            }
            catch (IOException e) {
                this.logger.error("Failed to add record to history at {}: {}", new Object[]{this.path, record, e});
            }
        });
    }

    @Override
    protected void recoverRecords(Tables schema, DdlParser ddlParser, Consumer<HistoryRecord> records) {
        this.lock.write(() -> {
            try {
                if (Files.exists(this.path, new LinkOption[0])) {
                    for (String line : Files.readAllLines(this.path)) {
                        records.accept(new HistoryRecord(this.reader.read(line)));
                    }
                }
            }
            catch (IOException e) {
                this.logger.error("Failed to add recover records from history at {}", (Object)this.path, (Object)e);
            }
        });
    }

    public String toString() {
        return "file " + (this.path != null ? this.path : "(unstarted)");
    }
}

