/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.config.Configuration;
import io.debezium.connector.mysql.MySqlConnector;
import io.debezium.connector.mysql.MySqlConnectorConfig;
import io.debezium.embedded.AbstractConnectorTest;
import io.debezium.relational.history.FileDatabaseHistory;
import io.debezium.util.Testing;
import java.nio.file.Path;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.List;
import org.apache.kafka.connect.data.Struct;
import org.fest.assertions.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class MySqlConnectorRegressionIT
extends AbstractConnectorTest {
    private static final Path DB_HISTORY_PATH = Testing.Files.createTestingPath((String)"file-db-history-regression.txt").toAbsolutePath();
    private Configuration config;

    @Before
    public void beforeEach() {
        this.stopConnector();
        this.initializeConnectorTestFramework();
        Testing.Files.delete((Path)DB_HISTORY_PATH);
    }

    @After
    public void afterEach() {
        try {
            this.stopConnector();
        }
        finally {
            Testing.Files.delete((Path)DB_HISTORY_PATH);
        }
    }

    @Test
    public void shouldConsumeAllEventsFromDatabaseUsingBinlogAndNoSnapshot() throws SQLException, InterruptedException {
        this.config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)Configuration.create().with(MySqlConnectorConfig.HOSTNAME, System.getProperty("database.hostname"))).with(MySqlConnectorConfig.PORT, System.getProperty("database.port"))).with(MySqlConnectorConfig.USER, "snapper")).with(MySqlConnectorConfig.PASSWORD, "snapperpass")).with(MySqlConnectorConfig.SERVER_ID, 18765)).with(MySqlConnectorConfig.SERVER_NAME, "regression")).with(MySqlConnectorConfig.POLL_INTERVAL_MS, 10)).with(MySqlConnectorConfig.DATABASE_WHITELIST, "regression_test")).with(MySqlConnectorConfig.DATABASE_HISTORY, FileDatabaseHistory.class)).with(MySqlConnectorConfig.INCLUDE_SCHEMA_CHANGES, true)).with(MySqlConnectorConfig.SNAPSHOT_MODE, MySqlConnectorConfig.SnapshotMode.NEVER.toString())).with(FileDatabaseHistory.FILE_PATH, (Object)DB_HISTORY_PATH)).with("database.useSSL", false)).build();
        this.start(MySqlConnector.class, this.config);
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(7);
        this.stopConnector();
        Assertions.assertThat((Object)records).isNotNull();
        Assertions.assertThat((int)records.recordsForTopic("regression").size()).isEqualTo(4);
        Assertions.assertThat((int)records.recordsForTopic("regression.regression_test.t1464075356413_testtable6").size()).isEqualTo(1);
        Assertions.assertThat((int)records.recordsForTopic("regression.regression_test.dbz84_integer_types_table").size()).isEqualTo(1);
        Assertions.assertThat((int)records.recordsForTopic("regression.regression_test.dbz_85_fractest").size()).isEqualTo(1);
        Assertions.assertThat((int)records.topics().size()).isEqualTo(4);
        Assertions.assertThat((int)records.databaseNames().size()).isEqualTo(1);
        Assertions.assertThat((int)records.ddlRecordsForDatabase("regression_test").size()).isEqualTo(4);
        Assertions.assertThat((List)records.ddlRecordsForDatabase("connector_test")).isNull();
        Assertions.assertThat((List)records.ddlRecordsForDatabase("readbinlog_test")).isNull();
        records.ddlRecordsForDatabase("regression_test").forEach(arg_0 -> ((MySqlConnectorRegressionIT)this).print(arg_0));
        records.forEach(arg_0 -> ((MySqlConnectorRegressionIT)this).validate(arg_0));
        records.forEach(record -> {
            Struct value = (Struct)record.value();
            if (record.topic().endsWith("dbz_85_fractest")) {
                Struct after = value.getStruct("after");
                Date c1 = (Date)after.get("c1");
                Date c2 = (Date)after.get("c2");
                Date c3 = (Date)after.get("c3");
                Date c4 = (Date)after.get("c4");
                Testing.debug((Object)("c1 = " + c1.getTime()));
                Testing.debug((Object)("c2 = " + c2.getTime()));
                Testing.debug((Object)("c3 = " + c3.getTime()));
                Testing.debug((Object)("c4 = " + c4.getTime()));
                Assertions.assertThat((long)(c1.getTime() % 1000L)).isEqualTo(0L);
                Assertions.assertThat((long)(c2.getTime() % 1000L)).isEqualTo(780L);
                Assertions.assertThat((long)(c3.getTime() % 1000L)).isEqualTo(780L);
                Assertions.assertThat((long)(c4.getTime() % 1000L)).isEqualTo(780L);
                ZoneId utc = ZoneId.of("UTC");
                ZoneId defaultTZ = ZoneId.systemDefault();
                LocalDate expectedDate = LocalDate.of(2014, 9, 8);
                LocalTime expectedTime = LocalTime.of(17, 51, 4).plus(780L, ChronoUnit.MILLIS);
                ZonedDateTime expectedC1UTC = ZonedDateTime.of(expectedDate, LocalTime.of(0, 0), defaultTZ).withZoneSameInstant(utc).truncatedTo(ChronoUnit.DAYS);
                Assertions.assertThat((long)c1.getTime()).isEqualTo(expectedC1UTC.toInstant().toEpochMilli());
                ZonedDateTime expectedC2UTC = ZonedDateTime.of(LocalDate.ofEpochDay(0L), expectedTime, utc);
                Assertions.assertThat((long)c2.getTime()).isEqualTo(expectedC2UTC.toInstant().toEpochMilli());
                ZonedDateTime expectedC3UTC = ZonedDateTime.of(expectedDate, expectedTime, utc);
                Assertions.assertThat((long)c3.getTime()).isEqualTo(expectedC3UTC.toInstant().toEpochMilli());
                Assertions.assertThat((long)c4.getTime()).isEqualTo(expectedC3UTC.toInstant().toEpochMilli());
                LocalDate localC1 = c1.toInstant().atZone(utc).toLocalDate();
                LocalTime localC2 = c2.toInstant().atZone(utc).toLocalTime();
                LocalDateTime localC3 = c3.toInstant().atZone(utc).toLocalDateTime();
                LocalDateTime localC4 = c4.toInstant().atZone(utc).toLocalDateTime();
                int expectedNanos = 780000000;
                Assertions.assertThat((int)localC1.getYear()).isEqualTo(2014);
                Assertions.assertThat((Object)localC1.getMonth()).isEqualTo((Object)Month.SEPTEMBER);
                Assertions.assertThat((int)localC1.getDayOfMonth()).isEqualTo(expectedC1UTC.get(ChronoField.DAY_OF_MONTH));
                Assertions.assertThat((int)localC2.getHour()).isEqualTo(17);
                Assertions.assertThat((int)localC2.getMinute()).isEqualTo(51);
                Assertions.assertThat((int)localC2.getSecond()).isEqualTo(4);
                Assertions.assertThat((int)localC2.getNano()).isEqualTo(780000000);
                Assertions.assertThat((int)localC3.getYear()).isEqualTo(2014);
                Assertions.assertThat((Object)localC3.getMonth()).isEqualTo((Object)Month.SEPTEMBER);
                Assertions.assertThat((int)localC3.getDayOfMonth()).isEqualTo(8);
                Assertions.assertThat((int)localC3.getHour()).isEqualTo(17);
                Assertions.assertThat((int)localC3.getMinute()).isEqualTo(51);
                Assertions.assertThat((int)localC3.getSecond()).isEqualTo(4);
                Assertions.assertThat((int)localC3.getNano()).isEqualTo(780000000);
                Assertions.assertThat((int)localC4.getYear()).isEqualTo(2014);
                Assertions.assertThat((Object)localC4.getMonth()).isEqualTo((Object)Month.SEPTEMBER);
                Assertions.assertThat((int)localC4.getDayOfMonth()).isEqualTo(8);
                Assertions.assertThat((int)localC4.getHour()).isEqualTo(17);
                Assertions.assertThat((int)localC4.getMinute()).isEqualTo(51);
                Assertions.assertThat((int)localC4.getSecond()).isEqualTo(4);
                Assertions.assertThat((int)localC4.getNano()).isEqualTo(780000000);
            }
        });
    }
}

