/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.relational;

import io.debezium.annotation.Immutable;
import io.debezium.annotation.ThreadSafe;
import io.debezium.data.Bits;
import io.debezium.data.IsoTime;
import io.debezium.data.IsoTimestamp;
import io.debezium.data.SchemaUtil;
import io.debezium.jdbc.JdbcConnection;
import io.debezium.jdbc.TimeZoneAdapter;
import io.debezium.relational.Column;
import io.debezium.relational.ColumnId;
import io.debezium.relational.Table;
import io.debezium.relational.TableId;
import io.debezium.relational.TableSchema;
import io.debezium.relational.ValueConverter;
import io.debezium.relational.mapping.ColumnMapper;
import io.debezium.relational.mapping.ColumnMappers;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.kafka.connect.data.Decimal;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.data.Time;
import org.apache.kafka.connect.errors.DataException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
@Immutable
public class TableSchemaBuilder {
    private static final Short SHORT_TRUE = new Short(1);
    private static final Short SHORT_FALSE = new Short(0);
    private static final Integer INTEGER_TRUE = new Integer(1);
    private static final Integer INTEGER_FALSE = new Integer(0);
    private static final Long LONG_TRUE = new Long(1L);
    private static final Long LONG_FALSE = new Long(0L);
    private static final Float FLOAT_TRUE = new Float(1.0);
    private static final Float FLOAT_FALSE = new Float(0.0);
    private static final Double DOUBLE_TRUE = new Double(1.0);
    private static final Double DOUBLE_FALSE = new Double(0.0);
    private static final Logger LOGGER = LoggerFactory.getLogger(TableSchemaBuilder.class);
    private static final LocalDate EPOCH_DAY = LocalDate.ofEpochDay(0L);
    private final TimeZoneAdapter timeZoneAdapter;

    public TableSchemaBuilder() {
        this(TimeZoneAdapter.create());
    }

    public TableSchemaBuilder(TimeZoneAdapter timeZoneAdapter) {
        this.timeZoneAdapter = timeZoneAdapter;
    }

    public TableSchema create(ResultSet resultSet, String name) throws SQLException {
        ArrayList<Column> columns = new ArrayList<Column>();
        JdbcConnection.columnsFor(resultSet, columns::add);
        SchemaBuilder schemaBuilder = SchemaBuilder.struct().name(name);
        columns.forEach(column -> this.addField(schemaBuilder, (Column)column, null));
        Schema valueSchema = schemaBuilder.build();
        TableId id = new TableId(null, null, name);
        Function<Object[], Struct> valueGenerator = this.createValueGenerator(valueSchema, id, columns, null, null);
        return new TableSchema(null, null, valueSchema, valueGenerator);
    }

    public TableSchema create(String schemaPrefix, Table table) {
        return this.create(schemaPrefix, table, null, null);
    }

    public TableSchema create(String schemaPrefix, Table table, Predicate<ColumnId> filter, ColumnMappers mappers) {
        Schema keySchema;
        if (schemaPrefix == null) {
            schemaPrefix = "";
        }
        TableId tableId = table.id();
        String tableIdStr = tableId.toString();
        String schemaNamePrefix = schemaPrefix + tableIdStr;
        SchemaBuilder valSchemaBuilder = SchemaBuilder.struct().name(schemaNamePrefix + ".Value");
        SchemaBuilder keySchemaBuilder = SchemaBuilder.struct().name(schemaNamePrefix + ".Key");
        LOGGER.debug("Mapping table '{}' to schemas under '{}'", (Object)tableId, (Object)schemaNamePrefix);
        AtomicBoolean hasPrimaryKey = new AtomicBoolean(false);
        table.columns().forEach(column -> {
            if (table.isPrimaryKeyColumn(column.name())) {
                this.addField(keySchemaBuilder, (Column)column, null);
                hasPrimaryKey.set(true);
            }
            if (filter == null || filter.test(new ColumnId(tableId, column.name()))) {
                ColumnMapper mapper = mappers == null ? null : mappers.mapperFor(tableId, (Column)column);
                this.addField(valSchemaBuilder, (Column)column, mapper);
            }
        });
        Schema valSchema = valSchemaBuilder.optional().build();
        Schema schema = keySchema = hasPrimaryKey.get() ? keySchemaBuilder.build() : null;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Mapped primary key for table '{}' to schema: {}", (Object)tableId, (Object)SchemaUtil.asDetailedString(keySchema));
            LOGGER.debug("Mapped columns for table '{}' to schema: {}", (Object)tableId, (Object)SchemaUtil.asDetailedString(valSchema));
        }
        Function<Object[], Object> keyGenerator = this.createKeyGenerator(keySchema, tableId, table.primaryKeyColumns());
        Function<Object[], Struct> valueGenerator = this.createValueGenerator(valSchema, tableId, table.columns(), filter, mappers);
        return new TableSchema(keySchema, keyGenerator, valSchema, valueGenerator);
    }

    protected Function<Object[], Object> createKeyGenerator(Schema schema, TableId columnSetName, List<Column> columns) {
        if (schema != null) {
            int[] recordIndexes = this.indexesForColumns(columns);
            Field[] fields = this.fieldsForColumns(schema, columns);
            int numFields = recordIndexes.length;
            ValueConverter[] converters = this.convertersForColumns(schema, columnSetName, columns, null, null);
            return row -> {
                Struct result = new Struct(schema);
                for (int i = 0; i != numFields; ++i) {
                    Object value = row[recordIndexes[i]];
                    ValueConverter converter = converters[i];
                    if (converter == null) continue;
                    value = value == null ? value : converter.convert(value);
                    try {
                        result.put(fields[i], value);
                        continue;
                    }
                    catch (DataException e) {
                        Column col = (Column)columns.get(i);
                        LOGGER.error("Failed to properly convert key value for '" + columnSetName + "." + col.name() + "' of type " + col.typeName() + ":", (Throwable)e);
                    }
                }
                return result;
            };
        }
        return null;
    }

    protected Function<Object[], Struct> createValueGenerator(Schema schema, TableId tableId, List<Column> columns, Predicate<ColumnId> filter, ColumnMappers mappers) {
        if (schema != null) {
            int[] recordIndexes = this.indexesForColumns(columns);
            Field[] fields = this.fieldsForColumns(schema, columns);
            int numFields = recordIndexes.length;
            ValueConverter[] converters = this.convertersForColumns(schema, tableId, columns, filter, mappers);
            AtomicBoolean traceMessage = new AtomicBoolean(true);
            return row -> {
                Struct result = new Struct(schema);
                for (int i = 0; i != numFields; ++i) {
                    Object value = row[recordIndexes[i]];
                    ValueConverter converter = converters[i];
                    if (converter != null) {
                        if (value != null) {
                            value = converter.convert(value);
                        }
                        try {
                            result.put(fields[i], value);
                        }
                        catch (DataException e) {
                            Column col = (Column)columns.get(i);
                            LOGGER.error("Failed to properly convert data value for '" + tableId + "." + col.name() + "' of type " + col.typeName() + ":", (Throwable)e);
                        }
                        continue;
                    }
                    if (!traceMessage.getAndSet(false)) continue;
                    Column col = (Column)columns.get(i);
                    LOGGER.trace("Excluding '" + tableId + "." + col.name() + "' of type " + col.typeName());
                }
                return result;
            };
        }
        return null;
    }

    protected int[] indexesForColumns(List<Column> columns) {
        int[] recordIndexes = new int[columns.size()];
        AtomicInteger i = new AtomicInteger(0);
        columns.forEach(column -> {
            recordIndexes[i.getAndIncrement()] = column.position() - 1;
        });
        return recordIndexes;
    }

    protected Field[] fieldsForColumns(Schema schema, List<Column> columns) {
        Field[] fields = new Field[columns.size()];
        AtomicInteger i = new AtomicInteger(0);
        columns.forEach(column -> {
            Field field;
            fields[i.getAndIncrement()] = field = schema.field(column.name());
        });
        return fields;
    }

    protected ValueConverter[] convertersForColumns(Schema schema, TableId tableId, List<Column> columns, Predicate<ColumnId> filter, ColumnMappers mappers) {
        ValueConverter[] converters = new ValueConverter[columns.size()];
        AtomicInteger i = new AtomicInteger(0);
        columns.forEach(column -> {
            Field field = schema.field(column.name());
            ValueConverter converter = null;
            if (filter == null || filter.test(new ColumnId(tableId, column.name()))) {
                ValueConverter mappingConverter;
                ValueConverter valueConverter = this.createValueConverterFor((Column)column, field);
                assert (valueConverter != null);
                if (mappers != null && (mappingConverter = mappers.mappingConverterFor(tableId, (Column)column)) != null) {
                    converter = value -> {
                        if (value != null) {
                            value = valueConverter.convert(value);
                        }
                        return mappingConverter.convert(value);
                    };
                }
                if (converter == null) {
                    converter = valueConverter;
                }
                assert (converter != null);
            }
            converters[i.getAndIncrement()] = converter;
        });
        return converters;
    }

    protected void addField(SchemaBuilder builder, Column column, ColumnMapper mapper) {
        SchemaBuilder fieldBuilder = null;
        switch (column.jdbcType()) {
            case 0: {
                LOGGER.warn("Unexpected JDBC type: NULL");
                break;
            }
            case -7: {
                if (column.length() > 1) {
                    fieldBuilder = Bits.builder();
                    break;
                }
            }
            case 16: {
                fieldBuilder = SchemaBuilder.bool();
                break;
            }
            case -2: 
            case 2004: {
                fieldBuilder = SchemaBuilder.bytes();
                break;
            }
            case -4: 
            case -3: {
                fieldBuilder = SchemaBuilder.bytes();
                break;
            }
            case -6: {
                fieldBuilder = SchemaBuilder.int8();
                break;
            }
            case 5: {
                fieldBuilder = SchemaBuilder.int16();
                break;
            }
            case 4: {
                fieldBuilder = SchemaBuilder.int32();
                break;
            }
            case -5: {
                fieldBuilder = SchemaBuilder.int64();
                break;
            }
            case 7: {
                fieldBuilder = SchemaBuilder.float32();
                break;
            }
            case 6: 
            case 8: {
                fieldBuilder = SchemaBuilder.float64();
                break;
            }
            case 2: 
            case 3: {
                fieldBuilder = Decimal.builder((int)column.scale());
                break;
            }
            case -16: 
            case -15: 
            case -9: 
            case 1: 
            case 2011: {
                fieldBuilder = SchemaBuilder.string();
                break;
            }
            case -1: 
            case 12: 
            case 70: 
            case 2005: 
            case 2009: {
                fieldBuilder = SchemaBuilder.string();
                break;
            }
            case 91: {
                fieldBuilder = org.apache.kafka.connect.data.Date.builder();
                break;
            }
            case 92: {
                fieldBuilder = Time.builder();
                break;
            }
            case 93: {
                fieldBuilder = org.apache.kafka.connect.data.Timestamp.builder();
                break;
            }
            case 2013: {
                fieldBuilder = IsoTime.builder();
                break;
            }
            case 2014: {
                fieldBuilder = IsoTimestamp.builder();
                break;
            }
            case -8: {
                fieldBuilder = SchemaBuilder.bytes();
                break;
            }
            default: {
                fieldBuilder = this.addOtherField(column, mapper);
            }
        }
        if (fieldBuilder != null) {
            if (mapper != null) {
                mapper.alterFieldSchema(column, fieldBuilder);
            }
            if (column.isOptional()) {
                fieldBuilder.optional();
            }
            builder.field(column.name(), fieldBuilder.build());
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("- field '{}' ({}{}) from column {}", new Object[]{column.name(), builder.isOptional() ? "OPTIONAL " : "", fieldBuilder.type(), column});
            }
        }
    }

    protected SchemaBuilder addOtherField(Column column, ColumnMapper mapper) {
        LOGGER.warn("Unexpected JDBC type: {}", (Object)column.jdbcType());
        return null;
    }

    protected ValueConverter createValueConverterFor(Column column, Field fieldDefn) {
        switch (column.jdbcType()) {
            case 0: {
                return data -> null;
            }
            case -7: {
                return data -> this.convertBit(column, fieldDefn, data);
            }
            case 16: {
                return data -> this.convertBoolean(column, fieldDefn, data);
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                return data -> this.convertBinary(column, fieldDefn, data);
            }
            case -6: {
                return data -> this.convertTinyInt(column, fieldDefn, data);
            }
            case 5: {
                return data -> this.convertSmallInt(column, fieldDefn, data);
            }
            case 4: {
                return data -> this.convertInteger(column, fieldDefn, data);
            }
            case -5: {
                return data -> this.convertBigInt(column, fieldDefn, data);
            }
            case 6: {
                return data -> this.convertFloat(column, fieldDefn, data);
            }
            case 8: {
                return data -> this.convertDouble(column, fieldDefn, data);
            }
            case 7: {
                return data -> this.convertReal(column, fieldDefn, data);
            }
            case 2: {
                return data -> this.convertNumeric(column, fieldDefn, data);
            }
            case 3: {
                return data -> this.convertDecimal(column, fieldDefn, data);
            }
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: 
            case 70: 
            case 2005: 
            case 2009: 
            case 2011: {
                return data -> this.convertString(column, fieldDefn, data);
            }
            case 91: {
                return data -> this.convertDate(column, fieldDefn, data);
            }
            case 92: {
                return data -> this.convertTime(column, fieldDefn, data);
            }
            case 93: {
                return data -> this.convertTimestamp(column, fieldDefn, data);
            }
            case 2013: {
                return data -> this.convertTimeWithZone(column, fieldDefn, data);
            }
            case 2014: {
                return data -> this.convertTimestampWithZone(column, fieldDefn, data);
            }
            case -8: {
                return data -> this.convertRowId(column, fieldDefn, data);
            }
        }
        return data -> this.handleUnknownData(column, fieldDefn, data);
    }

    protected Object handleUnknownData(Column column, Field fieldDefn, Object data) {
        LOGGER.warn("Unexpected value for JDBC type {} and column {}: class={}, value={}", new Object[]{column.jdbcType(), column, data.getClass(), data});
        return null;
    }

    protected Object convertTimestampWithZone(Column column, Field fieldDefn, Object data) {
        if (data == null) {
            return null;
        }
        OffsetDateTime dateTime = null;
        LOGGER.debug("TimestampWithZone: " + data + " , class=" + data.getClass());
        if (data instanceof OffsetDateTime) {
            dateTime = (OffsetDateTime)data;
        } else if (data instanceof Timestamp) {
            Timestamp sqlTime = (Timestamp)data;
            dateTime = sqlTime.toInstant().atOffset(ZoneOffset.UTC);
        } else if (data instanceof Date) {
            java.sql.Time sqlTime = (java.sql.Time)data;
            dateTime = sqlTime.toInstant().atOffset(ZoneOffset.UTC);
        } else if (data instanceof java.util.Date) {
            java.util.Date date = (java.util.Date)data;
            dateTime = date.toInstant().atOffset(ZoneOffset.UTC);
        } else if (data instanceof LocalDate) {
            LocalDate local = (LocalDate)data;
            dateTime = local.atTime(OffsetTime.of(0, 0, 0, 0, ZoneOffset.UTC));
        } else if (data instanceof LocalDateTime) {
            LocalDateTime local = (LocalDateTime)data;
            dateTime = local.atOffset(ZoneOffset.UTC);
        } else {
            dateTime = this.unexpectedTimestampWithZone(data, fieldDefn);
        }
        return dateTime;
    }

    protected OffsetDateTime unexpectedTimestampWithZone(Object value, Field fieldDefn) {
        LOGGER.warn("Unexpected JDBC TIMESTAMP_WITH_TIMEZONE value for field {} with schema {}: class={}, value={}", new Object[]{fieldDefn.name(), fieldDefn.schema(), value.getClass(), value});
        return null;
    }

    protected Object convertTimeWithZone(Column column, Field fieldDefn, Object data) {
        if (data == null) {
            return null;
        }
        OffsetTime time = null;
        LOGGER.debug("TimeWithZone: " + data + " , class=" + data.getClass());
        if (data instanceof OffsetTime) {
            time = (OffsetTime)data;
        } else if (data instanceof java.sql.Time) {
            java.sql.Time sqlTime = (java.sql.Time)data;
            time = OffsetTime.of(sqlTime.toLocalTime(), ZoneOffset.UTC);
        } else if (data instanceof java.util.Date) {
            java.util.Date date = (java.util.Date)data;
            time = OffsetTime.ofInstant(date.toInstant(), ZoneOffset.UTC.normalized());
        } else if (data instanceof LocalTime) {
            LocalTime local = (LocalTime)data;
            time = local.atOffset(ZoneOffset.UTC);
        } else if (data instanceof LocalDateTime) {
            LocalDateTime local = (LocalDateTime)data;
            time = local.toLocalTime().atOffset(ZoneOffset.UTC);
        } else {
            time = this.unexpectedTimeWithZone(data, fieldDefn);
        }
        return time;
    }

    protected OffsetTime unexpectedTimeWithZone(Object value, Field fieldDefn) {
        LOGGER.warn("Unexpected JDBC TIME_WITH_TIMEZONE value for field {} with schema {}: class={}, value={}", new Object[]{fieldDefn.name(), fieldDefn.schema(), value.getClass(), value});
        return null;
    }

    protected Object convertTimestamp(Column column, Field fieldDefn, Object data) {
        if (data == null) {
            return null;
        }
        java.util.Date date = null;
        LOGGER.debug("Timestamp: " + data + " , class=" + data.getClass());
        if (data instanceof java.util.Date) {
            ZonedDateTime zdt = this.timeZoneAdapter.toZonedDateTime((java.util.Date)data);
            date = java.util.Date.from(zdt.toInstant());
        } else if (data instanceof LocalDate) {
            LocalDate local = (LocalDate)data;
            date = java.util.Date.from(local.atStartOfDay().toInstant(ZoneOffset.UTC));
        } else if (data instanceof LocalDateTime) {
            LocalDateTime local = (LocalDateTime)data;
            date = java.util.Date.from(local.toInstant(ZoneOffset.UTC));
        } else {
            date = this.unexpectedTimestamp(data, fieldDefn);
        }
        return date;
    }

    protected java.util.Date unexpectedTimestamp(Object value, Field fieldDefn) {
        LOGGER.warn("Unexpected JDBC TIMESTAMP value for field {} with schema {}: class={}, value={}", new Object[]{fieldDefn.name(), fieldDefn.schema(), value.getClass(), value});
        return null;
    }

    protected Object convertTime(Column column, Field fieldDefn, Object data) {
        if (data == null) {
            return null;
        }
        java.util.Date date = null;
        LOGGER.debug("Time: " + data + " , class=" + data.getClass());
        if (data instanceof java.util.Date) {
            ZonedDateTime zdt = this.timeZoneAdapter.toZonedDateTime((java.util.Date)data);
            date = java.util.Date.from(zdt.toInstant());
        } else if (data instanceof LocalTime) {
            LocalTime local = (LocalTime)data;
            date = java.util.Date.from(local.atDate(EPOCH_DAY).toInstant(ZoneOffset.UTC));
        } else if (data instanceof LocalDateTime) {
            LocalDateTime local = (LocalDateTime)data;
            date = java.util.Date.from(local.with(ChronoField.EPOCH_DAY, 0L).toInstant(ZoneOffset.UTC));
        } else {
            date = this.unexpectedTime(data, fieldDefn);
        }
        return date;
    }

    protected java.util.Date unexpectedTime(Object value, Field fieldDefn) {
        LOGGER.warn("Unexpected JDBC TIME value for field {} with schema {}: class={}, value={}", new Object[]{fieldDefn.name(), fieldDefn.schema(), value.getClass(), value});
        return null;
    }

    protected Object convertDate(Column column, Field fieldDefn, Object data) {
        if (data == null) {
            return null;
        }
        java.util.Date date = null;
        LOGGER.debug("Date: " + data + " , class=" + data.getClass());
        if (data instanceof java.util.Date) {
            ZonedDateTime zdt = this.timeZoneAdapter.toZonedDateTime((java.util.Date)data);
            date = java.util.Date.from(zdt.toInstant());
        } else if (data instanceof LocalDate) {
            LocalDate local = (LocalDate)data;
            date = java.util.Date.from(local.atStartOfDay().toInstant(ZoneOffset.UTC));
        } else if (data instanceof LocalDateTime) {
            LocalDateTime local = (LocalDateTime)data;
            date = java.util.Date.from(local.truncatedTo(ChronoUnit.DAYS).toInstant(ZoneOffset.UTC));
        } else {
            date = this.unexpectedDate(data, fieldDefn);
        }
        return date;
    }

    protected java.util.Date unexpectedDate(Object value, Field fieldDefn) {
        LOGGER.warn("Unexpected JDBC DATE value for field {} with schema {}: class={}, value={}", new Object[]{fieldDefn.name(), fieldDefn.schema(), value.getClass(), value});
        return null;
    }

    protected Object convertBinary(Column column, Field fieldDefn, Object data) {
        if (data == null) {
            return null;
        }
        if (data instanceof char[]) {
            data = new String((char[])data);
        }
        if (data instanceof String) {
            data = ((String)data).getBytes();
        }
        if (data instanceof byte[]) {
            return ByteBuffer.wrap((byte[])data);
        }
        return this.unexpectedBinary(data, fieldDefn);
    }

    protected byte[] unexpectedBinary(Object value, Field fieldDefn) {
        LOGGER.warn("Unexpected JDBC BINARY value for field {} with schema {}: class={}, value={}", new Object[]{fieldDefn.name(), fieldDefn.schema(), value.getClass(), value});
        return null;
    }

    protected Object convertTinyInt(Column column, Field fieldDefn, Object data) {
        return this.convertSmallInt(column, fieldDefn, data);
    }

    protected Object convertSmallInt(Column column, Field fieldDefn, Object data) {
        if (data == null) {
            return null;
        }
        if (data instanceof Short) {
            return data;
        }
        if (data instanceof Number) {
            Number value = (Number)data;
            return new Short(value.shortValue());
        }
        if (data instanceof Boolean) {
            return (Boolean)data != false ? SHORT_TRUE : SHORT_FALSE;
        }
        return this.handleUnknownData(column, fieldDefn, data);
    }

    protected Object convertInteger(Column column, Field fieldDefn, Object data) {
        if (data == null) {
            return null;
        }
        if (data instanceof Integer) {
            return data;
        }
        if (data instanceof Number) {
            Number value = (Number)data;
            return new Integer(value.intValue());
        }
        if (data instanceof Boolean) {
            return (Boolean)data != false ? INTEGER_TRUE : INTEGER_FALSE;
        }
        return this.handleUnknownData(column, fieldDefn, data);
    }

    protected Object convertBigInt(Column column, Field fieldDefn, Object data) {
        if (data == null) {
            return null;
        }
        if (data instanceof Long) {
            return data;
        }
        if (data instanceof Number) {
            Number value = (Number)data;
            return new Long(value.longValue());
        }
        if (data instanceof Boolean) {
            return (Boolean)data != false ? LONG_TRUE : LONG_FALSE;
        }
        return this.handleUnknownData(column, fieldDefn, data);
    }

    protected Object convertFloat(Column column, Field fieldDefn, Object data) {
        return this.convertDouble(column, fieldDefn, data);
    }

    protected Object convertDouble(Column column, Field fieldDefn, Object data) {
        if (data == null) {
            return null;
        }
        if (data instanceof Double) {
            return data;
        }
        if (data instanceof Number) {
            Number value = (Number)data;
            return new Double(value.doubleValue());
        }
        if (data instanceof Boolean) {
            return (Boolean)data != false ? DOUBLE_TRUE : DOUBLE_FALSE;
        }
        return this.handleUnknownData(column, fieldDefn, data);
    }

    protected Object convertReal(Column column, Field fieldDefn, Object data) {
        if (data == null) {
            return null;
        }
        if (data instanceof Float) {
            return data;
        }
        if (data instanceof Number) {
            Number value = (Number)data;
            return new Float(value.floatValue());
        }
        if (data instanceof Boolean) {
            return (Boolean)data != false ? FLOAT_TRUE : FLOAT_FALSE;
        }
        return this.handleUnknownData(column, fieldDefn, data);
    }

    protected Object convertNumeric(Column column, Field fieldDefn, Object data) {
        BigDecimal decimal = null;
        if (data instanceof BigDecimal) {
            decimal = (BigDecimal)data;
        } else if (data instanceof Boolean) {
            decimal = new BigDecimal((Boolean)data != false ? 1 : 0);
        } else if (data instanceof Short) {
            decimal = new BigDecimal(((Short)data).intValue());
        } else if (data instanceof Integer) {
            decimal = new BigDecimal((Integer)data);
        } else if (data instanceof Long) {
            decimal = BigDecimal.valueOf((Long)data);
        } else if (data instanceof Float) {
            decimal = BigDecimal.valueOf(((Float)data).doubleValue());
        } else if (data instanceof Double) {
            decimal = BigDecimal.valueOf((Double)data);
        } else {
            return this.handleUnknownData(column, fieldDefn, data);
        }
        return decimal;
    }

    protected Object convertDecimal(Column column, Field fieldDefn, Object data) {
        if (data == null) {
            return null;
        }
        BigDecimal decimal = null;
        if (data instanceof BigDecimal) {
            decimal = (BigDecimal)data;
        } else if (data instanceof Boolean) {
            decimal = new BigDecimal((Boolean)data != false ? 1 : 0);
        } else if (data instanceof Short) {
            decimal = new BigDecimal(((Short)data).intValue());
        } else if (data instanceof Integer) {
            decimal = new BigDecimal((Integer)data);
        } else if (data instanceof Long) {
            decimal = BigDecimal.valueOf((Long)data);
        } else if (data instanceof Float) {
            decimal = BigDecimal.valueOf(((Float)data).doubleValue());
        } else if (data instanceof Double) {
            decimal = BigDecimal.valueOf((Double)data);
        } else {
            return this.handleUnknownData(column, fieldDefn, data);
        }
        return decimal;
    }

    protected Object convertString(Column column, Field fieldDefn, Object data) {
        return data == null ? null : data.toString();
    }

    protected Object convertRowId(Column column, Field fieldDefn, Object data) {
        if (data == null) {
            return null;
        }
        if (data instanceof RowId) {
            RowId row = (RowId)data;
            return ByteBuffer.wrap(row.getBytes());
        }
        return this.handleUnknownData(column, fieldDefn, data);
    }

    protected Object convertBit(Column column, Field fieldDefn, Object data) {
        if (data == null) {
            return null;
        }
        if (data instanceof Boolean) {
            return data;
        }
        if (data instanceof Short) {
            return ((Short)data).intValue() == 0 ? Boolean.FALSE : Boolean.TRUE;
        }
        if (data instanceof Integer) {
            return (Integer)data == 0 ? Boolean.FALSE : Boolean.TRUE;
        }
        if (data instanceof Long) {
            return ((Long)data).intValue() == 0 ? Boolean.FALSE : Boolean.TRUE;
        }
        return this.handleUnknownData(column, fieldDefn, data);
    }

    protected Object convertBoolean(Column column, Field fieldDefn, Object data) {
        if (data == null) {
            return null;
        }
        if (data instanceof Boolean) {
            return data;
        }
        if (data instanceof Short) {
            return ((Short)data).intValue() == 0 ? Boolean.FALSE : Boolean.TRUE;
        }
        if (data instanceof Integer) {
            return (Integer)data == 0 ? Boolean.FALSE : Boolean.TRUE;
        }
        if (data instanceof Long) {
            return ((Long)data).intValue() == 0 ? Boolean.FALSE : Boolean.TRUE;
        }
        return this.handleUnknownData(column, fieldDefn, data);
    }
}

