/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.annotation.NotThreadSafe;
import io.debezium.connector.mysql.GtidSet;
import io.debezium.document.Document;
import io.debezium.util.Collect;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.errors.ConnectException;

@NotThreadSafe
final class SourceInfo {
    public static final String SERVER_ID_KEY = "server_id";
    public static final String SERVER_NAME_KEY = "name";
    public static final String SERVER_PARTITION_KEY = "server";
    public static final String GTID_SET_KEY = "gtids";
    public static final String GTID_KEY = "gtid";
    public static final String BINLOG_FILENAME_OFFSET_KEY = "file";
    public static final String BINLOG_POSITION_OFFSET_KEY = "pos";
    public static final String BINLOG_EVENT_ROW_NUMBER_OFFSET_KEY = "row";
    public static final String TIMESTAMP_KEY = "ts_sec";
    public static final String SNAPSHOT_KEY = "snapshot";
    public static final Schema SCHEMA = SchemaBuilder.struct().name("io.debezium.connector.mysql.Source").field("name", Schema.STRING_SCHEMA).field("server_id", Schema.INT64_SCHEMA).field("ts_sec", Schema.INT64_SCHEMA).field("gtid", Schema.OPTIONAL_STRING_SCHEMA).field("file", Schema.STRING_SCHEMA).field("pos", Schema.INT64_SCHEMA).field("row", Schema.INT32_SCHEMA).field("snapshot", Schema.OPTIONAL_BOOLEAN_SCHEMA).build();
    private String gtidSet;
    private String binlogGtid;
    private String binlogFilename;
    private long lastBinlogPosition = 0L;
    private int lastEventRowNumber = 0;
    private long nextBinlogPosition = 4L;
    private int nextEventRowNumber = 0;
    private String serverName;
    private long serverId = 0L;
    private long binlogTimestampSeconds = 0L;
    private Map<String, String> sourcePartition;
    private boolean lastSnapshot = true;
    private boolean nextSnapshot = false;

    public void setServerName(String logicalId) {
        this.serverName = logicalId;
        this.sourcePartition = Collect.hashMapOf((Object)SERVER_PARTITION_KEY, (Object)this.serverName);
    }

    public Map<String, String> partition() {
        return this.sourcePartition;
    }

    public Map<String, ?> offset() {
        return this.offsetUsingPosition(this.nextBinlogPosition);
    }

    public Map<String, ?> offsetForRow(int eventRowNumber, int totalNumberOfRows) {
        if (eventRowNumber < totalNumberOfRows - 1) {
            this.lastEventRowNumber = eventRowNumber;
            this.nextEventRowNumber = eventRowNumber + 1;
            return this.offsetUsingPosition(this.lastBinlogPosition);
        }
        this.lastEventRowNumber = this.nextEventRowNumber;
        this.nextEventRowNumber = 0;
        return this.offsetUsingPosition(this.nextBinlogPosition);
    }

    private Map<String, ?> offsetUsingPosition(long binlogPosition) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (this.serverId != 0L) {
            map.put(SERVER_ID_KEY, this.serverId);
        }
        if (this.binlogTimestampSeconds != 0L) {
            map.put(TIMESTAMP_KEY, this.binlogTimestampSeconds);
        }
        if (this.gtidSet != null) {
            map.put(GTID_SET_KEY, this.gtidSet);
        }
        map.put(BINLOG_FILENAME_OFFSET_KEY, this.binlogFilename);
        map.put(BINLOG_POSITION_OFFSET_KEY, binlogPosition);
        map.put(BINLOG_EVENT_ROW_NUMBER_OFFSET_KEY, this.nextEventRowNumber);
        if (this.isSnapshotInEffect()) {
            map.put(SNAPSHOT_KEY, true);
        }
        return map;
    }

    public Schema schema() {
        return SCHEMA;
    }

    public Struct struct() {
        assert (this.serverName != null);
        Struct result = new Struct(SCHEMA);
        result.put(SERVER_NAME_KEY, (Object)this.serverName);
        result.put(SERVER_ID_KEY, (Object)this.serverId);
        if (this.binlogGtid != null) {
            result.put(GTID_KEY, (Object)this.binlogGtid);
        }
        result.put(BINLOG_FILENAME_OFFSET_KEY, (Object)this.binlogFilename);
        result.put(BINLOG_POSITION_OFFSET_KEY, (Object)this.lastBinlogPosition);
        result.put(BINLOG_EVENT_ROW_NUMBER_OFFSET_KEY, (Object)this.lastEventRowNumber);
        result.put(TIMESTAMP_KEY, (Object)this.binlogTimestampSeconds);
        if (this.lastSnapshot) {
            result.put(SNAPSHOT_KEY, (Object)true);
        }
        return result;
    }

    public boolean isSnapshotInEffect() {
        return this.nextSnapshot;
    }

    public void setGtid(String gtid) {
        this.binlogGtid = gtid;
    }

    public void setGtidSet(String gtidSet) {
        if (gtidSet != null && !gtidSet.trim().isEmpty()) {
            this.gtidSet = gtidSet;
        }
    }

    public void setBinlogStartPoint(String binlogFilename, long positionOfFirstEvent) {
        this.binlogFilename = binlogFilename;
        this.lastBinlogPosition = this.nextBinlogPosition = positionOfFirstEvent;
        this.nextEventRowNumber = 0;
        this.lastEventRowNumber = 0;
    }

    public void setEventPosition(long positionOfCurrentEvent, long eventSizeInBytes) {
        this.lastBinlogPosition = positionOfCurrentEvent;
        this.nextBinlogPosition = positionOfCurrentEvent + eventSizeInBytes;
    }

    public void setBinlogServerId(long serverId) {
        this.serverId = serverId;
    }

    public void setBinlogTimestampSeconds(long timestampInSeconds) {
        this.binlogTimestampSeconds = timestampInSeconds / 1000L;
    }

    public void startSnapshot() {
        this.lastSnapshot = true;
        this.nextSnapshot = true;
    }

    public void markLastSnapshot() {
        this.lastSnapshot = true;
        this.nextSnapshot = false;
    }

    public void completeSnapshot() {
        this.lastSnapshot = false;
        this.nextSnapshot = false;
    }

    public void setOffset(Map<String, ?> sourceOffset) {
        if (sourceOffset != null) {
            this.setGtidSet((String)sourceOffset.get(GTID_SET_KEY));
            this.binlogFilename = (String)sourceOffset.get(BINLOG_FILENAME_OFFSET_KEY);
            if (this.binlogFilename == null) {
                throw new ConnectException("Source offset 'file' parameter is missing");
            }
            this.nextBinlogPosition = this.longOffsetValue(sourceOffset, BINLOG_POSITION_OFFSET_KEY);
            this.nextEventRowNumber = (int)this.longOffsetValue(sourceOffset, BINLOG_EVENT_ROW_NUMBER_OFFSET_KEY);
            this.lastBinlogPosition = this.nextBinlogPosition;
            this.lastEventRowNumber = this.nextEventRowNumber;
            this.lastSnapshot = this.nextSnapshot = this.booleanOffsetValue(sourceOffset, SNAPSHOT_KEY);
        }
    }

    private long longOffsetValue(Map<String, ?> values, String key) {
        Object obj = values.get(key);
        if (obj == null) {
            return 0L;
        }
        if (obj instanceof Number) {
            return ((Number)obj).longValue();
        }
        try {
            return Long.parseLong(obj.toString());
        }
        catch (NumberFormatException e) {
            throw new ConnectException("Source offset '" + key + "' parameter value " + obj + " could not be converted to a long");
        }
    }

    private boolean booleanOffsetValue(Map<String, ?> values, String key) {
        Object obj = values.get(key);
        if (obj == null) {
            return false;
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        return Boolean.parseBoolean(obj.toString());
    }

    public String gtidSet() {
        return this.gtidSet != null ? this.gtidSet.toString() : null;
    }

    public String binlogFilename() {
        return this.binlogFilename;
    }

    public long nextBinlogPosition() {
        return this.nextBinlogPosition;
    }

    public long lastBinlogPosition() {
        return this.lastBinlogPosition;
    }

    public int nextEventRowNumber() {
        return this.nextEventRowNumber;
    }

    public int lastEventRowNumber() {
        return this.lastEventRowNumber;
    }

    public String serverName() {
        return this.serverName;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.gtidSet != null) {
            sb.append("GTIDs ");
            sb.append(this.gtidSet);
            sb.append(" and binlog file '").append(this.binlogFilename).append("'");
            sb.append(", pos=").append(this.nextBinlogPosition());
            sb.append(", row=").append(this.nextEventRowNumber());
        } else if (this.binlogFilename == null) {
            sb.append("<latest>");
        } else if ("".equals(this.binlogFilename)) {
            sb.append("earliest binlog file and position");
        } else {
            sb.append("binlog file '").append(this.binlogFilename).append("'");
            sb.append(", pos=").append(this.nextBinlogPosition());
            sb.append(", row=").append(this.nextEventRowNumber());
        }
        return sb.toString();
    }

    public static boolean isPositionAtOrBefore(Document recorded, Document desired) {
        int desiredRow;
        int desiredPosition;
        int desiredServerId;
        String recordedGtidSetStr = recorded.getString((CharSequence)GTID_SET_KEY);
        String desiredGtidSetStr = desired.getString((CharSequence)GTID_SET_KEY);
        if (desiredGtidSetStr != null) {
            if (recordedGtidSetStr != null) {
                GtidSet recordedGtidSet = new GtidSet(recordedGtidSetStr);
                GtidSet desiredGtidSet = new GtidSet(desiredGtidSetStr);
                if (recordedGtidSet.equals(desiredGtidSet)) {
                    return recorded.has((CharSequence)SNAPSHOT_KEY) || !desired.has((CharSequence)SNAPSHOT_KEY);
                }
                return recordedGtidSet.isContainedWithin(desiredGtidSet);
            }
            return true;
        }
        if (recordedGtidSetStr != null) {
            return false;
        }
        int recordedServerId = recorded.getInteger((CharSequence)SERVER_ID_KEY, 0);
        if (recordedServerId != (desiredServerId = recorded.getInteger((CharSequence)SERVER_ID_KEY, 0))) {
            long desiredTimestamp;
            long recordedTimestamp = recorded.getLong((CharSequence)TIMESTAMP_KEY, 0L);
            return recordedTimestamp <= (desiredTimestamp = recorded.getLong((CharSequence)TIMESTAMP_KEY, 0L));
        }
        String recordedFilename = recorded.getString((CharSequence)BINLOG_FILENAME_OFFSET_KEY);
        String desiredFilename = desired.getString((CharSequence)BINLOG_FILENAME_OFFSET_KEY);
        assert (recordedFilename != null);
        int diff = recordedFilename.compareToIgnoreCase(desiredFilename);
        if (diff > 0) {
            return false;
        }
        int recordedPosition = recorded.getInteger((CharSequence)BINLOG_POSITION_OFFSET_KEY, -1);
        diff = recordedPosition - (desiredPosition = desired.getInteger((CharSequence)BINLOG_POSITION_OFFSET_KEY, -1));
        if (diff > 0) {
            return false;
        }
        int recordedRow = recorded.getInteger((CharSequence)BINLOG_EVENT_ROW_NUMBER_OFFSET_KEY, -1);
        diff = recordedRow - (desiredRow = desired.getInteger((CharSequence)BINLOG_EVENT_ROW_NUMBER_OFFSET_KEY, -1));
        return diff <= 0;
    }
}

