/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.relational;

import io.debezium.relational.Column;
import io.debezium.relational.Table;
import io.debezium.relational.TableEditor;
import io.debezium.relational.TableEditorImpl;
import io.debezium.relational.TableId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

final class TableImpl
implements Table {
    private final TableId id;
    private final List<Column> columnDefs;
    private final List<String> pkColumnNames;
    private final List<String> columnNames;
    private final Map<String, Column> columnsByLowercaseName;

    protected TableImpl(Table table) {
        this(table.id(), table.columns(), table.primaryKeyColumnNames());
    }

    protected TableImpl(TableId id, List<Column> sortedColumns, List<String> pkColumnNames) {
        this.id = id;
        this.columnDefs = Collections.unmodifiableList(sortedColumns);
        this.pkColumnNames = pkColumnNames == null ? Collections.emptyList() : Collections.unmodifiableList(pkColumnNames);
        LinkedHashMap<String, Column> defsByLowercaseName = new LinkedHashMap<String, Column>();
        ArrayList<String> columnNames = new ArrayList<String>();
        for (Column def : this.columnDefs) {
            defsByLowercaseName.put(def.name().toLowerCase(), def);
            columnNames.add(def.name());
        }
        this.columnsByLowercaseName = Collections.unmodifiableMap(defsByLowercaseName);
        this.columnNames = Collections.unmodifiableList(columnNames);
    }

    @Override
    public TableId id() {
        return this.id;
    }

    @Override
    public List<String> primaryKeyColumnNames() {
        return this.pkColumnNames;
    }

    @Override
    public List<String> columnNames() {
        return this.columnNames;
    }

    @Override
    public List<Column> columns() {
        return this.columnDefs;
    }

    @Override
    public Column columnWithName(String name) {
        return this.columnsByLowercaseName.get(name.toLowerCase());
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Table) {
            Table that = (Table)obj;
            return this.id().equals(that.id()) && this.columns().equals(that.columns()) && this.primaryKeyColumnNames().equals(that.primaryKeyColumnNames());
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.toString(sb, "");
        return sb.toString();
    }

    protected void toString(StringBuilder sb, String prefix) {
        if (prefix == null) {
            prefix = "";
        }
        sb.append(prefix).append("columns: {").append(System.lineSeparator());
        for (Column defn : this.columnDefs) {
            sb.append(prefix).append("  ").append(defn).append(System.lineSeparator());
        }
        sb.append(prefix).append("}").append(System.lineSeparator());
        sb.append(prefix).append("primary key: ").append(this.primaryKeyColumnNames()).append(System.lineSeparator());
    }

    @Override
    public TableEditor edit() {
        return new TableEditorImpl().tableId(this.id).setColumns(this.columnDefs).setPrimaryKeyNames(this.pkColumnNames);
    }
}

