/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.config;

import io.debezium.annotation.Immutable;
import io.debezium.config.Configuration;
import java.util.Objects;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntSupplier;
import java.util.function.LongSupplier;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.lang.model.SourceVersion;

@Immutable
public final class Field {
    private final String name;
    private final String desc;
    private final Supplier<String> defaultValueGenerator;
    private final Validator validator;

    public static Field create(String name) {
        return new Field(name, null, null, null);
    }

    public static Field create(String name, String description) {
        return new Field(name, description, null, null);
    }

    public static Field create(String name, String description, String defaultValue) {
        return new Field(name, description, () -> defaultValue, null);
    }

    public static Field create(String name, String description, int defaultValue) {
        return new Field(name, description, () -> Integer.toString(defaultValue), null);
    }

    public static Field create(String name, String description, long defaultValue) {
        return new Field(name, description, () -> Long.toString(defaultValue), null);
    }

    public static Field create(String name, String description, boolean defaultValue) {
        return new Field(name, description, () -> Boolean.toString(defaultValue), null);
    }

    public static Field create(String name, String description, Supplier<String> defaultValueGenerator) {
        return new Field(name, description, defaultValueGenerator, null);
    }

    public static Field create(String name, String description, BooleanSupplier defaultValueGenerator) {
        return new Field(name, description, () -> Boolean.toString(defaultValueGenerator.getAsBoolean()), null);
    }

    public static Field create(String name, String description, IntSupplier defaultValueGenerator) {
        return new Field(name, description, () -> Integer.toString(defaultValueGenerator.getAsInt()), null);
    }

    public static Field create(String name, String description, LongSupplier defaultValueGenerator) {
        return new Field(name, description, () -> Long.toString(defaultValueGenerator.getAsLong()), null);
    }

    protected Field(String name, String description, Supplier<String> defaultValueGenerator, Validator validator) {
        Objects.requireNonNull(name, "The field name is required");
        this.name = name;
        this.desc = description;
        this.defaultValueGenerator = defaultValueGenerator != null ? defaultValueGenerator : () -> null;
        this.validator = validator;
        assert (this.name != null);
    }

    public String name() {
        return this.name;
    }

    public String defaultValue() {
        return this.defaultValueGenerator.get();
    }

    public String description() {
        return this.desc;
    }

    public boolean validate(Configuration config, Consumer<String> problems) {
        return this.validator == null ? true : this.validator.validate(config, this, problems) == 0;
    }

    public Field withDescription(String description) {
        return Field.create(this.name(), this.description(), this.defaultValueGenerator);
    }

    public Field withDefault(String defaultValue) {
        return Field.create(this.name(), this.description(), defaultValue);
    }

    public Field withDefault(boolean defaultValue) {
        return Field.create(this.name(), this.description(), defaultValue);
    }

    public Field withDefault(int defaultValue) {
        return Field.create(this.name(), this.description(), defaultValue);
    }

    public Field withDefault(long defaultValue) {
        return Field.create(this.name(), this.description(), defaultValue);
    }

    public Field withDefault(BooleanSupplier defaultValueGenerator) {
        return Field.create(this.name(), this.description(), defaultValueGenerator);
    }

    public Field withDefault(IntSupplier defaultValueGenerator) {
        return Field.create(this.name(), this.description(), defaultValueGenerator);
    }

    public Field withDefault(LongSupplier defaultValueGenerator) {
        return Field.create(this.name(), this.description(), defaultValueGenerator);
    }

    public Field withNoValidation() {
        return new Field(this.name(), this.description(), this.defaultValueGenerator, null);
    }

    public Field withValidation(Validator ... validators) {
        Validator actualValidator = null;
        actualValidator = validators != null && validators.length == 0 && validators[0] != null ? validators[0] : (config, field, problems) -> {
            int result = 0;
            for (Validator validator : validators) {
                if (validator == null) continue;
                result += validator.validate(config, field, problems);
            }
            return result;
        };
        return new Field(this.name(), this.description(), this.defaultValueGenerator, actualValidator);
    }

    public Field withValidation(Function<String, ?> ... conversionCheck) {
        return new Field(this.name(), this.description(), this.defaultValueGenerator, (config, field, problems) -> {
            String value = config.getString(field);
            for (Function check : conversionCheck) {
                if (check == null) continue;
                try {
                    check.apply(value);
                }
                catch (Throwable t) {
                    problems.accept("The '" + field.name() + "' value '" + value + "' is not allowed: " + t.getMessage());
                    return 1;
                }
            }
            return 0;
        });
    }

    public Field withValidation(Predicate<String> ... predicates) {
        return new Field(this.name(), this.description(), this.defaultValueGenerator, (config, field, problems) -> {
            String value = config.getString(field);
            for (Predicate predicate : predicates) {
                if (predicate == null) continue;
                try {
                    if (predicate.test(value)) continue;
                    problems.accept("The " + field.name() + " value '" + value + "' is not valid");
                    return 1;
                }
                catch (Throwable t) {
                    problems.accept("The " + field.name() + " value '" + value + "' is not allowed: " + t.getMessage());
                    return 1;
                }
            }
            return 0;
        });
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Field) {
            Field that = (Field)obj;
            return this.name().equals(that.name());
        }
        return false;
    }

    public String toString() {
        return this.name();
    }

    public static int isClassName(Configuration config, Field field, Consumer<String> problems) {
        String value = config.getString(field);
        if (value == null || SourceVersion.isName(value)) {
            return 0;
        }
        problems.accept("The '" + field.name() + "' field must contain a valid name of a Java class.");
        return 1;
    }

    public static int isRequired(Configuration config, Field field, Consumer<String> problems) {
        String value = config.getString(field);
        if (value != null && value.trim().length() > 0) {
            return 0;
        }
        problems.accept("The '" + field.name() + "' field is required.");
        return 1;
    }

    public static int isBoolean(Configuration config, Field field, Consumer<String> problems) {
        String value = config.getString(field);
        if (value == null || value.trim().equalsIgnoreCase(Boolean.TRUE.toString()) || value.trim().equalsIgnoreCase(Boolean.FALSE.toString())) {
            return 0;
        }
        problems.accept("The '" + field.name() + "' value '" + value + "' is expected to be 'true' or 'false'.");
        return 1;
    }

    public static int isInteger(Configuration config, Field field, Consumer<String> problems) {
        String value = config.getString(field);
        if (value == null) {
            return 0;
        }
        try {
            Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            problems.accept("The '" + field.name() + "' value '" + value + "' is expected to be an integer.");
            return 1;
        }
        return 0;
    }

    public static int isPositiveInteger(Configuration config, Field field, Consumer<String> problems) {
        String value = config.getString(field);
        if (value == null) {
            return 0;
        }
        try {
            if (Integer.parseInt(value) > 0) {
                return 0;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        problems.accept("The '" + field.name() + "' value '" + value + "' is expected to be a positive integer.");
        return 1;
    }

    public static int isNonNegativeInteger(Configuration config, Field field, Consumer<String> problems) {
        String value = config.getString(field);
        if (value == null) {
            return 0;
        }
        try {
            if (Integer.parseInt(value) >= 0) {
                return 0;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        problems.accept("The '" + field.name() + "' value '" + value + "' is expected to be a non-negative integer.");
        return 1;
    }

    public static int isLong(Configuration config, Field field, Consumer<String> problems) {
        String value = config.getString(field);
        if (value == null) {
            return 0;
        }
        try {
            Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            problems.accept("The '" + field.name() + "' value '" + value + "' is expected to be an long value.");
            return 1;
        }
        return 0;
    }

    public static int isPositiveLong(Configuration config, Field field, Consumer<String> problems) {
        String value = config.getString(field);
        if (value == null) {
            return 0;
        }
        try {
            if (Long.parseLong(value) > 0L) {
                return 0;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        problems.accept("The '" + field.name() + "' value '" + value + "' is expected to be a positive long value.");
        return 1;
    }

    public static int isNonNegativeLong(Configuration config, Field field, Consumer<String> problems) {
        String value = config.getString(field);
        if (value == null) {
            return 0;
        }
        try {
            if (Long.parseLong(value) >= 0L) {
                return 0;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        problems.accept("The '" + field.name() + "' value '" + value + "' is expected to be a non-negative long value.");
        return 1;
    }

    public static interface Validator {
        public int validate(Configuration var1, Field var2, Consumer<String> var3);
    }
}

