/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.relational;

import io.debezium.annotation.Immutable;
import io.debezium.relational.Column;
import io.debezium.relational.TableEditor;
import io.debezium.relational.TableEditorImpl;
import io.debezium.relational.TableId;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;

@Immutable
public interface Table {
    public static TableEditor editor() {
        return new TableEditorImpl();
    }

    public TableId id();

    public List<String> primaryKeyColumnNames();

    default public List<Column> primaryKeyColumns() {
        return this.filterColumns(col -> this.isPrimaryKeyColumn(col.name()));
    }

    default public List<Column> nonPrimaryKeyColumns() {
        return this.filterColumns(col -> !this.isPrimaryKeyColumn(col.name()));
    }

    default public List<Column> filterColumns(Predicate<Column> predicate) {
        return this.columns().stream().filter(predicate).collect(Collectors.toList());
    }

    default public List<String> filterColumnNames(Predicate<Column> predicate) {
        return this.columns().stream().filter(predicate).map(Column::name).collect(Collectors.toList());
    }

    public List<String> columnNames();

    public List<Column> columns();

    public Column columnWithName(String var1);

    default public boolean isPrimaryKeyColumn(String columnName) {
        Column column = this.columnWithName(columnName);
        return column == null ? false : this.primaryKeyColumnNames().contains(column.name());
    }

    default public boolean isAutoIncremented(String columnName) {
        Column column = this.columnWithName(columnName);
        return column == null ? false : column.isAutoIncremented();
    }

    default public boolean isGenerated(String columnName) {
        Column column = this.columnWithName(columnName);
        return column == null ? false : column.isGenerated();
    }

    default public boolean isOptional(String columnName) {
        Column column = this.columnWithName(columnName);
        return column == null ? false : column.isOptional();
    }

    public TableEditor edit();
}

