/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.connector.mysql.AbstractReader;
import io.debezium.connector.mysql.Filters;
import io.debezium.connector.mysql.MySqlSchema;
import io.debezium.connector.mysql.MySqlTaskContext;
import io.debezium.connector.mysql.RecordMakers;
import io.debezium.connector.mysql.SourceInfo;
import io.debezium.function.BlockingConsumer;
import io.debezium.function.Predicates;
import io.debezium.jdbc.JdbcConnection;
import io.debezium.relational.Table;
import io.debezium.relational.TableId;
import io.debezium.util.Clock;
import io.debezium.util.Strings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.kafka.connect.source.SourceRecord;

public class SnapshotReader
extends AbstractReader {
    private boolean minimalBlocking = true;
    private RecordRecorder recorder = this::recordRowAsRead;
    private volatile Thread thread;
    private volatile Runnable onSuccessfulCompletion;

    public SnapshotReader(MySqlTaskContext context) {
        super(context);
    }

    public SnapshotReader onSuccessfulCompletion(Runnable onSuccessfulCompletion) {
        this.onSuccessfulCompletion = onSuccessfulCompletion;
        return this;
    }

    public SnapshotReader useMinimalBlocking(boolean minimalBlocking) {
        this.minimalBlocking = minimalBlocking;
        return this;
    }

    public SnapshotReader generateReadEvents() {
        this.recorder = this::recordRowAsRead;
        return this;
    }

    public SnapshotReader generateInsertEvents() {
        this.recorder = this::recordRowAsInsert;
        return this;
    }

    @Override
    protected void doStart() {
        this.thread = new Thread(this::execute, "mysql-snapshot-" + this.context.serverName());
        this.thread.start();
    }

    @Override
    protected void doStop() {
        this.thread.interrupt();
    }

    @Override
    protected void doCleanup() {
        this.thread = null;
        this.logger.trace("Completed writing all snapshot records");
        try {
            if (this.onSuccessfulCompletion != null) {
                this.onSuccessfulCompletion.run();
            }
        }
        catch (Throwable e) {
            this.logger.error("Error calling completion function after completing snapshot");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute() {
        this.context.configureLoggingContext("snapshot");
        this.logger.info("Starting snapshot");
        AtomicReference<String> sql = new AtomicReference<String>();
        JdbcConnection mysql = this.context.jdbc();
        MySqlSchema schema = this.context.dbSchema();
        Filters filters = schema.filters();
        SourceInfo source = this.context.source();
        Clock clock = this.context.clock();
        long ts = clock.currentTimeInMillis();
        try {
            this.logger.info("Step 0: disabling autocommit and enabling repeatable read transactions");
            mysql.setAutoCommit(false);
            sql.set("SET TRANSACTION ISOLATION LEVEL REPEATABLE READ");
            mysql.execute(new String[]{(String)sql.get()});
            this.logger.info("Step 1: start transaction with consistent snapshot");
            sql.set("START TRANSACTION WITH CONSISTENT SNAPSHOT");
            mysql.execute(new String[]{(String)sql.get()});
            long lockAcquired = clock.currentTimeInMillis();
            this.logger.info("Step 2: flush and obtain global read lock (preventing writes to database)");
            sql.set("FLUSH TABLES WITH READ LOCK");
            mysql.execute(new String[]{(String)sql.get()});
            this.logger.info("Step 3: read binlog position of MySQL master");
            sql.set("SHOW MASTER STATUS");
            mysql.query((String)sql.get(), rs -> {
                if (rs.next()) {
                    String binlogFilename = rs.getString(1);
                    long binlogPosition = rs.getLong(2);
                    String gtidSet = rs.getString(5);
                    source.setBinlogStartPoint(binlogFilename, binlogPosition);
                    source.setGtidSet(gtidSet);
                    source.startSnapshot();
                }
            });
            this.logger.info("Step 4: read list of available databases");
            ArrayList databaseNames = new ArrayList();
            sql.set("SHOW DATABASES");
            mysql.query((String)sql.get(), rs -> {
                while (rs.next()) {
                    databaseNames.add(rs.getString(1));
                }
            });
            this.logger.info("Step 5: read list of available tables in each database");
            ArrayList tableIds = new ArrayList();
            HashMap tableIdsByDbName = new HashMap();
            for (String dbName : databaseNames) {
                sql.set("SHOW TABLES IN " + dbName);
                mysql.query((String)sql.get(), rs -> {
                    while (rs.next()) {
                        TableId id = new TableId(dbName, null, rs.getString(1));
                        if (!filters.tableFilter().test(id)) continue;
                        tableIds.add(id);
                        tableIdsByDbName.computeIfAbsent(dbName, k -> new ArrayList()).add(id);
                    }
                });
            }
            this.logger.info("Step 6: generating DROP and CREATE statements to reflect current database schemas");
            ArrayList<String> ddlStatements = new ArrayList<String>();
            HashSet allTableIds = new HashSet(schema.tables().tableIds());
            allTableIds.addAll(tableIds);
            allTableIds.forEach(tableId -> ddlStatements.add("DROP TABLE IF EXISTS " + tableId));
            schema.tables().tableIds().stream().map(TableId::catalog).filter(Predicates.not(databaseNames::contains)).forEach(missingDbName -> ddlStatements.add("DROP DATABASE IF EXISTS " + missingDbName));
            for (Map.Entry entry : tableIdsByDbName.entrySet()) {
                String dbName = (String)entry.getKey();
                ddlStatements.add("DROP DATABASE IF EXISTS " + dbName);
                ddlStatements.add("CREATE DATABASE " + dbName);
                ddlStatements.add("USE " + dbName);
                for (TableId tableId2 : (List)entry.getValue()) {
                    sql.set("SHOW CREATE TABLE " + tableId2);
                    mysql.query((String)sql.get(), rs -> {
                        if (rs.next()) {
                            ddlStatements.add(rs.getString(2));
                        }
                    });
                }
            }
            this.logger.debug("Step 6b: applying DROP and CREATE statements to connector's table model");
            String ddlStatementsStr = String.join((CharSequence)(";" + System.lineSeparator()), ddlStatements);
            schema.applyDdl(source, null, ddlStatementsStr, this::enqueueSchemaChanges);
            this.context.makeRecord().regenerate();
            boolean unlocked = false;
            if (this.minimalBlocking) {
                this.logger.info("Step 7: releasing global read lock to enable MySQL writes");
                sql.set("UNLOCK TABLES");
                mysql.execute(new String[]{(String)sql.get()});
                unlocked = true;
                long lockReleased = clock.currentTimeInMillis();
                this.logger.info("Writes to MySQL prevented for a total of {}", (Object)Strings.duration((long)(lockReleased - lockAcquired)));
            }
            this.logger.info("Step 8: scanning contents of {} tables", (Object)tableIds.size());
            long startScan = clock.currentTimeInMillis();
            AtomicBoolean interrupted = new AtomicBoolean(false);
            int counter = 0;
            Iterator tableIdIter = tableIds.iterator();
            while (tableIdIter.hasNext()) {
                TableId tableId3 = (TableId)tableIdIter.next();
                boolean isLastTable = !tableIdIter.hasNext();
                long start = clock.currentTimeInMillis();
                this.logger.debug("Step 8.{}: scanning table '{}'; {} tables remain", new Object[]{++counter, tableId3, tableIds.size() - counter});
                sql.set("SELECT * FROM " + tableId3);
                mysql.query((String)sql.get(), rs -> {
                    block7: {
                        RecordMakers.RecordsForTable recordMaker = this.context.makeRecord().forTable(tableId3, null, (BlockingConsumer<SourceRecord>)((BlockingConsumer)x$0 -> super.enqueueRecord((SourceRecord)x$0)));
                        if (recordMaker != null) {
                            boolean completed = false;
                            try {
                                Table table = schema.tableFor(tableId3);
                                int numColumns = table.columns().size();
                                Object[] row = new Object[numColumns];
                                while (rs.next()) {
                                    int i = 0;
                                    int j = 1;
                                    while (i != numColumns) {
                                        row[i] = rs.getObject(j);
                                        ++i;
                                        ++j;
                                    }
                                    if (isLastTable && rs.isLast()) {
                                        source.markLastSnapshot();
                                    }
                                    this.recorder.recordRow(recordMaker, row, ts);
                                }
                                if (isLastTable) {
                                    completed = true;
                                }
                            }
                            catch (InterruptedException e) {
                                Thread.interrupted();
                                if (completed) break block7;
                                this.logger.info("Stopping the snapshot after thread interruption");
                                interrupted.set(true);
                            }
                        }
                    }
                });
                if (interrupted.get()) break;
                long stop = clock.currentTimeInMillis();
                this.logger.info("Step 8.{}: scanned table '{}' in {}", new Object[]{counter, tableId3, Strings.duration((long)(stop - start))});
            }
            long stop = clock.currentTimeInMillis();
            this.logger.info("Step 8: scanned contents of {} tables in {}", (Object)tableIds.size(), (Object)Strings.duration((long)(stop - startScan)));
            if (!unlocked) {
                this.logger.info("Step 9: releasing global read lock to enable MySQL writes");
                sql.set("UNLOCK TABLES");
                mysql.execute(new String[]{(String)sql.get()});
                unlocked = true;
                long lockReleased = clock.currentTimeInMillis();
                this.logger.info("Writes to MySQL prevented for a total of {}", (Object)Strings.duration((long)(lockReleased - lockAcquired)));
            }
            if (interrupted.get()) {
                this.logger.info("Step 10: rolling back transaction after request to stop");
                sql.set("ROLLBACK");
                mysql.execute(new String[]{(String)sql.get()});
                return;
            }
            this.logger.info("Step 10: committing transaction");
            sql.set("COMMIT");
            mysql.execute(new String[]{(String)sql.get()});
            try {
                source.completeSnapshot();
            }
            finally {
                super.completeSuccessfully();
                stop = clock.currentTimeInMillis();
                this.logger.info("Completed snapshot in {}", (Object)Strings.duration((long)(stop - ts)));
            }
        }
        catch (Throwable e) {
            this.failed(e, "Aborting snapshot after running '" + (String)sql.get() + "': " + e.getMessage());
        }
    }

    protected void enqueueSchemaChanges(String dbName, String ddlStatements) {
        if (this.context.includeSchemaChangeRecords() && this.context.makeRecord().schemaChanges(dbName, ddlStatements, (BlockingConsumer<SourceRecord>)((BlockingConsumer)x$0 -> super.enqueueRecord((SourceRecord)x$0))) > 0) {
            this.logger.debug("Recorded DDL statements for database '{}': {}", (Object)dbName, (Object)ddlStatements);
        }
    }

    protected void recordRowAsRead(RecordMakers.RecordsForTable recordMaker, Object[] row, long ts) throws InterruptedException {
        recordMaker.read(row, ts);
    }

    protected void recordRowAsInsert(RecordMakers.RecordsForTable recordMaker, Object[] row, long ts) throws InterruptedException {
        recordMaker.create(row, ts);
    }

    protected static interface RecordRecorder {
        public void recordRow(RecordMakers.RecordsForTable var1, Object[] var2, long var3) throws InterruptedException;
    }
}

