/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.connector.mysql.MySqlSchema;
import io.debezium.connector.mysql.SourceInfo;
import io.debezium.connector.mysql.TopicSelector;
import io.debezium.data.Envelope;
import io.debezium.function.BlockingConsumer;
import io.debezium.relational.TableId;
import io.debezium.relational.TableSchema;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecordMakers {
    protected static final Schema SCHEMA_CHANGE_RECORD_KEY_SCHEMA = SchemaBuilder.struct().name("io.debezium.connector.mysql.SchemaChangeKey").field("databaseName", Schema.STRING_SCHEMA).build();
    protected static final Schema SCHEMA_CHANGE_RECORD_VALUE_SCHEMA = SchemaBuilder.struct().name("io.debezium.connector.mysql.SchemaChangeValue").field("source", SourceInfo.SCHEMA).field("databaseName", Schema.STRING_SCHEMA).field("ddl", Schema.STRING_SCHEMA).build();
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final MySqlSchema schema;
    private final SourceInfo source;
    private final TopicSelector topicSelector;
    private final Map<Long, Converter> convertersByTableNumber = new HashMap<Long, Converter>();
    private final Map<TableId, Long> tableNumbersByTableId = new HashMap<TableId, Long>();

    public RecordMakers(MySqlSchema schema, SourceInfo source, TopicSelector topicSelector) {
        this.schema = schema;
        this.source = source;
        this.topicSelector = topicSelector;
    }

    public RecordsForTable forTable(TableId tableId, BitSet includedColumns, BlockingConsumer<SourceRecord> consumer) {
        Long tableNumber = this.tableNumbersByTableId.get(tableId);
        return tableNumber != null ? this.forTable(tableNumber, includedColumns, consumer) : null;
    }

    public RecordsForTable forTable(long tableNumber, BitSet includedColumns, BlockingConsumer<SourceRecord> consumer) {
        Converter converter = this.convertersByTableNumber.get(tableNumber);
        if (converter == null) {
            return null;
        }
        return new RecordsForTable(converter, includedColumns, consumer);
    }

    public int schemaChanges(String databaseName, String ddlStatements, BlockingConsumer<SourceRecord> consumer) {
        String topicName = this.topicSelector.getPrimaryTopic();
        Integer partition = 0;
        Struct key = this.schemaChangeRecordKey(databaseName);
        Struct value = this.schemaChangeRecordValue(databaseName, ddlStatements);
        SourceRecord record = new SourceRecord(this.source.partition(), this.source.offset(), topicName, partition, SCHEMA_CHANGE_RECORD_KEY_SCHEMA, (Object)key, SCHEMA_CHANGE_RECORD_VALUE_SCHEMA, (Object)value);
        try {
            consumer.accept((Object)record);
            return 1;
        }
        catch (InterruptedException e) {
            return 0;
        }
    }

    public void clear() {
        this.logger.debug("Clearing table converters");
        this.convertersByTableNumber.clear();
        this.tableNumbersByTableId.clear();
    }

    public void regenerate() {
        this.clear();
        AtomicInteger nextTableNumber = new AtomicInteger(0);
        Set tableIds = this.schema.tables().tableIds();
        this.logger.debug("Regenerating converters for {} tables", (Object)tableIds.size());
        tableIds.forEach(id -> this.assign(nextTableNumber.incrementAndGet(), (TableId)id));
    }

    public boolean assign(long tableNumber, final TableId id) {
        Long existingTableNumber = this.tableNumbersByTableId.get(id);
        if (existingTableNumber != null && existingTableNumber == tableNumber && this.convertersByTableNumber.containsKey(tableNumber)) {
            return true;
        }
        final TableSchema tableSchema = this.schema.schemaFor(id);
        if (tableSchema == null) {
            return false;
        }
        final String topicName = this.topicSelector.getTopic(id);
        final Envelope envelope = Envelope.defineSchema().withName(topicName + ".Envelope").withRecord(this.schema.schemaFor(id).valueSchema()).withSource(SourceInfo.SCHEMA).build();
        final Integer partitionNum = null;
        Converter converter = new Converter(){

            @Override
            public int read(SourceInfo source, Object[] row, int rowNumber, int numberOfRows, BitSet includedColumns, long ts, BlockingConsumer<SourceRecord> consumer) throws InterruptedException {
                Object key = tableSchema.keyFromColumnData(row);
                Struct value = tableSchema.valueFromColumnData(row);
                if (value != null || key != null) {
                    Schema keySchema = tableSchema.keySchema();
                    Map<String, String> partition = source.partition();
                    Map<String, ?> offset = source.offsetForRow(rowNumber, numberOfRows);
                    Struct origin = source.struct();
                    SourceRecord record = new SourceRecord(partition, offset, topicName, partitionNum, keySchema, key, envelope.schema(), (Object)envelope.read(value, origin, Long.valueOf(ts)));
                    consumer.accept((Object)record);
                    return 1;
                }
                return 0;
            }

            @Override
            public int insert(SourceInfo source, Object[] row, int rowNumber, int numberOfRows, BitSet includedColumns, long ts, BlockingConsumer<SourceRecord> consumer) throws InterruptedException {
                Object key = tableSchema.keyFromColumnData(row);
                Struct value = tableSchema.valueFromColumnData(row);
                if (value != null || key != null) {
                    Schema keySchema = tableSchema.keySchema();
                    Map<String, String> partition = source.partition();
                    Map<String, ?> offset = source.offsetForRow(rowNumber, numberOfRows);
                    Struct origin = source.struct();
                    SourceRecord record = new SourceRecord(partition, offset, topicName, partitionNum, keySchema, key, envelope.schema(), (Object)envelope.create(value, origin, Long.valueOf(ts)));
                    consumer.accept((Object)record);
                    return 1;
                }
                return 0;
            }

            @Override
            public int update(SourceInfo source, Object[] before, Object[] after, int rowNumber, int numberOfRows, BitSet includedColumns, long ts, BlockingConsumer<SourceRecord> consumer) throws InterruptedException {
                int count = 0;
                Object key = tableSchema.keyFromColumnData(after);
                Struct valueAfter = tableSchema.valueFromColumnData(after);
                if (valueAfter != null || key != null) {
                    Object oldKey = tableSchema.keyFromColumnData(before);
                    Struct valueBefore = tableSchema.valueFromColumnData(before);
                    Schema keySchema = tableSchema.keySchema();
                    Map<String, String> partition = source.partition();
                    Map<String, ?> offset = source.offsetForRow(rowNumber, numberOfRows);
                    Struct origin = source.struct();
                    if (key != null && !Objects.equals(key, oldKey)) {
                        SourceRecord record = new SourceRecord(partition, offset, topicName, partitionNum, keySchema, key, envelope.schema(), (Object)envelope.create(valueAfter, origin, Long.valueOf(ts)));
                        consumer.accept((Object)record);
                        ++count;
                        record = new SourceRecord(partition, offset, topicName, partitionNum, keySchema, oldKey, envelope.schema(), (Object)envelope.delete(valueBefore, origin, Long.valueOf(ts)));
                        consumer.accept((Object)record);
                        ++count;
                        record = new SourceRecord(partition, offset, topicName, partitionNum, keySchema, oldKey, null, null);
                        consumer.accept((Object)record);
                        ++count;
                    } else {
                        SourceRecord record = new SourceRecord(partition, offset, topicName, partitionNum, keySchema, key, envelope.schema(), (Object)envelope.update(valueBefore, valueAfter, origin, Long.valueOf(ts)));
                        consumer.accept((Object)record);
                        ++count;
                    }
                }
                return count;
            }

            @Override
            public int delete(SourceInfo source, Object[] row, int rowNumber, int numberOfRows, BitSet includedColumns, long ts, BlockingConsumer<SourceRecord> consumer) throws InterruptedException {
                int count = 0;
                Object key = tableSchema.keyFromColumnData(row);
                Struct value = tableSchema.valueFromColumnData(row);
                if (value != null || key != null) {
                    Schema keySchema = tableSchema.keySchema();
                    Map<String, String> partition = source.partition();
                    Map<String, ?> offset = source.offsetForRow(rowNumber, numberOfRows);
                    Struct origin = source.struct();
                    SourceRecord record = new SourceRecord(partition, offset, topicName, partitionNum, keySchema, key, envelope.schema(), (Object)envelope.delete(value, origin, Long.valueOf(ts)));
                    consumer.accept((Object)record);
                    ++count;
                    record = new SourceRecord(partition, offset, topicName, partitionNum, keySchema, key, null, null);
                    consumer.accept((Object)record);
                    ++count;
                }
                return count;
            }

            public String toString() {
                return "RecordMaker.Converter(" + id + ")";
            }
        };
        this.convertersByTableNumber.put(tableNumber, converter);
        Long previousTableNumber = this.tableNumbersByTableId.put(id, tableNumber);
        if (previousTableNumber != null) {
            assert (previousTableNumber != tableNumber);
            this.convertersByTableNumber.remove(previousTableNumber);
        }
        return true;
    }

    protected Struct schemaChangeRecordKey(String databaseName) {
        Struct result = new Struct(SCHEMA_CHANGE_RECORD_KEY_SCHEMA);
        result.put("databaseName", (Object)databaseName);
        return result;
    }

    protected Struct schemaChangeRecordValue(String databaseName, String ddlStatements) {
        Struct result = new Struct(SCHEMA_CHANGE_RECORD_VALUE_SCHEMA);
        result.put("source", (Object)this.source.struct());
        result.put("databaseName", (Object)databaseName);
        result.put("ddl", (Object)ddlStatements);
        return result;
    }

    public final class RecordsForTable {
        private final BitSet includedColumns;
        private final Converter converter;
        private final BlockingConsumer<SourceRecord> consumer;

        protected RecordsForTable(Converter converter, BitSet includedColumns, BlockingConsumer<SourceRecord> consumer) {
            this.converter = converter;
            this.includedColumns = includedColumns;
            this.consumer = consumer;
        }

        public int read(Object[] row, long ts) throws InterruptedException {
            return this.read(row, ts, 0, 1);
        }

        public int read(Object[] row, long ts, int rowNumber, int numberOfRows) throws InterruptedException {
            return this.converter.read(RecordMakers.this.source, row, rowNumber, numberOfRows, this.includedColumns, ts, this.consumer);
        }

        public int create(Object[] row, long ts) throws InterruptedException {
            return this.create(row, ts, 0, 1);
        }

        public int create(Object[] row, long ts, int rowNumber, int numberOfRows) throws InterruptedException {
            return this.converter.insert(RecordMakers.this.source, row, rowNumber, numberOfRows, this.includedColumns, ts, this.consumer);
        }

        public int update(Object[] before, Object[] after, long ts) throws InterruptedException {
            return this.update(before, after, ts, 0, 1);
        }

        public int update(Object[] before, Object[] after, long ts, int rowNumber, int numberOfRows) throws InterruptedException {
            return this.converter.update(RecordMakers.this.source, before, after, rowNumber, numberOfRows, this.includedColumns, ts, this.consumer);
        }

        public int delete(Object[] row, long ts) throws InterruptedException {
            return this.delete(row, ts, 0, 1);
        }

        public int delete(Object[] row, long ts, int rowNumber, int numberOfRows) throws InterruptedException {
            return this.converter.delete(RecordMakers.this.source, row, rowNumber, numberOfRows, this.includedColumns, ts, this.consumer);
        }
    }

    protected static interface Converter {
        public int read(SourceInfo var1, Object[] var2, int var3, int var4, BitSet var5, long var6, BlockingConsumer<SourceRecord> var8) throws InterruptedException;

        public int insert(SourceInfo var1, Object[] var2, int var3, int var4, BitSet var5, long var6, BlockingConsumer<SourceRecord> var8) throws InterruptedException;

        public int update(SourceInfo var1, Object[] var2, Object[] var3, int var4, int var5, BitSet var6, long var7, BlockingConsumer<SourceRecord> var9) throws InterruptedException;

        public int delete(SourceInfo var1, Object[] var2, int var3, int var4, BitSet var5, long var6, BlockingConsumer<SourceRecord> var8) throws InterruptedException;
    }
}

