/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.config.Configuration;
import io.debezium.config.Field;
import io.debezium.connector.mysql.MySqlConnectorConfig;
import io.debezium.connector.mysql.MySqlSchema;
import io.debezium.connector.mysql.RecordMakers;
import io.debezium.connector.mysql.SourceInfo;
import io.debezium.connector.mysql.TopicSelector;
import io.debezium.jdbc.JdbcConnection;
import io.debezium.util.Clock;
import io.debezium.util.LoggingContext;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MySqlTaskContext {
    protected static JdbcConnection.ConnectionFactory FACTORY = JdbcConnection.patternBasedFactory((String)"jdbc:mysql://${hostname}:${port}", (Field[])new Field[0]);
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Configuration config;
    private final SourceInfo source;
    private final MySqlSchema dbSchema;
    private final TopicSelector topicSelector;
    private final RecordMakers recordProcessor;
    private final Clock clock = Clock.system();
    private final JdbcConnection jdbc;

    public MySqlTaskContext(Configuration config) {
        this.config = config;
        this.topicSelector = TopicSelector.defaultSelector(this.serverName());
        this.source = new SourceInfo();
        this.source.setServerName(this.serverName());
        this.dbSchema = new MySqlSchema(config, this.serverName());
        this.dbSchema.start();
        this.recordProcessor = new RecordMakers(this.dbSchema, this.source, this.topicSelector);
        Configuration jdbcConfig = config.subset("database.", true);
        this.jdbc = new JdbcConnection(jdbcConfig, FACTORY);
    }

    public Configuration config() {
        return this.config;
    }

    public JdbcConnection jdbc() {
        return this.jdbc;
    }

    public TopicSelector topicSelector() {
        return this.topicSelector;
    }

    public Logger logger() {
        return this.logger;
    }

    public SourceInfo source() {
        return this.source;
    }

    public MySqlSchema dbSchema() {
        return this.dbSchema;
    }

    public RecordMakers makeRecord() {
        return this.recordProcessor;
    }

    public void loadHistory(SourceInfo startingPoint) {
        this.dbSchema.loadHistory(startingPoint);
        this.recordProcessor.regenerate();
    }

    public Clock clock() {
        return this.clock;
    }

    public long serverId() {
        return this.config.getLong(MySqlConnectorConfig.SERVER_ID);
    }

    public String serverName() {
        String serverName = this.config.getString(MySqlConnectorConfig.SERVER_NAME);
        if (serverName == null) {
            serverName = this.hostname() + ":" + this.port();
        }
        return serverName;
    }

    public String username() {
        return this.config.getString(MySqlConnectorConfig.USER);
    }

    public String password() {
        return this.config.getString(MySqlConnectorConfig.PASSWORD);
    }

    public String hostname() {
        return this.config.getString(MySqlConnectorConfig.HOSTNAME);
    }

    public int port() {
        return this.config.getInteger(MySqlConnectorConfig.PORT);
    }

    public int maxQueueSize() {
        return this.config.getInteger(MySqlConnectorConfig.MAX_QUEUE_SIZE);
    }

    public int maxBatchSize() {
        return this.config.getInteger(MySqlConnectorConfig.MAX_BATCH_SIZE);
    }

    public long timeoutInMilliseconds() {
        return this.config.getLong(MySqlConnectorConfig.CONNECTION_TIMEOUT_MS);
    }

    public long pollIntervalInMillseconds() {
        return this.config.getLong(MySqlConnectorConfig.POLL_INTERVAL_MS);
    }

    public boolean includeSchemaChangeRecords() {
        return this.config.getBoolean(MySqlConnectorConfig.INCLUDE_SCHEMA_CHANGES);
    }

    public boolean isSnapshotAllowedWhenNeeded() {
        return this.snapshotMode() == MySqlConnectorConfig.SnapshotMode.WHEN_NEEDED;
    }

    public boolean isSnapshotNeverAllowed() {
        return this.snapshotMode() == MySqlConnectorConfig.SnapshotMode.NEVER;
    }

    protected MySqlConnectorConfig.SnapshotMode snapshotMode() {
        String value = this.config.getString(MySqlConnectorConfig.SNAPSHOT_MODE);
        return MySqlConnectorConfig.SnapshotMode.parse(value, MySqlConnectorConfig.SNAPSHOT_MODE.defaultValue());
    }

    public boolean useMinimalSnapshotLocking() {
        return this.config.getBoolean(MySqlConnectorConfig.SNAPSHOT_MINIMAL_LOCKING);
    }

    public void start() {
        this.configureLoggingContext("task");
        this.dbSchema().start();
    }

    public void shutdown() {
        try {
            this.logger.debug("Stopping database history");
            this.dbSchema.shutdown();
        }
        catch (Throwable e) {
            this.logger.error("Unexpected error shutting down the database history", e);
        }
        finally {
            try {
                this.jdbc.close();
            }
            catch (SQLException e) {
                this.logger.error("Unexpected error shutting down the database connection", (Throwable)e);
            }
        }
    }

    public LoggingContext.PreviousContext configureLoggingContext(String contextName) {
        return LoggingContext.forConnector((String)"MySQL", (String)this.serverName(), (String)contextName);
    }

    public void temporaryLoggingContext(String contextName, Runnable operation) {
        LoggingContext.temporarilyForConnector((String)"MySQL", (String)this.serverName(), (String)contextName, (Runnable)operation);
    }
}

