/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.annotation.NotThreadSafe;
import io.debezium.relational.Column;
import io.debezium.relational.ColumnEditor;
import io.debezium.relational.Table;
import io.debezium.relational.TableEditor;
import io.debezium.relational.TableId;
import io.debezium.relational.ddl.DataType;
import io.debezium.relational.ddl.DataTypeParser;
import io.debezium.relational.ddl.DdlParser;
import io.debezium.text.ParsingException;
import io.debezium.text.TokenStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;

@NotThreadSafe
public class MySqlDdlParser
extends DdlParser {
    public MySqlDdlParser() {
        super(";");
    }

    public MySqlDdlParser(boolean includeViews) {
        super(";", includeViews);
    }

    protected void initializeDataTypes(DataTypeParser dataTypes) {
        dataTypes.register(-7, "BIT[(L)]");
        dataTypes.register(4, "TINYINT[(L)] [UNSIGNED] [ZEROFILL]");
        dataTypes.register(4, "SMALLINT[(L)] [UNSIGNED] [ZEROFILL]");
        dataTypes.register(4, "MEDIUMINT[(L)] [UNSIGNED] [ZEROFILL]");
        dataTypes.register(4, "INT[(L)] [UNSIGNED|SIGNED] [ZEROFILL]");
        dataTypes.register(4, "INTEGER[(L)] [UNSIGNED] [ZEROFILL]");
        dataTypes.register(-5, "BIGINT[(L)] [UNSIGNED|SIGNED] [ZEROFILL]");
        dataTypes.register(7, "REAL[(M[,D])] [UNSIGNED] [ZEROFILL]");
        dataTypes.register(8, "DOUBLE[(M[,D])] [UNSIGNED] [ZEROFILL]");
        dataTypes.register(6, "FLOAT[(M[,D])] [UNSIGNED] [ZEROFILL]");
        dataTypes.register(3, "DECIMAL[(M[,D])] [UNSIGNED] [ZEROFILL]");
        dataTypes.register(2, "NUMERIC[(M[,D])] [UNSIGNED] [ZEROFILL]");
        dataTypes.register(16, "BOOLEAN");
        dataTypes.register(16, "BOOL");
        dataTypes.register(91, "DATE");
        dataTypes.register(92, "TIME[(L)]");
        dataTypes.register(93, "TIMESTAMP[(L)]");
        dataTypes.register(93, "DATETIME[(L)]");
        dataTypes.register(91, "YEAR[(2|4)]");
        dataTypes.register(2004, "CHAR[(L)] BINARY [CHARACTER SET charset_name] [COLLATE collation_name]");
        dataTypes.register(2004, "VARCHAR(L) BINARY [CHARACTER SET charset_name] [COLLATE collation_name]");
        dataTypes.register(12, "CHAR[(L)] [CHARACTER SET charset_name] [COLLATE collation_name]");
        dataTypes.register(12, "VARCHAR(L) [CHARACTER SET charset_name] [COLLATE collation_name]");
        dataTypes.register(2004, "CHAR[(L)] BINARY [CHARSET charset_name] [COLLATE collation_name]");
        dataTypes.register(2004, "VARCHAR(L) BINARY [CHARSET charset_name] [COLLATE collation_name]");
        dataTypes.register(12, "CHAR[(L)] [CHARSET charset_name] [COLLATE collation_name]");
        dataTypes.register(12, "VARCHAR(L) [CHARSET charset_name] [COLLATE collation_name]");
        dataTypes.register(1, "BINARY[(L)]");
        dataTypes.register(-3, "VARBINARY(L)");
        dataTypes.register(2004, "TINYBLOB");
        dataTypes.register(2004, "BLOB");
        dataTypes.register(2004, "MEDIUMBLOB");
        dataTypes.register(2004, "LONGBLOB");
        dataTypes.register(2004, "TINYTEXT BINARY [CHARACTER SET charset_name] [COLLATE collation_name]");
        dataTypes.register(2004, "TEXT BINARY [CHARACTER SET charset_name] [COLLATE collation_name]");
        dataTypes.register(2004, "MEDIUMTEXT BINARY [CHARACTER SET charset_name] [COLLATE collation_name]");
        dataTypes.register(2004, "LONGTEXT BINARY [CHARACTER SET charset_name] [COLLATE collation_name]");
        dataTypes.register(12, "TINYTEXT [CHARACTER SET charset_name] [COLLATE collation_name]");
        dataTypes.register(12, "TEXT [CHARACTER SET charset_name] [COLLATE collation_name]");
        dataTypes.register(12, "MEDIUMTEXT [CHARACTER SET charset_name] [COLLATE collation_name]");
        dataTypes.register(12, "LONGTEXT [CHARACTER SET charset_name] [COLLATE collation_name]");
        dataTypes.register(1, "ENUM(...) [CHARACTER SET charset_name] [COLLATE collation_name]");
        dataTypes.register(1, "SET(...) [CHARACTER SET charset_name] [COLLATE collation_name]");
        dataTypes.register(2004, "TINYTEXT BINARY [CHARSET charset_name] [COLLATE collation_name]");
        dataTypes.register(2004, "TEXT BINARY [CHARSET charset_name] [COLLATE collation_name]");
        dataTypes.register(2004, "MEDIUMTEXT BINARY [CHARSET charset_name] [COLLATE collation_name]");
        dataTypes.register(2004, "LONGTEXT BINARY [CHARSET charset_name] [COLLATE collation_name]");
        dataTypes.register(12, "TINYTEXT [CHARSET charset_name] [COLLATE collation_name]");
        dataTypes.register(12, "TEXT [CHARSET charset_name] [COLLATE collation_name]");
        dataTypes.register(12, "MEDIUMTEXT [CHARSET charset_name] [COLLATE collation_name]");
        dataTypes.register(12, "LONGTEXT [CHARSET charset_name] [COLLATE collation_name]");
        dataTypes.register(1, "ENUM(...) [CHARSET charset_name] [COLLATE collation_name]");
        dataTypes.register(1, "SET(...) [CHARSET charset_name] [COLLATE collation_name]");
        dataTypes.register(1111, "JSON");
    }

    protected void initializeKeywords(DdlParser.TokenSet keywords) {
    }

    protected void initializeStatementStarts(DdlParser.TokenSet statementStartTokens) {
        statementStartTokens.add("CREATE", new String[]{"ALTER", "DROP", "INSERT", "SET", "GRANT", "REVOKE", "FLUSH", "TRUNCATE", "COMMIT", "USE"});
    }

    protected void parseNextStatement(TokenStream.Marker marker) {
        if (this.tokens.matches(32)) {
            this.parseComment(marker);
        } else if (this.tokens.matches("CREATE")) {
            this.parseCreate(marker);
        } else if (this.tokens.matches("ALTER")) {
            this.parseAlter(marker);
        } else if (this.tokens.matches("DROP")) {
            this.parseDrop(marker);
        } else if (this.tokens.matches("RENAME")) {
            this.parseRename(marker);
        } else if (this.tokens.matches("USE")) {
            this.parseUse(marker);
        } else {
            this.parseUnknownStatement(marker);
        }
    }

    protected void parseCreate(TokenStream.Marker marker) {
        this.tokens.consume("CREATE");
        if (this.tokens.matches("TABLE") || this.tokens.matches("TEMPORARY", new String[]{"TABLE"})) {
            this.parseCreateTable(marker);
        } else if (this.tokens.matches("VIEW")) {
            this.parseCreateView(marker);
        } else if (this.tokens.matchesAnyOf("DATABASE", new String[]{"SCHEMA"})) {
            this.parseCreateDatabase(marker);
        } else if (this.tokens.matchesAnyOf("EVENT", new String[0])) {
            this.parseCreateUnknown(marker);
        } else if (this.tokens.matchesAnyOf("FUNCTION", new String[]{"PROCEDURE"})) {
            this.parseCreateUnknown(marker);
        } else if (this.tokens.matchesAnyOf("UNIQUE", new String[]{"FULLTEXT", "SPATIAL", "INDEX"})) {
            this.parseCreateIndex(marker);
        } else if (this.tokens.matchesAnyOf("SERVER", new String[0])) {
            this.parseCreateUnknown(marker);
        } else if (this.tokens.matchesAnyOf("TABLESPACE", new String[0])) {
            this.parseCreateUnknown(marker);
        } else if (this.tokens.matchesAnyOf("TRIGGER", new String[0])) {
            this.parseCreateUnknown(marker);
        } else {
            this.sequentially(this::parseCreateView, this::parseCreateUnknown);
        }
    }

    protected void parseCreateDatabase(TokenStream.Marker start) {
        this.tokens.consumeAnyOf(new String[]{"DATABASE", "SCHEMA"});
        this.tokens.canConsume("IF", new String[]{"NOT", "EXISTS"});
        String dbName = this.tokens.consume();
        this.consumeRemainingStatement(start);
        this.signalCreateDatabase(dbName, start);
        this.debugParsed(start);
    }

    protected void parseAlterDatabase(TokenStream.Marker start) {
        this.tokens.consumeAnyOf(new String[]{"DATABASE", "SCHEMA"});
        String dbName = this.tokens.consume();
        this.consumeRemainingStatement(start);
        this.signalAlterDatabase(dbName, null, start);
        this.debugParsed(start);
    }

    protected void parseDropDatabase(TokenStream.Marker start) {
        this.tokens.consumeAnyOf(new String[]{"DATABASE", "SCHEMA"});
        this.tokens.canConsume("IF", new String[]{"EXISTS"});
        String dbName = this.tokens.consume();
        this.signalDropDatabase(dbName, start);
        this.debugParsed(start);
    }

    protected void parseCreateTable(TokenStream.Marker start) {
        this.tokens.canConsume("TEMPORARY");
        this.tokens.consume("TABLE");
        boolean onlyIfNotExists = this.tokens.canConsume("IF", new String[]{"NOT", "EXISTS"});
        TableId tableId = this.parseQualifiedTableName(start);
        if (this.tokens.canConsume("LIKE")) {
            TableId originalId = this.parseQualifiedTableName(start);
            Table original = this.databaseTables.forTable(originalId);
            if (original != null) {
                this.databaseTables.overwriteTable(tableId, original.columns(), original.primaryKeyColumnNames());
            }
            this.consumeRemainingStatement(start);
            this.signalCreateTable(tableId, start);
            this.debugParsed(start);
            return;
        }
        if (onlyIfNotExists && this.databaseTables.forTable(tableId) != null) {
            this.consumeRemainingStatement(start);
            this.signalCreateTable(tableId, start);
            this.debugParsed(start);
            return;
        }
        TableEditor table = this.databaseTables.editOrCreateTable(tableId);
        if (this.tokens.matches('(')) {
            this.parseCreateDefinitionList(start, table);
        }
        this.parseTableOptions(start, table);
        if (this.tokens.matches("PARTITION")) {
            this.parsePartitionOptions(start, table);
        }
        if (this.tokens.canConsume("AS") || this.tokens.canConsume("IGNORE", new String[]{"AS"}) || this.tokens.canConsume("REPLACE", new String[]{"AS"})) {
            this.parseAsSelectStatement(start, table);
        }
        this.databaseTables.overwriteTable(table.create());
        this.signalCreateTable(tableId, start);
        this.debugParsed(start);
    }

    protected void parseTableOptions(TokenStream.Marker start, TableEditor table) {
        while (this.parseTableOption(start, table)) {
        }
    }

    protected boolean parseTableOption(TokenStream.Marker start, TableEditor table) {
        if (this.tokens.canConsume("AUTO_INCREMENT")) {
            this.tokens.canConsume('=');
            this.tokens.consume();
            return true;
        }
        if (this.tokens.canConsumeAnyOf("CHECKSUM", new String[]{"ENGINE", "AVG_ROW_LENGTH", "MAX_ROWS", "MIN_ROWS", "ROW_FORMAT", "DELAY_KEY_WRITE", "INSERT_METHOD", "KEY_BLOCK_SIZE", "PACK_KEYS", "STATS_AUTO_RECALC", "STATS_PERSISTENT", "STATS_SAMPLE_PAGES"})) {
            this.tokens.canConsume('=');
            this.tokens.consume();
            return true;
        }
        if (this.tokens.canConsume("DEFAULT", new String[]{"CHARACTER", "SET"}) || this.tokens.canConsume("CHARACTER", new String[]{"SET"}) || this.tokens.canConsume("DEFAULT", new String[]{"CHARSET"}) || this.tokens.canConsume("CHARSET")) {
            this.tokens.canConsume('=');
            this.tokens.consume();
            return true;
        }
        if (this.tokens.canConsume("DEFAULT", new String[]{"COLLATE"}) || this.tokens.canConsume("COLLATE")) {
            this.tokens.canConsume('=');
            this.tokens.consume();
            return true;
        }
        if (this.tokens.canConsumeAnyOf("COMMENT", new String[]{"COMPRESSION", "CONNECTION", "ENCRYPTION", "PASSWORD"})) {
            this.tokens.canConsume('=');
            this.consumeQuotedString();
            return true;
        }
        if (this.tokens.canConsume("DATA", new String[]{"DIRECTORY"}) || this.tokens.canConsume("INDEX", new String[]{"DIRECTORY"})) {
            this.tokens.canConsume('=');
            this.consumeQuotedString();
            return true;
        }
        if (this.tokens.canConsume("TABLESPACE")) {
            this.tokens.consume();
            return true;
        }
        if (this.tokens.canConsumeAnyOf("STORAGE", new String[]{"ENGINE"})) {
            this.tokens.consume();
            return true;
        }
        if (this.tokens.canConsume("UNION")) {
            this.tokens.canConsume('=');
            this.tokens.consume();
            while (this.tokens.canConsume(',')) {
                this.tokens.consume();
            }
            return true;
        }
        return false;
    }

    protected void parsePartitionOptions(TokenStream.Marker start, TableEditor table) {
        this.tokens.consume("PARTITION", new String[]{"BY"});
        if (this.tokens.canConsume("LINEAR", new String[]{"HASH"}) || this.tokens.canConsume("HASH")) {
            this.consumeExpression(start);
        } else if (this.tokens.canConsume("LINEAR", new String[]{"KEY"}) || this.tokens.canConsume("KEY")) {
            if (this.tokens.canConsume("ALGORITHM")) {
                this.tokens.consume("=");
                this.tokens.consumeAnyOf(new String[]{"1", "2"});
            }
            this.parseColumnNameList(start);
        } else if (this.tokens.canConsumeAnyOf("RANGE", new String[]{"LIST"})) {
            if (this.tokens.canConsume("COLUMNS")) {
                this.parseColumnNameList(start);
            } else {
                this.consumeExpression(start);
            }
        }
        if (this.tokens.canConsume("PARTITIONS")) {
            this.tokens.consume();
        }
        if (this.tokens.canConsume("SUBPARTITION", new String[]{"BY"})) {
            if (this.tokens.canConsume("LINEAR", new String[]{"HASH"}) || this.tokens.canConsume("HASH")) {
                this.consumeExpression(start);
            } else if (this.tokens.canConsume("LINEAR", new String[]{"KEY"}) || this.tokens.canConsume("KEY")) {
                if (this.tokens.canConsume("ALGORITHM")) {
                    this.tokens.consume("=");
                    this.tokens.consumeAnyOf(new String[]{"1", "2"});
                }
                this.parseColumnNameList(start);
            }
            if (this.tokens.canConsume("SUBPARTITIONS")) {
                this.tokens.consume();
            }
        }
        if (this.tokens.canConsume('(')) {
            do {
                this.parsePartitionDefinition(start, table);
            } while (this.tokens.canConsume(','));
            this.tokens.consume(')');
        }
    }

    protected void parsePartitionDefinition(TokenStream.Marker start, TableEditor table) {
        this.tokens.consume("PARTITION");
        this.tokens.consume();
        if (this.tokens.canConsume("VALUES")) {
            if (this.tokens.canConsume("LESS", new String[]{"THAN"})) {
                if (!this.tokens.canConsume("MAXVALUE")) {
                    this.consumeExpression(start);
                }
            } else {
                this.tokens.consume("IN");
                this.consumeValueList(start);
            }
        } else if (this.tokens.canConsume("STORAGE", new String[]{"ENGINE"}) || this.tokens.canConsume("ENGINE")) {
            this.tokens.canConsume('=');
            this.tokens.consume();
        } else if (this.tokens.canConsumeAnyOf("COMMENT", new String[0])) {
            this.tokens.canConsume('=');
            this.consumeQuotedString();
        } else if (this.tokens.canConsumeAnyOf("DATA", new String[]{"INDEX"}) && this.tokens.canConsume("DIRECTORY")) {
            this.tokens.canConsume('=');
            this.consumeQuotedString();
        } else if (this.tokens.canConsumeAnyOf("MAX_ROWS", new String[]{"MIN_ROWS", "TABLESPACE"})) {
            this.tokens.canConsume('=');
            this.tokens.consume();
        } else if (this.tokens.canConsume('(')) {
            do {
                this.parseSubpartitionDefinition(start, table);
            } while (this.tokens.canConsume(','));
            this.tokens.consume(')');
        }
    }

    protected void parseSubpartitionDefinition(TokenStream.Marker start, TableEditor table) {
        this.tokens.consume("SUBPARTITION");
        this.tokens.consume();
        if (this.tokens.canConsume("STORAGE", new String[]{"ENGINE"}) || this.tokens.canConsume("ENGINE")) {
            this.tokens.canConsume('=');
            this.tokens.consume();
        } else if (this.tokens.canConsumeAnyOf("COMMENT", new String[0])) {
            this.tokens.canConsume('=');
            this.consumeQuotedString();
        } else if (this.tokens.canConsumeAnyOf("DATA", new String[]{"INDEX"}) && this.tokens.canConsume("DIRECTORY")) {
            this.tokens.canConsume('=');
            this.consumeQuotedString();
        } else if (this.tokens.canConsumeAnyOf("MAX_ROWS", new String[]{"MIN_ROWS", "TABLESPACE"})) {
            this.tokens.canConsume('=');
            this.tokens.consume();
        }
    }

    protected void parseAsSelectStatement(TokenStream.Marker start, TableEditor table) {
        this.tokens.consume("SELECT");
        this.consumeRemainingStatement(start);
    }

    protected void parseCreateDefinitionList(TokenStream.Marker start, TableEditor table) {
        this.tokens.consume('(');
        this.parseCreateDefinition(start, table);
        while (this.tokens.canConsume(',')) {
            this.parseCreateDefinition(start, table);
        }
        this.tokens.consume(')');
    }

    protected void parseCreateDefinition(TokenStream.Marker start, TableEditor table) {
        if (this.tokens.canConsume("CHECK")) {
            this.consumeExpression(start);
        } else if (this.tokens.canConsume("CONSTRAINT", new String[]{"any value", "PRIMARY", "KEY"}) || this.tokens.canConsume("PRIMARY", new String[]{"KEY"})) {
            if (this.tokens.canConsume("USING")) {
                this.parseIndexType(start);
            }
            if (!this.tokens.matches('(')) {
                this.tokens.consume();
            }
            List<String> pkColumnNames = this.parseIndexColumnNames(start);
            table.setPrimaryKeyNames(pkColumnNames);
            this.parseIndexOptions(start);
            pkColumnNames.forEach(name -> {
                Column c = table.columnWithName(name);
                if (c.isOptional()) {
                    table.addColumn(c.edit().optional(false).create());
                }
            });
        } else if (this.tokens.canConsume("CONSTRAINT", new String[]{"any value", "UNIQUE"}) || this.tokens.canConsume("UNIQUE")) {
            this.tokens.canConsumeAnyOf("KEY", new String[]{"INDEX"});
            if (!this.tokens.matches('(')) {
                if (!this.tokens.matches("USING")) {
                    this.tokens.consume();
                }
                if (this.tokens.matches("USING")) {
                    this.parseIndexType(start);
                }
            }
            List<String> uniqueKeyColumnNames = this.parseIndexColumnNames(start);
            if (table.primaryKeyColumnNames().isEmpty()) {
                table.setPrimaryKeyNames(uniqueKeyColumnNames);
            }
            this.parseIndexOptions(start);
        } else if (this.tokens.canConsume("CONSTRAINT", new String[]{"any value", "FOREIGN", "KEY"}) || this.tokens.canConsume("FOREIGN", new String[]{"KEY"})) {
            if (!this.tokens.matches('(')) {
                this.tokens.consume();
            }
            this.parseIndexColumnNames(start);
            if (this.tokens.matches("REFERENCES")) {
                this.parseReferenceDefinition(start);
            }
        } else if (this.tokens.canConsumeAnyOf("INDEX", new String[]{"KEY"})) {
            if (!this.tokens.matches('(')) {
                if (!this.tokens.matches("USING")) {
                    this.tokens.consume();
                }
                if (this.tokens.matches("USING")) {
                    this.parseIndexType(start);
                }
            }
            this.parseIndexColumnNames(start);
            this.parseIndexOptions(start);
        } else if (this.tokens.canConsume("FULLTEXT", new String[]{"SPATIAL"})) {
            this.tokens.canConsumeAnyOf("INDEX", new String[]{"KEY"});
            if (!this.tokens.matches('(')) {
                this.tokens.consume();
            }
            this.parseIndexColumnNames(start);
            this.parseIndexOptions(start);
        } else {
            this.tokens.canConsume("COLUMN");
            String columnName = this.tokens.consume();
            this.parseCreateColumn(start, table, columnName);
            if (this.tokens.canConsume("FIRST")) {
                table.reorderColumn(columnName, null);
            } else if (this.tokens.canConsume("AFTER")) {
                table.reorderColumn(columnName, this.tokens.consume());
            }
        }
    }

    protected Column parseCreateColumn(TokenStream.Marker start, TableEditor table, String columnName) {
        Column existingColumn = table.columnWithName(columnName);
        ColumnEditor column = existingColumn != null ? existingColumn.edit() : Column.editor().name(columnName);
        AtomicBoolean isPrimaryKey = new AtomicBoolean(false);
        this.parseColumnDefinition(start, columnName, this.tokens, table, column, isPrimaryKey);
        Column newColumnDefn = column.create();
        table.addColumns(new Column[]{newColumnDefn});
        if (isPrimaryKey.get()) {
            table.setPrimaryKeyNames(new String[]{newColumnDefn.name()});
        }
        return table.columnWithName(newColumnDefn.name());
    }

    protected void parseColumnDefinition(TokenStream.Marker start, String columnName, TokenStream tokens, TableEditor table, ColumnEditor column, AtomicBoolean isPrimaryKey) {
        String dataTypeName;
        ArrayList errors = new ArrayList();
        TokenStream.Marker dataTypeStart = tokens.mark();
        DataType dataType = this.dataTypeParser.parse(tokens, errors::addAll);
        if (dataType == null && (dataTypeName = this.parseDomainName(start)) != null) {
            dataType = DataType.userDefinedType((String)dataTypeName);
        }
        if (dataType == null) {
            this.parsingFailed(dataTypeStart.position(), errors, "Unable to read the data type");
            return;
        }
        column.jdbcType(dataType.jdbcType());
        column.typeName(dataType.name());
        if (dataType.length() > -1L) {
            column.length((int)dataType.length());
        }
        if (dataType.scale() > -1) {
            column.scale(dataType.scale());
        }
        if (tokens.canConsume("AS") || tokens.canConsume("GENERATED", new String[]{"ALWAYS", "AS"})) {
            this.consumeExpression(start);
            tokens.canConsumeAnyOf("VIRTUAL", new String[]{"STORED"});
            if (tokens.canConsume("UNIQUE")) {
                tokens.canConsume("KEY");
            }
            if (tokens.canConsume("COMMENT")) {
                this.consumeQuotedString();
            }
            tokens.canConsume("NOT", new String[]{"NULL"});
            tokens.canConsume("NULL");
            tokens.canConsume("PRIMARY", new String[]{"KEY"});
            tokens.canConsume("KEY");
        } else {
            while (tokens.matchesAnyOf("NOT", new String[]{"NULL", "DEFAULT", "AUTO_INCREMENT", "UNIQUE", "PRIMARY", "KEY", "COMMENT", "REFERENCES", "COLUMN_FORMAT", "ON"})) {
                if (tokens.canConsume("NOT", new String[]{"NULL"})) {
                    column.optional(false);
                } else if (tokens.canConsume("NULL")) {
                    column.optional(true);
                }
                if (tokens.matches("DEFAULT")) {
                    this.parseDefaultClause(start);
                }
                if (tokens.canConsume("ON")) {
                    if (tokens.canConsumeAnyOf("UPDATE", new String[]{"DELETE"})) {
                        tokens.consume();
                    }
                    column.autoIncremented(true);
                }
                if (tokens.canConsume("AUTO_INCREMENT")) {
                    column.autoIncremented(true);
                    column.generated(true);
                }
                if ((tokens.canConsume("UNIQUE", new String[]{"KEY"}) || tokens.canConsume("UNIQUE")) && table.primaryKeyColumnNames().isEmpty() && !column.isOptional()) {
                    isPrimaryKey.set(true);
                }
                if (tokens.canConsume("PRIMARY", new String[]{"KEY"}) || tokens.canConsume("KEY")) {
                    column.optional(false);
                    isPrimaryKey.set(true);
                }
                if (tokens.canConsume("COMMENT")) {
                    this.consumeQuotedString();
                }
                if (tokens.canConsume("COLUMN_FORMAT")) {
                    tokens.consumeAnyOf(new String[]{"FIXED", "DYNAMIC", "DEFAULT"});
                }
                if (!tokens.matches("REFERENCES")) continue;
                this.parseReferenceDefinition(start);
            }
        }
    }

    protected String parseDomainName(TokenStream.Marker start) {
        return this.parseSchemaQualifiedName(start);
    }

    protected List<String> parseIndexColumnNames(TokenStream.Marker start) {
        ArrayList<String> names = new ArrayList<String>();
        this.tokens.consume('(');
        this.parseIndexColumnName(names::add);
        while (this.tokens.canConsume(',')) {
            this.parseIndexColumnName(names::add);
        }
        this.tokens.consume(')');
        return names;
    }

    private void parseIndexColumnName(Consumer<String> name) {
        name.accept(this.tokens.consume());
        if (this.tokens.canConsume('(')) {
            this.tokens.consume();
            this.tokens.consume(')');
        }
        this.tokens.canConsumeAnyOf("ASC", new String[]{"DESC"});
    }

    protected void parseIndexType(TokenStream.Marker start) {
        this.tokens.consume("USING");
        this.tokens.consumeAnyOf(new String[]{"BTREE", "HASH"});
    }

    protected void parseIndexOptions(TokenStream.Marker start) {
        while (true) {
            if (this.tokens.matches("USING")) {
                this.parseIndexType(start);
                continue;
            }
            if (this.tokens.canConsume("COMMENT")) {
                this.consumeQuotedString();
                continue;
            }
            if (this.tokens.canConsume("KEY_BLOCK_SIZE")) {
                this.tokens.consume("=");
                this.tokens.consume();
                continue;
            }
            if (!this.tokens.canConsume("WITH", new String[]{"PARSER"})) break;
            this.tokens.consume();
        }
    }

    protected void parseReferenceDefinition(TokenStream.Marker start) {
        this.tokens.consume("REFERENCES");
        this.parseSchemaQualifiedName(start);
        if (this.tokens.matches('(')) {
            this.parseColumnNameList(start);
        }
        if (this.tokens.canConsume("MATCH")) {
            this.tokens.consumeAnyOf(new String[]{"FULL", "PARTIAL", "SIMPLE"});
            if (this.tokens.canConsume("ON")) {
                this.tokens.consumeAnyOf(new String[]{"DELETE", "UPDATE"});
                this.parseReferenceOption(start);
            }
        }
    }

    protected void parseReferenceOption(TokenStream.Marker start) {
        if (!(this.tokens.canConsume("RESTRICT") || this.tokens.canConsume("CASCADE") || this.tokens.canConsume("SET", new String[]{"NULL"}))) {
            this.tokens.canConsume("NO", new String[]{"ACTION"});
        }
    }

    protected void parseCreateView(TokenStream.Marker start) {
        this.tokens.canConsume("OR", new String[]{"REPLACE"});
        if (this.tokens.canConsume("ALGORITHM")) {
            this.tokens.consume('=');
            this.tokens.consumeAnyOf(new String[]{"UNDEFINED", "MERGE", "TEMPTABLE"});
        }
        if (this.tokens.canConsume("DEFINER")) {
            this.tokens.consume('=');
            this.tokens.consume();
        }
        if (this.tokens.canConsume("SQL", new String[]{"SECURITY"})) {
            this.tokens.consumeAnyOf(new String[]{"DEFINER", "INVOKER"});
        }
        this.tokens.consume("VIEW");
        TableId tableId = this.parseQualifiedTableName(start);
        if (this.skipViews) {
            this.consumeRemainingStatement(start);
            this.signalCreateView(tableId, start);
            this.debugSkipped(start);
            return;
        }
        TableEditor table = this.databaseTables.editOrCreateTable(tableId);
        if (this.tokens.matches('(')) {
            List<String> columnNames = this.parseColumnNameList(start);
            columnNames.forEach(name -> table.addColumn(Column.editor().name(name).create()));
        }
        this.tokens.canConsume("AS");
        if (this.tokens.canConsume("SELECT")) {
            Map selectedColumnsByAlias = this.parseColumnsInSelectClause(start);
            if (table.columns().isEmpty()) {
                selectedColumnsByAlias.forEach((columnName, fromTableColumn) -> {
                    if (fromTableColumn != null && columnName != null) {
                        table.addColumn(fromTableColumn.edit().name(columnName).create());
                    }
                });
            } else {
                ArrayList changedColumns = new ArrayList();
                table.columns().forEach(column -> {
                    Column selectedColumn = (Column)selectedColumnsByAlias.get(column.name());
                    if (selectedColumn != null) {
                        changedColumns.add(column.edit().jdbcType(selectedColumn.jdbcType()).typeName(selectedColumn.typeName()).length(selectedColumn.length()).scale(selectedColumn.scale()).autoIncremented(selectedColumn.isAutoIncremented()).generated(selectedColumn.isGenerated()).optional(selectedColumn.isOptional()).create());
                    }
                });
                changedColumns.forEach(arg_0 -> ((TableEditor)table).addColumn(arg_0));
            }
            Map fromTables = this.parseSelectFromClause(start);
            if (fromTables.size() == 1) {
                Table fromTable = (Table)fromTables.values().stream().findFirst().get();
                List fromTablePkColumnNames = fromTable.columnNames();
                ArrayList viewPkColumnNames = new ArrayList();
                selectedColumnsByAlias.forEach((viewColumnName, fromTableColumn) -> {
                    if (fromTablePkColumnNames.contains(fromTableColumn)) {
                        viewPkColumnNames.add(viewColumnName);
                    }
                });
                if (viewPkColumnNames.size() == fromTablePkColumnNames.size()) {
                    table.setPrimaryKeyNames(viewPkColumnNames);
                }
            }
        }
        this.consumeRemainingStatement(start);
        this.databaseTables.overwriteTable(table.create());
        this.signalCreateView(tableId, start);
        this.debugParsed(start);
    }

    protected void parseCreateIndex(TokenStream.Marker start) {
        TableEditor table;
        boolean unique = this.tokens.canConsume("UNIQUE");
        this.tokens.canConsumeAnyOf("FULLTEXT", new String[]{"SPATIAL"});
        this.tokens.consume("INDEX");
        String indexName = this.tokens.consume();
        if (this.tokens.matches("USING")) {
            this.parseIndexType(start);
        }
        TableId tableId = null;
        if (this.tokens.canConsume("ON")) {
            tableId = this.parseQualifiedTableName(start);
        }
        if (unique && tableId != null && (table = this.databaseTables.editTable(tableId)) != null && !table.hasPrimaryKey()) {
            List<String> names = this.parseIndexColumnNames(start);
            if (table.columns().stream().allMatch(Column::isRequired)) {
                this.databaseTables.overwriteTable(table.setPrimaryKeyNames(names).create());
            }
        }
        this.consumeRemainingStatement(start);
        this.signalCreateIndex(indexName, tableId, start);
        this.debugParsed(start);
    }

    protected void parseCreateUnknown(TokenStream.Marker start) {
        this.consumeRemainingStatement(start);
    }

    protected void parseAlter(TokenStream.Marker marker) {
        this.tokens.consume("ALTER");
        if (this.tokens.matches("TABLE") || this.tokens.matches("IGNORE", new String[]{"TABLE"})) {
            this.parseAlterTable(marker);
            this.debugParsed(marker);
        } else if (this.tokens.matchesAnyOf("DATABASE", new String[]{"SCHEMA"})) {
            this.parseAlterDatabase(marker);
        } else {
            this.parseAlterUnknown(marker);
        }
    }

    protected void parseAlterTable(TokenStream.Marker start) {
        this.tokens.canConsume("IGNORE");
        this.tokens.consume("TABLE");
        TableId tableId = this.parseQualifiedTableName(start);
        TableEditor table = this.databaseTables.editTable(tableId);
        TableId oldTableId = null;
        if (table != null) {
            Table renamed;
            AtomicReference<Object> newTableName = new AtomicReference<Object>(null);
            if (!this.tokens.matches(this.terminator()) && !this.tokens.matches("PARTITION")) {
                this.parseAlterSpecificationList(start, table, newTableName::set);
            }
            if (this.tokens.matches("PARTITION")) {
                this.parsePartitionOptions(start, table);
            }
            this.databaseTables.overwriteTable(table.create());
            if (newTableName.get() != null && (renamed = this.databaseTables.renameTable(tableId, (TableId)newTableName.get())) != null) {
                oldTableId = tableId;
                tableId = renamed.id();
            }
        } else {
            this.consumeRemainingStatement(start);
        }
        this.signalAlterTable(tableId, oldTableId, start);
    }

    protected void parseAlterSpecificationList(TokenStream.Marker start, TableEditor table, Consumer<TableId> newTableName) {
        this.parseAlterSpecification(start, table, newTableName);
        while (this.tokens.canConsume(',')) {
            this.parseAlterSpecification(start, table, newTableName);
        }
    }

    protected void parseAlterSpecification(TokenStream.Marker start, TableEditor table, Consumer<TableId> newTableName) {
        this.parseTableOptions(start, table);
        if (this.tokens.canConsume("ADD")) {
            if (this.tokens.matches("COLUMN", new String[]{"("}) || this.tokens.matches('(')) {
                this.tokens.canConsume("COLUMN");
                this.parseCreateDefinitionList(start, table);
            } else if (this.tokens.canConsume("PARTITION", new String[]{"("})) {
                this.parsePartitionDefinition(start, table);
                this.tokens.consume(')');
            } else {
                this.parseCreateDefinition(start, table);
            }
        } else if (this.tokens.canConsume("DROP")) {
            if (this.tokens.canConsume("PRIMARY", new String[]{"KEY"})) {
                table.setPrimaryKeyNames(new String[0]);
            } else if (this.tokens.canConsume("FOREIGN", new String[]{"KEY"})) {
                this.tokens.consume();
            } else if (this.tokens.canConsumeAnyOf("INDEX", new String[]{"KEY"})) {
                this.tokens.consume();
            } else if (this.tokens.canConsume("PARTITION")) {
                this.parsePartitionNames(start);
            } else {
                this.tokens.canConsume("COLUMN");
                String columnName = this.tokens.consume();
                table.removeColumn(columnName);
            }
        } else if (this.tokens.canConsume("ALTER")) {
            this.tokens.canConsume("COLUMN");
            this.tokens.consume();
            if (!this.tokens.canConsume("DROP", new String[]{"DEFAULT"})) {
                this.tokens.consume("SET", new String[]{"DEFAULT"});
                this.parseDefaultClause(start);
            }
        } else if (this.tokens.canConsume("CHANGE")) {
            this.tokens.canConsume("COLUMN");
            String oldName = this.tokens.consume();
            String newName = this.tokens.consume();
            this.parseCreateColumn(start, table, oldName);
            table.renameColumn(oldName, newName);
            if (this.tokens.canConsume("FIRST")) {
                table.reorderColumn(newName, null);
            } else if (this.tokens.canConsume("AFTER")) {
                table.reorderColumn(newName, this.tokens.consume());
            }
        } else if (this.tokens.canConsume("MODIFY")) {
            this.tokens.canConsume("COLUMN");
            String columnName = this.tokens.consume();
            this.parseCreateColumn(start, table, columnName);
            if (this.tokens.canConsume("FIRST")) {
                table.reorderColumn(columnName, null);
            } else if (this.tokens.canConsume("AFTER")) {
                table.reorderColumn(columnName, this.tokens.consume());
            }
        } else if (this.tokens.canConsumeAnyOf("ALGORITHM", new String[]{"LOCK"})) {
            this.tokens.canConsume('=');
            this.tokens.consume();
        } else if (!this.tokens.canConsume("DISABLE", new String[]{"KEYS"}) && !this.tokens.canConsume("ENABLE", new String[]{"KEYS"})) {
            if (this.tokens.canConsume("RENAME", new String[]{"INDEX"}) || this.tokens.canConsume("RENAME", new String[]{"KEY"})) {
                this.tokens.consume();
                this.tokens.consume("TO");
                this.tokens.consume();
            } else if (this.tokens.canConsume("RENAME")) {
                this.tokens.canConsumeAnyOf("AS", new String[]{"TO"});
                TableId newTableId = this.parseQualifiedTableName(start);
                newTableName.accept(newTableId);
            } else if (this.tokens.canConsume("ORDER", new String[]{"BY"})) {
                this.consumeCommaSeparatedValueList(start);
            } else if (this.tokens.canConsume("CONVERT", new String[]{"TO", "CHARACTER", "SET"}) || this.tokens.canConsume("CONVERT", new String[]{"TO", "CHARSET"})) {
                this.tokens.consume();
                if (this.tokens.canConsume("COLLATE")) {
                    this.tokens.consume();
                }
            } else if (this.tokens.canConsume("CHARACTER", new String[]{"SET"}) || this.tokens.canConsume("CHARSET") || this.tokens.canConsume("DEFAULT", new String[]{"CHARACTER", "SET"}) || this.tokens.canConsume("DEFAULT", new String[]{"CHARSET"})) {
                this.tokens.canConsume('=');
                this.tokens.consume();
                if (this.tokens.canConsume("COLLATE")) {
                    this.tokens.canConsume('=');
                    this.tokens.consume();
                }
            } else if (!(this.tokens.canConsume("DISCARD", new String[]{"TABLESPACE"}) || this.tokens.canConsume("IMPORT", new String[]{"TABLESPACE"}) || this.tokens.canConsume("FORCE") || this.tokens.canConsume("WITH", new String[]{"VALIDATION"}) || this.tokens.canConsume("WITHOUT", new String[]{"VALIDATION"}))) {
                if (this.tokens.canConsume("DISCARD", new String[]{"PARTITION"}) || this.tokens.canConsume("IMPORT", new String[]{"PARTITION"})) {
                    if (!this.tokens.canConsume("ALL")) {
                        this.tokens.consume();
                    }
                    this.tokens.consume("TABLESPACE");
                } else if (this.tokens.canConsume("COALLESCE", new String[]{"PARTITION"})) {
                    this.tokens.consume();
                } else if (this.tokens.canConsume("REORGANIZE", new String[]{"PARTITION"})) {
                    this.parsePartitionNames(start);
                    this.tokens.consume("INTO", new String[]{"("});
                    this.parsePartitionDefinition(start, table);
                    this.tokens.consume(')');
                } else if (this.tokens.canConsume("EXCHANGE", new String[]{"PARTITION"})) {
                    this.tokens.consume();
                    this.tokens.consume("WITH", new String[]{"TABLE"});
                    this.parseSchemaQualifiedName(start);
                    if (this.tokens.canConsumeAnyOf("WITH", new String[]{"WITHOUT"})) {
                        this.tokens.consume("VALIDATION");
                    }
                } else if (this.tokens.matches("any value", new String[]{"PARTITION"})) {
                    this.tokens.consumeAnyOf(new String[]{"TRUNCATE", "CHECK", "ANALYZE", "OPTIMIZE", "REBUILD", "REPAIR"});
                    this.tokens.consume("PARTITION");
                    if (!this.tokens.canConsume("ALL")) {
                        this.parsePartitionNames(start);
                    }
                } else if (this.tokens.canConsume("REMOVE", new String[]{"PARTITIONING"}) || this.tokens.canConsume("UPGRADE", new String[]{"PARTITIONING"})) {
                    // empty if block
                }
            }
        }
    }

    protected void parseAlterUnknown(TokenStream.Marker start) {
        this.consumeRemainingStatement(start);
        this.debugSkipped(start);
    }

    protected void parseDrop(TokenStream.Marker marker) {
        this.tokens.consume("DROP");
        if (this.tokens.matches("TABLE") || this.tokens.matches("TEMPORARY", new String[]{"TABLE"})) {
            this.parseDropTable(marker);
        } else if (this.tokens.matches("VIEW")) {
            this.parseDropView(marker);
        } else if (this.tokens.matches("INDEX")) {
            this.parseDropIndex(marker);
        } else if (this.tokens.matchesAnyOf("DATABASE", new String[]{"SCHEMA"})) {
            this.parseDropDatabase(marker);
        } else {
            this.parseDropUnknown(marker);
        }
    }

    protected void parseDropTable(TokenStream.Marker start) {
        this.tokens.canConsume("TEMPORARY");
        this.tokens.consume("TABLE");
        this.tokens.canConsume("IF", new String[]{"EXISTS"});
        String statementPrefix = this.statement(start);
        List ids = this.parseQualifiedTableNames(start);
        boolean restrict = this.tokens.canConsume("RESTRICT");
        boolean cascade = this.tokens.canConsume("CASCADE");
        ids.forEach(tableId -> {
            this.databaseTables.removeTable(tableId);
            this.signalDropTable((TableId)tableId, statementPrefix + tableId + (restrict ? " RESTRICT" : (cascade ? " CASCADE" : "")));
        });
        this.debugParsed(start);
    }

    protected void parseDropView(TokenStream.Marker start) {
        if (this.skipViews) {
            this.consumeRemainingStatement(start);
            this.debugSkipped(start);
            return;
        }
        this.tokens.consume("VIEW");
        this.tokens.canConsume("IF", new String[]{"EXISTS"});
        String statementPrefix = this.statement(start);
        List ids = this.parseQualifiedTableNames(start);
        boolean restrict = this.tokens.canConsume("RESTRICT");
        boolean cascade = this.tokens.canConsume("CASCADE");
        ids.forEach(tableId -> {
            this.databaseTables.removeTable(tableId);
            this.signalDropView((TableId)tableId, statementPrefix + tableId + (restrict ? " RESTRICT" : (cascade ? " CASCADE" : "")));
        });
        this.debugParsed(start);
    }

    protected void parseDropIndex(TokenStream.Marker start) {
        this.tokens.consume("INDEX");
        String indexName = this.tokens.consume();
        this.tokens.consume("ON");
        TableId tableId = this.parseQualifiedTableName(start);
        this.consumeRemainingStatement(start);
        this.signalDropIndex(indexName, tableId, start);
        this.debugParsed(start);
    }

    protected void parseDropUnknown(TokenStream.Marker start) {
        this.consumeRemainingStatement(start);
        this.debugSkipped(start);
    }

    protected void parseRename(TokenStream.Marker start) {
        this.tokens.consume("RENAME");
        if (this.tokens.canConsume("TABLE")) {
            this.parseRenameTable(start);
            while (this.tokens.canConsume(',')) {
                this.parseRenameTable(start);
            }
        } else if (this.tokens.canConsumeAnyOf("DATABASE", new String[]{"SCHEMA"})) {
            this.consumeRemainingStatement(start);
        }
    }

    protected void parseRenameTable(TokenStream.Marker start) {
        TableId from = this.parseQualifiedTableName(start);
        this.tokens.consume("TO");
        TableId to = this.parseQualifiedTableName(start);
        this.databaseTables.renameTable(from, to);
        this.signalAlterTable(from, to, "RENAME TABLE " + from + " TO " + to);
    }

    protected void parseUse(TokenStream.Marker marker) {
        this.tokens.consume("USE");
        String dbName = this.tokens.consume();
        this.setCurrentSchema(dbName);
    }

    protected List<String> parseColumnNameList(TokenStream.Marker start) {
        ArrayList<String> names = new ArrayList<String>();
        this.tokens.consume('(');
        names.add(this.tokens.consume());
        while (this.tokens.canConsume(',')) {
            names.add(this.tokens.consume());
        }
        this.tokens.consume(')');
        return names;
    }

    protected void parsePartitionNames(TokenStream.Marker start) {
        this.consumeCommaSeparatedValueList(start);
    }

    protected void consumeCommaSeparatedValueList(TokenStream.Marker start) {
        this.tokens.consume();
        while (this.tokens.canConsume(',')) {
            this.tokens.consume();
        }
    }

    protected void consumeValueList(TokenStream.Marker start) {
        this.tokens.consume('(');
        this.consumeCommaSeparatedValueList(start);
        this.tokens.consume(')');
    }

    protected void consumeExpression(TokenStream.Marker start) {
        this.tokens.consume("(");
        this.tokens.consumeThrough(')', '(');
    }

    protected void sequentially(Consumer<TokenStream.Marker> ... functions) {
        if (functions == null || functions.length == 0) {
            return;
        }
        ArrayList<ParsingException> errors = new ArrayList<ParsingException>();
        TokenStream.Marker marker = this.tokens.mark();
        for (Consumer<TokenStream.Marker> function : functions) {
            try {
                function.accept(marker);
                return;
            }
            catch (ParsingException e) {
                errors.add(e);
                this.tokens.rewind(marker);
            }
        }
        this.parsingFailed(marker.position(), errors, "Unable to parse statement");
    }

    protected void parseDefaultClause(TokenStream.Marker start) {
        this.tokens.consume("DEFAULT");
        if (this.tokens.canConsume("CURRENT_TIMESTAMP")) {
            if (this.tokens.canConsume('(')) {
                this.tokens.consumeInteger();
                this.tokens.consume(')');
            }
            this.tokens.canConsume("ON", new String[]{"UPDATE", "CURRENT_TIMESTAMP"});
            if (this.tokens.canConsume('(')) {
                this.tokens.consumeInteger();
                this.tokens.consume(')');
            }
        } else if (!this.tokens.canConsume("NULL")) {
            this.parseLiteral(start);
        }
    }
}

