/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.annotation.Immutable;
import io.debezium.config.Configuration;
import io.debezium.connector.mysql.MySqlConnectorConfig;
import io.debezium.relational.ColumnId;
import io.debezium.relational.Selectors;
import io.debezium.relational.TableId;
import io.debezium.relational.Tables;
import io.debezium.relational.mapping.ColumnMappers;
import io.debezium.util.Collect;
import java.util.Set;
import java.util.function.Predicate;

@Immutable
public class Filters {
    protected static final Set<String> BUILT_IN_TABLE_NAMES = Collect.unmodifiableSet((Object[])new String[]{"db", "user", "func", "plugin", "tables_priv", "columns_priv", "help_topic", "help_category", "help_relation", "help_keyword", "time_zone_name", "time_zone", "time_zone_transition", "time_zone_transition_type", "time_zone_leap_second", "proc", "procs_priv", "general_log", "event", "ndb_binlog_index", "innodb_table_stats", "innodb_index_stats", "slave_relay_log_info", "slave_master_info", "slave_worker_info", "gtid_executed", "server_cost", "engine_cost"});
    protected static final Set<String> BUILT_IN_DB_NAMES = Collect.unmodifiableSet((Object[])new String[]{"mysql", "performance_schema"});
    private final Predicate<String> dbFilter;
    private final Predicate<TableId> tableFilter;
    private final Predicate<String> isBuiltInDb = dbName -> BUILT_IN_DB_NAMES.contains(dbName.toLowerCase());
    private final Predicate<TableId> isBuiltInTable = id -> this.isBuiltInDb.test(id.catalog()) || BUILT_IN_TABLE_NAMES.contains(id.table().toLowerCase());
    private final Predicate<ColumnId> columnFilter;
    private final ColumnMappers columnMappers;

    public Filters(Configuration config) {
        Predicate dbFilter = Selectors.databaseSelector().includeDatabases(config.getString(MySqlConnectorConfig.DATABASE_WHITELIST)).excludeDatabases(config.getString(MySqlConnectorConfig.DATABASE_BLACKLIST)).build();
        Predicate tableFilter = Selectors.tableSelector().includeDatabases(config.getString(MySqlConnectorConfig.DATABASE_WHITELIST)).excludeDatabases(config.getString(MySqlConnectorConfig.DATABASE_BLACKLIST)).includeTables(config.getString(MySqlConnectorConfig.TABLE_WHITELIST)).excludeTables(config.getString(MySqlConnectorConfig.TABLE_BLACKLIST)).build();
        if (config.getBoolean(MySqlConnectorConfig.TABLES_IGNORE_BUILTIN)) {
            this.tableFilter = tableFilter.and(this.isBuiltInTable.negate());
            this.dbFilter = dbFilter.and(this.isBuiltInDb.negate());
        } else {
            this.tableFilter = tableFilter.or(this.isBuiltInTable);
            this.dbFilter = dbFilter.or(this.isBuiltInDb);
        }
        this.columnFilter = Selectors.excludeColumns((String)config.getString(MySqlConnectorConfig.COLUMN_BLACKLIST));
        ColumnMappers.Builder columnMapperBuilder = ColumnMappers.create();
        config.forEachMatchingFieldNameWithInteger("column\\.truncate\\.to\\.(\\d+)\\.chars", (arg_0, arg_1) -> ((ColumnMappers.Builder)columnMapperBuilder).truncateStrings(arg_0, arg_1));
        config.forEachMatchingFieldNameWithInteger("column\\.mask\\.with\\.(\\d+)\\.chars", (arg_0, arg_1) -> ((ColumnMappers.Builder)columnMapperBuilder).maskStrings(arg_0, arg_1));
        this.columnMappers = columnMapperBuilder.build();
    }

    public Predicate<String> databaseFilter() {
        return this.dbFilter;
    }

    public Predicate<TableId> tableFilter() {
        return this.tableFilter;
    }

    public Tables.TableNameFilter tableNameFilter() {
        return Tables.filterFor(this.tableFilter);
    }

    public Predicate<TableId> builtInTableFilter() {
        return this.isBuiltInTable;
    }

    public Predicate<String> builtInDatabaseFilter() {
        return this.isBuiltInDb;
    }

    public Predicate<ColumnId> columnFilter() {
        return this.columnFilter;
    }

    public ColumnMappers columnMappers() {
        return this.columnMappers;
    }
}

