/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.annotation.Immutable;
import io.debezium.connector.mysql.MySqlValueConverters;
import io.debezium.relational.Column;
import io.debezium.relational.ColumnEditor;
import io.debezium.relational.ValueConverter;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.regex.Pattern;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;

@Immutable
public class MySqlDefaultValueConverter {
    private static final Pattern EPOCH_EQUIVALENT_TIMESTAMP = Pattern.compile("(\\d{4}-\\d{2}-00|\\d{4}-00-\\d{2}|0000-\\d{2}-\\d{2}) (00:00:00(\\.\\d{1,6})?)");
    private static final Pattern EPOCH_EQUIVALENT_DATE = Pattern.compile("\\d{4}-\\d{2}-00|\\d{4}-00-\\d{2}|0000-\\d{2}-\\d{2}");
    private static final String EPOCH_TIMESTAMP = "1970-01-01 00:00:00";
    private static final String EPOCH_DATE = "1970-01-01";
    private final MySqlValueConverters converters;

    public MySqlDefaultValueConverter(MySqlValueConverters converters) {
        this.converters = converters;
    }

    public Object convert(Column column, String value) {
        if (value == null) {
            return value;
        }
        if ("TINYINT".equals(column.typeName()) && ("true".equalsIgnoreCase(value) || "false".equalsIgnoreCase(value))) {
            return this.convertToBoolean(value);
        }
        switch (column.jdbcType()) {
            case 91: {
                return this.convertToLocalDate(column, value);
            }
            case 93: {
                return this.convertToLocalDateTime(column, value);
            }
            case 2014: {
                return this.convertToTimestamp(column, value);
            }
            case 92: {
                return this.convertToDuration(column, value);
            }
            case 16: {
                return this.convertToBoolean(value);
            }
            case -7: {
                return this.convertToBits(column, value);
            }
            case 2: 
            case 3: {
                return this.convertToDecimal(column, value);
            }
            case 6: 
            case 7: 
            case 8: {
                return this.convertToDouble(value);
            }
        }
        return value;
    }

    private Object convertToLocalDate(Column column, String value) {
        boolean zero;
        boolean bl = zero = EPOCH_EQUIVALENT_DATE.matcher(value).matches() || "0".equals(value);
        if (zero && column.isOptional()) {
            return null;
        }
        if (zero) {
            value = EPOCH_DATE;
        }
        return LocalDate.from(DateTimeFormatter.ISO_LOCAL_DATE.parse(value));
    }

    private Object convertToLocalDateTime(Column column, String value) {
        boolean matches;
        boolean bl = matches = EPOCH_EQUIVALENT_TIMESTAMP.matcher(value).matches() || "0".equals(value);
        if (matches) {
            if (column.isOptional()) {
                return null;
            }
            value = EPOCH_TIMESTAMP;
        }
        return LocalDateTime.from(this.timestampFormat(column.length()).parse(value));
    }

    private Object convertToTimestamp(Column column, String value) {
        boolean matches;
        boolean bl = matches = EPOCH_EQUIVALENT_TIMESTAMP.matcher(value).matches() || "0".equals(value) || EPOCH_TIMESTAMP.equals(value);
        if (matches) {
            if (column.isOptional()) {
                return null;
            }
            return Timestamp.from(Instant.EPOCH);
        }
        return Timestamp.valueOf(value).toInstant().atZone(ZoneId.systemDefault());
    }

    private Object convertToDuration(Column column, String value) {
        return MySqlValueConverters.stringToDuration(value);
    }

    private Object convertToDouble(String value) {
        return Double.parseDouble(value);
    }

    private Object convertToDecimal(Column column, String value) {
        return column.scale().isPresent() ? new BigDecimal(value).setScale((int)((Integer)column.scale().get()), RoundingMode.HALF_UP) : new BigDecimal(value);
    }

    private Object convertToBits(Column column, String value) {
        if (column.length() > 1) {
            return this.convertToBits(value);
        }
        return this.convertToBit(value);
    }

    private Object convertToBit(String value) {
        try {
            return Short.parseShort(value) != 0;
        }
        catch (NumberFormatException ignore) {
            return Boolean.parseBoolean(value);
        }
    }

    private Object convertToBits(String value) {
        int nums = value.length() / 8 + (value.length() % 8 == 0 ? 0 : 1);
        byte[] bytes = new byte[nums];
        for (int i = 0; i < nums; ++i) {
            int s = value.length() - 8 < 0 ? 0 : value.length() - 8;
            int e = value.length();
            bytes[nums - i - 1] = (byte)Integer.parseInt(value.substring(s, e), 2);
            value = value.substring(0, s);
        }
        return bytes;
    }

    private Object convertToBoolean(String value) {
        try {
            return Integer.parseInt(value) != 0;
        }
        catch (NumberFormatException ignore) {
            return Boolean.parseBoolean(value);
        }
    }

    private DateTimeFormatter timestampFormat(int length) {
        DateTimeFormatterBuilder dtf = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd HH:mm:ss");
        if (length > 0) {
            dtf.appendFraction(ChronoField.MICRO_OF_SECOND, 0, length, true);
        }
        return dtf.toFormatter();
    }

    public ColumnEditor setColumnDefaultValue(ColumnEditor columnEditor) {
        Column column = columnEditor.create();
        if (this.converters != null && columnEditor.defaultValue() != null) {
            Object defaultValue = columnEditor.defaultValue();
            SchemaBuilder schemaBuilder = this.converters.schemaBuilder(column);
            if (schemaBuilder == null) {
                return columnEditor;
            }
            Schema schema = schemaBuilder.build();
            Field field = new Field(columnEditor.name(), -1, schema);
            ValueConverter valueConverter = this.converters.converter(columnEditor.create(), field);
            if (defaultValue instanceof String) {
                defaultValue = this.convert(column, (String)defaultValue);
            }
            defaultValue = valueConverter.convert(defaultValue);
            columnEditor.defaultValue(defaultValue);
        }
        return columnEditor;
    }
}

