/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.connector.mysql.ReconcilingBinlogReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.connect.source.SourceRecord;
import org.junit.Assert;
import org.junit.Test;

public class ReconcilingBinlogReaderTest {
    private final int SERVER_ID = 0;
    private final String BINLOG_FILENAME = "bin.log1";
    private final int STARTING_BINLOG_POSTION = 20;

    @Test
    public void haltAfterPredicateTrue() {
        List<Map<String, ?>> offsets = this.createOrderedOffsets(2);
        ReconcilingBinlogReader.OffsetLimitPredicate offsetLimitPredicate = new ReconcilingBinlogReader.OffsetLimitPredicate(offsets.get(1), x -> true);
        SourceRecord testSourceRecord = this.createSourceRecordWithOffset(offsets.get(0));
        Assert.assertTrue((boolean)offsetLimitPredicate.accepts(testSourceRecord));
    }

    @Test
    public void haltAfterPredicateFalse() {
        List<Map<String, ?>> offsets = this.createOrderedOffsets(2);
        ReconcilingBinlogReader.OffsetLimitPredicate offsetLimitPredicate = new ReconcilingBinlogReader.OffsetLimitPredicate(offsets.get(0), x -> true);
        SourceRecord testSourceRecord = this.createSourceRecordWithOffset(offsets.get(1));
        Assert.assertFalse((boolean)offsetLimitPredicate.accepts(testSourceRecord));
    }

    private List<Map<String, ?>> createOrderedOffsets(int size) {
        ArrayList orderedDocuments = new ArrayList(size);
        for (int i = 0; i < size; ++i) {
            HashMap<String, Object> offset = new HashMap<String, Object>(3);
            offset.put("server_id", 0);
            offset.put("file", "bin.log1");
            offset.put("pos", 20 + i);
            orderedDocuments.add(offset);
        }
        return orderedDocuments;
    }

    private SourceRecord createSourceRecordWithOffset(Map<String, ?> offset) {
        return new SourceRecord(null, offset, null, null, null);
    }
}

