/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.connector.mysql.MySqlConnector;
import io.debezium.connector.mysql.MySqlConnectorConfig;
import io.debezium.connector.mysql.UniqueDatabase;
import io.debezium.doc.FixFor;
import io.debezium.embedded.AbstractConnectorTest;
import io.debezium.util.Testing;
import java.nio.file.Path;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.source.SourceRecord;
import org.fest.assertions.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class MySqlEnumColumnIT
extends AbstractConnectorTest {
    private static final Path DB_HISTORY_PATH = Testing.Files.createTestingPath((String)"file-db-history-enum-column.txt").toAbsolutePath();
    private final UniqueDatabase DATABASE = new UniqueDatabase("enumcolumnit", "enum_column_test").withDbHistoryPath(DB_HISTORY_PATH);
    private Configuration config;

    @Before
    public void beforeEach() {
        this.stopConnector();
        this.DATABASE.createAndInitialize();
        this.initializeConnectorTestFramework();
        Testing.Files.delete((Path)DB_HISTORY_PATH);
    }

    @After
    public void afterEach() {
        try {
            this.stopConnector();
        }
        finally {
            Testing.Files.delete((Path)DB_HISTORY_PATH);
        }
    }

    @Test
    @FixFor(value={"DBZ-1203"})
    public void shouldAlterEnumColumnCharacterSet() throws Exception {
        this.config = ((Configuration.Builder)((Configuration.Builder)this.DATABASE.defaultConfig().with(MySqlConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)MySqlConnectorConfig.SnapshotMode.NEVER)).with(MySqlConnectorConfig.TABLE_WHITELIST, this.DATABASE.qualifiedTableName("test_stations_10"))).build();
        this.start(MySqlConnector.class, this.config);
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(5);
        Schema schemaBeforeAlter = ((SourceRecord)records.allRecordsInOrder().get(2)).valueSchema().field("after").schema();
        Schema schemaAfterAlter = ((SourceRecord)records.allRecordsInOrder().get(4)).valueSchema().field("after").schema();
        String allowedBeforeAlter = (String)schemaBeforeAlter.field("type").schema().parameters().get("allowed");
        String allowedAfterAlter = (String)schemaAfterAlter.field("type").schema().parameters().get("allowed");
        Assertions.assertThat((String)allowedBeforeAlter).isEqualTo((Object)"station,post_office");
        Assertions.assertThat((String)allowedAfterAlter).isEqualTo((Object)"station,post_office,plane,ahihi_dongok,now,test,a\\,b,c\\,'d,g\\,'h");
        this.stopConnector();
    }
}

