/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb;

import com.mongodb.MongoClientSettings;
import com.mongodb.ReadPreference;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.internal.MongoClientImpl;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.InsertOneOptions;
import io.debezium.DebeziumException;
import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.Configuration;
import io.debezium.connector.mongodb.AbstractMongoIT;
import io.debezium.connector.mongodb.CollectionId;
import io.debezium.connector.mongodb.MongoDbConnectorConfig;
import io.debezium.connector.mongodb.TestHelper;
import io.debezium.util.Testing;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.junit.Before;
import org.junit.Test;

public class ConnectionIT
extends AbstractMongoIT {
    @Before
    public void setUp() {
        TestHelper.cleanDatabase(mongo, "dbA");
        TestHelper.cleanDatabase(mongo, "dbB");
        TestHelper.cleanDatabase(mongo, "dbC");
    }

    @Test
    public void shouldHonorReadPreference() throws InterruptedException {
        this.connection.execute("Check client read preference", mongo -> {
            if (mongo instanceof MongoClientImpl) {
                MongoClientSettings settings = ((MongoClientImpl)mongo).getSettings();
                Assertions.assertThat((Object)settings.getReadPreference()).isEqualTo((Object)ReadPreference.secondaryPreferred());
            }
        });
    }

    @Test(expected=DebeziumException.class)
    public void shouldUseSSL() throws InterruptedException, IOException {
        this.useConfiguration(((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)this.config.edit().with(MongoDbConnectorConfig.POLL_INTERVAL_MS, 10)).with(MongoDbConnectorConfig.COLLECTION_INCLUDE_LIST, "dbit.*")).with(CommonConnectorConfig.TOPIC_PREFIX, "mongo")).with(MongoDbConnectorConfig.SSL_ENABLED, true)).with(MongoDbConnectorConfig.SERVER_SELECTION_TIMEOUT_MS, 2000)).build());
        this.connection.execute("Try SSL connection", mongo -> {
            this.connection.close();
            mongo.getDatabase("dbit").listCollectionNames().first();
        });
    }

    @Test
    public void shouldCreateMovieDatabase() throws InterruptedException {
        MongoDatabase db;
        this.useConfiguration(((Configuration.Builder)((Configuration.Builder)this.config.edit().with(MongoDbConnectorConfig.DATABASE_INCLUDE_LIST, "dbA,dbB")).with(MongoDbConnectorConfig.COLLECTION_EXCLUDE_LIST, "dbB.moviesB")).build());
        Testing.print((Object)("Configuration: " + this.config));
        List<String> dbNames = Arrays.asList("A", "B", "C");
        try (MongoClient client2 = this.connect();){
            Testing.debug((Object)"Getting or creating 'movies' collections");
            for (String dbName : dbNames) {
                db = client2.getDatabase("db" + dbName);
                db.getCollection("movies" + dbName);
            }
            Testing.debug((Object)"Completed getting 'movies' collections");
        }
        client2 = this.connect();
        try {
            Testing.debug((Object)"Adding document to 'movies' collections");
            for (String dbName : dbNames) {
                MongoCollection collection;
                db = client2.getDatabase("db" + dbName);
                MongoCollection movies = collection = db.getCollection("movies" + dbName);
                InsertOneOptions insertOptions = new InsertOneOptions().bypassDocumentValidation(Boolean.valueOf(true));
                movies.insertOne((Object)Document.parse((String)"{ \"name\":\"Starter Wars\"}"), insertOptions);
                Assertions.assertThat((long)collection.countDocuments()).isEqualTo(1L);
            }
            Testing.debug((Object)"Completed adding documents to 'movies' collections");
        }
        finally {
            if (client2 != null) {
                client2.close();
            }
        }
        this.connection.execute("Add document to movies collections", client -> {
            for (String dbName : dbNames) {
                MongoDatabase db = client.getDatabase("db" + dbName);
                MongoCollection collection = db.getCollection("movies" + dbName);
                Bson filter = Filters.eq((String)"name", (Object)"Starter Wars");
                FindIterable movieResults = collection.find(filter);
                MongoCursor cursor = movieResults.iterator();
                try {
                    Assertions.assertThat((String)((Document)cursor.tryNext()).getString((Object)"name")).isEqualTo((Object)"Starter Wars");
                    Assertions.assertThat((Map)((Map)cursor.tryNext())).isNull();
                }
                finally {
                    if (cursor == null) continue;
                    cursor.close();
                }
            }
        });
        Assertions.assertThat((Iterable)this.connection.databaseNames()).containsOnly((Object[])new String[]{"dbA", "dbB"});
        Assertions.assertThat((List)this.connection.collections()).containsOnly((Object[])new CollectionId[]{new CollectionId("dbA", "moviesA")});
    }
}

