/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb;

import com.mongodb.client.ClientSession;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.MongoIterable;
import com.mongodb.client.model.InsertOneOptions;
import io.debezium.connector.mongodb.TestHelper;
import io.debezium.connector.mongodb.junit.MongoDbDatabaseProvider;
import io.debezium.connector.mongodb.junit.MongoDbDatabaseVersionResolver;
import io.debezium.connector.mongodb.junit.MongoDbPlatform;
import io.debezium.data.Envelope;
import io.debezium.embedded.AbstractConnectorTest;
import io.debezium.testing.testcontainers.MongoDbDeployment;
import io.debezium.testing.testcontainers.MongoDbShardedCluster;
import io.debezium.testing.testcontainers.util.DockerUtils;
import io.debezium.util.Testing;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceRecord;
import org.assertj.core.api.Assertions;
import org.bson.Document;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;

public class AbstractShardedMongoConnectorIT
extends AbstractConnectorTest {
    protected static final String DEFAULT_DATABASE = "dbit";
    protected static final String DEFAULT_COLLECTION = "items";
    protected static final String DEFAULT_SHARDING_KEY = "_id";
    protected static MongoDbShardedCluster mongo;

    protected static MongoClient connect() {
        return AbstractShardedMongoConnectorIT.connect((MongoDbDeployment)mongo);
    }

    protected static MongoClient connect(MongoDbDeployment mongo) {
        return MongoClients.create((String)mongo.getConnectionString());
    }

    @BeforeClass
    public static void beforeAll() {
        Assume.assumeTrue((boolean)MongoDbDatabaseVersionResolver.getPlatform().equals((Object)MongoDbPlatform.MONGODB_DOCKER));
        DockerUtils.enableFakeDnsIfRequired();
        mongo = MongoDbDatabaseProvider.mongoDbShardedCluster();
        mongo.start();
    }

    @AfterClass
    public static void afterAll() {
        DockerUtils.disableFakeDns();
        if (mongo != null) {
            mongo.stop();
        }
    }

    @Before
    public void beforeEach() {
        this.stopConnector();
        this.initializeConnectorTestFramework();
        String database = this.shardedDatabase();
        TestHelper.cleanDatabase((MongoDbDeployment)mongo, database);
        mongo.enableSharding(database);
        this.shardedCollections().forEach((collection, key) -> mongo.shardCollection(database, collection, key));
    }

    @After
    public void afterEach() {
        this.stopConnector();
    }

    protected String shardedDatabase() {
        return DEFAULT_DATABASE;
    }

    protected Map<String, String> shardedCollections() {
        return Map.of(DEFAULT_COLLECTION, DEFAULT_SHARDING_KEY);
    }

    protected String shardedCollection() {
        return (String)this.shardedCollections().keySet().stream().findFirst().orElseThrow();
    }

    protected void insertDocuments(String dbName, String collectionName, Document ... documents) {
        if (documents.length == 0) {
            return;
        }
        try (MongoClient client = TestHelper.connect((MongoDbDeployment)mongo);){
            Testing.debug((Object)("Storing in '" + dbName + "." + collectionName + "' document"));
            MongoDatabase db = client.getDatabase(dbName);
            MongoCollection collection = db.getCollection(collectionName);
            for (Document document : documents) {
                InsertOneOptions options = new InsertOneOptions().bypassDocumentValidation(Boolean.valueOf(true));
                Assertions.assertThat((Map)document).isNotNull();
                Assertions.assertThat((int)document.size()).isGreaterThan(0);
                collection.insertOne((Object)document, options);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void insertDocumentsInTx(String dbName, String collectionName, Document ... documents) {
        Assertions.assertThat((boolean)TestHelper.transactionsSupported()).isTrue();
        try (MongoClient client = TestHelper.connect((MongoDbDeployment)mongo);){
            Testing.debug((Object)("Storing documents in '" + dbName + "." + collectionName + "'"));
            MongoDatabase db = client.getDatabase(dbName);
            if (!AbstractShardedMongoConnectorIT.collectionExists(db, collectionName)) {
                db.createCollection(collectionName);
            }
            MongoCollection collection = db.getCollection(collectionName);
            try (ClientSession session = client.startSession();){
                session.startTransaction();
                InsertOneOptions insertOptions = new InsertOneOptions().bypassDocumentValidation(Boolean.valueOf(true));
                for (Document document : documents) {
                    Assertions.assertThat((Map)document).isNotNull();
                    Assertions.assertThat((int)document.size()).isGreaterThan(0);
                    collection.insertOne(session, (Object)document, insertOptions);
                }
                session.commitTransaction();
            }
        }
    }

    private static boolean collectionExists(MongoDatabase database, String collectionName) {
        MongoIterable collections = database.listCollectionNames();
        MongoCursor cursor = collections.cursor();
        while (cursor.hasNext()) {
            if (!collectionName.equalsIgnoreCase((String)cursor.next())) continue;
            return true;
        }
        return false;
    }

    protected void verifyNotFromInitialSnapshot(SourceRecord record) {
        Assertions.assertThat((boolean)record.sourceOffset().containsKey("initsync")).isFalse();
        Struct value = (Struct)record.value();
        Assertions.assertThat((String)value.getStruct("source").getString("snapshot")).isNull();
    }

    protected void verifyFromInitialSnapshot(SourceRecord record, AtomicBoolean foundLast) {
        if (record.sourceOffset().containsKey("initsync")) {
            Assertions.assertThat((boolean)record.sourceOffset().containsKey("initsync")).isTrue();
            Struct value = (Struct)record.value();
            Assertions.assertThat((String)value.getStruct("source").getString("snapshot")).isEqualTo((Object)"true");
        } else {
            Assertions.assertThat((boolean)foundLast.getAndSet(true)).isFalse();
            Struct value = (Struct)record.value();
            Assertions.assertThat((String)value.getStruct("source").getString("snapshot")).isEqualTo((Object)"last");
        }
    }

    protected void verifyOperation(SourceRecord record, Envelope.Operation expected) {
        Struct value = (Struct)record.value();
        Assertions.assertThat((String)value.getString("op")).isEqualTo((Object)expected.code());
    }
}

