/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb;

import io.debezium.annotation.Immutable;
import io.debezium.spi.schema.DataCollectionId;
import io.debezium.util.Collect;
import java.util.Collections;
import java.util.List;

@Immutable
public final class CollectionId
implements DataCollectionId {
    private final String dbName;
    private final String name;

    public static CollectionId parse(String str) {
        int dotPosition = str.indexOf(46);
        if (dotPosition == -1 || dotPosition + 1 == str.length() || dotPosition == 0) {
            return null;
        }
        return new CollectionId(str.substring(0, dotPosition), str.substring(dotPosition + 1));
    }

    public CollectionId(String dbName, String collectionName) {
        this.dbName = dbName;
        this.name = collectionName;
        assert (this.dbName != null);
        assert (this.name != null);
    }

    public String name() {
        return this.name;
    }

    public String dbName() {
        return this.dbName;
    }

    public String identifier() {
        return this.dbName + "." + this.name;
    }

    public List<String> parts() {
        return Collect.arrayListOf((Object)this.dbName, (Object[])new String[]{this.name});
    }

    public List<String> databaseParts() {
        return Collect.arrayListOf((Object)this.dbName, (Object[])new String[]{this.name});
    }

    public List<String> schemaParts() {
        return Collections.emptyList();
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof CollectionId) {
            CollectionId that = (CollectionId)obj;
            return this.dbName.equals(that.dbName) && this.name.equals(that.name);
        }
        return false;
    }

    public String namespace() {
        return this.identifier();
    }

    public String toString() {
        return this.identifier();
    }
}

