/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.operation;

import com.mongodb.MongoNamespace;
import com.mongodb.WriteConcern;
import com.mongodb.internal.operation.AbstractWriteSearchIndexOperation;
import com.mongodb.internal.operation.SearchIndexRequest;
import com.mongodb.internal.operation.WriteConcernHelper;
import org.bson.BsonDocument;
import org.bson.BsonString;
import org.bson.BsonValue;

final class UpdateSearchIndexesOperation
extends AbstractWriteSearchIndexOperation {
    private static final String COMMAND_NAME = "updateSearchIndex";
    private final SearchIndexRequest request;

    UpdateSearchIndexesOperation(MongoNamespace namespace, SearchIndexRequest request, WriteConcern writeConcern) {
        super(namespace, writeConcern);
        this.request = request;
    }

    @Override
    BsonDocument buildCommand() {
        BsonDocument command = new BsonDocument(COMMAND_NAME, (BsonValue)new BsonString(this.getNamespace().getCollectionName())).append("name", (BsonValue)new BsonString(this.request.getIndexName())).append("definition", (BsonValue)this.request.getDefinition());
        WriteConcernHelper.appendWriteConcernToCommand(this.getWriteConcern(), command);
        return command;
    }
}

