/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb.transforms;

import io.debezium.DebeziumException;
import io.debezium.connector.mongodb.TestHelper;
import io.debezium.connector.mongodb.transforms.ExtractNewDocumentState;
import io.debezium.connector.mongodb.transforms.MongoDataConverter;
import io.debezium.doc.FixFor;
import java.util.Map;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.assertj.core.api.Assertions;
import org.bson.BsonDocument;
import org.junit.Before;
import org.junit.Test;

public class MongoArrayConverterTest {
    private static final String HETEROGENOUS_ARRAY = TestHelper.lines("{", "    \"_id\": 1,", "    \"a2\": [", "        11,", "        \"abc\"", "    ]", "}");
    private static final String EMPTY_ARRAY = TestHelper.lines("{", "    \"_id\": 1,", "    \"f\": []", "}");
    private static final String HETEROGENOUS_DOCUMENT_IN_ARRAY = TestHelper.lines("{", "    \"_id\": 1,", "    \"a1\": [", "        {", "            \"a\": 1", "        },", "        {", "            \"a\": \"c\"", "        }", "    ],", "}");
    private static final String HOMOGENOUS_ARRAYS = TestHelper.lines("{", "  \"_id\": 1,", "  \"a1\": [", "      {", "          \"a\": 1", "      },", "      {", "          \"b\": \"c\"", "      }", "  ],", "  \"a2\": [", "      \"11\",", "      \"abc\"", "  ],", "  \"empty\": [],", "  \"additionalContacts\": [", "    {", "      \"firstName\": \"John\",", "      \"lastName\": \"Doe\",", "      \"comment\": null", "    },", "    {", "      \"firstName\": \"Jane\",", "      \"lastName\": \"Doe\",", "      \"comment\": \"A comment\"", "    }", "  ]", "}");
    private SchemaBuilder builder;

    @Before
    public void setup() throws Exception {
        this.builder = SchemaBuilder.struct().name("array");
    }

    @Test(expected=DebeziumException.class)
    public void shouldDetectHeterogenousArray() throws Exception {
        MongoDataConverter converter = new MongoDataConverter(ExtractNewDocumentState.ArrayEncoding.ARRAY);
        BsonDocument val = BsonDocument.parse((String)HETEROGENOUS_ARRAY);
        for (Map.Entry entry : val.entrySet()) {
            converter.addFieldSchema(entry, this.builder);
        }
    }

    @Test(expected=DebeziumException.class)
    public void shouldDetectHeterogenousDocumentInArray() throws Exception {
        MongoDataConverter converter = new MongoDataConverter(ExtractNewDocumentState.ArrayEncoding.ARRAY);
        BsonDocument val = BsonDocument.parse((String)HETEROGENOUS_DOCUMENT_IN_ARRAY);
        for (Map.Entry entry : val.entrySet()) {
            converter.addFieldSchema(entry, this.builder);
        }
    }

    @Test
    @FixFor(value={"DBZ-6760"})
    public void shouldCreateSchemaForHomogenousArray() throws Exception {
        MongoDataConverter converter = new MongoDataConverter(ExtractNewDocumentState.ArrayEncoding.ARRAY);
        BsonDocument val = BsonDocument.parse((String)HOMOGENOUS_ARRAYS);
        for (Map.Entry entry : val.entrySet()) {
            converter.addFieldSchema(entry, this.builder);
        }
        Schema finalSchema = this.builder.build();
        Assertions.assertThat((Object)finalSchema).isEqualTo((Object)SchemaBuilder.struct().name("array").field("_id", Schema.OPTIONAL_INT32_SCHEMA).field("a1", SchemaBuilder.array((Schema)SchemaBuilder.struct().name("array.a1").optional().field("a", Schema.OPTIONAL_INT32_SCHEMA).field("b", Schema.OPTIONAL_STRING_SCHEMA).build()).optional().build()).field("a2", SchemaBuilder.array((Schema)Schema.OPTIONAL_STRING_SCHEMA).optional().build()).field("empty", SchemaBuilder.array((Schema)Schema.OPTIONAL_STRING_SCHEMA).optional().build()).field("additionalContacts", SchemaBuilder.array((Schema)SchemaBuilder.struct().name("array.additionalContacts").optional().field("firstName", Schema.OPTIONAL_STRING_SCHEMA).field("lastName", Schema.OPTIONAL_STRING_SCHEMA).field("comment", Schema.OPTIONAL_STRING_SCHEMA).build()).optional().build()).build());
    }

    @Test
    @FixFor(value={"DBZ-6760"})
    public void shouldCreateStructForHomogenousArray() throws Exception {
        MongoDataConverter converter = new MongoDataConverter(ExtractNewDocumentState.ArrayEncoding.ARRAY);
        BsonDocument val = BsonDocument.parse((String)HOMOGENOUS_ARRAYS);
        SchemaBuilder builder = SchemaBuilder.struct().name("array");
        for (Map.Entry entry : val.entrySet()) {
            converter.addFieldSchema(entry, builder);
        }
        Schema finalSchema = builder.build();
        Struct struct = new Struct(finalSchema);
        for (Map.Entry entry : val.entrySet()) {
            converter.convertRecord(entry, finalSchema, struct);
        }
        Assertions.assertThat((String)struct.toString()).isEqualTo((Object)"Struct{_id=1,a1=[Struct{a=1}, Struct{b=c}],a2=[11, abc],empty=[],additionalContacts=[Struct{firstName=John,lastName=Doe}, Struct{firstName=Jane,lastName=Doe,comment=A comment}]}");
    }

    @Test
    public void shouldCreateSchemaForEmptyArrayEncodingArray() throws Exception {
        BsonDocument val = BsonDocument.parse((String)EMPTY_ARRAY);
        MongoDataConverter arrayConverter = new MongoDataConverter(ExtractNewDocumentState.ArrayEncoding.ARRAY);
        for (Map.Entry entry : val.entrySet()) {
            arrayConverter.addFieldSchema(entry, this.builder);
        }
        Schema arraySchema = this.builder.build();
        Assertions.assertThat((Object)arraySchema).isEqualTo((Object)SchemaBuilder.struct().name("array").field("_id", Schema.OPTIONAL_INT32_SCHEMA).field("f", SchemaBuilder.array((Schema)Schema.OPTIONAL_STRING_SCHEMA).optional().build()).build());
    }

    @Test
    public void shouldCreateStructForEmptyArrayEncodingArray() throws Exception {
        BsonDocument val = BsonDocument.parse((String)EMPTY_ARRAY);
        MongoDataConverter arrayConverter = new MongoDataConverter(ExtractNewDocumentState.ArrayEncoding.ARRAY);
        for (Map.Entry entry : val.entrySet()) {
            arrayConverter.addFieldSchema(entry, this.builder);
        }
        Schema arraySchema = this.builder.build();
        Struct struct = new Struct(arraySchema);
        for (Map.Entry entry : val.entrySet()) {
            arrayConverter.convertRecord(entry, arraySchema, struct);
        }
        Assertions.assertThat((String)struct.toString()).isEqualTo((Object)"Struct{_id=1,f=[]}");
    }

    @Test
    public void shouldCreateSchemaForEmptyArrayEncodingDocument() throws Exception {
        BsonDocument val = BsonDocument.parse((String)EMPTY_ARRAY);
        MongoDataConverter documentConverter = new MongoDataConverter(ExtractNewDocumentState.ArrayEncoding.DOCUMENT);
        for (Map.Entry entry : val.entrySet()) {
            documentConverter.addFieldSchema(entry, this.builder);
        }
        Schema documentSchema = this.builder.build();
        Assertions.assertThat((Object)documentSchema).isEqualTo((Object)SchemaBuilder.struct().name("array").field("_id", Schema.OPTIONAL_INT32_SCHEMA).field("f", SchemaBuilder.struct().name("array.f").optional().build()).build());
    }

    @Test
    public void shouldCreateStructForEmptyArrayEncodingDocument() throws Exception {
        BsonDocument val = BsonDocument.parse((String)EMPTY_ARRAY);
        MongoDataConverter documentConverter = new MongoDataConverter(ExtractNewDocumentState.ArrayEncoding.DOCUMENT);
        for (Map.Entry entry : val.entrySet()) {
            documentConverter.addFieldSchema(entry, this.builder);
        }
        Schema documentSchema = this.builder.build();
        Struct struct = new Struct(documentSchema);
        for (Map.Entry entry : val.entrySet()) {
            documentConverter.convertRecord(entry, documentSchema, struct);
        }
        Assertions.assertThat((String)struct.toString()).isEqualTo((Object)"Struct{_id=1,f=Struct{}}");
    }

    @Test
    public void shouldCreateSchemaForHeterogenousArray() throws Exception {
        MongoDataConverter converter = new MongoDataConverter(ExtractNewDocumentState.ArrayEncoding.DOCUMENT);
        BsonDocument val = BsonDocument.parse((String)HETEROGENOUS_ARRAY);
        for (Map.Entry entry : val.entrySet()) {
            converter.addFieldSchema(entry, this.builder);
        }
        Schema finalSchema = this.builder.build();
        Assertions.assertThat((Object)finalSchema).isEqualTo((Object)SchemaBuilder.struct().name("array").field("_id", Schema.OPTIONAL_INT32_SCHEMA).field("a2", SchemaBuilder.struct().name("array.a2").optional().field("_0", Schema.OPTIONAL_INT32_SCHEMA).field("_1", Schema.OPTIONAL_STRING_SCHEMA).build()).build());
    }

    @Test
    public void shouldCreateStructForHeterogenousArray() throws Exception {
        MongoDataConverter converter = new MongoDataConverter(ExtractNewDocumentState.ArrayEncoding.DOCUMENT);
        BsonDocument val = BsonDocument.parse((String)HETEROGENOUS_ARRAY);
        for (Map.Entry entry : val.entrySet()) {
            converter.addFieldSchema(entry, this.builder);
        }
        Schema finalSchema = this.builder.build();
        Struct struct = new Struct(finalSchema);
        for (Map.Entry entry : val.entrySet()) {
            converter.convertRecord(entry, finalSchema, struct);
        }
        Assertions.assertThat((String)struct.toString()).isEqualTo((Object)"Struct{_id=1,a2=Struct{_0=11,_1=abc}}");
    }

    @Test
    public void shouldCreateSchemaForHeterogenousDocumentInArray() throws Exception {
        MongoDataConverter converter = new MongoDataConverter(ExtractNewDocumentState.ArrayEncoding.DOCUMENT);
        BsonDocument val = BsonDocument.parse((String)HETEROGENOUS_DOCUMENT_IN_ARRAY);
        for (Map.Entry entry : val.entrySet()) {
            converter.addFieldSchema(entry, this.builder);
        }
        Schema finalSchema = this.builder.build();
        Assertions.assertThat((Object)finalSchema).isEqualTo((Object)SchemaBuilder.struct().name("array").field("_id", Schema.OPTIONAL_INT32_SCHEMA).field("a1", SchemaBuilder.struct().name("array.a1").optional().field("_0", SchemaBuilder.struct().name("array.a1._0").optional().field("a", Schema.OPTIONAL_INT32_SCHEMA).build()).field("_1", SchemaBuilder.struct().name("array.a1._1").optional().field("a", Schema.OPTIONAL_STRING_SCHEMA).build()).build()).build());
    }

    @Test
    public void shouldCreateStructForHeterogenousDocumentInArray() throws Exception {
        MongoDataConverter converter = new MongoDataConverter(ExtractNewDocumentState.ArrayEncoding.DOCUMENT);
        BsonDocument val = BsonDocument.parse((String)HETEROGENOUS_DOCUMENT_IN_ARRAY);
        for (Map.Entry entry : val.entrySet()) {
            converter.addFieldSchema(entry, this.builder);
        }
        Schema finalSchema = this.builder.build();
        Struct struct = new Struct(finalSchema);
        for (Map.Entry entry : val.entrySet()) {
            converter.convertRecord(entry, finalSchema, struct);
        }
        Assertions.assertThat((String)struct.toString()).isEqualTo((Object)"Struct{_id=1,a1=Struct{_0=Struct{a=1},_1=Struct{a=c}}}");
    }
}

