/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb;

import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.connector.mongodb.MongoDbConnector;
import io.debezium.connector.mongodb.MongoDbConnectorConfig;
import io.debezium.connector.mongodb.MongoDbSchema;
import io.debezium.connector.mongodb.TestHelper;
import io.debezium.connector.mongodb.junit.MongoDbDatabaseProvider;
import io.debezium.connector.mongodb.junit.MongoDbDatabaseVersionResolver;
import io.debezium.connector.mongodb.junit.MongoDbPlatform;
import io.debezium.doc.FixFor;
import io.debezium.embedded.AbstractConnectorTest;
import io.debezium.junit.logging.LogInterceptor;
import io.debezium.testing.testcontainers.MongoDbDeployment;
import io.debezium.testing.testcontainers.MongoDbReplicaSet;
import io.debezium.testing.testcontainers.util.DockerUtils;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.assertj.core.api.AssertionsForClassTypes;
import org.bson.Document;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FiltersRestrictedIT
extends AbstractConnectorTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(FiltersRestrictedIT.class);
    public static final String AUTH_DATABASE = "admin";
    public static final String TEST_DATABASE1 = "dbit1";
    public static final String TEST_DATABASE2 = "dbit2";
    public static final String TEST_COLLECTION1 = "collection1";
    public static final String TEST_COLLECTION2 = "collection2";
    public static final String TEST_USER = "testUser";
    public static final String TEST_PWD = "testPassword";
    public static final String TOPIC_PREFIX = "mongo";
    private static final int INIT_DOCUMENT_COUNT = 10;
    protected static MongoDbReplicaSet mongo;

    @BeforeClass
    public static void beforeAll() {
        Assume.assumeTrue((boolean)MongoDbDatabaseVersionResolver.getPlatform().equals((Object)MongoDbPlatform.MONGODB_DOCKER));
        DockerUtils.enableFakeDnsIfRequired();
        mongo = MongoDbDatabaseProvider.dockerAuthReplicaSet();
        LOGGER.info("Starting {}...", (Object)mongo);
        mongo.start();
        LOGGER.info("Setting up users");
        mongo.createUser(TEST_USER, TEST_PWD, AUTH_DATABASE, new String[]{"read:dbit1"});
    }

    @AfterClass
    public static void afterAll() {
        DockerUtils.disableFakeDns();
        if (mongo != null) {
            LOGGER.info("Stopping {}...", (Object)mongo);
            mongo.stop();
        }
    }

    @Before
    public void beforeEach() {
        this.stopConnector();
        this.initializeConnectorTestFramework();
        TestHelper.cleanDatabase((MongoDbDeployment)mongo, TEST_DATABASE1);
        TestHelper.cleanDatabase((MongoDbDeployment)mongo, TEST_DATABASE2);
    }

    @After
    public void afterEach() {
        this.stopConnector();
    }

    protected static MongoClient connect() {
        return MongoClients.create((String)mongo.getConnectionString());
    }

    protected static void populateCollection(String dbName, String colName, int count) {
        FiltersRestrictedIT.populateCollection(dbName, colName, 0, count);
    }

    protected static void populateCollection(String dbName, String colName, int startId, int count) {
        try (MongoClient client = FiltersRestrictedIT.connect();){
            MongoDatabase db = client.getDatabase(dbName);
            MongoCollection collection = db.getCollection(colName);
            List items = IntStream.range(startId, startId + count).mapToObj(i -> new Document("_id", (Object)i).append("name", (Object)("name_" + i))).collect(Collectors.toList());
            collection.insertMany(items);
        }
    }

    protected Configuration connectorConfiguration() {
        String connectionString = mongo.getAuthConnectionString(TEST_USER, TEST_PWD, AUTH_DATABASE);
        return ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)TestHelper.getConfiguration(connectionString).edit().with(MongoDbConnectorConfig.POLL_INTERVAL_MS, 10)).with(CommonConnectorConfig.TOPIC_PREFIX, TOPIC_PREFIX)).with(MongoDbConnectorConfig.CAPTURE_SCOPE, (EnumeratedValue)MongoDbConnectorConfig.CaptureScope.DATABASE)).with(MongoDbConnectorConfig.CAPTURE_TARGET, TEST_DATABASE1)).with(CommonConnectorConfig.MAX_RETRIES_ON_ERROR, 2)).build();
    }

    @Test
    @FixFor(value={"DBZ-7485"})
    public void shouldNotConsumeEventsFromRestrictedDatabaseCollection() throws InterruptedException {
        LogInterceptor logInterceptor = new LogInterceptor(MongoDbSchema.class);
        String topic1 = String.format("%s.%s.%s", TOPIC_PREFIX, TEST_DATABASE1, TEST_COLLECTION1);
        String topic2 = String.format("%s.%s.%s", TOPIC_PREFIX, TEST_DATABASE2, TEST_COLLECTION1);
        FiltersRestrictedIT.populateCollection(TEST_DATABASE1, TEST_COLLECTION1, 10);
        FiltersRestrictedIT.populateCollection(TEST_DATABASE2, TEST_COLLECTION1, 10);
        Configuration config = ((Configuration.Builder)((Configuration.Builder)this.connectorConfiguration().edit().with(MongoDbConnectorConfig.DATABASE_INCLUDE_LIST, TEST_DATABASE1)).with(MongoDbConnectorConfig.COLLECTION_INCLUDE_LIST, "dbit2.collection1")).build();
        this.start(MongoDbConnector.class, config);
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(20);
        AssertionsForClassTypes.assertThat((Object)records.recordsForTopic(topic1)).isNull();
        AssertionsForClassTypes.assertThat((Object)records.recordsForTopic(topic2)).isNull();
        logInterceptor.containsWarnMessage("After applying the include/exclude list filters, no changes will be captured. Please check your configuration!");
    }

    @Test
    @FixFor(value={"DBZ-7485"})
    public void shouldConsumeEventsOnlyOnCollectionLevelNotDatabaseLevel() throws InterruptedException {
        String topic1 = String.format("%s.%s.%s", TOPIC_PREFIX, TEST_DATABASE1, TEST_COLLECTION1);
        String topic2 = String.format("%s.%s.%s", TOPIC_PREFIX, TEST_DATABASE1, TEST_COLLECTION2);
        FiltersRestrictedIT.populateCollection(TEST_DATABASE1, TEST_COLLECTION1, 10);
        FiltersRestrictedIT.populateCollection(TEST_DATABASE1, TEST_COLLECTION2, 10);
        Configuration config = ((Configuration.Builder)((Configuration.Builder)this.connectorConfiguration().edit().with(MongoDbConnectorConfig.DATABASE_INCLUDE_LIST, TEST_DATABASE1)).with(MongoDbConnectorConfig.COLLECTION_INCLUDE_LIST, "dbit1.collection1")).build();
        this.start(MongoDbConnector.class, config);
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(20);
        AssertionsForClassTypes.assertThat((int)records.recordsForTopic(topic1).size()).isEqualTo(10);
        AssertionsForClassTypes.assertThat((Object)records.recordsForTopic(topic2)).isNull();
        AssertionsForClassTypes.assertThat((int)records.topics().size()).isEqualTo(1);
    }

    @Test
    @FixFor(value={"DBZ-7485"})
    public void shouldConsumeEventsOnlyFromIncludedDatabaseCollections() throws InterruptedException {
        String topic1 = String.format("%s.%s.%s", TOPIC_PREFIX, TEST_DATABASE1, TEST_COLLECTION1);
        String topic2 = String.format("%s.%s.%s", TOPIC_PREFIX, TEST_DATABASE1, TEST_COLLECTION2);
        FiltersRestrictedIT.populateCollection(TEST_DATABASE1, TEST_COLLECTION1, 10);
        FiltersRestrictedIT.populateCollection(TEST_DATABASE1, TEST_COLLECTION2, 10);
        Configuration config = ((Configuration.Builder)((Configuration.Builder)this.connectorConfiguration().edit().with(MongoDbConnectorConfig.DATABASE_INCLUDE_LIST, TEST_DATABASE1)).with(MongoDbConnectorConfig.COLLECTION_EXCLUDE_LIST, "dbit1.collection2")).build();
        this.start(MongoDbConnector.class, config);
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(20);
        AssertionsForClassTypes.assertThat((int)records.recordsForTopic(topic1).size()).isEqualTo(10);
        AssertionsForClassTypes.assertThat((Object)records.recordsForTopic(topic2)).isNull();
        AssertionsForClassTypes.assertThat((int)records.topics().size()).isEqualTo(1);
    }
}

