/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb;

import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.InsertOneOptions;
import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.connector.mongodb.AbstractMongoConnectorIT;
import io.debezium.connector.mongodb.FieldBlacklistIT;
import io.debezium.connector.mongodb.JsonSerialization;
import io.debezium.connector.mongodb.MongoDbConnector;
import io.debezium.connector.mongodb.MongoDbConnectorConfig;
import io.debezium.connector.mongodb.MongoDbTaskContext;
import io.debezium.connector.mongodb.TestHelper;
import io.debezium.doc.FixFor;
import io.debezium.embedded.AbstractConnectorTest;
import io.debezium.util.Testing;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceRecord;
import org.assertj.core.api.Assertions;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.junit.Test;

public class FieldExcludeListIT
extends AbstractMongoConnectorIT {
    private static final String DATABASE_NAME = "dbA";
    private static final String COLLECTION_NAME = "c1";
    private static final String SERVER_NAME = "serverX";

    @Test
    public void shouldNotExcludeFieldsForEventOfOtherCollection() throws InterruptedException {
        ObjectId objId = new ObjectId();
        Document obj = new Document().append("_id", (Object)objId).append("name", (Object)"Sally").append("phone", (Object)123L).append("active", (Object)true).append("scores", Arrays.asList(1.2, 3.4, 5.6));
        this.assertReadRecord("*.c2.name,*.c2.active", obj, "after", obj.toJson(JsonSerialization.COMPACT_JSON_SETTINGS));
    }

    @Test
    public void shouldExcludeFieldsForReadEvent() throws InterruptedException {
        ObjectId objId = new ObjectId();
        Document obj = new Document().append("_id", (Object)objId).append("name", (Object)"Sally").append("phone", (Object)123L).append("active", (Object)true).append("scores", Arrays.asList(1.2, 3.4, 5.6));
        String expected = "{\"_id\": {\"$oid\": \"" + objId + "\"},\"phone\": {\"$numberLong\": \"123\"},\"scores\": [1.2,3.4,5.6]}";
        this.assertReadRecord("*.c1.name,*.c1.active", obj, "after", expected);
    }

    @Test
    public void shouldNotExcludeMissingFieldsForReadEvent() throws InterruptedException {
        ObjectId objId = new ObjectId();
        Document obj = new Document().append("_id", (Object)objId).append("name", (Object)"Sally").append("phone", (Object)123L).append("active", (Object)true).append("scores", Arrays.asList(1.2, 3.4, 5.6));
        this.assertReadRecord("*.c1.missing", obj, "after", obj.toJson(JsonSerialization.COMPACT_JSON_SETTINGS));
    }

    @Test
    public void shouldExcludeNestedFieldsForReadEvent() throws InterruptedException {
        ObjectId objId = new ObjectId();
        Document obj = new Document().append("_id", (Object)objId).append("name", (Object)"Sally").append("phone", (Object)123L).append("address", (Object)new Document().append("number", (Object)34L).append("street", (Object)"Claude Debussylaan").append("city", (Object)"Amsterdam")).append("active", (Object)true).append("scores", Arrays.asList(1.2, 3.4, 5.6));
        String expected = "{\"_id\": {\"$oid\": \"" + objId + "\"},\"phone\": {\"$numberLong\": \"123\"},\"address\": {\"street\": \"Claude Debussylaan\",\"city\": \"Amsterdam\"},\"scores\": [1.2,3.4,5.6]}";
        this.assertReadRecord("*.c1.name,*.c1.active,*.c1.address.number", obj, "after", expected);
    }

    @Test
    public void shouldNotExcludeNestedMissingFieldsForReadEvent() throws InterruptedException {
        ObjectId objId = new ObjectId();
        Document obj = new Document().append("_id", (Object)objId).append("name", (Object)"Sally").append("phone", (Object)123L).append("address", (Object)new Document().append("number", (Object)34L).append("street", (Object)"Claude Debussylaan").append("city", (Object)"Amsterdam")).append("active", (Object)true).append("scores", Arrays.asList(1.2, 3.4, 5.6));
        this.assertReadRecord("*.c1.address.missing", obj, "after", obj.toJson(JsonSerialization.COMPACT_JSON_SETTINGS));
    }

    @Test
    public void shouldExcludeFieldsForInsertEvent() throws InterruptedException {
        ObjectId objId = new ObjectId();
        Document obj = new Document().append("_id", (Object)objId).append("name", (Object)"Sally").append("phone", (Object)123L).append("active", (Object)true).append("scores", Arrays.asList(1.2, 3.4, 5.6));
        String expected = "{\"_id\": {\"$oid\": \"" + objId + "\"},\"phone\": {\"$numberLong\": \"123\"},\"scores\": [1.2,3.4,5.6]}";
        this.assertInsertRecord("*.c1.name,*.c1.active", obj, "after", expected);
    }

    @Test
    public void shouldNotExcludeMissingFieldsForInsertEvent() throws InterruptedException {
        ObjectId objId = new ObjectId();
        Document obj = new Document().append("_id", (Object)objId).append("name", (Object)"Sally").append("phone", (Object)123L).append("active", (Object)true).append("scores", Arrays.asList(1.2, 3.4, 5.6));
        this.assertInsertRecord("*.c1.missing", obj, "after", obj.toJson(JsonSerialization.COMPACT_JSON_SETTINGS));
    }

    @Test
    public void shouldExcludeNestedFieldsForInsertEvent() throws InterruptedException {
        ObjectId objId = new ObjectId();
        Document obj = new Document().append("_id", (Object)objId).append("name", (Object)"Sally").append("phone", (Object)123L).append("address", (Object)new Document().append("number", (Object)34L).append("street", (Object)"Claude Debussylaan").append("city", (Object)"Amsterdam")).append("active", (Object)true).append("scores", Arrays.asList(1.2, 3.4, 5.6));
        String expected = "{\"_id\": {\"$oid\": \"" + objId + "\"},\"phone\": {\"$numberLong\": \"123\"},\"address\": {\"street\": \"Claude Debussylaan\",\"city\": \"Amsterdam\"},\"scores\": [1.2,3.4,5.6]}";
        this.assertInsertRecord("*.c1.name,*.c1.active,*.c1.address.number", obj, "after", expected);
    }

    @Test
    public void shouldNotExcludeNestedMissingFieldsForInsertEvent() throws InterruptedException {
        ObjectId objId = new ObjectId();
        Document obj = new Document().append("_id", (Object)objId).append("name", (Object)"Sally").append("phone", (Object)123L).append("address", (Object)new Document().append("number", (Object)34L).append("street", (Object)"Claude Debussylaan").append("city", (Object)"Amsterdam")).append("active", (Object)true).append("scores", Arrays.asList(1.2, 3.4, 5.6));
        this.assertInsertRecord("*.c1.address.missing", obj, "after", obj.toJson(JsonSerialization.COMPACT_JSON_SETTINGS));
    }

    @Test
    public void shouldExcludeFieldsForUpdateEvent() throws InterruptedException {
        ObjectId objId = new ObjectId();
        Document obj = new Document().append("_id", (Object)objId).append("name", (Object)"Sally").append("phone", (Object)456L).append("active", (Object)true).append("scores", Arrays.asList(1.2, 3.4, 5.6, 7.8));
        Document updateObj = new Document().append("phone", (Object)123L).append("scores", Arrays.asList(1.2, 3.4, 5.6));
        String patch = "{\"$v\": 1,\"$set\": {\"phone\": {\"$numberLong\": \"123\"},\"scores\": [1.2,3.4,5.6]}}";
        String full = "{\"_id\": {\"$oid\": \"<OID>\"}, \"phone\": {\"$numberLong\": \"123\"}, \"scores\": [1.2, 3.4, 5.6]}";
        String updated = "{\"phone\": 123, \"scores\": [1.2, 3.4, 5.6]}";
        this.assertUpdateRecord("*.c1.name,*.c1.active", objId, obj, updateObj, this.updateField(), new FieldBlacklistIT.ExpectedUpdate(patch, full, "{\"phone\": 123, \"scores\": [1.2, 3.4, 5.6]}", null));
    }

    @Test
    public void shouldNotExcludeMissingFieldsForUpdateEvent() throws InterruptedException {
        ObjectId objId = new ObjectId();
        Document obj = new Document().append("_id", (Object)objId).append("name", (Object)"Sally").append("phone", (Object)456L).append("active", (Object)true).append("scores", Arrays.asList(1.2, 3.4, 5.6, 7.8));
        Document updateObj = new Document().append("phone", (Object)123L).append("scores", Arrays.asList(1.2, 3.4, 5.6));
        String patch = "{\"$v\": 1,\"$set\": {\"phone\": {\"$numberLong\": \"123\"},\"scores\": [1.2,3.4,5.6]}}";
        String full = "{\"_id\": {\"$oid\": \"<OID>\"}, \"name\": \"Sally\", \"phone\": {\"$numberLong\": \"123\"}, \"active\": true, \"scores\": [1.2, 3.4, 5.6]}";
        String updated = "{\"phone\": 123, \"scores\": [1.2, 3.4, 5.6]}";
        this.assertUpdateRecord("*.c1.missing", objId, obj, updateObj, this.updateField(), new FieldBlacklistIT.ExpectedUpdate(patch, full, "{\"phone\": 123, \"scores\": [1.2, 3.4, 5.6]}", null));
    }

    @Test
    public void shouldExcludeNestedFieldsForUpdateEventWithEmbeddedDocument() throws InterruptedException {
        ObjectId objId = new ObjectId();
        Document obj = new Document().append("_id", (Object)objId).append("name", (Object)"Sally").append("phone", (Object)456L).append("address", (Object)new Document().append("number", (Object)35L).append("street", (Object)"Claude Debussylaane").append("city", (Object)"Amsterdame")).append("active", (Object)true).append("scores", Arrays.asList(1.2, 3.4, 5.6, 7.8));
        Document updateObj = new Document().append("_id", (Object)objId).append("name", (Object)"Sally").append("phone", (Object)123L).append("address", (Object)new Document().append("number", (Object)34L).append("street", (Object)"Claude Debussylaan").append("city", (Object)"Amsterdam")).append("active", (Object)true).append("scores", Arrays.asList(1.2, 3.4, 5.6));
        String patch = "{\"$v\": 1,\"$set\": {\"address\": {\"street\": \"Claude Debussylaan\",\"city\": \"Amsterdam\"},\"phone\": {\"$numberLong\": \"123\"},\"scores\": [1.2,3.4,5.6]}}";
        String full = "{\"_id\": {\"$oid\": \"<OID>\"}, \"phone\": {\"$numberLong\": \"123\"}, \"address\": {\"street\": \"Claude Debussylaan\", \"city\": \"Amsterdam\"},\"scores\": [1.2, 3.4, 5.6]}";
        String updated = "{\"address\": {\"street\": \"Claude Debussylaan\", \"city\": \"Amsterdam\"}, \"phone\": 123, \"scores\": [1.2, 3.4, 5.6]}";
        this.assertUpdateRecord("*.c1.name,*.c1.active,*.c1.address.number", objId, obj, updateObj, this.updateField(), new FieldBlacklistIT.ExpectedUpdate(patch, full, "{\"address\": {\"street\": \"Claude Debussylaan\", \"city\": \"Amsterdam\"}, \"phone\": 123, \"scores\": [1.2, 3.4, 5.6]}", null));
    }

    @Test
    public void shouldNotExcludeNestedMissingFieldsForUpdateEventWithEmbeddedDocument() throws InterruptedException {
        ObjectId objId = new ObjectId();
        Document obj = new Document().append("_id", (Object)objId).append("name", (Object)"Sally").append("phone", (Object)456L).append("address", (Object)new Document().append("number", (Object)45L).append("street", (Object)"Claude Debussylaann").append("city", (Object)"Amsterdame")).append("active", (Object)false).append("scores", Arrays.asList(1.2, 3.4, 5.6, 7.8));
        Document updateObj = new Document().append("_id", (Object)objId).append("name", (Object)"Sally").append("phone", (Object)123L).append("address", (Object)new Document().append("number", (Object)34L).append("street", (Object)"Claude Debussylaan").append("city", (Object)"Amsterdam")).append("active", (Object)true).append("scores", Arrays.asList(1.2, 3.4, 5.6));
        String patch = "{\"$v\": 1,\"$set\": {\"active\": true,\"address\": {\"number\": {\"$numberLong\": \"34\"},\"street\": \"Claude Debussylaan\",\"city\": \"Amsterdam\"},\"phone\": {\"$numberLong\": \"123\"},\"scores\": [1.2,3.4,5.6]}}";
        String full = "{\"_id\": {\"$oid\": \"<OID>\"}, \"name\": \"Sally\", \"phone\": {\"$numberLong\": \"123\"}, \"address\": {\"number\": {\"$numberLong\": \"34\"}, \"street\": \"Claude Debussylaan\", \"city\": \"Amsterdam\"},\"active\": true, \"scores\": [1.2, 3.4, 5.6]}";
        String updated = "{\"active\": true, \"address\": {\"number\": 34, \"street\": \"Claude Debussylaan\", \"city\": \"Amsterdam\"}, \"phone\": 123, \"scores\": [1.2, 3.4, 5.6]}";
        this.assertUpdateRecord("*.c1.address.missing", objId, obj, updateObj, this.updateField(), new FieldBlacklistIT.ExpectedUpdate(patch, full, "{\"active\": true, \"address\": {\"number\": 34, \"street\": \"Claude Debussylaan\", \"city\": \"Amsterdam\"}, \"phone\": 123, \"scores\": [1.2, 3.4, 5.6]}", null));
    }

    @Test
    public void shouldExcludeNestedFieldsForUpdateEventWithArrayOfEmbeddedDocuments() throws InterruptedException {
        ObjectId objId = new ObjectId();
        Document obj = new Document().append("_id", (Object)objId).append("name", (Object)"Sally").append("phone", (Object)456L).append("addresses", Arrays.asList(new Document().append("number", (Object)45L).append("street", (Object)"Claude Debussylaann").append("city", (Object)"Amsterdame"), new Document().append("number", (Object)8L).append("street", (Object)"Fragkokklisiass").append("city", (Object)"Athense"))).append("active", (Object)false).append("scores", Arrays.asList(1.2, 3.4, 5.6, 7.8));
        Document updateObj = new Document().append("_id", (Object)objId).append("name", (Object)"Sally").append("phone", (Object)123L).append("addresses", Arrays.asList(new Document().append("number", (Object)34L).append("street", (Object)"Claude Debussylaan").append("city", (Object)"Amsterdam"), new Document().append("number", (Object)7L).append("street", (Object)"Fragkokklisias").append("city", (Object)"Athens"))).append("active", (Object)true).append("scores", Arrays.asList(1.2, 3.4, 5.6));
        String patch = "{\"$v\": 1,\"$set\": {\"active\": true,\"addresses\": [{\"street\": \"Claude Debussylaan\",\"city\": \"Amsterdam\"},{\"street\": \"Fragkokklisias\",\"city\": \"Athens\"}],\"phone\": {\"$numberLong\": \"123\"},\"scores\": [1.2,3.4,5.6]}}";
        String full = "{\"_id\": {\"$oid\": \"<OID>\"}, \"phone\": {\"$numberLong\": \"123\"}, \"addresses\": [{\"street\": \"Claude Debussylaan\", \"city\": \"Amsterdam\"},{\"street\": \"Fragkokklisias\",\"city\": \"Athens\"}], \"active\": true, \"scores\": [1.2, 3.4, 5.6]}";
        String updated = "{\"active\": true, \"addresses\": [{\"street\": \"Claude Debussylaan\", \"city\": \"Amsterdam\"}, {\"street\": \"Fragkokklisias\", \"city\": \"Athens\"}], \"phone\": 123, \"scores\": [1.2, 3.4, 5.6]}";
        this.assertUpdateRecord("*.c1.name,*.c1.addresses.number", objId, obj, updateObj, this.updateField(), new FieldBlacklistIT.ExpectedUpdate(patch, full, "{\"active\": true, \"addresses\": [{\"street\": \"Claude Debussylaan\", \"city\": \"Amsterdam\"}, {\"street\": \"Fragkokklisias\", \"city\": \"Athens\"}], \"phone\": 123, \"scores\": [1.2, 3.4, 5.6]}", null));
    }

    @Test
    public void shouldNotExcludeNestedFieldsForUpdateEventWithArrayOfArrays() throws InterruptedException {
        ObjectId objId = new ObjectId();
        Document obj = new Document().append("_id", (Object)objId).append("name", (Object)"Sally Mae").append("phone", (Object)456L).append("addresses", Arrays.asList(Collections.singletonList(new Document().append("number", (Object)45L).append("street", (Object)"Claude Debussylaann").append("city", (Object)"Amsterdame")), Collections.singletonList(new Document().append("number", (Object)8L).append("street", (Object)"Fragkokklisiass").append("city", (Object)"Athenss")))).append("active", (Object)false).append("scores", Arrays.asList(1.2, 3.4, 5.6, 7.8));
        Document updateObj = new Document().append("_id", (Object)objId).append("name", (Object)"Sally").append("phone", (Object)123L).append("addresses", Arrays.asList(Collections.singletonList(new Document().append("number", (Object)34L).append("street", (Object)"Claude Debussylaan").append("city", (Object)"Amsterdam")), Collections.singletonList(new Document().append("number", (Object)7L).append("street", (Object)"Fragkokklisias").append("city", (Object)"Athens")))).append("active", (Object)true).append("scores", Arrays.asList(1.2, 3.4, 5.6));
        String patch = "{\"$v\": 1,\"$set\": {\"active\": true,\"addresses\": [[{\"number\": {\"$numberLong\": \"34\"},\"street\": \"Claude Debussylaan\",\"city\": \"Amsterdam\"}],[{\"number\": {\"$numberLong\": \"7\"},\"street\": \"Fragkokklisias\",\"city\": \"Athens\"}]],\"phone\": {\"$numberLong\": \"123\"},\"scores\": [1.2,3.4,5.6]}}";
        String full = "{\"_id\": {\"$oid\": \"<OID>\"}, \"phone\": {\"$numberLong\": \"123\"}, \"addresses\": [[{\"number\": {\"$numberLong\": \"34\"},\"street\": \"Claude Debussylaan\", \"city\": \"Amsterdam\"}],[{\"number\": {\"$numberLong\": \"7\"},\"street\": \"Fragkokklisias\",\"city\": \"Athens\"}]], \"active\": true, \"scores\": [1.2, 3.4, 5.6]}";
        String updated = "{\"active\": true, \"addresses\": [[{\"number\": 34, \"street\": \"Claude Debussylaan\", \"city\": \"Amsterdam\"}], [{\"number\": 7, \"street\": \"Fragkokklisias\", \"city\": \"Athens\"}]], \"phone\": 123, \"scores\": [1.2, 3.4, 5.6]}";
        this.assertUpdateRecord("*.c1.name,*.c1.addresses.number", objId, obj, updateObj, this.updateField(), new FieldBlacklistIT.ExpectedUpdate(patch, full, "{\"active\": true, \"addresses\": [[{\"number\": 34, \"street\": \"Claude Debussylaan\", \"city\": \"Amsterdam\"}], [{\"number\": 7, \"street\": \"Fragkokklisias\", \"city\": \"Athens\"}]], \"phone\": 123, \"scores\": [1.2, 3.4, 5.6]}", null));
    }

    @Test
    public void shouldExcludeFieldsForSetTopLevelFieldUpdateEvent() throws InterruptedException {
        ObjectId objId = new ObjectId();
        Document obj = new Document().append("_id", (Object)objId).append("name", (Object)"Sally May").append("phone", (Object)456L);
        Document updateObj = new Document().append("name", (Object)"Sally").append("phone", (Object)123L);
        String patch = "{\"$v\": 1,\"$set\": {\"phone\": {\"$numberLong\": \"123\"}}}";
        String full = "{\"_id\": {\"$oid\": \"<OID>\"}, \"phone\": {\"$numberLong\": \"123\"}}";
        String updated = "{\"phone\": 123}";
        this.assertUpdateRecord("*.c1.name", objId, obj, updateObj, this.updateField(), new FieldBlacklistIT.ExpectedUpdate(patch, full, "{\"phone\": 123}", null));
    }

    @Test
    public void shouldExcludeFieldsForUnsetTopLevelFieldUpdateEvent() throws InterruptedException {
        ObjectId objId = new ObjectId();
        Document obj = new Document().append("_id", (Object)objId).append("name", (Object)"Sally").append("phone", (Object)456L).append("active", (Object)true).append("scores", Arrays.asList(1.2, 3.4, 5.6));
        Document updateObj = new Document().append("name", (Object)"").append("phone", (Object)"");
        String patch = "{\"$v\": 1,\"$unset\": {\"phone\": true}}";
        String full = "{\"_id\": {\"$oid\": \"<OID>\"}, \"active\": true, \"scores\": [1.2, 3.4, 5.6]}";
        String updated = "{}";
        this.assertUpdateRecord("*.c1.name", objId, obj, updateObj, false, this.updateField(), new FieldBlacklistIT.ExpectedUpdate(patch, full, "{}", Arrays.asList("phone")));
    }

    @Test
    public void shouldExcludeNestedFieldsForSetTopLevelFieldUpdateEventWithEmbeddedDocument() throws InterruptedException {
        ObjectId objId = new ObjectId();
        Document obj = new Document().append("_id", (Object)objId).append("name", (Object)"Sally May").append("phone", (Object)456L).append("address", (Object)new Document().append("number", (Object)45L).append("street", (Object)"Claude Debussylaann").append("city", (Object)"Amsterdame"));
        Document updateObj = new Document().append("name", (Object)"Sally").append("phone", (Object)123L).append("address", (Object)new Document().append("number", (Object)34L).append("street", (Object)"Claude Debussylaan").append("city", (Object)"Amsterdam"));
        String patch = "{\"$v\": 1,\"$set\": {\"address\": {\"street\": \"Claude Debussylaan\",\"city\": \"Amsterdam\"},\"phone\": {\"$numberLong\": \"123\"}}}";
        String full = "{\"_id\": {\"$oid\": \"<OID>\"}, \"phone\": {\"$numberLong\": \"123\"}, \"address\": {\"street\": \"Claude Debussylaan\", \"city\": \"Amsterdam\"}}";
        String updated = "{\"address\": {\"street\": \"Claude Debussylaan\", \"city\": \"Amsterdam\"}, \"phone\": 123}";
        this.assertUpdateRecord("*.c1.name,*.c1.address.number", objId, obj, updateObj, this.updateField(), new FieldBlacklistIT.ExpectedUpdate(patch, full, "{\"address\": {\"street\": \"Claude Debussylaan\", \"city\": \"Amsterdam\"}, \"phone\": 123}", null));
    }

    @Test
    public void shouldExcludeNestedFieldsForSetTopLevelFieldUpdateEventWithArrayOfEmbeddedDocuments() throws InterruptedException {
        ObjectId objId = new ObjectId();
        Document obj = new Document().append("_id", (Object)objId).append("name", (Object)"Sally May").append("phone", (Object)456L).append("addresses", Arrays.asList(new Document().append("number", (Object)45L).append("street", (Object)"Claude Debussylaann").append("city", (Object)"Amsterdame"), new Document().append("number", (Object)8L).append("street", (Object)"Fragkokklisiass").append("city", (Object)"Athense")));
        Document updateObj = new Document().append("name", (Object)"Sally").append("phone", (Object)123L).append("addresses", Arrays.asList(new Document().append("number", (Object)34L).append("street", (Object)"Claude Debussylaan").append("city", (Object)"Amsterdam"), new Document().append("number", (Object)7L).append("street", (Object)"Fragkokklisias").append("city", (Object)"Athens")));
        String patch = "{\"$v\": 1,\"$set\": {\"addresses\": [{\"street\": \"Claude Debussylaan\",\"city\": \"Amsterdam\"},{\"street\": \"Fragkokklisias\",\"city\": \"Athens\"}],\"phone\": {\"$numberLong\": \"123\"}}}";
        String full = "{\"_id\": {\"$oid\": \"<OID>\"}, \"phone\": {\"$numberLong\": \"123\"}, \"addresses\": [{\"street\": \"Claude Debussylaan\", \"city\": \"Amsterdam\"},{\"street\": \"Fragkokklisias\",\"city\": \"Athens\"}]}";
        String updated = "{\"addresses\": [{\"street\": \"Claude Debussylaan\", \"city\": \"Amsterdam\"}, {\"street\": \"Fragkokklisias\", \"city\": \"Athens\"}], \"phone\": 123}";
        this.assertUpdateRecord("*.c1.name,*.c1.addresses.number", objId, obj, updateObj, this.updateField(), new FieldBlacklistIT.ExpectedUpdate(patch, full, "{\"addresses\": [{\"street\": \"Claude Debussylaan\", \"city\": \"Amsterdam\"}, {\"street\": \"Fragkokklisias\", \"city\": \"Athens\"}], \"phone\": 123}", null));
    }

    @Test
    public void shouldNotExcludeNestedFieldsForSetTopLevelFieldUpdateEventWithArrayOfArrays() throws InterruptedException {
        ObjectId objId = new ObjectId();
        Document obj = new Document().append("_id", (Object)objId).append("name", (Object)"Sally May").append("phone", (Object)456L).append("addresses", Arrays.asList(Collections.singletonList(new Document().append("number", (Object)45L).append("street", (Object)"Claude Debussylaann").append("city", (Object)"Amsterdame")), Collections.singletonList(new Document().append("number", (Object)8L).append("street", (Object)"Fragkokklisiass").append("city", (Object)"Athense"))));
        Document updateObj = new Document().append("name", (Object)"Sally").append("phone", (Object)123L).append("addresses", Arrays.asList(Collections.singletonList(new Document().append("number", (Object)34L).append("street", (Object)"Claude Debussylaan").append("city", (Object)"Amsterdam")), Collections.singletonList(new Document().append("number", (Object)7L).append("street", (Object)"Fragkokklisias").append("city", (Object)"Athens"))));
        String patch = "{\"$v\": 1,\"$set\": {\"addresses\": [[{\"number\": {\"$numberLong\": \"34\"},\"street\": \"Claude Debussylaan\",\"city\": \"Amsterdam\"}],[{\"number\": {\"$numberLong\": \"7\"},\"street\": \"Fragkokklisias\",\"city\": \"Athens\"}]],\"phone\": {\"$numberLong\": \"123\"}}}";
        String full = "{\"_id\": {\"$oid\": \"<OID>\"}, \"phone\": {\"$numberLong\": \"123\"}, \"addresses\": [[{\"number\": {\"$numberLong\": \"34\"},\"street\": \"Claude Debussylaan\", \"city\": \"Amsterdam\"}],[{\"number\": {\"$numberLong\": \"7\"},\"street\": \"Fragkokklisias\",\"city\": \"Athens\"}]]}";
        String updated = "{\"addresses\": [[{\"number\": 34, \"street\": \"Claude Debussylaan\", \"city\": \"Amsterdam\"}], [{\"number\": 7, \"street\": \"Fragkokklisias\", \"city\": \"Athens\"}]], \"phone\": 123}";
        this.assertUpdateRecord("*.c1.name,*.c1.addresses.number", objId, obj, updateObj, this.updateField(), new FieldBlacklistIT.ExpectedUpdate(patch, full, "{\"addresses\": [[{\"number\": 34, \"street\": \"Claude Debussylaan\", \"city\": \"Amsterdam\"}], [{\"number\": 7, \"street\": \"Fragkokklisias\", \"city\": \"Athens\"}]], \"phone\": 123}", null));
    }

    @Test
    public void shouldExcludeNestedFieldsForSetNestedFieldUpdateEventWithEmbeddedDocument() throws InterruptedException {
        ObjectId objId = new ObjectId();
        Document obj = new Document().append("_id", (Object)objId).append("name", (Object)"Sally May").append("phone", (Object)456L).append("address", (Object)new Document().append("number", (Object)45L).append("street", (Object)"Claude Debussylaann").append("city", (Object)"Amsterdame"));
        Document updateObj = new Document().append("name", (Object)"Sally").append("address.number", (Object)34L).append("address.street", (Object)"Claude Debussylaan").append("address.city", (Object)"Amsterdam");
        String patch = "{\"$v\": 1,\"$set\": {\"address.city\": \"Amsterdam\",\"address.street\": \"Claude Debussylaan\"}}";
        String full = "{\"_id\": {\"$oid\": \"<OID>\"}, \"phone\": {\"$numberLong\": \"456\"}, \"address\": {\"street\": \"Claude Debussylaan\", \"city\": \"Amsterdam\"}}";
        String updated = "{\"address.city\": \"Amsterdam\", \"address.street\": \"Claude Debussylaan\"}";
        this.assertUpdateRecord("*.c1.name,*.c1.address.number", objId, obj, updateObj, this.updateField(), new FieldBlacklistIT.ExpectedUpdate(patch, full, "{\"address.city\": \"Amsterdam\", \"address.street\": \"Claude Debussylaan\"}", null));
    }

    @Test
    public void shouldExcludeNestedFieldsForSetNestedFieldUpdateEventWithArrayOfEmbeddedDocuments() throws InterruptedException {
        ObjectId objId = new ObjectId();
        Document obj = new Document().append("_id", (Object)objId).append("name", (Object)"Sally May").append("addresses", Arrays.asList(new Document().append("number", (Object)45L).append("street", (Object)"Claude Debussylaann").append("city", (Object)"Amsterdame")));
        Document updateObj = new Document().append("name", (Object)"Sally").append("addresses.0.number", (Object)34L).append("addresses.0.street", (Object)"Claude Debussylaan").append("addresses.0.city", (Object)"Amsterdam");
        String patch = "{\"$v\": 1,\"$set\": {\"addresses.0.city\": \"Amsterdam\",\"addresses.0.street\": \"Claude Debussylaan\",\"name\": \"Sally\"}}";
        String full = "{\"_id\": {\"$oid\": \"<OID>\"}, \"name\": \"Sally\", \"addresses\": [{\"street\": \"Claude Debussylaan\", \"city\": \"Amsterdam\"}]}";
        String updated = "{\"addresses.0.city\": \"Amsterdam\", \"addresses.0.street\": \"Claude Debussylaan\", \"name\": \"Sally\"}";
        this.assertUpdateRecord("*.c1.addresses.number", objId, obj, updateObj, this.updateField(), new FieldBlacklistIT.ExpectedUpdate(patch, full, "{\"addresses.0.city\": \"Amsterdam\", \"addresses.0.street\": \"Claude Debussylaan\", \"name\": \"Sally\"}", null));
    }

    @Test
    public void shouldNotExcludeNestedFieldsForSetNestedFieldUpdateEventWithArrayOfArrays() throws InterruptedException {
        ObjectId objId = new ObjectId();
        Document obj = new Document().append("_id", (Object)objId).append("name", (Object)"Sally May").append("addresses", Arrays.asList(Collections.singletonList(new Document().append("number", (Object)45L).append("street", (Object)"Claude Debussylaann").append("city", (Object)"Amsterdame")), Collections.singletonList(new Document().append("number", (Object)8L).append("street", (Object)"Fragkokklisiass").append("city", (Object)"Athense"))));
        Document updateObj = new Document().append("name", (Object)"Sally").append("addresses.0.0.number", (Object)34L).append("addresses.0.0.street", (Object)"Claude Debussylaan").append("addresses.0.0.city", (Object)"Amsterdam");
        String patch = "{\"$v\": 1,\"$set\": {\"addresses.0.0.city\": \"Amsterdam\",\"addresses.0.0.number\": {\"$numberLong\": \"34\"},\"addresses.0.0.street\": \"Claude Debussylaan\",\"name\": \"Sally\"}}";
        String full = "{\"_id\": {\"$oid\": \"<OID>\"}, \"name\": \"Sally\", \"addresses\": [[{\"number\": {\"$numberLong\": \"34\"},\"street\": \"Claude Debussylaan\", \"city\": \"Amsterdam\"}],[{\"number\": {\"$numberLong\": \"8\"},\"street\": \"Fragkokklisiass\",\"city\": \"Athense\"}]]}";
        String updated = "{\"addresses.0.0.city\": \"Amsterdam\", \"addresses.0.0.number\": 34, \"addresses.0.0.street\": \"Claude Debussylaan\", \"name\": \"Sally\"}";
        this.assertUpdateRecord("*.c1.addresses.number", objId, obj, updateObj, this.updateField(), new FieldBlacklistIT.ExpectedUpdate(patch, full, "{\"addresses.0.0.city\": \"Amsterdam\", \"addresses.0.0.number\": 34, \"addresses.0.0.street\": \"Claude Debussylaan\", \"name\": \"Sally\"}", null));
    }

    @Test
    public void shouldExcludeNestedFieldsForSetNestedFieldUpdateEventWithSeveralArrays() throws InterruptedException {
        ObjectId objId = new ObjectId();
        Document obj = new Document().append("_id", (Object)objId).append("name", (Object)"Sally May").append("addresses", Arrays.asList(Collections.singletonMap("second", Arrays.asList(new Document().append("number", (Object)45L).append("street", (Object)"Claude Debussylaann").append("city", (Object)"Amsterdame")))));
        Document updateObj = new Document().append("name", (Object)"Sally").append("addresses.0.second.0.number", (Object)34L).append("addresses.0.second.0.street", (Object)"Claude Debussylaan").append("addresses.0.second.0.city", (Object)"Amsterdam");
        String patch = "{\"$v\": 1,\"$set\": {\"addresses.0.second.0.city\": \"Amsterdam\",\"addresses.0.second.0.street\": \"Claude Debussylaan\",\"name\": \"Sally\"}}";
        String full = "{\"_id\": {\"$oid\": \"<OID>\"}, \"name\": \"Sally\", \"addresses\": [{\"second\": [{\"street\": \"Claude Debussylaan\", \"city\": \"Amsterdam\"}]}]}";
        String updated = "{\"addresses.0.second.0.city\": \"Amsterdam\", \"addresses.0.second.0.street\": \"Claude Debussylaan\", \"name\": \"Sally\"}";
        this.assertUpdateRecord("*.c1.addresses.second.number", objId, obj, updateObj, this.updateField(), new FieldBlacklistIT.ExpectedUpdate(patch, full, "{\"addresses.0.second.0.city\": \"Amsterdam\", \"addresses.0.second.0.street\": \"Claude Debussylaan\", \"name\": \"Sally\"}", null));
    }

    @Test
    public void shouldExcludeFieldsForSetNestedFieldUpdateEventWithArrayOfEmbeddedDocuments() throws InterruptedException {
        ObjectId objId = new ObjectId();
        Document obj = new Document().append("_id", (Object)objId).append("name", (Object)"Sally May").append("addresses", Arrays.asList(new Document().append("number", (Object)45L).append("street", (Object)"Claude Debussylaann").append("city", (Object)"Amsterdame")));
        Document updateObj = new Document().append("name", (Object)"Sally").append("addresses.0.0.number", (Object)34L).append("addresses.0.0.street", (Object)"Claude Debussylaan").append("addresses.0.0.city", (Object)"Amsterdam");
        String patch = "{\"$v\": 1,\"$set\": {\"name\": \"Sally\"}}";
        String full = "{\"_id\": {\"$oid\": \"<OID>\"}, \"name\": \"Sally\"}";
        String updated = "{\"name\": \"Sally\"}";
        this.assertUpdateRecord("*.c1.addresses", objId, obj, updateObj, this.updateField(), new FieldBlacklistIT.ExpectedUpdate(patch, full, "{\"name\": \"Sally\"}", null));
    }

    @Test
    public void shouldExcludeFieldsForSetToArrayFieldUpdateEventWithArrayOfEmbeddedDocuments() throws InterruptedException {
        ObjectId objId = new ObjectId();
        Document obj = new Document().append("_id", (Object)objId).append("name", (Object)"Sally May").append("addresses", Arrays.asList(new Document().append("number", (Object)45L).append("street", (Object)"Claude Debussylaann").append("city", (Object)"Amsterdame")));
        Document updateObj = new Document().append("name", (Object)"Sally").append("addresses.0", (Object)new Document().append("number", (Object)34L).append("street", (Object)"Claude Debussylaan").append("city", (Object)"Amsterdam"));
        String patch = "{\"$v\": 1,\"$set\": {\"name\": \"Sally\"}}";
        String full = "{\"_id\": {\"$oid\": \"<OID>\"}, \"name\": \"Sally\"}";
        String updated = "{\"name\": \"Sally\"}";
        this.assertUpdateRecord("*.c1.addresses", objId, obj, updateObj, this.updateField(), new FieldBlacklistIT.ExpectedUpdate(patch, full, "{\"name\": \"Sally\"}", null));
    }

    @Test
    public void shouldExcludeNestedFieldsForUnsetNestedFieldUpdateEventWithEmbeddedDocument() throws InterruptedException {
        ObjectId objId = new ObjectId();
        Document obj = new Document().append("_id", (Object)objId).append("name", (Object)"Sally").append("phone", (Object)456L).append("address", (Object)new Document().append("number", (Object)45L).append("street", (Object)"Claude Debussylaann").append("city", (Object)"Amsterdame")).append("active", (Object)false).append("scores", Arrays.asList(1.2, 3.4, 5.6, 7.8));
        Document updateObj = new Document().append("name", (Object)"").append("address.number", (Object)"").append("address.street", (Object)"").append("address.city", (Object)"");
        String patch = "{\"$v\": 1,\"$unset\": {\"address.city\": true,\"address.street\": true}}";
        String full = "{\"_id\": {\"$oid\": \"<OID>\"}, \"phone\": {\"$numberLong\": \"456\"}, \"address\": {}, \"active\": false, \"scores\": [1.2, 3.4, 5.6, 7.8]}";
        String updated = "{}";
        this.assertUpdateRecord("*.c1.name,*.c1.address.number", objId, obj, updateObj, false, this.updateField(), new FieldBlacklistIT.ExpectedUpdate(patch, full, "{}", Arrays.asList("address.city", "address.street")));
    }

    @Test
    public void shouldExcludeNestedFieldsForUnsetNestedFieldUpdateEventWithArrayOfEmbeddedDocuments() throws InterruptedException {
        ObjectId objId = new ObjectId();
        Document obj = new Document().append("_id", (Object)objId).append("name", (Object)"Sally").append("phone", (Object)123L).append("addresses", Arrays.asList(new Document().append("number", (Object)34L).append("street", (Object)"Claude Debussylaan").append("city", (Object)"Amsterdam"), new Document().append("number", (Object)7L).append("street", (Object)"Fragkokklisias").append("city", (Object)"Athens"))).append("active", (Object)true).append("scores", Arrays.asList(1.2, 3.4, 5.6));
        Document updateObj = new Document().append("name", (Object)"").append("addresses.0.number", (Object)"").append("addresses.0.street", (Object)"").append("addresses.0.city", (Object)"");
        String patch = "{\"$v\": 1,\"$unset\": {\"addresses.0.city\": true,\"addresses.0.street\": true,\"name\": true}}";
        String full = "{\"_id\": {\"$oid\": \"<OID>\"}, \"phone\": {\"$numberLong\": \"123\"}, \"addresses\": [{},{\"street\": \"Fragkokklisias\",\"city\": \"Athens\"}], \"active\": true, \"scores\": [1.2, 3.4, 5.6]}";
        String updated = "{}";
        this.assertUpdateRecord("*.c1.addresses.number", objId, obj, updateObj, false, this.updateField(), new FieldBlacklistIT.ExpectedUpdate(patch, full, "{}", Arrays.asList("addresses.0.city", "addresses.0.street", "name")));
    }

    @Test
    public void shouldNotExcludeNestedFieldsForUnsetNestedFieldUpdateEventWithArrayOfArrays() throws InterruptedException {
        ObjectId objId = new ObjectId();
        Document obj = new Document().append("_id", (Object)objId).append("name", (Object)"Sally").append("phone", (Object)123L).append("addresses", Arrays.asList(Arrays.asList(new Document().append("number", (Object)34L).append("street", (Object)"Claude Debussylaan").append("city", (Object)"Amsterdam")))).append("active", (Object)true).append("scores", Arrays.asList(1.2, 3.4, 5.6));
        Document updateObj = new Document().append("name", (Object)"").append("addresses.0.0.number", (Object)"").append("addresses.0.0.street", (Object)"").append("addresses.0.0.city", (Object)"");
        String patch = "{\"$v\": 1,\"$unset\": {\"addresses.0.0.city\": true,\"addresses.0.0.number\": true,\"addresses.0.0.street\": true,\"name\": true}}";
        String full = "{\"_id\": {\"$oid\": \"<OID>\"}, \"phone\": {\"$numberLong\": \"123\"}, \"addresses\": [[{}]], \"active\": true, \"scores\": [1.2, 3.4, 5.6]}";
        String updated = "{}";
        this.assertUpdateRecord("*.c1.addresses.number", objId, obj, updateObj, false, this.updateField(), new FieldBlacklistIT.ExpectedUpdate(patch, full, "{}", Arrays.asList("addresses.0.0.city", "addresses.0.0.number", "addresses.0.0.street", "name")));
    }

    @Test
    public void shouldExcludeNestedFieldsForUnsetNestedFieldUpdateEventWithSeveralArrays() throws InterruptedException {
        ObjectId objId = new ObjectId();
        Document obj = new Document().append("_id", (Object)objId).append("name", (Object)"Sally").append("addresses", Arrays.asList(Collections.singletonMap("second", Arrays.asList(new Document().append("number", (Object)34L).append("street", (Object)"Claude Debussylaan").append("city", (Object)"Amsterdam")))));
        Document updateObj = new Document().append("name", (Object)"").append("addresses.0.second.0.number", (Object)"").append("addresses.0.second.0.street", (Object)"").append("addresses.0.second.0.city", (Object)"");
        String patch = "{\"$v\": 1,\"$unset\": {\"addresses.0.second.0.city\": true,\"addresses.0.second.0.street\": true,\"name\": true}}";
        String full = "{\"_id\": {\"$oid\": \"<OID>\"}, \"addresses\": [{\"second\": [{}]}]}";
        String updated = "{}";
        this.assertUpdateRecord("*.c1.addresses.second.number", objId, obj, updateObj, false, this.updateField(), new FieldBlacklistIT.ExpectedUpdate(patch, full, "{}", Arrays.asList("addresses.0.second.0.city", "addresses.0.second.0.street", "name")));
    }

    @Test
    public void shouldExcludeFieldsForUnsetNestedFieldUpdateEventWithArrayOfEmbeddedDocuments() throws InterruptedException {
        ObjectId objId = new ObjectId();
        Document obj = new Document().append("_id", (Object)objId).append("name", (Object)"Sally").append("addresses", Arrays.asList(new Document().append("number", (Object)34L).append("street", (Object)"Claude Debussylaan").append("city", (Object)"Amsterdam")));
        Document updateObj = new Document().append("name", (Object)"").append("addresses.0.number", (Object)"").append("addresses.0.street", (Object)"").append("addresses.0.city", (Object)"");
        String patch = "{\"$v\": 1,\"$unset\": {\"name\": true}}";
        String full = "{\"_id\": {\"$oid\": \"<OID>\"}}";
        String updated = "{}";
        this.assertUpdateRecord("*.c1.addresses", objId, obj, updateObj, false, this.updateField(), new FieldBlacklistIT.ExpectedUpdate(patch, full, "{}", Arrays.asList("name")));
    }

    @Test
    public void shouldExcludeFieldsForDeleteEvent() throws InterruptedException {
        this.config = this.getConfiguration("*.c1.name,*.c1.active");
        this.context = new MongoDbTaskContext(this.config);
        TestHelper.cleanDatabase(mongo, DATABASE_NAME);
        ObjectId objId = new ObjectId();
        Document obj = new Document("_id", (Object)objId);
        this.storeDocuments(DATABASE_NAME, COLLECTION_NAME, obj);
        this.start(MongoDbConnector.class, this.config);
        AbstractConnectorTest.SourceRecords snapshotRecords = this.consumeRecordsByTopic(1);
        Assertions.assertThat((int)snapshotRecords.topics().size()).isEqualTo(1);
        Assertions.assertThat((int)snapshotRecords.allRecordsInOrder().size()).isEqualTo(1);
        FieldExcludeListIT.waitForStreamingRunning("mongodb", SERVER_NAME);
        this.deleteDocuments(DATABASE_NAME, COLLECTION_NAME, objId);
        AbstractConnectorTest.SourceRecords deleteRecords = this.consumeRecordsByTopic(2);
        Assertions.assertThat((int)deleteRecords.topics().size()).isEqualTo(1);
        Assertions.assertThat((int)deleteRecords.allRecordsInOrder().size()).isEqualTo(2);
        SourceRecord record = (SourceRecord)deleteRecords.allRecordsInOrder().get(0);
        Struct value = this.getValue(record);
        String json = value.getString("after");
        Assertions.assertThat((String)json).isNull();
    }

    @Test
    public void shouldExcludeFieldsForDeleteTombstoneEvent() throws InterruptedException {
        this.config = this.getConfiguration("*.c1.name,*.c1.active");
        this.context = new MongoDbTaskContext(this.config);
        TestHelper.cleanDatabase(mongo, DATABASE_NAME);
        ObjectId objId = new ObjectId();
        Document obj = new Document("_id", (Object)objId);
        this.storeDocuments(DATABASE_NAME, COLLECTION_NAME, obj);
        this.start(MongoDbConnector.class, this.config);
        AbstractConnectorTest.SourceRecords snapshotRecords = this.consumeRecordsByTopic(1);
        Assertions.assertThat((int)snapshotRecords.topics().size()).isEqualTo(1);
        Assertions.assertThat((int)snapshotRecords.allRecordsInOrder().size()).isEqualTo(1);
        FieldExcludeListIT.waitForStreamingRunning("mongodb", SERVER_NAME);
        this.deleteDocuments(DATABASE_NAME, COLLECTION_NAME, objId);
        AbstractConnectorTest.SourceRecords deleteRecords = this.consumeRecordsByTopic(2);
        Assertions.assertThat((int)deleteRecords.topics().size()).isEqualTo(1);
        Assertions.assertThat((int)deleteRecords.allRecordsInOrder().size()).isEqualTo(2);
        SourceRecord record = (SourceRecord)deleteRecords.allRecordsInOrder().get(1);
        Struct value = this.getValue(record);
        Assertions.assertThat((Object)value).isNull();
    }

    @Test
    @FixFor(value={"DBZ-5328"})
    public void shouldExcludeFieldsIncludingDashesForReadEvent() throws InterruptedException {
        ObjectId objId = new ObjectId();
        Document obj = new Document().append("_id", (Object)objId).append("name-1", (Object)"Sally").append("phone", (Object)123L).append("active-2", (Object)true).append("scores", Arrays.asList(1.2, 3.4, 5.6));
        String expected = "{\"_id\": {\"$oid\": \"" + objId + "\"},\"phone\": {\"$numberLong\": \"123\"},\"scores\": [1.2,3.4,5.6]}";
        this.assertReadRecord("db-A", COLLECTION_NAME, "db-A.c1.name-1,*.c1.active-2", obj, "after", expected);
    }

    @Test
    @FixFor(value={"DBZ-5328"})
    public void shouldExcludeFieldsIncludingDashesForInsertEvent() throws InterruptedException {
        ObjectId objId = new ObjectId();
        Document obj = new Document().append("_id", (Object)objId).append("name-1", (Object)"Sally").append("phone", (Object)123L).append("active-2", (Object)true).append("scores", Arrays.asList(1.2, 3.4, 5.6));
        String expected = "{\"_id\": {\"$oid\": \"" + objId + "\"},\"phone\": {\"$numberLong\": \"123\"},\"scores\": [1.2,3.4,5.6]}";
        this.assertInsertRecord("db-A", COLLECTION_NAME, "db-A.c1.name-1,*.c1.active-2", obj, "after", expected);
    }

    @Test
    @FixFor(value={"DBZ-5328"})
    public void shouldExcludeNestedFieldsIncludingDashesForInsertEvent() throws InterruptedException {
        ObjectId objId = new ObjectId();
        Document obj = new Document().append("_id", (Object)objId).append("name-1", (Object)"Sally").append("phone", (Object)123L).append("address", (Object)new Document().append("number-3", (Object)34L).append("street", (Object)"Claude Debussylaan").append("city", (Object)"Amsterdam")).append("active-2", (Object)true).append("scores", Arrays.asList(1.2, 3.4, 5.6));
        String expected = "{\"_id\": {\"$oid\": \"" + objId + "\"},\"phone\": {\"$numberLong\": \"123\"},\"address\": {\"street\": \"Claude Debussylaan\",\"city\": \"Amsterdam\"},\"scores\": [1.2,3.4,5.6]}";
        this.assertInsertRecord("db-A", COLLECTION_NAME, "db-A.c1.name-1,*.c1.active-2,*.c1.address.number-3", obj, "after", expected);
    }

    @Test
    @FixFor(value={"DBZ-5328"})
    public void shouldExcludeFieldsIncludingDashesForUpdateEvent() throws InterruptedException {
        ObjectId objId = new ObjectId();
        Document obj = new Document().append("_id", (Object)objId).append("name-1", (Object)"Sally").append("phone", (Object)456L).append("active-2", (Object)true).append("scores", Arrays.asList(1.2, 3.4, 5.6, 7.8));
        Document updateObj = new Document().append("phone", (Object)123L).append("scores", Arrays.asList(1.2, 3.4, 5.6));
        String patch = "{\"$v\": 1,\"$set\": {\"phone\": {\"$numberLong\": \"123\"},\"scores\": [1.2,3.4,5.6]}}";
        String full = "{\"_id\": {\"$oid\": \"<OID>\"}, \"phone\": {\"$numberLong\": \"123\"}, \"scores\": [1.2, 3.4, 5.6]}";
        String updated = "{\"phone\": 123, \"scores\": [1.2, 3.4, 5.6]}";
        this.assertUpdateRecord("db-A", COLLECTION_NAME, "db-A.c1.name-1,*.c1.active-2", objId, obj, updateObj, true, this.updateField(), new FieldBlacklistIT.ExpectedUpdate(patch, full, "{\"phone\": 123, \"scores\": [1.2, 3.4, 5.6]}", null));
    }

    @Test
    @FixFor(value={"DBZ-4846"})
    public void shouldExcludeFieldsIncludingSameNamesForReadEvent() throws InterruptedException {
        ObjectId objId = new ObjectId();
        Document obj = new Document().append("_id", (Object)objId).append("name", (Object)"Sally").append("phone", (Object)123L).append("active", (Object)true).append("scores", Arrays.asList(1.2, 3.4, 5.6));
        String expected = "{\"_id\": {\"$oid\": \"" + objId + "\"},\"phone\": {\"$numberLong\": \"123\"},\"scores\": [1.2,3.4,5.6]}";
        this.config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)TestHelper.getConfiguration(mongo).edit().with(MongoDbConnectorConfig.FIELD_EXCLUDE_LIST, "*.c1.name,*.c1.active,*.c2.name,*.c2.active")).with(MongoDbConnectorConfig.COLLECTION_INCLUDE_LIST, "dbA.c1,dbA.c2")).with(CommonConnectorConfig.TOPIC_PREFIX, SERVER_NAME)).build();
        this.context = new MongoDbTaskContext(this.config);
        TestHelper.cleanDatabase(mongo, DATABASE_NAME);
        this.storeDocuments(DATABASE_NAME, COLLECTION_NAME, obj);
        this.storeDocuments(DATABASE_NAME, "c2", obj);
        this.start(MongoDbConnector.class, this.config);
        AbstractConnectorTest.SourceRecords snapshotRecords = this.consumeRecordsByTopic(2);
        Assertions.assertThat((int)snapshotRecords.topics().size()).isEqualTo(2);
        Assertions.assertThat((int)snapshotRecords.allRecordsInOrder().size()).isEqualTo(2);
        SourceRecord record1 = (SourceRecord)snapshotRecords.allRecordsInOrder().get(0);
        Struct value1 = this.getValue(record1);
        SourceRecord record2 = (SourceRecord)snapshotRecords.allRecordsInOrder().get(0);
        Struct value2 = this.getValue(record2);
        Assertions.assertThat((Object)value1.get("after")).isEqualTo((Object)expected);
        Assertions.assertThat((Object)value2.get("after")).isEqualTo((Object)expected);
    }

    private Configuration getConfiguration(String blackList) {
        return this.getConfiguration(blackList, DATABASE_NAME, COLLECTION_NAME);
    }

    private Configuration getConfiguration(String fieldExcludeList, String database, String collection) {
        return ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)TestHelper.getConfiguration(mongo).edit().with(MongoDbConnectorConfig.FIELD_EXCLUDE_LIST, fieldExcludeList)).with(MongoDbConnectorConfig.COLLECTION_INCLUDE_LIST, database + "." + collection)).with(CommonConnectorConfig.TOPIC_PREFIX, SERVER_NAME)).with(CommonConnectorConfig.SCHEMA_NAME_ADJUSTMENT_MODE, (EnumeratedValue)CommonConnectorConfig.SchemaNameAdjustmentMode.AVRO)).build();
    }

    private Struct getValue(SourceRecord record) {
        return (Struct)record.value();
    }

    private void storeDocuments(String dbName, String collectionName, Document ... documents) {
        try (MongoClient client = this.connect();){
            Testing.debug((Object)("Storing in '" + dbName + "." + collectionName + "' document"));
            MongoDatabase db = client.getDatabase(dbName);
            MongoCollection coll = db.getCollection(collectionName);
            coll.drop();
            for (Document document : documents) {
                InsertOneOptions insertOptions = new InsertOneOptions().bypassDocumentValidation(Boolean.valueOf(true));
                Assertions.assertThat((Map)document).isNotNull();
                Assertions.assertThat((int)document.size()).isGreaterThan(0);
                coll.insertOne((Object)document, insertOptions);
            }
        }
    }

    private void updateDocuments(String dbName, String collectionName, ObjectId objId, Document document, boolean doSet) {
        try (MongoClient client = this.connect();){
            MongoDatabase db = client.getDatabase(dbName);
            MongoCollection coll = db.getCollection(collectionName);
            Document filter = Document.parse((String)("{\"_id\": {\"$oid\": \"" + objId + "\"}}"));
            coll.updateOne((Bson)filter, (Bson)new Document().append(doSet ? "$set" : "$unset", (Object)document));
        }
    }

    private void deleteDocuments(String dbName, String collectionName, ObjectId objId) {
        try (MongoClient client = this.connect();){
            MongoDatabase db = client.getDatabase(dbName);
            MongoCollection coll = db.getCollection(collectionName);
            Document filter = Document.parse((String)("{\"_id\": {\"$oid\": \"" + objId + "\"}}"));
            coll.deleteOne((Bson)filter);
        }
    }

    private void assertReadRecord(String blackList, Document snapshotRecord, String field, String expected) throws InterruptedException {
        this.assertReadRecord(DATABASE_NAME, COLLECTION_NAME, blackList, snapshotRecord, field, expected);
    }

    private void assertReadRecord(String dbName, String collectionName, String blackList, Document snapshotRecord, String field, String expected) throws InterruptedException {
        this.config = this.getConfiguration(blackList, dbName, collectionName);
        this.context = new MongoDbTaskContext(this.config);
        TestHelper.cleanDatabase(mongo, dbName);
        this.storeDocuments(dbName, collectionName, snapshotRecord);
        this.start(MongoDbConnector.class, this.config);
        AbstractConnectorTest.SourceRecords snapshotRecords = this.consumeRecordsByTopic(1);
        Assertions.assertThat((int)snapshotRecords.topics().size()).isEqualTo(1);
        Assertions.assertThat((int)snapshotRecords.allRecordsInOrder().size()).isEqualTo(1);
        SourceRecord record = (SourceRecord)snapshotRecords.allRecordsInOrder().get(0);
        Struct value = this.getValue(record);
        Assertions.assertThat((Object)value.get(field)).isEqualTo((Object)expected);
    }

    private void assertInsertRecord(String blackList, Document insertRecord, String field, String expected) throws InterruptedException {
        this.assertInsertRecord(DATABASE_NAME, COLLECTION_NAME, blackList, insertRecord, field, expected);
    }

    private void assertInsertRecord(String dbName, String collectionName, String blackList, Document insertRecord, String field, String expected) throws InterruptedException {
        this.config = this.getConfiguration(blackList, dbName, collectionName);
        this.context = new MongoDbTaskContext(this.config);
        TestHelper.cleanDatabase(mongo, dbName);
        this.start(MongoDbConnector.class, this.config);
        FieldExcludeListIT.waitForSnapshotToBeCompleted("mongodb", SERVER_NAME);
        this.storeDocuments(dbName, collectionName, insertRecord);
        AbstractConnectorTest.SourceRecords insertRecords = this.consumeRecordsByTopic(1);
        Assertions.assertThat((int)insertRecords.topics().size()).isEqualTo(1);
        Assertions.assertThat((int)insertRecords.allRecordsInOrder().size()).isEqualTo(1);
        SourceRecord record = (SourceRecord)insertRecords.allRecordsInOrder().get(0);
        Struct value = this.getValue(record);
        Assertions.assertThat((Object)value.get(field)).isEqualTo((Object)expected);
    }

    private void assertUpdateRecord(String blackList, ObjectId objectId, Document snapshotRecord, Document updateRecord, String field, FieldBlacklistIT.ExpectedUpdate expected) throws InterruptedException {
        this.assertUpdateRecord(blackList, objectId, snapshotRecord, updateRecord, true, field, expected);
    }

    private void assertUpdateRecord(String blackList, ObjectId objectId, Document snapshotRecord, Document updateRecord, boolean doSet, String field, FieldBlacklistIT.ExpectedUpdate expected) throws InterruptedException {
        this.assertUpdateRecord(DATABASE_NAME, COLLECTION_NAME, blackList, objectId, snapshotRecord, updateRecord, doSet, field, expected);
    }

    private void assertUpdateRecord(String dbName, String collectionName, String blackList, ObjectId objectId, Document snapshotRecord, Document updateRecord, boolean doSet, String field, FieldBlacklistIT.ExpectedUpdate expected) throws InterruptedException {
        this.config = this.getConfiguration(blackList, dbName, collectionName);
        this.context = new MongoDbTaskContext(this.config);
        TestHelper.cleanDatabase(mongo, dbName);
        this.storeDocuments(dbName, collectionName, snapshotRecord);
        this.start(MongoDbConnector.class, this.config);
        AbstractConnectorTest.SourceRecords snapshotRecords = this.consumeRecordsByTopic(1);
        Assertions.assertThat((int)snapshotRecords.topics().size()).isEqualTo(1);
        Assertions.assertThat((int)snapshotRecords.allRecordsInOrder().size()).isEqualTo(1);
        FieldExcludeListIT.waitForStreamingRunning("mongodb", SERVER_NAME);
        this.updateDocuments(dbName, collectionName, objectId, updateRecord, doSet);
        AbstractConnectorTest.SourceRecords updateRecords = this.consumeRecordsByTopic(1);
        Assertions.assertThat((int)updateRecords.topics().size()).isEqualTo(1);
        Assertions.assertThat((int)updateRecords.allRecordsInOrder().size()).isEqualTo(1);
        SourceRecord record = (SourceRecord)updateRecords.allRecordsInOrder().get(0);
        Struct value = this.getValue(record);
        TestHelper.assertChangeStreamUpdateAsDocs(objectId, value, expected.full, expected.removedFields, expected.updatedFields);
    }

    private String updateField() {
        return "after";
    }
}

