/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb.connection;

import io.debezium.DebeziumException;
import io.debezium.config.Configuration;
import io.debezium.connector.mongodb.CollectionId;
import io.debezium.connector.mongodb.DisconnectEvent;
import io.debezium.connector.mongodb.MongoDbPartition;
import io.debezium.connector.mongodb.connection.MongoDbConnection;
import io.debezium.pipeline.ConnectorEvent;
import io.debezium.pipeline.EventDispatcher;
import io.debezium.pipeline.spi.Partition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MongoDbConnections {
    public static final Logger LOGGER = LoggerFactory.getLogger(MongoDbConnections.class);

    public static MongoDbConnection.ErrorHandler throwingErrorHandler() {
        return (desc, error) -> {
            throw new DebeziumException(desc, error);
        };
    }

    public static MongoDbConnection.ErrorHandler eventSourcingErrorHandler(EventDispatcher<MongoDbPartition, CollectionId> dispatcher, MongoDbPartition partition) {
        return (desc, error) -> {
            if (error.getMessage() == null || !error.getMessage().startsWith("Command failed with error 13")) {
                dispatcher.dispatchConnectorEvent((Partition)partition, (ConnectorEvent)new DisconnectEvent());
            }
            LOGGER.error("Error while attempting to {}: {}", new Object[]{desc, error.getMessage(), error});
            throw new DebeziumException("Error while attempting to " + desc, error);
        };
    }

    public static MongoDbConnection create(Configuration configuration) {
        return new MongoDbConnection(configuration, MongoDbConnections.throwingErrorHandler());
    }

    public static MongoDbConnection create(Configuration configuration, MongoDbConnection.ErrorHandler errorHandler) {
        return new MongoDbConnection(configuration, errorHandler);
    }

    public static MongoDbConnection create(Configuration configuration, EventDispatcher<MongoDbPartition, CollectionId> dispatcher, MongoDbPartition partition) {
        return new MongoDbConnection(configuration, MongoDbConnections.eventSourcingErrorHandler(dispatcher, partition));
    }

    private MongoDbConnections() {
    }
}

