/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.connector.mongodb.Module;
import io.debezium.connector.mongodb.MongoDbConnectorConfig;
import io.debezium.connector.mongodb.MongoDbTaskContext;
import io.debezium.util.Testing;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;

public class MongoDbTaskContextTest
implements Testing {
    private Configuration config;
    private MongoDbTaskContext context;

    @Before
    public void setup() {
        this.config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)Configuration.create().with(MongoDbConnectorConfig.CONNECTION_STRING, "mongodb://dummy:27017")).with(MongoDbConnectorConfig.TASK_ID, 42)).with(MongoDbConnectorConfig.TOPIC_PREFIX, "bistromath")).with(MongoDbConnectorConfig.CAPTURE_MODE, (EnumeratedValue)MongoDbConnectorConfig.CaptureMode.CHANGE_STREAMS)).build();
        this.context = new MongoDbTaskContext(this.config);
    }

    @Test
    public void shouldConfigureCommonTaskPropertiesFromConfig() {
        Assertions.assertThat((String)this.context.getTaskId()).isEqualTo((Object)this.config.getString(MongoDbConnectorConfig.TASK_ID));
        Assertions.assertThat((String)this.context.getConnectorName()).isEqualTo((Object)this.config.getString(CommonConnectorConfig.TOPIC_PREFIX));
        Assertions.assertThat((String)this.context.getConnectorType()).isEqualTo((Object)Module.contextName());
    }

    @Test
    public void shouldConfigureMongoDbTaskPropertiesFromConfig() {
        Assertions.assertThat((Object)this.context.getConnectorConfig().getConfig()).isEqualTo((Object)this.config);
        Assertions.assertThat((Comparable)this.context.getCaptureMode()).isEqualTo((Object)MongoDbConnectorConfig.CaptureMode.CHANGE_STREAMS);
    }
}

