/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb.transforms;

import com.mongodb.client.MongoClient;
import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.Configuration;
import io.debezium.connector.mongodb.AbstractMongoConnectorIT;
import io.debezium.connector.mongodb.MongoDbConnector;
import io.debezium.connector.mongodb.MongoDbConnectorConfig;
import io.debezium.connector.mongodb.MongoDbTaskContext;
import io.debezium.connector.mongodb.TestHelper;
import io.debezium.connector.mongodb.transforms.ExtractNewDocumentState;
import io.debezium.data.Envelope;
import io.debezium.embedded.AbstractConnectorTest;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.header.Header;
import org.apache.kafka.connect.source.SourceRecord;
import org.assertj.core.api.Assertions;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.junit.After;
import org.junit.Before;

public abstract class AbstractExtractNewDocumentStateTestIT
extends AbstractMongoConnectorIT {
    protected static final String DB_NAME = "transform_operations";
    protected static final String SERVER_NAME = "mongo";
    protected static final String CONFIG_DROP_TOMBSTONES = "drop.tombstones";
    protected static final String HANDLE_DELETES = "delete.handling.mode";
    protected static final String HANDLE_TOMBSTONE_DELETES = "delete.tombstone.handling.mode";
    protected static final String FLATTEN_STRUCT = "flatten.struct";
    protected static final String DELIMITER = "flatten.struct.delimiter";
    protected static final String DROP_TOMBSTONE = "drop.tombstones";
    protected static final String ADD_HEADERS = "add.headers";
    protected static final String ADD_FIELDS = "add.fields";
    protected static final String ADD_FIELDS_PREFIX = "add.fields.prefix";
    protected static final String ADD_HEADERS_PREFIX = "add.headers.prefix";
    protected static final String ARRAY_ENCODING = "array.encoding";
    protected ExtractNewDocumentState<SourceRecord> transformation;

    protected abstract String getCollectionName();

    protected String topicName() {
        return String.format("%s.%s.%s", SERVER_NAME, DB_NAME, this.getCollectionName());
    }

    @Override
    @Before
    public void beforeEach() {
        Configuration config = this.getBaseConfigBuilder().build();
        this.beforeEach(config);
    }

    public void beforeEach(Configuration config) {
        super.beforeEach();
        this.transformation = new ExtractNewDocumentState();
        this.transformation.configure(Collections.emptyMap());
        this.context = new MongoDbTaskContext(config);
        TestHelper.cleanDatabase(mongo, DB_NAME);
        this.start(MongoDbConnector.class, config);
    }

    @Override
    @After
    public void afterEach() {
        super.afterEach();
        this.transformation.close();
    }

    protected void restartConnectorWithoutEmittingTombstones() {
        this.afterEach();
        Configuration config = ((Configuration.Builder)this.getBaseConfigBuilder().with(MongoDbConnectorConfig.TOMBSTONES_ON_DELETE, false)).build();
        this.beforeEach(config);
    }

    protected Configuration.Builder getBaseConfigBuilder() {
        return (Configuration.Builder)((Configuration.Builder)((Configuration.Builder)TestHelper.getConfiguration(mongo).edit().with(MongoDbConnectorConfig.POLL_INTERVAL_MS, 10)).with(MongoDbConnectorConfig.COLLECTION_INCLUDE_LIST, "transform_operations." + this.getCollectionName())).with(CommonConnectorConfig.TOPIC_PREFIX, SERVER_NAME);
    }

    protected void restartConnectorWithConfig(Configuration config) {
        this.afterEach();
        this.beforeEach(config);
    }

    SourceRecord getRecordByOperation(Envelope.Operation operation) throws InterruptedException {
        SourceRecord candidateRecord = this.getNextRecord();
        if (!((Struct)candidateRecord.value()).get("op").equals(operation.code())) {
            return this.getRecordByOperation(operation);
        }
        return candidateRecord;
    }

    SourceRecord getNextRecord() throws InterruptedException {
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(1);
        Assertions.assertThat((int)records.recordsForTopic(this.topicName()).size()).isEqualTo(1);
        return (SourceRecord)records.recordsForTopic(this.topicName()).get(0);
    }

    protected SourceRecord getUpdateRecord() throws InterruptedException {
        return this.getRecordByOperation(Envelope.Operation.UPDATE);
    }

    protected AbstractConnectorTest.SourceRecords createCreateRecordFromJson(String pathOnClasspath) throws Exception {
        List<Document> documents = this.loadTestDocuments(pathOnClasspath);
        try (MongoClient client = this.connect();){
            for (Document document : documents) {
                client.getDatabase(DB_NAME).getCollection(this.getCollectionName()).insertOne((Object)document);
            }
        }
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(documents.size());
        Assertions.assertThat((int)records.recordsForTopic(this.topicName()).size()).isEqualTo(documents.size());
        this.assertNoRecordsToConsume();
        return records;
    }

    protected SourceRecord createCreateRecord() throws Exception {
        ObjectId objId = new ObjectId();
        Document obj = new Document().append("_id", (Object)objId).append("name", (Object)"Sally").append("address", (Object)new Document().append("struct", (Object)"Morris Park Ave").append("zipcode", (Object)"10462"));
        try (MongoClient client = this.connect();){
            client.getDatabase(DB_NAME).getCollection(this.getCollectionName()).insertOne((Object)obj);
        }
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(1);
        Assertions.assertThat((int)records.recordsForTopic(this.topicName()).size()).isEqualTo(1);
        this.assertNoRecordsToConsume();
        return (SourceRecord)records.allRecordsInOrder().get(0);
    }

    protected AbstractConnectorTest.SourceRecords createDeleteRecordWithTombstone() throws Exception {
        ObjectId objId = new ObjectId();
        Document obj = new Document().append("_id", (Object)objId).append("name", (Object)"Sally").append("address", (Object)new Document().append("struct", (Object)"Morris Park Ave").append("zipcode", (Object)"10462"));
        try (MongoClient client = this.connect();){
            client.getDatabase(DB_NAME).getCollection(this.getCollectionName()).insertOne((Object)obj);
        }
        AbstractConnectorTest.SourceRecords createRecords = this.consumeRecordsByTopic(1);
        Assertions.assertThat((int)createRecords.recordsForTopic(this.topicName()).size()).isEqualTo(1);
        this.assertNoRecordsToConsume();
        try (MongoClient client = this.connect();){
            Document filter = Document.parse((String)("{\"_id\": {\"$oid\": \"" + objId + "\"}}"));
            client.getDatabase(DB_NAME).getCollection(this.getCollectionName()).deleteOne((Bson)filter);
        }
        AbstractConnectorTest.SourceRecords deleteRecords = this.consumeRecordsByTopic(2);
        Assertions.assertThat((int)deleteRecords.recordsForTopic(this.topicName()).size()).isEqualTo(2);
        this.assertNoRecordsToConsume();
        return deleteRecords;
    }

    protected static void waitForStreamingRunning() throws InterruptedException {
        AbstractExtractNewDocumentStateTestIT.waitForStreamingRunning("mongodb", SERVER_NAME);
    }

    protected String getSourceRecordHeaderByKey(SourceRecord record, String headerKey) {
        Iterator headers = record.headers().allWithName(headerKey);
        if (!headers.hasNext()) {
            return null;
        }
        Object value = ((Header)headers.next()).value();
        return value != null ? value.toString() : null;
    }
}

