/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.relational;

import io.debezium.DebeziumException;
import io.debezium.connector.SnapshotRecord;
import io.debezium.jdbc.CancellableResultSet;
import io.debezium.jdbc.JdbcConnection;
import io.debezium.jdbc.MainConnectionProvidingConnectionFactory;
import io.debezium.pipeline.EventDispatcher;
import io.debezium.pipeline.notification.NotificationService;
import io.debezium.pipeline.source.AbstractSnapshotChangeEventSource;
import io.debezium.pipeline.source.SnapshottingTask;
import io.debezium.pipeline.source.spi.ChangeEventSource;
import io.debezium.pipeline.source.spi.SnapshotProgressListener;
import io.debezium.pipeline.spi.ChangeRecordEmitter;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.pipeline.spi.Partition;
import io.debezium.pipeline.spi.SnapshotResult;
import io.debezium.relational.HistorizedRelationalDatabaseSchema;
import io.debezium.relational.RelationalDatabaseConnectorConfig;
import io.debezium.relational.RelationalDatabaseSchema;
import io.debezium.relational.SnapshotChangeRecordEmitter;
import io.debezium.relational.Table;
import io.debezium.relational.TableId;
import io.debezium.relational.Tables;
import io.debezium.schema.SchemaChangeEvent;
import io.debezium.snapshot.SnapshotterService;
import io.debezium.spi.schema.DataCollectionId;
import io.debezium.util.Clock;
import io.debezium.util.ColumnUtils;
import io.debezium.util.Strings;
import io.debezium.util.Threads;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.kafka.connect.errors.ConnectException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RelationalSnapshotChangeEventSource<P extends Partition, O extends OffsetContext>
extends AbstractSnapshotChangeEventSource<P, O> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RelationalSnapshotChangeEventSource.class);
    public static final Pattern SELECT_ALL_PATTERN = Pattern.compile("\\*");
    public static final Pattern MATCH_ALL_PATTERN = Pattern.compile(".*");
    private final RelationalDatabaseConnectorConfig connectorConfig;
    private final JdbcConnection jdbcConnection;
    private final MainConnectionProvidingConnectionFactory<? extends JdbcConnection> jdbcConnectionFactory;
    private final RelationalDatabaseSchema schema;
    protected final EventDispatcher<P, TableId> dispatcher;
    protected final Clock clock;
    private final SnapshotProgressListener<P> snapshotProgressListener;
    protected final SnapshotterService snapshotterService;
    protected Queue<JdbcConnection> connectionPool;

    public RelationalSnapshotChangeEventSource(RelationalDatabaseConnectorConfig connectorConfig, MainConnectionProvidingConnectionFactory<? extends JdbcConnection> jdbcConnectionFactory, RelationalDatabaseSchema schema, EventDispatcher<P, TableId> dispatcher, Clock clock, SnapshotProgressListener<P> snapshotProgressListener, NotificationService<P, O> notificationService, SnapshotterService snapshotterService) {
        super(connectorConfig, snapshotProgressListener, notificationService);
        this.connectorConfig = connectorConfig;
        this.jdbcConnection = jdbcConnectionFactory.mainConnection();
        this.jdbcConnectionFactory = jdbcConnectionFactory;
        this.schema = schema;
        this.dispatcher = dispatcher;
        this.clock = clock;
        this.snapshotProgressListener = snapshotProgressListener;
        this.snapshotterService = snapshotterService;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SnapshotResult<O> doExecute(ChangeEventSource.ChangeEventSourceContext context, O previousOffset, AbstractSnapshotChangeEventSource.SnapshotContext<P, O> snapshotContext, SnapshottingTask snapshottingTask) throws Exception {
        SnapshotResult<OffsetContext> snapshotResult;
        RelationalSnapshotContext ctx = (RelationalSnapshotContext)snapshotContext;
        Connection connection = null;
        Object exceptionWhileSnapshot = null;
        try {
            Set<Pattern> dataCollectionsToBeSnapshotted = this.getDataCollectionPattern(snapshottingTask.getDataCollections());
            Map<DataCollectionId, String> snapshotSelectOverridesByTable = snapshottingTask.getFilterQueries().entrySet().stream().collect(Collectors.toMap(e -> TableId.parse((String)e.getKey()), Map.Entry::getValue));
            this.preSnapshot();
            LOGGER.info("Snapshot step 1 - Preparing");
            if (previousOffset != null && previousOffset.isSnapshotRunning()) {
                LOGGER.info("Previous snapshot was cancelled before completion; a new snapshot will be taken.");
            }
            connection = this.createSnapshotConnection();
            this.connectionCreated(ctx);
            LOGGER.info("Snapshot step 2 - Determining captured tables");
            this.determineCapturedTables(ctx, dataCollectionsToBeSnapshotted, snapshottingTask);
            this.snapshotProgressListener.monitoredDataCollectionsDetermined(snapshotContext.partition, ctx.capturedTables);
            this.connectionPool = this.createConnectionPool(ctx);
            LOGGER.info("Snapshot step 3 - Locking captured tables {}", ctx.capturedTables);
            if (snapshottingTask.snapshotSchema()) {
                this.lockTablesForSchemaSnapshot(context, ctx);
            }
            LOGGER.info("Snapshot step 4 - Determining snapshot offset");
            this.determineSnapshotOffset(ctx, previousOffset);
            LOGGER.info("Snapshot step 5 - Reading structure of captured tables");
            this.readTableStructure(context, ctx, previousOffset, snapshottingTask);
            if (snapshottingTask.snapshotSchema()) {
                LOGGER.info("Snapshot step 6 - Persisting schema history");
                this.createSchemaChangeEventsForTables(context, ctx, snapshottingTask);
                this.releaseSchemaSnapshotLocks(ctx);
            } else {
                LOGGER.info("Snapshot step 6 - Skipping persisting of schema history");
            }
            if (snapshottingTask.snapshotData()) {
                LOGGER.info("Snapshot step 7 - Snapshotting data");
                this.createDataEvents(context, ctx, this.connectionPool, snapshotSelectOverridesByTable, snapshottingTask);
            } else {
                LOGGER.info("Snapshot step 7 - Skipping snapshotting of data");
                this.releaseDataSnapshotLocks(ctx);
                ctx.offset.preSnapshotCompletion();
                ctx.offset.postSnapshotCompletion();
            }
            this.postSnapshot();
            this.dispatcher.alwaysDispatchHeartbeatEvent(ctx.partition, ctx.offset);
            snapshotResult = SnapshotResult.completed(ctx.offset);
        }
        catch (AssertionError | Exception e3) {
            try {
                LOGGER.error("Error during snapshot", (Throwable)e3);
                exceptionWhileSnapshot = e3;
                throw e3;
            }
            catch (Throwable throwable) {
                try {
                    if (this.connectionPool != null) {
                        for (JdbcConnection conn : this.connectionPool) {
                            if (this.jdbcConnection.equals(conn)) continue;
                            conn.close();
                        }
                    }
                    this.rollbackTransaction(connection);
                    throw throwable;
                }
                catch (Exception e4) {
                    LOGGER.error("Error in finally block", (Throwable)e4);
                    if (exceptionWhileSnapshot == null) throw e4;
                    e4.addSuppressed((Throwable)exceptionWhileSnapshot);
                    throw e4;
                }
            }
        }
        try {
            if (this.connectionPool != null) {
                for (JdbcConnection conn : this.connectionPool) {
                    if (this.jdbcConnection.equals(conn)) continue;
                    conn.close();
                }
            }
            this.rollbackTransaction(connection);
            return snapshotResult;
        }
        catch (Exception e2) {
            LOGGER.error("Error in finally block", (Throwable)e2);
            if (exceptionWhileSnapshot == null) throw e2;
            e2.addSuppressed((Throwable)exceptionWhileSnapshot);
            throw e2;
        }
    }

    private Queue<JdbcConnection> createConnectionPool(RelationalSnapshotContext<P, O> ctx) throws SQLException {
        ConcurrentLinkedQueue<JdbcConnection> connectionPool = new ConcurrentLinkedQueue<JdbcConnection>();
        connectionPool.add(this.jdbcConnection);
        int snapshotMaxThreads = Math.max(1, Math.min(this.connectorConfig.getSnapshotMaxThreads(), ctx.capturedTables.size()));
        if (snapshotMaxThreads > 1) {
            Optional<String> firstQuery = this.getSnapshotConnectionFirstSelect(ctx, ctx.capturedTables.iterator().next());
            for (int i = 1; i < snapshotMaxThreads; ++i) {
                JdbcConnection conn = ((JdbcConnection)this.jdbcConnectionFactory.newConnection()).setAutoCommit(false);
                conn.connection().setTransactionIsolation(this.jdbcConnection.connection().getTransactionIsolation());
                this.connectionPoolConnectionCreated(ctx, conn);
                connectionPool.add(conn);
                if (!firstQuery.isPresent()) continue;
                conn.execute(firstQuery.get());
            }
        }
        LOGGER.info("Created connection pool with {} threads", (Object)snapshotMaxThreads);
        return connectionPool;
    }

    public Connection createSnapshotConnection() throws SQLException {
        Connection connection = this.jdbcConnection.connection();
        connection.setAutoCommit(false);
        return connection;
    }

    protected void connectionCreated(RelationalSnapshotContext<P, O> snapshotContext) throws Exception {
    }

    protected void connectionPoolConnectionCreated(RelationalSnapshotContext<P, O> snapshotContext, JdbcConnection connection) throws SQLException {
    }

    protected List<Pattern> getSignalDataCollectionPattern(String signalingDataCollection) {
        return Strings.listOfRegex(signalingDataCollection, 2);
    }

    private Stream<TableId> toTableIds(Set<TableId> tableIds, Pattern pattern) {
        return tableIds.stream().filter(tid -> pattern.asMatchPredicate().test(this.connectorConfig.getTableIdMapper().toString((TableId)tid))).sorted();
    }

    private Set<TableId> addSignalingCollectionAndSort(Set<TableId> capturedTables) {
        String tableIncludeList = this.connectorConfig.tableIncludeList();
        String signalingDataCollection = this.connectorConfig.getSignalingDataCollectionId();
        ArrayList<Pattern> captureTablePatterns = new ArrayList<Pattern>();
        if (!Strings.isNullOrBlank(tableIncludeList)) {
            captureTablePatterns.addAll(Strings.listOfRegex(tableIncludeList, 2));
        } else {
            captureTablePatterns.add(MATCH_ALL_PATTERN);
        }
        if (!Strings.isNullOrBlank(signalingDataCollection)) {
            captureTablePatterns.addAll(this.getSignalDataCollectionPattern(signalingDataCollection));
        }
        return captureTablePatterns.stream().flatMap(pattern -> this.toTableIds(capturedTables, (Pattern)pattern)).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private void determineCapturedTables(RelationalSnapshotContext<P, O> ctx, Set<Pattern> dataCollectionsToBeSnapshotted, SnapshottingTask snapshottingTask) throws Exception {
        Set<TableId> allTableIds = this.getAllTableIds(ctx);
        Set snapshottedTableIds = this.determineDataCollectionsToBeSnapshotted(allTableIds, dataCollectionsToBeSnapshotted).collect(Collectors.toSet());
        HashSet<TableId> capturedTables = new HashSet<TableId>();
        HashSet<TableId> capturedSchemaTables = new HashSet<TableId>();
        for (TableId tableId : allTableIds) {
            if (!this.connectorConfig.getTableFilters().eligibleForSchemaDataCollectionFilter().isIncluded(tableId) || snapshottingTask.isOnDemand()) continue;
            LOGGER.info("Adding table {} to the list of capture schema tables", (Object)tableId);
            capturedSchemaTables.add(tableId);
        }
        for (TableId tableId : snapshottedTableIds) {
            if (this.connectorConfig.getTableFilters().dataCollectionFilter().isIncluded(tableId)) {
                LOGGER.trace("Adding table {} to the list of captured tables for which the data will be snapshotted", (Object)tableId);
                capturedTables.add(tableId);
                continue;
            }
            LOGGER.trace("Ignoring table {} for data snapshotting as it's not included in the filter configuration", (Object)tableId);
        }
        ctx.capturedTables = this.addSignalingCollectionAndSort(capturedTables);
        ctx.capturedSchemaTables = snapshottingTask.isOnDemand() ? ctx.capturedTables : (Set)capturedSchemaTables.stream().sorted().collect(Collectors.toCollection(LinkedHashSet::new));
    }

    protected abstract Set<TableId> getAllTableIds(RelationalSnapshotContext<P, O> var1) throws Exception;

    protected abstract void lockTablesForSchemaSnapshot(ChangeEventSource.ChangeEventSourceContext var1, RelationalSnapshotContext<P, O> var2) throws Exception;

    protected abstract void determineSnapshotOffset(RelationalSnapshotContext<P, O> var1, O var2) throws Exception;

    protected abstract void readTableStructure(ChangeEventSource.ChangeEventSourceContext var1, RelationalSnapshotContext<P, O> var2, O var3, SnapshottingTask var4) throws Exception;

    protected abstract void releaseSchemaSnapshotLocks(RelationalSnapshotContext<P, O> var1) throws Exception;

    protected void releaseDataSnapshotLocks(RelationalSnapshotContext<P, O> snapshotContext) throws Exception {
    }

    protected void createSchemaChangeEventsForTables(ChangeEventSource.ChangeEventSourceContext sourceContext, RelationalSnapshotContext<P, O> snapshotContext, SnapshottingTask snapshottingTask) throws Exception {
        this.tryStartingSnapshot(snapshotContext);
        if (!this.schema.isHistorized()) {
            return;
        }
        Iterator<TableId> iterator = this.getTablesForSchemaChange(snapshotContext).iterator();
        while (iterator.hasNext()) {
            TableId tableId = iterator.next();
            if (!sourceContext.isRunning()) {
                throw new InterruptedException("Interrupted while capturing schema of table " + tableId);
            }
            LOGGER.info("Capturing structure of table {}", (Object)tableId);
            snapshotContext.offset.event(tableId, this.getClock().currentTime());
            if (!snapshottingTask.snapshotData() && !iterator.hasNext()) {
                this.lastSnapshotRecord(snapshotContext);
            }
            SchemaChangeEvent event = this.getCreateTableEvent(snapshotContext, snapshotContext.tables.forTable(tableId));
            if (HistorizedRelationalDatabaseSchema.class.isAssignableFrom(this.schema.getClass()) && ((HistorizedRelationalDatabaseSchema)this.schema).skipSchemaChangeEvent(event)) continue;
            this.dispatcher.dispatchSchemaChangeEvent(snapshotContext.partition, snapshotContext.offset, tableId, receiver -> {
                try {
                    receiver.schemaChangeEvent(event);
                }
                catch (Exception e) {
                    throw new DebeziumException((Throwable)e);
                }
            });
        }
    }

    protected Collection<TableId> getTablesForSchemaChange(RelationalSnapshotContext<P, O> snapshotContext) {
        return snapshotContext.capturedTables;
    }

    protected abstract SchemaChangeEvent getCreateTableEvent(RelationalSnapshotContext<P, O> var1, Table var2) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createDataEvents(ChangeEventSource.ChangeEventSourceContext sourceContext, RelationalSnapshotContext<P, O> snapshotContext, Queue<JdbcConnection> connectionPool, Map<DataCollectionId, String> snapshotSelectOverridesByTable, SnapshottingTask snapshottingTask) throws Exception {
        this.tryStartingSnapshot(snapshotContext);
        EventDispatcher.SnapshotReceiver<P> snapshotReceiver = this.dispatcher.getSnapshotChangeEventReceiver();
        int snapshotMaxThreads = connectionPool.size();
        LOGGER.info("Creating snapshot worker pool with {} worker thread(s)", (Object)snapshotMaxThreads);
        ExecutorService executorService = Executors.newFixedThreadPool(snapshotMaxThreads);
        ExecutorCompletionService<Void> completionService = new ExecutorCompletionService<Void>(executorService);
        HashMap<TableId, String> queryTables = new HashMap<TableId, String>();
        Map rowCountTables = new LinkedHashMap<TableId, Object>();
        for (TableId tableId : snapshotContext.capturedTables) {
            Optional<String> selectStatement = this.determineSnapshotSelect(snapshotContext, tableId, snapshotSelectOverridesByTable);
            if (selectStatement.isPresent()) {
                LOGGER.info("For table '{}' using select statement: '{}'", (Object)tableId, (Object)selectStatement.get());
                queryTables.put(tableId, selectStatement.get());
                OptionalLong rowCount = this.rowCountForTable(tableId);
                rowCountTables.put(tableId, rowCount);
                continue;
            }
            LOGGER.warn("For table '{}' the select statement was not provided, skipping table", (Object)tableId);
            this.snapshotProgressListener.dataCollectionSnapshotCompleted(snapshotContext.partition, tableId, 0L);
        }
        if (this.connectorConfig.snapshotOrderByRowCount() != RelationalDatabaseConnectorConfig.SnapshotTablesRowCountOrder.DISABLED) {
            LOGGER.info("Sort tables by row count '{}'", (Object)this.connectorConfig.snapshotOrderByRowCount());
            int orderFactor = this.connectorConfig.snapshotOrderByRowCount() == RelationalDatabaseConnectorConfig.SnapshotTablesRowCountOrder.ASCENDING ? 1 : -1;
            rowCountTables = rowCountTables.entrySet().stream().sorted(Map.Entry.comparingByValue((a, b) -> orderFactor * Long.compare(a.orElse(0L), b.orElse(0L)))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
        }
        ConcurrentLinkedQueue<OffsetContext> offsets = new ConcurrentLinkedQueue<OffsetContext>();
        offsets.add(snapshotContext.offset);
        for (int i = 1; i < snapshotMaxThreads; ++i) {
            offsets.add((OffsetContext)this.copyOffset(snapshotContext));
        }
        try {
            int tableCount = rowCountTables.size();
            int tableOrder = 1;
            for (TableId tableId : rowCountTables.keySet()) {
                boolean firstTable = tableOrder == 1 && snapshotMaxThreads == 1;
                boolean lastTable = tableOrder == tableCount && snapshotMaxThreads == 1;
                String selectStatement = (String)queryTables.get(tableId);
                OptionalLong rowCount = (OptionalLong)rowCountTables.get(tableId);
                this.notificationService.initialSnapshotNotificationService().notifyTableInProgress(snapshotContext.partition, snapshotContext.offset, tableId.identifier(), rowCountTables.keySet());
                Callable<Void> callable = this.createDataEventsForTableCallable(sourceContext, snapshotContext, snapshotReceiver, snapshotContext.tables.forTable(tableId), firstTable, lastTable, tableOrder++, tableCount, selectStatement, rowCount, connectionPool, offsets);
                completionService.submit(callable);
            }
            for (int i = 0; i < tableCount; ++i) {
                completionService.take().get();
            }
        }
        finally {
            executorService.shutdownNow();
        }
        this.releaseDataSnapshotLocks(snapshotContext);
        for (OffsetContext offset : offsets) {
            offset.preSnapshotCompletion();
        }
        snapshotReceiver.completeSnapshot();
        for (OffsetContext offset : offsets) {
            offset.postSnapshotCompletion();
        }
    }

    protected abstract O copyOffset(RelationalSnapshotContext<P, O> var1);

    protected void tryStartingSnapshot(RelationalSnapshotContext<P, O> snapshotContext) {
        if (!snapshotContext.offset.isSnapshotRunning()) {
            snapshotContext.offset.preSnapshotStart();
        }
    }

    protected Instant getSnapshotSourceTimestamp(JdbcConnection jdbcConnection, O offset, TableId tableId) {
        try {
            Optional<Instant> snapshotTs = jdbcConnection.getCurrentTimestamp();
            if (snapshotTs.isEmpty()) {
                throw new ConnectException("Failed reading CURRENT_TIMESTAMP from source database");
            }
            return snapshotTs.get();
        }
        catch (SQLException e) {
            throw new ConnectException("Failed reading CURRENT_TIMESTAMP from source database", (Throwable)e);
        }
    }

    protected Callable<Void> createDataEventsForTableCallable(ChangeEventSource.ChangeEventSourceContext sourceContext, RelationalSnapshotContext<P, O> snapshotContext, EventDispatcher.SnapshotReceiver<P> snapshotReceiver, Table table, boolean firstTable, boolean lastTable, int tableOrder, int tableCount, String selectStatement, OptionalLong rowCount, Queue<JdbcConnection> connectionPool, Queue<O> offsets) {
        return () -> {
            JdbcConnection connection = (JdbcConnection)connectionPool.poll();
            OffsetContext offset = (OffsetContext)offsets.poll();
            try {
                this.doCreateDataEventsForTable(sourceContext, snapshotContext, offset, snapshotReceiver, table, firstTable, lastTable, tableOrder, tableCount, selectStatement, rowCount, connection);
            }
            catch (SQLException e) {
                this.notificationService.initialSnapshotNotificationService().notifyCompletedTableWithError(snapshotContext.partition, snapshotContext.offset, table.id().identifier());
                throw new ConnectException("Snapshotting of table " + table.id() + " failed", (Throwable)e);
            }
            finally {
                offsets.add(offset);
                connectionPool.add(connection);
            }
            return null;
        };
    }

    protected void doCreateDataEventsForTable(ChangeEventSource.ChangeEventSourceContext sourceContext, RelationalSnapshotContext<P, O> snapshotContext, O offset, EventDispatcher.SnapshotReceiver<P> snapshotReceiver, Table table, boolean firstTable, boolean lastTable, int tableOrder, int tableCount, String selectStatement, OptionalLong rowCount, JdbcConnection jdbcConnection) throws InterruptedException, SQLException {
        if (!sourceContext.isRunning()) {
            throw new InterruptedException("Interrupted while snapshotting table " + table.id());
        }
        long exportStart = this.clock.currentTimeInMillis();
        LOGGER.info("Exporting data from table '{}' ({} of {} tables)", new Object[]{table.id(), tableOrder, tableCount});
        Instant sourceTableSnapshotTimestamp = this.getSnapshotSourceTimestamp(jdbcConnection, offset, table.id());
        try (Statement statement = this.readTableStatement(jdbcConnection, rowCount);
             ResultSet rs = this.resultSetForDataEvents(selectStatement, statement);){
            ColumnUtils.ColumnArray columnArray = ColumnUtils.toArray(rs, table);
            long rows = 0L;
            Threads.Timer logTimer = this.getTableScanLogTimer();
            boolean hasNext = rs.next();
            if (hasNext) {
                while (hasNext) {
                    if (!sourceContext.isRunning()) {
                        throw new InterruptedException("Interrupted while snapshotting table " + table.id());
                    }
                    ++rows;
                    Object[] row = jdbcConnection.rowToArray(table, rs, columnArray);
                    if (logTimer.expired()) {
                        long stop = this.clock.currentTimeInMillis();
                        if (rowCount.isPresent()) {
                            LOGGER.info("\t Exported {} of {} records for table '{}' after {}", new Object[]{rows, rowCount.getAsLong(), table.id(), Strings.duration(stop - exportStart)});
                        } else {
                            LOGGER.info("\t Exported {} records for table '{}' after {}", new Object[]{rows, table.id(), Strings.duration(stop - exportStart)});
                        }
                        this.snapshotProgressListener.rowsScanned(snapshotContext.partition, table.id(), rows);
                        logTimer = this.getTableScanLogTimer();
                    }
                    hasNext = rs.next();
                    this.setSnapshotMarker((OffsetContext)offset, firstTable, lastTable, rows == 1L, !hasNext);
                    this.dispatcher.dispatchSnapshotEvent(snapshotContext.partition, table.id(), this.getChangeRecordEmitter(snapshotContext.partition, offset, table.id(), row, sourceTableSnapshotTimestamp), snapshotReceiver);
                }
            } else {
                this.setSnapshotMarker((OffsetContext)offset, firstTable, lastTable, false, true);
            }
            LOGGER.info("\t Finished exporting {} records for table '{}' ({} of {} tables); total duration '{}'", new Object[]{rows, table.id(), tableOrder, tableCount, Strings.duration(this.clock.currentTimeInMillis() - exportStart)});
            this.snapshotProgressListener.dataCollectionSnapshotCompleted(snapshotContext.partition, table.id(), rows);
            this.notificationService.initialSnapshotNotificationService().notifyCompletedTableSuccessfully(snapshotContext.partition, snapshotContext.offset, table.id().identifier(), rows, snapshotContext.capturedTables);
        }
    }

    protected ResultSet resultSetForDataEvents(String selectStatement, Statement statement) throws SQLException {
        return CancellableResultSet.from(statement.executeQuery(selectStatement));
    }

    private void setSnapshotMarker(OffsetContext offset, boolean firstTable, boolean lastTable, boolean firstRecordInTable, boolean lastRecordInTable) {
        if (lastRecordInTable && lastTable) {
            offset.markSnapshotRecord(SnapshotRecord.LAST);
        } else if (firstRecordInTable && firstTable) {
            offset.markSnapshotRecord(SnapshotRecord.FIRST);
        } else if (lastRecordInTable) {
            offset.markSnapshotRecord(SnapshotRecord.LAST_IN_DATA_COLLECTION);
        } else if (firstRecordInTable) {
            offset.markSnapshotRecord(SnapshotRecord.FIRST_IN_DATA_COLLECTION);
        } else {
            offset.markSnapshotRecord(SnapshotRecord.TRUE);
        }
    }

    protected void lastSnapshotRecord(RelationalSnapshotContext<P, O> snapshotContext) {
        snapshotContext.offset.markSnapshotRecord(SnapshotRecord.LAST);
    }

    protected OptionalLong rowCountForTable(TableId tableId) {
        return OptionalLong.empty();
    }

    private Threads.Timer getTableScanLogTimer() {
        return Threads.timer(this.clock, LOG_INTERVAL);
    }

    protected ChangeRecordEmitter<P> getChangeRecordEmitter(P partition, O offset, TableId tableId, Object[] row, Instant timestamp) {
        offset.event(tableId, timestamp);
        return new SnapshotChangeRecordEmitter<P>(partition, (OffsetContext)offset, row, this.getClock(), this.connectorConfig);
    }

    private Optional<String> determineSnapshotSelect(RelationalSnapshotContext<P, O> snapshotContext, TableId tableId, Map<DataCollectionId, String> snapshotSelectOverridesByTable) {
        String overriddenSelect = this.getSnapshotSelectOverridesByTable(tableId, snapshotSelectOverridesByTable);
        if (overriddenSelect != null) {
            return Optional.of(this.enhanceOverriddenSelect(snapshotContext, overriddenSelect, tableId));
        }
        List<String> columns = this.getPreparedColumnNames(snapshotContext.partition, this.schema.tableFor(tableId));
        return this.getSnapshotSelect(snapshotContext, tableId, columns);
    }

    protected String getSnapshotSelectOverridesByTable(TableId tableId, Map<DataCollectionId, String> snapshotSelectOverrides) {
        String overriddenSelect = snapshotSelectOverrides.get(tableId);
        if (overriddenSelect == null) {
            overriddenSelect = snapshotSelectOverrides.get(new TableId(null, tableId.schema(), tableId.table()));
        }
        return overriddenSelect;
    }

    protected List<String> getPreparedColumnNames(P partition, Table table) {
        List<String> columnNames = table.retrieveColumnNames().stream().filter(columnName -> this.additionalColumnFilter(partition, table.id(), (String)columnName)).filter(columnName -> this.connectorConfig.getColumnFilter().matches(table.id().catalog(), table.id().schema(), table.id().table(), (String)columnName)).map(this.jdbcConnection::quotedColumnIdString).collect(Collectors.toList());
        if (columnNames.isEmpty()) {
            LOGGER.info("\t All columns in table {} were excluded due to include/exclude lists, defaulting to selecting all columns", (Object)table.id());
            columnNames = table.retrieveColumnNames().stream().map(this.jdbcConnection::quotedColumnIdString).collect(Collectors.toList());
        }
        return columnNames;
    }

    protected boolean additionalColumnFilter(P partition, TableId tableId, String columnName) {
        return true;
    }

    protected String enhanceOverriddenSelect(RelationalSnapshotContext<P, O> snapshotContext, String overriddenSelect, TableId tableId) {
        return overriddenSelect;
    }

    protected abstract Optional<String> getSnapshotSelect(RelationalSnapshotContext<P, O> var1, TableId var2, List<String> var3);

    protected Optional<String> getSnapshotConnectionFirstSelect(RelationalSnapshotContext<P, O> snapshotContext, TableId tableId) {
        return Optional.empty();
    }

    protected Statement readTableStatement(JdbcConnection jdbcConnection, OptionalLong tableSize) throws SQLException {
        return jdbcConnection.readTableStatement(this.connectorConfig, tableSize);
    }

    private void rollbackTransaction(Connection connection) {
        if (connection != null) {
            try {
                connection.rollback();
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected Clock getClock() {
        return this.clock;
    }

    protected void postSnapshot() throws InterruptedException {
    }

    protected void preSnapshot() throws InterruptedException {
    }

    public static class RelationalSnapshotContext<P extends Partition, O extends OffsetContext>
    extends AbstractSnapshotChangeEventSource.SnapshotContext<P, O> {
        public final String catalogName;
        public final Tables tables;
        public final boolean onDemand;
        public Set<TableId> capturedTables;
        public Set<TableId> capturedSchemaTables;

        public RelationalSnapshotContext(P partition, String catalogName, boolean onDemand) {
            super(partition);
            this.catalogName = catalogName;
            this.tables = new Tables();
            this.onDemand = onDemand;
        }
    }
}

