/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.operation;

import com.mongodb.MongoException;
import com.mongodb.MongoWriteConcernException;
import com.mongodb.ServerAddress;
import com.mongodb.WriteConcern;
import com.mongodb.WriteConcernResult;
import com.mongodb.bulk.WriteConcernError;
import com.mongodb.internal.connection.ProtocolHelper;
import com.mongodb.internal.operation.CommandOperationHelper;
import java.util.stream.Collectors;
import org.bson.BsonArray;
import org.bson.BsonDocument;
import org.bson.BsonString;
import org.bson.BsonValue;

public final class WriteConcernHelper {
    public static void appendWriteConcernToCommand(WriteConcern writeConcern, BsonDocument commandDocument) {
        if (writeConcern != null && !writeConcern.isServerDefault()) {
            commandDocument.put("writeConcern", (BsonValue)writeConcern.asDocument());
        }
    }

    public static void throwOnWriteConcernError(BsonDocument result, ServerAddress serverAddress, int maxWireVersion) {
        if (WriteConcernHelper.hasWriteConcernError(result)) {
            MongoException exception = ProtocolHelper.createSpecialException(result, serverAddress, "errmsg");
            if (exception == null) {
                exception = WriteConcernHelper.createWriteConcernException(result, serverAddress);
            }
            CommandOperationHelper.addRetryableWriteErrorLabel(exception, maxWireVersion);
            throw exception;
        }
    }

    public static boolean hasWriteConcernError(BsonDocument result) {
        return result.containsKey((Object)"writeConcernError");
    }

    public static MongoWriteConcernException createWriteConcernException(BsonDocument result, ServerAddress serverAddress) {
        MongoWriteConcernException writeConcernException = new MongoWriteConcernException(WriteConcernHelper.createWriteConcernError(result.getDocument((Object)"writeConcernError")), WriteConcernResult.acknowledged(0, false, null), serverAddress);
        result.getArray((Object)"errorLabels", new BsonArray()).stream().map(i -> i.asString().getValue()).forEach(writeConcernException::addLabel);
        return writeConcernException;
    }

    public static WriteConcernError createWriteConcernError(BsonDocument writeConcernErrorDocument) {
        return new WriteConcernError(writeConcernErrorDocument.getNumber((Object)"code").intValue(), writeConcernErrorDocument.getString((Object)"codeName", new BsonString("")).getValue(), writeConcernErrorDocument.getString((Object)"errmsg").getValue(), writeConcernErrorDocument.getDocument((Object)"errInfo", new BsonDocument()), writeConcernErrorDocument.getArray((Object)"errorLabels", new BsonArray()).stream().map(i -> i.asString().getValue()).collect(Collectors.toSet()));
    }

    private WriteConcernHelper() {
    }
}

