/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb.connection.client;

import com.mongodb.MongoClientSettings;
import io.debezium.config.Configuration;
import io.debezium.connector.mongodb.MongoDbConnectorConfig;
import io.debezium.connector.mongodb.connection.MongoDbAuthProvider;
import io.debezium.connector.mongodb.connection.client.MongoDbClientFactory;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import org.bson.UuidRepresentation;

public class DefaultMongoDbClientFactory
implements MongoDbClientFactory {
    private final MongoDbConnectorConfig connectorConfig;
    private final MongoClientSettings clientSettings;
    private final MongoDbAuthProvider authProvider;

    public DefaultMongoDbClientFactory(Configuration config) {
        this.connectorConfig = new MongoDbConnectorConfig(config);
        this.authProvider = this.connectorConfig.getAuthProvider();
        this.authProvider.init(config);
        this.clientSettings = this.createMongoClientSettings();
    }

    @Override
    public MongoClientSettings getMongoClientSettings() {
        return this.clientSettings;
    }

    protected MongoClientSettings createMongoClientSettings() {
        SSLContext sslContext = MongoDbClientFactory.createSSLContext(this.connectorConfig);
        MongoClientSettings.Builder settings = MongoClientSettings.builder().uuidRepresentation(UuidRepresentation.STANDARD).applyToSocketSettings(builder -> builder.connectTimeout(this.connectorConfig.getConnectTimeoutMs(), TimeUnit.MILLISECONDS).readTimeout(this.connectorConfig.getSocketTimeoutMs(), TimeUnit.MILLISECONDS)).applyToClusterSettings(builder -> builder.serverSelectionTimeout((long)this.connectorConfig.getServerSelectionTimeoutMs(), TimeUnit.MILLISECONDS)).applyToServerSettings(builder -> builder.heartbeatFrequency((long)this.connectorConfig.getHeartbeatFrequencyMs(), TimeUnit.MILLISECONDS)).applyToSocketSettings(builder -> builder.connectTimeout(this.connectorConfig.getConnectTimeoutMs(), TimeUnit.MILLISECONDS).readTimeout(this.connectorConfig.getSocketTimeoutMs(), TimeUnit.MILLISECONDS)).applyToClusterSettings(builder -> builder.serverSelectionTimeout((long)this.connectorConfig.getServerSelectionTimeoutMs(), TimeUnit.MILLISECONDS)).applyToSslSettings(builder -> builder.enabled(this.connectorConfig.isSslEnabled()).invalidHostNameAllowed(this.connectorConfig.isSslAllowInvalidHostnames()).context(sslContext));
        this.authProvider.addAuthConfig(settings);
        settings.applyConnectionString(this.connectorConfig.getConnectionString());
        return settings.build();
    }
}

