/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb;

import com.mongodb.MongoChangeStreamException;
import com.mongodb.MongoCommandException;
import com.mongodb.client.ChangeStreamIterable;
import com.mongodb.client.MongoChangeStreamCursor;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.changestream.ChangeStreamDocument;
import io.debezium.DebeziumException;
import io.debezium.config.CommonConnectorConfig;
import io.debezium.connector.SnapshotRecord;
import io.debezium.connector.mongodb.CollectionId;
import io.debezium.connector.mongodb.MongoDbConnector;
import io.debezium.connector.mongodb.MongoDbConnectorConfig;
import io.debezium.connector.mongodb.MongoDbOffsetContext;
import io.debezium.connector.mongodb.MongoDbPartition;
import io.debezium.connector.mongodb.MongoDbTaskContext;
import io.debezium.connector.mongodb.MongoUtils;
import io.debezium.connector.mongodb.connection.MongoDbConnection;
import io.debezium.connector.mongodb.recordemitter.MongoDbSnapshotRecordEmitter;
import io.debezium.function.BlockingConsumer;
import io.debezium.pipeline.ErrorHandler;
import io.debezium.pipeline.EventDispatcher;
import io.debezium.pipeline.notification.NotificationService;
import io.debezium.pipeline.signal.actions.snapshotting.AdditionalCondition;
import io.debezium.pipeline.signal.actions.snapshotting.SnapshotConfiguration;
import io.debezium.pipeline.source.AbstractSnapshotChangeEventSource;
import io.debezium.pipeline.source.SnapshottingTask;
import io.debezium.pipeline.source.spi.ChangeEventSource;
import io.debezium.pipeline.source.spi.SnapshotProgressListener;
import io.debezium.pipeline.spi.ChangeRecordEmitter;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.pipeline.spi.Partition;
import io.debezium.pipeline.spi.SnapshotResult;
import io.debezium.snapshot.SnapshotterService;
import io.debezium.spi.schema.DataCollectionId;
import io.debezium.util.Clock;
import io.debezium.util.Strings;
import io.debezium.util.Threads;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bson.BsonDocument;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoDbSnapshotChangeEventSource
extends AbstractSnapshotChangeEventSource<MongoDbPartition, MongoDbOffsetContext> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MongoDbSnapshotChangeEventSource.class);
    private final MongoDbConnectorConfig connectorConfig;
    private final MongoDbTaskContext taskContext;
    private final EventDispatcher<MongoDbPartition, CollectionId> dispatcher;
    private final Clock clock;
    private final SnapshotProgressListener<MongoDbPartition> snapshotProgressListener;
    private final ErrorHandler errorHandler;
    private final SnapshotterService snapshotterService;

    public MongoDbSnapshotChangeEventSource(MongoDbConnectorConfig connectorConfig, MongoDbTaskContext taskContext, EventDispatcher<MongoDbPartition, CollectionId> dispatcher, Clock clock, SnapshotProgressListener<MongoDbPartition> snapshotProgressListener, ErrorHandler errorHandler, NotificationService<MongoDbPartition, MongoDbOffsetContext> notificationService, SnapshotterService snapshotterService) {
        super((CommonConnectorConfig)connectorConfig, snapshotProgressListener, notificationService);
        this.connectorConfig = connectorConfig;
        this.taskContext = taskContext;
        this.dispatcher = dispatcher;
        this.clock = clock;
        this.snapshotProgressListener = snapshotProgressListener;
        this.errorHandler = errorHandler;
        this.snapshotterService = snapshotterService;
    }

    protected SnapshotResult<MongoDbOffsetContext> doExecute(ChangeEventSource.ChangeEventSourceContext context, MongoDbOffsetContext prevOffsetCtx, AbstractSnapshotChangeEventSource.SnapshotContext<MongoDbPartition, MongoDbOffsetContext> snapshotContext, SnapshottingTask snapshottingTask) {
        MongoDbSnapshotContext mongoDbSnapshotContext = (MongoDbSnapshotContext)snapshotContext;
        LOGGER.info("Snapshot step 1 - Preparing");
        if (prevOffsetCtx != null && prevOffsetCtx.isSnapshotRunning()) {
            LOGGER.info("Previous snapshot was cancelled before completion; a new snapshot will be taken.");
        }
        LOGGER.info("Snapshot step 2 - Determining snapshot offsets");
        this.initSnapshotStartOffsets(mongoDbSnapshotContext);
        LOGGER.info("Snapshot step 3 - Snapshotting data");
        try {
            this.doSnapshot(context, mongoDbSnapshotContext, snapshottingTask);
        }
        catch (Throwable t) {
            LOGGER.error("Snapshot failed", t);
            this.errorHandler.setProducerThrowable(t);
            return SnapshotResult.aborted();
        }
        return SnapshotResult.completed((OffsetContext)((MongoDbOffsetContext)snapshotContext.offset));
    }

    public SnapshottingTask getBlockingSnapshottingTask(MongoDbPartition partition, MongoDbOffsetContext previousOffset, SnapshotConfiguration snapshotConfiguration) {
        Map<String, String> filtersByTable = snapshotConfiguration.getAdditionalConditions().stream().collect(Collectors.toMap(k -> k.getDataCollection().toString(), AdditionalCondition::getFilter));
        return new SnapshottingTask(false, true, snapshotConfiguration.getDataCollections(), filtersByTable, true);
    }

    public SnapshottingTask getSnapshottingTask(MongoDbPartition partition, MongoDbOffsetContext offsetContext) {
        List dataCollectionsToBeSnapshotted = this.connectorConfig.getDataCollectionsToBeSnapshotted();
        if (this.connectorConfig.getSnapshotMode().equals((Object)MongoDbConnectorConfig.SnapshotMode.NEVER) || this.connectorConfig.getSnapshotMode().equals((Object)MongoDbConnectorConfig.SnapshotMode.NO_DATA)) {
            LOGGER.info("According to the connector configuration, no snapshot will occur.");
            return new SnapshottingTask(false, false, dataCollectionsToBeSnapshotted, Map.of(), false);
        }
        if (offsetContext == null) {
            LOGGER.info("No previous offset has been found");
            return new SnapshottingTask(false, true, dataCollectionsToBeSnapshotted, this.connectorConfig.getSnapshotFilterQueryByCollection(), false);
        }
        boolean snapshotData = this.isSnapshotExpected(partition, offsetContext);
        return new SnapshottingTask(false, snapshotData, dataCollectionsToBeSnapshotted, this.connectorConfig.getSnapshotFilterQueryByCollection(), false);
    }

    protected AbstractSnapshotChangeEventSource.SnapshotContext<MongoDbPartition, MongoDbOffsetContext> prepare(MongoDbPartition partition, boolean onDemand) {
        return new MongoDbSnapshotContext(partition);
    }

    private void doSnapshot(ChangeEventSource.ChangeEventSourceContext sourceCtx, MongoDbSnapshotContext snapshotCtx, SnapshottingTask snapshottingTask) throws InterruptedException {
        try (MongoDbConnection mongo = this.taskContext.getConnection(this.dispatcher, (MongoDbPartition)snapshotCtx.partition);){
            this.initSnapshotStartOffsets(snapshotCtx, mongo);
            EventDispatcher.SnapshotReceiver snapshotReceiver = this.dispatcher.getSnapshotChangeEventReceiver();
            ((MongoDbOffsetContext)snapshotCtx.offset).preSnapshotStart();
            this.createDataEvents(sourceCtx, snapshotCtx, (EventDispatcher.SnapshotReceiver<MongoDbPartition>)snapshotReceiver, mongo, snapshottingTask);
            ((MongoDbOffsetContext)snapshotCtx.offset).preSnapshotCompletion();
            snapshotReceiver.completeSnapshot();
            ((MongoDbOffsetContext)snapshotCtx.offset).postSnapshotCompletion();
        }
    }

    private boolean isSnapshotExpected(MongoDbPartition partition, MongoDbOffsetContext offsetContext) {
        if (!offsetContext.hasOffset()) {
            LOGGER.info("No existing offset found, starting snapshot");
            return true;
        }
        if (offsetContext.isSnapshotRunning()) {
            LOGGER.info("The previous snapshot was incomplete, so restarting the snapshot");
            return true;
        }
        LOGGER.info("Found existing offset for at {}", offsetContext.getOffset());
        BsonDocument token = offsetContext.lastResumeTokenDoc();
        return this.isValidResumeToken(partition, token);
    }

    private boolean isValidResumeToken(MongoDbPartition partition, BsonDocument token) {
        if (token == null) {
            return false;
        }
        MongoDbConnection mongo = this.taskContext.getConnection(this.dispatcher, partition);
        try {
            boolean bl = (Boolean)mongo.execute("Checking change stream", client -> {
                Boolean bl;
                block8: {
                    ChangeStreamIterable<BsonDocument> stream = MongoUtils.openChangeStream(client, this.taskContext);
                    stream.resumeAfter(token);
                    MongoChangeStreamCursor ignored = stream.cursor();
                    try {
                        LOGGER.info("Valid resume token present, so no snapshot will be performed'");
                        bl = false;
                        if (ignored == null) break block8;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (ignored != null) {
                                try {
                                    ignored.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (MongoChangeStreamException | MongoCommandException e) {
                            LOGGER.info("Invalid resume token present, snapshot will be performed'");
                            return true;
                        }
                    }
                    ignored.close();
                }
                return bl;
            });
            if (mongo != null) {
                mongo.close();
            }
            return bl;
        }
        catch (Throwable throwable) {
            try {
                if (mongo != null) {
                    try {
                        mongo.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (InterruptedException e) {
                throw new DebeziumException("Interrupted while creating snapshotting task", (Throwable)e);
            }
        }
    }

    private void initSnapshotStartOffsets(MongoDbSnapshotContext snapshotCtx) {
        LOGGER.info("Initializing empty Offset context");
        snapshotCtx.offset = MongoDbOffsetContext.empty(this.connectorConfig);
    }

    private void initSnapshotStartOffsets(MongoDbSnapshotContext snapshotCtx, MongoDbConnection mongo) throws InterruptedException {
        LOGGER.info("Determine Snapshot start offset");
        mongo.execute("Setting resume token", (BlockingConsumer<MongoClient>)((BlockingConsumer)client -> {
            ChangeStreamIterable<BsonDocument> stream = MongoUtils.openChangeStream(client, this.taskContext);
            try (MongoChangeStreamCursor cursor = stream.cursor();){
                ((MongoDbOffsetContext)snapshotCtx.offset).initEvent((MongoChangeStreamCursor<ChangeStreamDocument<BsonDocument>>)cursor);
            }
        }));
        ((MongoDbOffsetContext)snapshotCtx.offset).initFromOpTimeIfNeeded(mongo.hello());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createDataEvents(ChangeEventSource.ChangeEventSourceContext sourceContext, MongoDbSnapshotContext snapshotContext, EventDispatcher.SnapshotReceiver<MongoDbPartition> snapshotReceiver, MongoDbConnection mongo, SnapshottingTask snapshottingTask) throws InterruptedException {
        snapshotContext.lastCollection = false;
        ((MongoDbOffsetContext)snapshotContext.offset).startInitialSnapshot();
        LOGGER.info("Beginning snapshot at {}", ((MongoDbOffsetContext)snapshotContext.offset).getOffset());
        Set dataCollectionPattern = this.getDataCollectionPattern(snapshottingTask.getDataCollections());
        List collections = this.determineDataCollectionsToBeSnapshotted(mongo.collections(), dataCollectionPattern).collect(Collectors.toList());
        this.snapshotProgressListener.monitoredDataCollectionsDetermined((Partition)((MongoDbPartition)snapshotContext.partition), collections);
        int numThreads = Math.min(collections.size(), this.connectorConfig.getSnapshotMaxThreads());
        ConcurrentLinkedQueue collectionsToCopy = new ConcurrentLinkedQueue(collections);
        LOGGER.info("Creating snapshot worker pool with {} worker thread(s)", (Object)numThreads);
        ExecutorService executorService = Threads.newFixedThreadPool(MongoDbConnector.class, (String)this.taskContext.getServerName(), (String)"snapshot-main", (int)this.connectorConfig.getSnapshotMaxThreads());
        CountDownLatch latch = new CountDownLatch(numThreads);
        AtomicBoolean aborted = new AtomicBoolean(false);
        AtomicInteger threadCounter = new AtomicInteger(0);
        LOGGER.info("Preparing to use {} thread(s) to snapshot {} collection(s): {}", new Object[]{numThreads, collections.size(), Strings.join((CharSequence)", ", collections)});
        for (int i = 0; i < numThreads; ++i) {
            executorService.submit(() -> {
                this.taskContext.configureLoggingContext("snapshot" + threadCounter.incrementAndGet());
                try {
                    CollectionId id = null;
                    while (!aborted.get() && (id = (CollectionId)collectionsToCopy.poll()) != null) {
                        if (!sourceContext.isRunning()) {
                            throw new InterruptedException("Interrupted while snapshotting");
                        }
                        if (collectionsToCopy.isEmpty()) {
                            snapshotContext.lastCollection = true;
                        }
                        this.createDataEventsForCollection(sourceContext, snapshotContext, snapshotReceiver, id, mongo, snapshottingTask.getFilterQueries());
                    }
                }
                catch (Throwable t) {
                    LOGGER.error("Snapshot failed", t);
                    this.errorHandler.setProducerThrowable(t);
                    aborted.set(true);
                }
                finally {
                    latch.countDown();
                }
            });
        }
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            aborted.set(true);
        }
        finally {
            executorService.shutdown();
        }
        ((MongoDbOffsetContext)snapshotContext.offset).stopInitialSnapshot();
    }

    protected <T extends DataCollectionId> Stream<T> determineDataCollectionsToBeSnapshotted(Collection<T> allDataCollections, Set<Pattern> snapshotAllowedDataCollections) {
        if (snapshotAllowedDataCollections.isEmpty()) {
            return allDataCollections.stream();
        }
        return allDataCollections.stream().filter(dataCollectionId -> snapshotAllowedDataCollections.stream().anyMatch(s -> s.matcher(((CollectionId)dataCollectionId).namespace()).matches()));
    }

    private void createDataEventsForCollection(ChangeEventSource.ChangeEventSourceContext sourceContext, MongoDbSnapshotContext snapshotContext, EventDispatcher.SnapshotReceiver<MongoDbPartition> snapshotReceiver, CollectionId collectionId, MongoDbConnection mongo, Map<String, String> snapshotFilterQueryForCollection) throws InterruptedException {
        long exportStart = this.clock.currentTimeInMillis();
        LOGGER.info("\t Exporting data for collection '{}'", (Object)collectionId);
        this.notificationService.initialSnapshotNotificationService().notifyTableInProgress((Partition)((MongoDbPartition)snapshotContext.partition), snapshotContext.offset, collectionId.namespace());
        mongo.execute("sync '" + collectionId + "'", (BlockingConsumer<MongoClient>)((BlockingConsumer)client -> {
            MongoDatabase database = client.getDatabase(collectionId.dbName());
            MongoCollection collection = database.getCollection(collectionId.name(), BsonDocument.class);
            int batchSize = this.taskContext.getConnectorConfig().getSnapshotFetchSize();
            long docs = 0L;
            Optional<String> snapshotFilterForCollectionId = Optional.ofNullable((String)snapshotFilterQueryForCollection.get(collectionId.dbName() + "." + collectionId.name()));
            Document filterQuery = Document.parse((String)snapshotFilterForCollectionId.orElse("{}"));
            try (MongoCursor cursor = collection.find((Bson)filterQuery).batchSize(batchSize).iterator();){
                snapshotContext.lastRecordInCollection = false;
                if (cursor.hasNext()) {
                    while (cursor.hasNext()) {
                        if (!sourceContext.isRunning()) {
                            throw new InterruptedException("Interrupted while snapshotting collection " + collectionId.name());
                        }
                        BsonDocument document = (BsonDocument)cursor.next();
                        ++docs;
                        boolean bl = snapshotContext.lastRecordInCollection = !cursor.hasNext();
                        if (snapshotContext.lastCollection && snapshotContext.lastRecordInCollection) {
                            ((MongoDbOffsetContext)snapshotContext.offset).markSnapshotRecord(SnapshotRecord.LAST);
                        }
                        this.dispatcher.dispatchSnapshotEvent((Partition)((MongoDbPartition)snapshotContext.partition), (DataCollectionId)collectionId, this.getChangeRecordEmitter(snapshotContext, collectionId, document), snapshotReceiver);
                    }
                } else if (snapshotContext.lastCollection) {
                    ((MongoDbOffsetContext)snapshotContext.offset).markSnapshotRecord(SnapshotRecord.LAST);
                }
                this.notificationService.initialSnapshotNotificationService().notifyCompletedTableSuccessfully((Partition)((MongoDbPartition)snapshotContext.partition), snapshotContext.offset, collectionId.namespace());
                LOGGER.info("\t Finished snapshotting {} records for collection '{}'; total duration '{}'", new Object[]{docs, collectionId, Strings.duration((long)(this.clock.currentTimeInMillis() - exportStart))});
                this.snapshotProgressListener.dataCollectionSnapshotCompleted((Partition)((MongoDbPartition)snapshotContext.partition), (DataCollectionId)collectionId, docs);
            }
        }));
    }

    private ChangeRecordEmitter<MongoDbPartition> getChangeRecordEmitter(AbstractSnapshotChangeEventSource.SnapshotContext<MongoDbPartition, MongoDbOffsetContext> snapshotContext, CollectionId collectionId, BsonDocument document) {
        ((MongoDbOffsetContext)snapshotContext.offset).readEvent(collectionId, this.getClock().currentTime());
        return new MongoDbSnapshotRecordEmitter((MongoDbPartition)snapshotContext.partition, snapshotContext.offset, this.getClock(), document, this.connectorConfig);
    }

    private Clock getClock() {
        return this.clock;
    }

    private static class MongoDbSnapshotContext
    extends AbstractSnapshotChangeEventSource.SnapshotContext<MongoDbPartition, MongoDbOffsetContext> {
        public boolean lastCollection;
        public boolean lastRecordInCollection;

        MongoDbSnapshotContext(MongoDbPartition partition) {
            super((Partition)partition);
        }
    }
}

